;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/structor "3.2.0"
  :description "Builds for 7theta projects"
  :url "https://github.com/7theta/structor"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.12.0-alpha5"]
                 [com.7theta/structor-task "1.1.1"]
                 [com.7theta/fs-watch "0.1.2"]
                 [com.7theta/crusta "1.1.4"]

                 [thheller/shadow-cljs "2.28.3"]
                 [binaryage/devtools "1.0.7"]
                 [babashka "1.3.189"
                  :exclusions [org.clojure/core.async org.ow2.asm/asm
                               org.checkerframework/checker-qual
                               commons-codec]]

                 [org.clojure/test.check "1.1.1"]
                 [com.gfredericks/test.chuck "0.2.14"]
                 [org.clojure/tools.namespace "1.5.0"]

                 [integrant "0.8.1"]
                 [integrant/repl "0.3.3"]]
  :scm {:name "git"
        :url "https://github.com/7theta/structor"})
