;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.process
  (:require [crusta.core :as sh]))

(defn run
  [command & {:keys [indent-level wait environment directory]
              :or {indent-level 0
                   wait true}}]
  (let [process (promise)
        logger (atom nil)]
    (reset! logger (future
                     (doseq [line (sh/stdout-seq @process)]
                       (println (str (apply str (repeat indent-level "  ")) line)))))
    (deliver process
             (sh/exec command
                      :redirect-stderr true
                      :on-exit (fn []
                                 (when-let [l @logger]
                                   (future-cancel l)))
                      :environment environment
                      :directory directory))
    (when wait
      (sh/exit-code @process))
    @process))

(defn kill
  [p]
  (sh/kill p))
