;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.namespace
  (:require [structor.artifact :as artifact]
            [clojure.tools.namespace.find :refer [find-namespaces]]
            [clojure.tools.namespace.file :as file]
            [clojure.tools.namespace.parse :as parse]
            [clojure.java.classpath :as java]
            [clojure.java.io :as io])
  (:import [java.io File]))

(defn classpath
  []
  (remove (comp (partial re-find #"\.m2") str) (java/classpath)))

(defn namespaces
  []
  (->> (classpath)
       find-namespaces
       (filter (comp (partial re-find (re-pattern artifact/name)) str))))

(defn test?
  [ns]
  (re-find #"-test$" (str ns)))

(defn file->ns
  [file]
  (try
    (->> (cond-> file (not (instance? File file)) io/file)
         file/read-file-ns-decl
         parse/name-from-ns-decl)
    (catch Throwable _ nil)))
