;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.npm
  (:refer-clojure :exclude [ensure])
  (:require [structor-task.core :refer [deftask]]
            [babashka.fs :as fs :refer [delete-tree]]
            [structor.process :refer [run]]
            [cheshire.core :as json]
            [clojure.java.io :as io]
            [clojure.string :as st]))

(deftask clean
  []
  (delete-tree "node_modules"))

(deftask install
  ([]
   (run "npm install --no-save"))
  ([& packages]
   (run ["npm install" (st/join " " packages) "--no-save"])))

(defn installed?
  [package-name]
  (let [manifest (str "node_modules/" package-name "/package.json")]
    (when (.exists (io/file manifest))
      (get (json/parse-stream (io/reader manifest)) "version"))))

(deftask ensure
  [& packages]
  (apply install (map (fn [[name version]] (str name "@" version)) packages)))

(deftask outdated
  {:depends [install]}
  []
  (run "npm outdated"))
