;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.tailwind
  (:require [structor-task.core :refer [deftask]]
            [structor.process :refer [run kill]]
            [babashka.fs :as fs]))

(def defaults
  {:input-css  "dev-resources/css/input.css"
   :input-js   "resources/public/js/compiled/main.js"
   :output-css "resources/public/css/main.css"})

(deftask clean
  [& {:keys [output-css]
      :or {output-css (:output-css defaults)}}]
  (fs/delete-if-exists output-css))

(deftask release
  {:depends [clean]
   :inputs (into [input-css "tailwind.config.js"]
                 (cond-> input-js (string? input-js) vector))
   :outputs [output-css]}
  [& {:keys [input-css output-css input-js minify]
      :or {input-css (:input-css defaults)
           input-js (fs/glob "resources/public/js/" "**/*.js")
           output-css (:output-css defaults)
           minify false}}]
  (run ["npx" "tailwindcss" "-i" input-css "-o" output-css
        (when minify "--minify")]
    {:environment {"NODE_ENV" "production"
                   "TAILWIND_MODE" "build"}})
  (run ["touch" output-css]))

(deftask watch
  [& {:keys [input-css output-css]
      :or {input-css (:input-css defaults)
           output-css (:output-css defaults)}}]
  (run ["npx" "tailwindcss" "-i" input-css "-o" output-css])
  (run ["touch" output-css])
  (run ["npx" "tailwindcss" "-i" input-css "-o" output-css "--watch"]
    :environment {"TAILWIND_MODE" "watch"}
    :wait false))

(deftask stop
  [watcher]
  (when watcher (kill watcher)))
