;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.test-async
  #?(:cljs (:require-macros [structor.test-async]
                            [cljs.test]
                            [cljs.core.async]))
  #?(:cljs (:require [cljs.test]
                     [cljs.core.async])))

#?(:clj
   (defmacro async
     {:style/indent 1}
     [done & body]
     (if (:ns &env)
       `(cljs.test/async ~done
          (cljs.core.async/go
            ~@body))
       `(let [~done (fn [])]
          ~@body))))

#?(:clj
   (defmacro sleep
     {:style/indent 1}
     [timeout]
     (if (:ns &env)
       `(cljs.core.async/<! (cljs.core.async/timeout ~timeout))
       `(java.lang.Thread/sleep ~timeout))))
