;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.git
  (:require [structor.process :refer [run]]
            [crusta.core :as sh]
            [clojure.string :as st]))

(defn tags
  []
  (->> @(sh/run "git tag")
       st/split-lines
       (filter not-empty)
       set))

(defn tag
  [tag-name]
  (run ["git tag" tag-name]))

(defn tree-clean?
  []
  @(run "git diff --stat"))
