;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.karma
  (:require [structor-task.core :refer [deftask]]
            [babashka.process :refer [process destroy-tree]]
            [clojure.java.io :as io]
            #?@(:bb []
                :clj [[integrant.core :as ig]])))

(declare watch stop)

#?(:bb nil
   :clj
   (defmethod ig/init-key :structor.karma/watcher [_ opts]
     (watch opts)))

#?(:bb nil
   :clj
   (defmethod ig/halt-key! :structor.karma/watcher [_ watchers]
     (stop watchers)))

(deftask watch
  [& _]
  (let [p (process {:err :inherit} "npx" "karma" "start")]
    (future
      (let [reader (io/reader (:out p))]
        (loop []
          (if-let [line (.readLine reader)]
            (do (println line)
                (recur))
            (.close reader)))))
    p))

(deftask stop
  [watcher]
  (when watcher (destroy-tree watcher)))
