;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns structor.watcher
  (:require [structor-task.core :refer [deftask log]]
            [structor.namespace :refer [classpath namespaces test? file->ns]]
            [structor.artifact :as artifact]
            [fs-watch.core :as fs]
            [integrant.core :as ig]))

(declare watch-files stop-files watch-namespaces stop-namespaces)

(defmethod ig/init-key :structor.watcher/files [_ {:keys [watch-fn]}]
  (watch-files watch-fn))

(defmethod ig/halt-key! :structor.watcher/files [_ watcher]
  (stop-files watcher))

(defmethod ig/init-key :structor.watcher/namespaces [_ {:keys [watch-fn]}]
  (watch-namespaces watch-fn))

(defmethod ig/halt-key! :structor.watcher/namespaces [_ watcher]
  (stop-namespaces watcher))

(defn watch-files
  [watch-fn]
  (log :start :structor.watcher/files artifact/name)
  (fs/watch (fn [{:keys [type path]}]
              (watch-fn type path))
            (->> (classpath)
                 (filter #(.exists %))
                 (map str))))

(defn stop-files
  [watcher]
  (fs/stop watcher)
  (log :end :structor.watcher/files artifact/name))

(defn watch-namespaces
  [watch-fn]
  (log :start :structor.watcher/files artifact/name)
  (watch-files (fn [file] (watch-fn (file->ns file)))))

(defn watch-namespaces
  [watcher]
  (stop-files watcher))
