;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns tailwind.react-native
  (:require [crusta.core :as sh]
            [clojure.string :as st])
  (:import [java.io File]))

(def default-tailwind-utilities-js "resources/compiled/js/tailwind_utilities.js")
(def default-tailwind-json "resources/compiled/json/tailwind.json")
(def default-input-tailwind-css "resources/css/input.css")
(def default-output-tailwind-css "resources/compiled/css/main.css")

(defn ensure-directories
  [path]
  (->> (st/split path #"/")
       drop-last
       (st/join "/")
       (File.)
       (.mkdirs)))

(defn write-tailwind-js
  [{:keys [tailwind-json tailwind-js]
    :or {tailwind-json default-tailwind-json
         tailwind-js default-tailwind-utilities-js}}]
  (when-let [json (not-empty (slurp tailwind-json))]
    (ensure-directories tailwind-js)
    (ensure-directories tailwind-json)
    (spit tailwind-js (str "export default " json))))
