(ns tailwind.react-native
  (:require [clojure.string :refer [starts-with? replace split join]]
            [tailwind.core]
            [utilis.js :as j]))

(declare tw class->color)

(defn init
  [styles]
  (set! tailwind.core/tw (partial tw styles))
  (set! tailwind.core/class->color (partial class->color styles)))


;;; Private

(defn- sanitize-string-value
  [style value]
  (let [new-value value
        new-value (replace new-value #"var\(([a-zA-Z-]+)\)" (fn [[_ k]] (j/get style k)))
        new-value (if (starts-with? new-value "rgb(")
                    (replace new-value #"rgb\((.*)\)" (fn [[_ rgba]]
                                                        (str "rgba("
                                                             (join ", " (-> rgba
                                                                            (replace #"/" " ")
                                                                            (split #"\s+")))
                                                             ")")))
                    new-value)]
    new-value))

(defn- sanitize-style-value
  [style value]
  (if (string? value)
    (sanitize-string-value style value)
    value))

(defn- sanitize-style-prop!
  [style new-style key value]
  (when-not (starts-with? key "--")
    (let [new-value (sanitize-style-value style value)]
      (j/assoc! new-style key new-value))))

(defn- sanitize-style
  [style]
  (let [new-style (js-obj)]
    (doseq [[k v] (js/Object.entries style)]
      (sanitize-style-prop! style new-style k v))
    new-style))

(defn- tw
  [styles classes]
  (->> classes
       flatten
       (map #(cond-> % (keyword? %) name))
       (map #(or (j/get-in styles [% "style"]) #js {}))
       (apply js/Object.assign #js {})
       (sanitize-style)))

(defn- class->color
  [styles class]
  (->> (tw styles [class])
       js->clj
       vals
       first))
