;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns tailwind.web
  (:require [tailwind.core]
            ["tailwindcss/colors" :as colors]
            [clojure.string :as st]
            [utilis.js :as j]))

;; API

(declare tw class->color)

(defn init
  []
  (set! tailwind.core/tw tw)
  (set! tailwind.core/class->color class->color))


;; Private

(defn- tw
  [classes]
  (->> classes
       flatten
       (map #(cond-> % (keyword? %) name))
       (st/join " ")))

(defn- class->color
  [class]
  (->> (st/split (name class) #"\-")
       (remove #{"bg" "text" "border"})
       (j/get-in colors)))
