;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns utilis.base64
  #?(:clj  (:import  [java.util Base64])
     :cljs (:require [goog.crypt.base64 :as base64])))

(defn encode
  [b]
  #?(:clj  (.encodeToString (Base64/getEncoder) b)
     :cljs (base64/encodeString b)))

(defn decode
  [s]
  #?(:clj  (.decode (Base64/getDecoder) ^String s)
     :cljs (base64/decodeString s)))
