;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(defproject com.7theta/vectio "0.3.1"
  :description "A stream-based transport layer."
  :url "https://github.com/7theta/vectio"
  :license {:name "MIT License"
            :url "https://opensource.org/licenses/MIT"}
  :dependencies [[org.clojure/clojure "1.11.1"]
                 [org.clojure/core.async "1.5.648"]

                 [com.7theta/utilis "2.3.8"]
                 [com.7theta/tempus "0.9.3"]

                 [io.netty/netty-transport "4.1.82.Final"]
                 [io.netty/netty-transport-native-epoll "4.1.82.Final"]
                 [io.netty/netty-codec "4.1.82.Final"]
                 [io.netty/netty-codec-http "4.1.82.Final"]
                 [io.netty/netty-codec-http2 "4.1.82.Final"]
                 [io.netty/netty-handler "4.1.82.Final"]
                 [io.netty/netty-handler-proxy "4.1.82.Final"]
                 [io.netty/netty-resolver "4.1.82.Final"]
                 [io.netty/netty-resolver-dns "4.1.82.Final"]

                 [org.clj-commons/byte-streams "0.3.1"]
                 [commons-io/commons-io "2.11.0"]
                 [com.brunobonacci/mulog "0.9.0"]

                 [haslett "0.1.7" :exclusions [org.clojure/clojure org.clojure/clojurescript
                                               org.clojure/spec.alpha org.clojure/core.specs.alpha
                                               qcom.cognitect/transit-cljs]]
                 [manifold "0.2.4"]
                 [integrant "0.8.0"]

                 [metosin/malli "0.9.2"]]
  :profiles {:repl {:global-vars {*warn-on-reflection* true}}
             :test
             {:global-vars {*warn-on-reflection* true}
              :source-paths ["test"]
              :dependencies [[org.clojure/test.check "1.1.1"]]}}
  :repl-options {:init-ns vectio.http}
  :scm {:name "git"
        :url "https://github.com/7theta/vectio"})
