;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns vectio.http
  (:require [vectio.haslett.websocket :as ws]
            [utilis.js :as j]
            [utilis.string :refer [ensure-starts-with]]))

(defn websocket-client
  [{:keys [address] :as args}]
  (ws/websocket-client-stream args))

(defn websocket-origin
  ([] (websocket-origin nil))
  ([path]
   (when-let [location (j/get js/window :location)]
     (str (if (= "http:" (j/get location :protocol))
            "ws://"
            "wss://")
          (j/get location :host)
          (ensure-starts-with (str path) "/")))))
