;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns vectio.netty.h2.handlers.window
  (:require [vectio.netty :as n])
  (:import [io.netty.channel ChannelHandlerContext]
           [io.netty.handler.codec.http2
            Http2WindowUpdateFrame]))

(defn handle?
  [msg]
  (instance? Http2WindowUpdateFrame msg))

(defn handle
  [^ChannelHandlerContext ctx connection-state ^Http2WindowUpdateFrame msg]
  (let [stream (.stream msg)
        stream-id (.id stream)
        pipeline (.pipeline ctx)
        increment (.windowSizeIncrement msg)]
    (if (zero? increment)
      (throw (ex-info "Received window update frame with zero increment"
                      {:msg msg}))
      (when-let [window (if (zero? stream-id)
                          (:window @connection-state)
                          (get-in @connection-state [:streams stream-id :window]))]
        (vswap! window + increment)
        (n/invoke-write pipeline "frame-writer" [:prune stream-id]))))
  nil)
