(ns vectio.util.fides-tls
  (:require [fides.tls-credential :as fides]
            [utilis.io :refer [input-stream]]))

(defn validate
  [{:keys [cred trust] :as tls} & {:keys [trust?] :or {trust? true}}]
  (when-not (and cred (fides/tls-credential? cred :key? true))
    (throw (ex-info "invalid tls cred" tls)))
  (when-not (if trust?
              (and trust (fides/tls-credential? trust :key? false))
              true)
    (throw (ex-info "invalid tls trust" tls))))

(defn ->input-streams
  [{:keys [cred trust]}]
  (let [{:keys [cert key]} (fides/->pem cred)]
    {:cert (input-stream cert)
     :key (input-stream key)
     :trust (when trust (-> trust fides/->pem :cert input-stream))}))
