(ns vectio.util.fides-tls
  (:require [fides.tls :as tls]
            [utilis.io :refer [input-stream]]))

(defn validate
  [{:keys [cred trust] :as tls} & {:keys [trust?] :or {trust? true}}]
  (when-not (and cred (tls/credential? cred :key? true))
    (throw (ex-info "invalid tls cred" tls)))
  (when-not (if trust?
              (and trust (tls/credential? trust :key? false))
              true)
    (throw (ex-info "invalid tls trust" tls))))

(defn ->input-streams
  [{:keys [cred trust]}]
  (let [{:keys [cert key]} (tls/->pem cred)]
    {:cert (input-stream cert)
     :key (input-stream key)
     :trust (when trust (-> trust tls/->pem :cert input-stream))}))
