goog.provide('cljs.core.async');
goog.scope(function(){
  cljs.core.async.goog$module$goog$array = goog.module.get('goog.array');
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52404 = (function (f,blockable,meta52405){
this.f = f;
this.blockable = blockable;
this.meta52405 = meta52405;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52406,meta52405__$1){
var self__ = this;
var _52406__$1 = this;
return (new cljs.core.async.t_cljs$core$async52404(self__.f,self__.blockable,meta52405__$1));
}));

(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52406){
var self__ = this;
var _52406__$1 = this;
return self__.meta52405;
}));

(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.blockable;
}));

(cljs.core.async.t_cljs$core$async52404.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.f;
}));

(cljs.core.async.t_cljs$core$async52404.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"blockable","blockable",-28395259,null),new cljs.core.Symbol(null,"meta52405","meta52405",-759601646,null)], null);
}));

(cljs.core.async.t_cljs$core$async52404.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async52404.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52404");

(cljs.core.async.t_cljs$core$async52404.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async52404");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async52404.
 */
cljs.core.async.__GT_t_cljs$core$async52404 = (function cljs$core$async$__GT_t_cljs$core$async52404(f,blockable,meta52405){
return (new cljs.core.async.t_cljs$core$async52404(f,blockable,meta52405));
});


cljs.core.async.fn_handler = (function cljs$core$async$fn_handler(var_args){
var G__52391 = arguments.length;
switch (G__52391) {
case 1:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1 = (function (f){
return cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(f,true);
}));

(cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2 = (function (f,blockable){
return (new cljs.core.async.t_cljs$core$async52404(f,blockable,cljs.core.PersistentArrayMap.EMPTY));
}));

(cljs.core.async.fn_handler.cljs$lang$maxFixedArity = 2);

/**
 * Returns a fixed buffer of size n. When full, puts will block/park.
 */
cljs.core.async.buffer = (function cljs$core$async$buffer(n){
return cljs.core.async.impl.buffers.fixed_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete but
 *   val will be dropped (no transfer).
 */
cljs.core.async.dropping_buffer = (function cljs$core$async$dropping_buffer(n){
return cljs.core.async.impl.buffers.dropping_buffer(n);
});
/**
 * Returns a buffer of size n. When full, puts will complete, and be
 *   buffered, but oldest elements in buffer will be dropped (not
 *   transferred).
 */
cljs.core.async.sliding_buffer = (function cljs$core$async$sliding_buffer(n){
return cljs.core.async.impl.buffers.sliding_buffer(n);
});
/**
 * Returns true if a channel created with buff will never block. That is to say,
 * puts into this buffer will never cause the buffer to be full. 
 */
cljs.core.async.unblocking_buffer_QMARK_ = (function cljs$core$async$unblocking_buffer_QMARK_(buff){
if((!((buff == null)))){
if(((false) || ((cljs.core.PROTOCOL_SENTINEL === buff.cljs$core$async$impl$protocols$UnblockingBuffer$)))){
return true;
} else {
if((!buff.cljs$lang$protocol_mask$partition$)){
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
} else {
return false;
}
}
} else {
return cljs.core.native_satisfies_QMARK_(cljs.core.async.impl.protocols.UnblockingBuffer,buff);
}
});
/**
 * Creates a channel with an optional buffer, an optional transducer (like (map f),
 *   (filter p) etc or a composition thereof), and an optional exception handler.
 *   If buf-or-n is a number, will create and use a fixed buffer of that size. If a
 *   transducer is supplied a buffer must be specified. ex-handler must be a
 *   fn of one argument - if an exception occurs during transformation it will be called
 *   with the thrown value as an argument, and any non-nil return value will be placed
 *   in the channel.
 */
cljs.core.async.chan = (function cljs$core$async$chan(var_args){
var G__52457 = arguments.length;
switch (G__52457) {
case 0:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1 = (function (buf_or_n){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,null,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$2 = (function (buf_or_n,xform){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(buf_or_n,xform,null);
}));

(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3 = (function (buf_or_n,xform,ex_handler){
var buf_or_n__$1 = ((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(buf_or_n,(0)))?null:buf_or_n);
if(cljs.core.truth_(xform)){
if(cljs.core.truth_(buf_or_n__$1)){
} else {
throw (new Error(["Assert failed: ","buffer must be supplied when transducer is","\n","buf-or-n"].join('')));
}
} else {
}

return cljs.core.async.impl.channels.chan.cljs$core$IFn$_invoke$arity$3(((typeof buf_or_n__$1 === 'number')?cljs.core.async.buffer(buf_or_n__$1):buf_or_n__$1),xform,ex_handler);
}));

(cljs.core.async.chan.cljs$lang$maxFixedArity = 3);

/**
 * Creates a promise channel with an optional transducer, and an optional
 *   exception-handler. A promise channel can take exactly one value that consumers
 *   will receive. Once full, puts complete but val is dropped (no transfer).
 *   Consumers will block until either a value is placed in the channel or the
 *   channel is closed. See chan for the semantics of xform and ex-handler.
 */
cljs.core.async.promise_chan = (function cljs$core$async$promise_chan(var_args){
var G__52465 = arguments.length;
switch (G__52465) {
case 0:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0();

break;
case 1:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$0 = (function (){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1(null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$1 = (function (xform){
return cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2(xform,null);
}));

(cljs.core.async.promise_chan.cljs$core$IFn$_invoke$arity$2 = (function (xform,ex_handler){
return cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3(cljs.core.async.impl.buffers.promise_buffer(),xform,ex_handler);
}));

(cljs.core.async.promise_chan.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel that will close after msecs
 */
cljs.core.async.timeout = (function cljs$core$async$timeout(msecs){
return cljs.core.async.impl.timers.timeout(msecs);
});
/**
 * takes a val from port. Must be called inside a (go ...) block. Will
 *   return nil if closed. Will park if nothing is available.
 *   Returns true unless port is already closed
 */
cljs.core.async._LT__BANG_ = (function cljs$core$async$_LT__BANG_(port){
throw (new Error("<! used not in (go ...) block"));
});
/**
 * Asynchronously takes a val from port, passing to fn1. Will pass nil
 * if closed. If on-caller? (default true) is true, and value is
 * immediately available, will call fn1 on calling thread.
 * Returns nil.
 */
cljs.core.async.take_BANG_ = (function cljs$core$async$take_BANG_(var_args){
var G__52491 = arguments.length;
switch (G__52491) {
case 2:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,fn1){
return cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3(port,fn1,true);
}));

(cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,fn1,on_caller_QMARK_){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(ret)){
var val_54692 = cljs.core.deref(ret);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_54692) : fn1.call(null, val_54692));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(val_54692) : fn1.call(null, val_54692));
}));
}
} else {
}

return null;
}));

(cljs.core.async.take_BANG_.cljs$lang$maxFixedArity = 3);

cljs.core.async.nop = (function cljs$core$async$nop(_){
return null;
});
cljs.core.async.fhnop = cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(cljs.core.async.nop);
/**
 * puts a val into port. nil values are not allowed. Must be called
 *   inside a (go ...) block. Will park if no buffer space is available.
 *   Returns true unless port is already closed.
 */
cljs.core.async._GT__BANG_ = (function cljs$core$async$_GT__BANG_(port,val){
throw (new Error(">! used not in (go ...) block"));
});
/**
 * Asynchronously puts a val into port, calling fn1 (if supplied) when
 * complete. nil values are not allowed. Will throw if closed. If
 * on-caller? (default true) is true, and the put is immediately
 * accepted, will call fn1 on calling thread.  Returns nil.
 */
cljs.core.async.put_BANG_ = (function cljs$core$async$put_BANG_(var_args){
var G__52497 = arguments.length;
switch (G__52497) {
case 2:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (port,val){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fhnop);
if(cljs.core.truth_(temp__5821__auto__)){
var ret = temp__5821__auto__;
return cljs.core.deref(ret);
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (port,val,fn1){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4(port,val,fn1,true);
}));

(cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$4 = (function (port,val,fn1,on_caller_QMARK_){
var temp__5821__auto__ = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$1(fn1));
if(cljs.core.truth_(temp__5821__auto__)){
var retb = temp__5821__auto__;
var ret = cljs.core.deref(retb);
if(cljs.core.truth_(on_caller_QMARK_)){
(fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
} else {
cljs.core.async.impl.dispatch.run((function (){
return (fn1.cljs$core$IFn$_invoke$arity$1 ? fn1.cljs$core$IFn$_invoke$arity$1(ret) : fn1.call(null, ret));
}));
}

return ret;
} else {
return true;
}
}));

(cljs.core.async.put_BANG_.cljs$lang$maxFixedArity = 4);

cljs.core.async.close_BANG_ = (function cljs$core$async$close_BANG_(port){
return cljs.core.async.impl.protocols.close_BANG_(port);
});
cljs.core.async.random_array = (function cljs$core$async$random_array(n){
var a = (new Array(n));
var n__5593__auto___54701 = n;
var x_54702 = (0);
while(true){
if((x_54702 < n__5593__auto___54701)){
(a[x_54702] = x_54702);

var G__54703 = (x_54702 + (1));
x_54702 = G__54703;
continue;
} else {
}
break;
}

cljs.core.async.goog$module$goog$array.shuffle(a);

return a;
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52501 = (function (flag,meta52502){
this.flag = flag;
this.meta52502 = meta52502;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52503,meta52502__$1){
var self__ = this;
var _52503__$1 = this;
return (new cljs.core.async.t_cljs$core$async52501(self__.flag,meta52502__$1));
}));

(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52503){
var self__ = this;
var _52503__$1 = this;
return self__.meta52502;
}));

(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.deref(self__.flag);
}));

(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async52501.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.flag,null);

return true;
}));

(cljs.core.async.t_cljs$core$async52501.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"meta52502","meta52502",-1903866711,null)], null);
}));

(cljs.core.async.t_cljs$core$async52501.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async52501.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52501");

(cljs.core.async.t_cljs$core$async52501.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async52501");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async52501.
 */
cljs.core.async.__GT_t_cljs$core$async52501 = (function cljs$core$async$__GT_t_cljs$core$async52501(flag,meta52502){
return (new cljs.core.async.t_cljs$core$async52501(flag,meta52502));
});


cljs.core.async.alt_flag = (function cljs$core$async$alt_flag(){
var flag = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(true);
return (new cljs.core.async.t_cljs$core$async52501(flag,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async52509 = (function (flag,cb,meta52510){
this.flag = flag;
this.cb = cb;
this.meta52510 = meta52510;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_52511,meta52510__$1){
var self__ = this;
var _52511__$1 = this;
return (new cljs.core.async.t_cljs$core$async52509(self__.flag,self__.cb,meta52510__$1));
}));

(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_52511){
var self__ = this;
var _52511__$1 = this;
return self__.meta52510;
}));

(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.flag);
}));

(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async52509.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.async.impl.protocols.commit(self__.flag);

return self__.cb;
}));

(cljs.core.async.t_cljs$core$async52509.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"flag","flag",-1565787888,null),new cljs.core.Symbol(null,"cb","cb",-2064487928,null),new cljs.core.Symbol(null,"meta52510","meta52510",-1401081711,null)], null);
}));

(cljs.core.async.t_cljs$core$async52509.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async52509.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async52509");

(cljs.core.async.t_cljs$core$async52509.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async52509");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async52509.
 */
cljs.core.async.__GT_t_cljs$core$async52509 = (function cljs$core$async$__GT_t_cljs$core$async52509(flag,cb,meta52510){
return (new cljs.core.async.t_cljs$core$async52509(flag,cb,meta52510));
});


cljs.core.async.alt_handler = (function cljs$core$async$alt_handler(flag,cb){
return (new cljs.core.async.t_cljs$core$async52509(flag,cb,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * returns derefable [val port] if immediate, nil if enqueued
 */
cljs.core.async.do_alts = (function cljs$core$async$do_alts(fret,ports,opts){
if((cljs.core.count(ports) > (0))){
} else {
throw (new Error(["Assert failed: ","alts must have at least one channel operation","\n","(pos? (count ports))"].join('')));
}

var flag = cljs.core.async.alt_flag();
var ports__$1 = cljs.core.vec(ports);
var n = cljs.core.count(ports__$1);
var idxs = cljs.core.async.random_array(n);
var priority = new cljs.core.Keyword(null,"priority","priority",1431093715).cljs$core$IFn$_invoke$arity$1(opts);
var ret = (function (){var i = (0);
while(true){
if((i < n)){
var idx = (cljs.core.truth_(priority)?i:(idxs[i]));
var port = cljs.core.nth.cljs$core$IFn$_invoke$arity$2(ports__$1,idx);
var wport = ((cljs.core.vector_QMARK_(port))?(port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((0)) : port.call(null, (0))):null);
var vbox = (cljs.core.truth_(wport)?(function (){var val = (port.cljs$core$IFn$_invoke$arity$1 ? port.cljs$core$IFn$_invoke$arity$1((1)) : port.call(null, (1)));
return cljs.core.async.impl.protocols.put_BANG_(wport,val,cljs.core.async.alt_handler(flag,((function (i,val,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__52534_SHARP_){
var G__52539 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__52534_SHARP_,wport], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__52539) : fret.call(null, G__52539));
});})(i,val,idx,port,wport,flag,ports__$1,n,idxs,priority))
));
})():cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.alt_handler(flag,((function (i,idx,port,wport,flag,ports__$1,n,idxs,priority){
return (function (p1__52535_SHARP_){
var G__52540 = new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [p1__52535_SHARP_,port], null);
return (fret.cljs$core$IFn$_invoke$arity$1 ? fret.cljs$core$IFn$_invoke$arity$1(G__52540) : fret.call(null, G__52540));
});})(i,idx,port,wport,flag,ports__$1,n,idxs,priority))
)));
if(cljs.core.truth_(vbox)){
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [cljs.core.deref(vbox),(function (){var or__5002__auto__ = wport;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return port;
}
})()], null));
} else {
var G__54710 = (i + (1));
i = G__54710;
continue;
}
} else {
return null;
}
break;
}
})();
var or__5002__auto__ = ret;
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
if(cljs.core.contains_QMARK_(opts,new cljs.core.Keyword(null,"default","default",-1987822328))){
var temp__5823__auto__ = (function (){var and__5000__auto__ = flag.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1(null, );
if(cljs.core.truth_(and__5000__auto__)){
return flag.cljs$core$async$impl$protocols$Handler$commit$arity$1(null, );
} else {
return and__5000__auto__;
}
})();
if(cljs.core.truth_(temp__5823__auto__)){
var got = temp__5823__auto__;
return cljs.core.async.impl.channels.box(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"default","default",-1987822328).cljs$core$IFn$_invoke$arity$1(opts),new cljs.core.Keyword(null,"default","default",-1987822328)], null));
} else {
return null;
}
} else {
return null;
}
}
});
/**
 * Completes at most one of several channel operations. Must be called
 * inside a (go ...) block. ports is a vector of channel endpoints,
 * which can be either a channel to take from or a vector of
 *   [channel-to-put-to val-to-put], in any combination. Takes will be
 *   made as if by <!, and puts will be made as if by >!. Unless
 *   the :priority option is true, if more than one port operation is
 *   ready a non-deterministic choice will be made. If no operation is
 *   ready and a :default value is supplied, [default-val :default] will
 *   be returned, otherwise alts! will park until the first operation to
 *   become ready completes. Returns [val port] of the completed
 *   operation, where val is the value taken for takes, and a
 *   boolean (true unless already closed, as per put!) for puts.
 * 
 *   opts are passed as :key val ... Supported options:
 * 
 *   :default val - the value to use if none of the operations are immediately ready
 *   :priority true - (default nil) when true, the operations will be tried in order.
 * 
 *   Note: there is no guarantee that the port exps or val exprs will be
 *   used, nor in what order should they be, so they should not be
 *   depended upon for side effects.
 */
cljs.core.async.alts_BANG_ = (function cljs$core$async$alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___54718 = arguments.length;
var i__5727__auto___54720 = (0);
while(true){
if((i__5727__auto___54720 < len__5726__auto___54718)){
args__5732__auto__.push((arguments[i__5727__auto___54720]));

var G__54721 = (i__5727__auto___54720 + (1));
i__5727__auto___54720 = G__54721;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(cljs.core.async.alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (ports,p__52560){
var map__52565 = p__52560;
var map__52565__$1 = cljs.core.__destructure_map(map__52565);
var opts = map__52565__$1;
throw (new Error("alts! used not in (go ...) block"));
}));

(cljs.core.async.alts_BANG_.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(cljs.core.async.alts_BANG_.cljs$lang$applyTo = (function (seq52541){
var G__52542 = cljs.core.first(seq52541);
var seq52541__$1 = cljs.core.next(seq52541);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__52542,seq52541__$1);
}));

/**
 * Puts a val into port if it's possible to do so immediately.
 *   nil values are not allowed. Never blocks. Returns true if offer succeeds.
 */
cljs.core.async.offer_BANG_ = (function cljs$core$async$offer_BANG_(port,val){
var ret = cljs.core.async.impl.protocols.put_BANG_(port,val,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes a val from port if it's possible to do so immediately.
 *   Never blocks. Returns value if successful, nil otherwise.
 */
cljs.core.async.poll_BANG_ = (function cljs$core$async$poll_BANG_(port){
var ret = cljs.core.async.impl.protocols.take_BANG_(port,cljs.core.async.fn_handler.cljs$core$IFn$_invoke$arity$2(cljs.core.async.nop,false));
if(cljs.core.truth_(ret)){
return cljs.core.deref(ret);
} else {
return null;
}
});
/**
 * Takes elements from the from channel and supplies them to the to
 * channel. By default, the to channel will be closed when the from
 * channel closes, but can be determined by the close?  parameter. Will
 * stop consuming the from channel if the to channel closes
 */
cljs.core.async.pipe = (function cljs$core$async$pipe(var_args){
var G__52588 = arguments.length;
switch (G__52588) {
case 2:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$2 = (function (from,to){
return cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3(from,to,true);
}));

(cljs.core.async.pipe.cljs$core$IFn$_invoke$arity$3 = (function (from,to,close_QMARK_){
var c__52308__auto___54728 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52652){
var state_val_52653 = (state_52652[(1)]);
if((state_val_52653 === (7))){
var inst_52647 = (state_52652[(2)]);
var state_52652__$1 = state_52652;
var statearr_52656_54729 = state_52652__$1;
(statearr_52656_54729[(2)] = inst_52647);

(statearr_52656_54729[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (1))){
var state_52652__$1 = state_52652;
var statearr_52657_54730 = state_52652__$1;
(statearr_52657_54730[(2)] = null);

(statearr_52657_54730[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (4))){
var inst_52629 = (state_52652[(7)]);
var inst_52629__$1 = (state_52652[(2)]);
var inst_52631 = (inst_52629__$1 == null);
var state_52652__$1 = (function (){var statearr_52658 = state_52652;
(statearr_52658[(7)] = inst_52629__$1);

return statearr_52658;
})();
if(cljs.core.truth_(inst_52631)){
var statearr_52659_54731 = state_52652__$1;
(statearr_52659_54731[(1)] = (5));

} else {
var statearr_52660_54732 = state_52652__$1;
(statearr_52660_54732[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (13))){
var state_52652__$1 = state_52652;
var statearr_52662_54736 = state_52652__$1;
(statearr_52662_54736[(2)] = null);

(statearr_52662_54736[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (6))){
var inst_52629 = (state_52652[(7)]);
var state_52652__$1 = state_52652;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52652__$1,(11),to,inst_52629);
} else {
if((state_val_52653 === (3))){
var inst_52650 = (state_52652[(2)]);
var state_52652__$1 = state_52652;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52652__$1,inst_52650);
} else {
if((state_val_52653 === (12))){
var state_52652__$1 = state_52652;
var statearr_52663_54737 = state_52652__$1;
(statearr_52663_54737[(2)] = null);

(statearr_52663_54737[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (2))){
var state_52652__$1 = state_52652;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52652__$1,(4),from);
} else {
if((state_val_52653 === (11))){
var inst_52640 = (state_52652[(2)]);
var state_52652__$1 = state_52652;
if(cljs.core.truth_(inst_52640)){
var statearr_52664_54738 = state_52652__$1;
(statearr_52664_54738[(1)] = (12));

} else {
var statearr_52666_54739 = state_52652__$1;
(statearr_52666_54739[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (9))){
var state_52652__$1 = state_52652;
var statearr_52667_54740 = state_52652__$1;
(statearr_52667_54740[(2)] = null);

(statearr_52667_54740[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (5))){
var state_52652__$1 = state_52652;
if(cljs.core.truth_(close_QMARK_)){
var statearr_52668_54742 = state_52652__$1;
(statearr_52668_54742[(1)] = (8));

} else {
var statearr_52669_54743 = state_52652__$1;
(statearr_52669_54743[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (14))){
var inst_52645 = (state_52652[(2)]);
var state_52652__$1 = state_52652;
var statearr_52670_54744 = state_52652__$1;
(statearr_52670_54744[(2)] = inst_52645);

(statearr_52670_54744[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (10))){
var inst_52637 = (state_52652[(2)]);
var state_52652__$1 = state_52652;
var statearr_52671_54745 = state_52652__$1;
(statearr_52671_54745[(2)] = inst_52637);

(statearr_52671_54745[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52653 === (8))){
var inst_52634 = cljs.core.async.close_BANG_(to);
var state_52652__$1 = state_52652;
var statearr_52672_54746 = state_52652__$1;
(statearr_52672_54746[(2)] = inst_52634);

(statearr_52672_54746[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_52674 = [null,null,null,null,null,null,null,null];
(statearr_52674[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_52674[(1)] = (1));

return statearr_52674;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_52652){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52652);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52675){var ex__52109__auto__ = e52675;
var statearr_52676_54749 = state_52652;
(statearr_52676_54749[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52652[(4)]))){
var statearr_52677_54750 = state_52652;
(statearr_52677_54750[(1)] = cljs.core.first((state_52652[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54751 = state_52652;
state_52652 = G__54751;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_52652){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_52652);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52678 = f__52309__auto__();
(statearr_52678[(6)] = c__52308__auto___54728);

return statearr_52678;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return to;
}));

(cljs.core.async.pipe.cljs$lang$maxFixedArity = 3);

cljs.core.async.pipeline_STAR_ = (function cljs$core$async$pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,type){
if((n > (0))){
} else {
throw (new Error("Assert failed: (pos? n)"));
}

var jobs = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var results = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(n);
var process__$1 = (function (p__52680){
var vec__52681 = p__52680;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52681,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52681,(1),null);
var job = vec__52681;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$3((1),xf,ex_handler);
var c__52308__auto___54753 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52689){
var state_val_52690 = (state_52689[(1)]);
if((state_val_52690 === (1))){
var state_52689__$1 = state_52689;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52689__$1,(2),res,v);
} else {
if((state_val_52690 === (2))){
var inst_52686 = (state_52689[(2)]);
var inst_52687 = cljs.core.async.close_BANG_(res);
var state_52689__$1 = (function (){var statearr_52691 = state_52689;
(statearr_52691[(7)] = inst_52686);

return statearr_52691;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_52689__$1,inst_52687);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_52692 = [null,null,null,null,null,null,null,null];
(statearr_52692[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__);

(statearr_52692[(1)] = (1));

return statearr_52692;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1 = (function (state_52689){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52689);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52693){var ex__52109__auto__ = e52693;
var statearr_52694_54755 = state_52689;
(statearr_52694_54755[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52689[(4)]))){
var statearr_52696_54757 = state_52689;
(statearr_52696_54757[(1)] = cljs.core.first((state_52689[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54758 = state_52689;
state_52689 = G__54758;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = function(state_52689){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1.call(this,state_52689);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52697 = f__52309__auto__();
(statearr_52697[(6)] = c__52308__auto___54753);

return statearr_52697;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var async = (function (p__52698){
var vec__52699 = p__52698;
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52699,(0),null);
var p = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__52699,(1),null);
var job = vec__52699;
if((job == null)){
cljs.core.async.close_BANG_(results);

return null;
} else {
var res = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
(xf.cljs$core$IFn$_invoke$arity$2 ? xf.cljs$core$IFn$_invoke$arity$2(v,res) : xf.call(null, v,res));

cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(p,res);

return true;
}
});
var n__5593__auto___54762 = n;
var __54763 = (0);
while(true){
if((__54763 < n__5593__auto___54762)){
var G__52702_54764 = type;
var G__52702_54765__$1 = (((G__52702_54764 instanceof cljs.core.Keyword))?G__52702_54764.fqn:null);
switch (G__52702_54765__$1) {
case "compute":
var c__52308__auto___54767 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__54763,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = ((function (__54763,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function (state_52715){
var state_val_52716 = (state_52715[(1)]);
if((state_val_52716 === (1))){
var state_52715__$1 = state_52715;
var statearr_52717_54768 = state_52715__$1;
(statearr_52717_54768[(2)] = null);

(statearr_52717_54768[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52716 === (2))){
var state_52715__$1 = state_52715;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52715__$1,(4),jobs);
} else {
if((state_val_52716 === (3))){
var inst_52713 = (state_52715[(2)]);
var state_52715__$1 = state_52715;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52715__$1,inst_52713);
} else {
if((state_val_52716 === (4))){
var inst_52705 = (state_52715[(2)]);
var inst_52706 = process__$1(inst_52705);
var state_52715__$1 = state_52715;
if(cljs.core.truth_(inst_52706)){
var statearr_52718_54769 = state_52715__$1;
(statearr_52718_54769[(1)] = (5));

} else {
var statearr_52719_54770 = state_52715__$1;
(statearr_52719_54770[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52716 === (5))){
var state_52715__$1 = state_52715;
var statearr_52720_54771 = state_52715__$1;
(statearr_52720_54771[(2)] = null);

(statearr_52720_54771[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52716 === (6))){
var state_52715__$1 = state_52715;
var statearr_52721_54772 = state_52715__$1;
(statearr_52721_54772[(2)] = null);

(statearr_52721_54772[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52716 === (7))){
var inst_52711 = (state_52715[(2)]);
var state_52715__$1 = state_52715;
var statearr_52722_54773 = state_52715__$1;
(statearr_52722_54773[(2)] = inst_52711);

(statearr_52722_54773[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__54763,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
;
return ((function (__54763,switch__52105__auto__,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_52723 = [null,null,null,null,null,null,null];
(statearr_52723[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__);

(statearr_52723[(1)] = (1));

return statearr_52723;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1 = (function (state_52715){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52715);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52724){var ex__52109__auto__ = e52724;
var statearr_52725_54775 = state_52715;
(statearr_52725_54775[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52715[(4)]))){
var statearr_52726_54776 = state_52715;
(statearr_52726_54776[(1)] = cljs.core.first((state_52715[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54779 = state_52715;
state_52715 = G__54779;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = function(state_52715){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1.call(this,state_52715);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__;
})()
;})(__54763,switch__52105__auto__,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
})();
var state__52310__auto__ = (function (){var statearr_52727 = f__52309__auto__();
(statearr_52727[(6)] = c__52308__auto___54767);

return statearr_52727;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
});})(__54763,c__52308__auto___54767,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
);


break;
case "async":
var c__52308__auto___54784 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run(((function (__54763,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = ((function (__54763,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function (state_52741){
var state_val_52742 = (state_52741[(1)]);
if((state_val_52742 === (1))){
var state_52741__$1 = state_52741;
var statearr_52743_54785 = state_52741__$1;
(statearr_52743_54785[(2)] = null);

(statearr_52743_54785[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52742 === (2))){
var state_52741__$1 = state_52741;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52741__$1,(4),jobs);
} else {
if((state_val_52742 === (3))){
var inst_52739 = (state_52741[(2)]);
var state_52741__$1 = state_52741;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52741__$1,inst_52739);
} else {
if((state_val_52742 === (4))){
var inst_52730 = (state_52741[(2)]);
var inst_52731 = async(inst_52730);
var state_52741__$1 = state_52741;
if(cljs.core.truth_(inst_52731)){
var statearr_52744_54786 = state_52741__$1;
(statearr_52744_54786[(1)] = (5));

} else {
var statearr_52745_54787 = state_52741__$1;
(statearr_52745_54787[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52742 === (5))){
var state_52741__$1 = state_52741;
var statearr_52746_54792 = state_52741__$1;
(statearr_52746_54792[(2)] = null);

(statearr_52746_54792[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52742 === (6))){
var state_52741__$1 = state_52741;
var statearr_52748_54793 = state_52741__$1;
(statearr_52748_54793[(2)] = null);

(statearr_52748_54793[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52742 === (7))){
var inst_52736 = (state_52741[(2)]);
var state_52741__$1 = state_52741;
var statearr_52749_54794 = state_52741__$1;
(statearr_52749_54794[(2)] = inst_52736);

(statearr_52749_54794[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
});})(__54763,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
;
return ((function (__54763,switch__52105__auto__,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async){
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_52750 = [null,null,null,null,null,null,null];
(statearr_52750[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__);

(statearr_52750[(1)] = (1));

return statearr_52750;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1 = (function (state_52741){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52741);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52751){var ex__52109__auto__ = e52751;
var statearr_52752_54798 = state_52741;
(statearr_52752_54798[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52741[(4)]))){
var statearr_52753_54799 = state_52741;
(statearr_52753_54799[(1)] = cljs.core.first((state_52741[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54800 = state_52741;
state_52741 = G__54800;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = function(state_52741){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1.call(this,state_52741);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__;
})()
;})(__54763,switch__52105__auto__,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
})();
var state__52310__auto__ = (function (){var statearr_52754 = f__52309__auto__();
(statearr_52754[(6)] = c__52308__auto___54784);

return statearr_52754;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
});})(__54763,c__52308__auto___54784,G__52702_54764,G__52702_54765__$1,n__5593__auto___54762,jobs,results,process__$1,async))
);


break;
default:
throw (new Error(["No matching clause: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(G__52702_54765__$1)].join('')));

}

var G__54801 = (__54763 + (1));
__54763 = G__54801;
continue;
} else {
}
break;
}

var c__52308__auto___54802 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52777){
var state_val_52778 = (state_52777[(1)]);
if((state_val_52778 === (7))){
var inst_52773 = (state_52777[(2)]);
var state_52777__$1 = state_52777;
var statearr_52780_54803 = state_52777__$1;
(statearr_52780_54803[(2)] = inst_52773);

(statearr_52780_54803[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52778 === (1))){
var state_52777__$1 = state_52777;
var statearr_52781_54804 = state_52777__$1;
(statearr_52781_54804[(2)] = null);

(statearr_52781_54804[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52778 === (4))){
var inst_52758 = (state_52777[(7)]);
var inst_52758__$1 = (state_52777[(2)]);
var inst_52759 = (inst_52758__$1 == null);
var state_52777__$1 = (function (){var statearr_52782 = state_52777;
(statearr_52782[(7)] = inst_52758__$1);

return statearr_52782;
})();
if(cljs.core.truth_(inst_52759)){
var statearr_52783_54805 = state_52777__$1;
(statearr_52783_54805[(1)] = (5));

} else {
var statearr_52784_54806 = state_52777__$1;
(statearr_52784_54806[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52778 === (6))){
var inst_52758 = (state_52777[(7)]);
var inst_52763 = (state_52777[(8)]);
var inst_52763__$1 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var inst_52764 = cljs.core.PersistentVector.EMPTY_NODE;
var inst_52765 = [inst_52758,inst_52763__$1];
var inst_52766 = (new cljs.core.PersistentVector(null,2,(5),inst_52764,inst_52765,null));
var state_52777__$1 = (function (){var statearr_52786 = state_52777;
(statearr_52786[(8)] = inst_52763__$1);

return statearr_52786;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52777__$1,(8),jobs,inst_52766);
} else {
if((state_val_52778 === (3))){
var inst_52775 = (state_52777[(2)]);
var state_52777__$1 = state_52777;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52777__$1,inst_52775);
} else {
if((state_val_52778 === (2))){
var state_52777__$1 = state_52777;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52777__$1,(4),from);
} else {
if((state_val_52778 === (9))){
var inst_52770 = (state_52777[(2)]);
var state_52777__$1 = (function (){var statearr_52787 = state_52777;
(statearr_52787[(9)] = inst_52770);

return statearr_52787;
})();
var statearr_52788_54811 = state_52777__$1;
(statearr_52788_54811[(2)] = null);

(statearr_52788_54811[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52778 === (5))){
var inst_52761 = cljs.core.async.close_BANG_(jobs);
var state_52777__$1 = state_52777;
var statearr_52789_54812 = state_52777__$1;
(statearr_52789_54812[(2)] = inst_52761);

(statearr_52789_54812[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52778 === (8))){
var inst_52763 = (state_52777[(8)]);
var inst_52768 = (state_52777[(2)]);
var state_52777__$1 = (function (){var statearr_52791 = state_52777;
(statearr_52791[(10)] = inst_52768);

return statearr_52791;
})();
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52777__$1,(9),results,inst_52763);
} else {
return null;
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_52792 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_52792[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__);

(statearr_52792[(1)] = (1));

return statearr_52792;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1 = (function (state_52777){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52777);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52793){var ex__52109__auto__ = e52793;
var statearr_52794_54814 = state_52777;
(statearr_52794_54814[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52777[(4)]))){
var statearr_52795_54815 = state_52777;
(statearr_52795_54815[(1)] = cljs.core.first((state_52777[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54816 = state_52777;
state_52777 = G__54816;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = function(state_52777){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1.call(this,state_52777);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52796 = f__52309__auto__();
(statearr_52796[(6)] = c__52308__auto___54802);

return statearr_52796;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


var c__52308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52835){
var state_val_52836 = (state_52835[(1)]);
if((state_val_52836 === (7))){
var inst_52831 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
var statearr_52838_54817 = state_52835__$1;
(statearr_52838_54817[(2)] = inst_52831);

(statearr_52838_54817[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (20))){
var state_52835__$1 = state_52835;
var statearr_52839_54821 = state_52835__$1;
(statearr_52839_54821[(2)] = null);

(statearr_52839_54821[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (1))){
var state_52835__$1 = state_52835;
var statearr_52840_54822 = state_52835__$1;
(statearr_52840_54822[(2)] = null);

(statearr_52840_54822[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (4))){
var inst_52800 = (state_52835[(7)]);
var inst_52800__$1 = (state_52835[(2)]);
var inst_52801 = (inst_52800__$1 == null);
var state_52835__$1 = (function (){var statearr_52841 = state_52835;
(statearr_52841[(7)] = inst_52800__$1);

return statearr_52841;
})();
if(cljs.core.truth_(inst_52801)){
var statearr_52842_54827 = state_52835__$1;
(statearr_52842_54827[(1)] = (5));

} else {
var statearr_52843_54828 = state_52835__$1;
(statearr_52843_54828[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (15))){
var inst_52813 = (state_52835[(8)]);
var state_52835__$1 = state_52835;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52835__$1,(18),to,inst_52813);
} else {
if((state_val_52836 === (21))){
var inst_52826 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
var statearr_52845_54833 = state_52835__$1;
(statearr_52845_54833[(2)] = inst_52826);

(statearr_52845_54833[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (13))){
var inst_52828 = (state_52835[(2)]);
var state_52835__$1 = (function (){var statearr_52846 = state_52835;
(statearr_52846[(9)] = inst_52828);

return statearr_52846;
})();
var statearr_52847_54834 = state_52835__$1;
(statearr_52847_54834[(2)] = null);

(statearr_52847_54834[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (6))){
var inst_52800 = (state_52835[(7)]);
var state_52835__$1 = state_52835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52835__$1,(11),inst_52800);
} else {
if((state_val_52836 === (17))){
var inst_52821 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
if(cljs.core.truth_(inst_52821)){
var statearr_52848_54835 = state_52835__$1;
(statearr_52848_54835[(1)] = (19));

} else {
var statearr_52849_54836 = state_52835__$1;
(statearr_52849_54836[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (3))){
var inst_52833 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52835__$1,inst_52833);
} else {
if((state_val_52836 === (12))){
var inst_52810 = (state_52835[(10)]);
var state_52835__$1 = state_52835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52835__$1,(14),inst_52810);
} else {
if((state_val_52836 === (2))){
var state_52835__$1 = state_52835;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52835__$1,(4),results);
} else {
if((state_val_52836 === (19))){
var state_52835__$1 = state_52835;
var statearr_52850_54840 = state_52835__$1;
(statearr_52850_54840[(2)] = null);

(statearr_52850_54840[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (11))){
var inst_52810 = (state_52835[(2)]);
var state_52835__$1 = (function (){var statearr_52851 = state_52835;
(statearr_52851[(10)] = inst_52810);

return statearr_52851;
})();
var statearr_52853_54841 = state_52835__$1;
(statearr_52853_54841[(2)] = null);

(statearr_52853_54841[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (9))){
var state_52835__$1 = state_52835;
var statearr_52854_54842 = state_52835__$1;
(statearr_52854_54842[(2)] = null);

(statearr_52854_54842[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (5))){
var state_52835__$1 = state_52835;
if(cljs.core.truth_(close_QMARK_)){
var statearr_52855_54843 = state_52835__$1;
(statearr_52855_54843[(1)] = (8));

} else {
var statearr_52856_54844 = state_52835__$1;
(statearr_52856_54844[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (14))){
var inst_52813 = (state_52835[(8)]);
var inst_52815 = (state_52835[(11)]);
var inst_52813__$1 = (state_52835[(2)]);
var inst_52814 = (inst_52813__$1 == null);
var inst_52815__$1 = cljs.core.not(inst_52814);
var state_52835__$1 = (function (){var statearr_52857 = state_52835;
(statearr_52857[(8)] = inst_52813__$1);

(statearr_52857[(11)] = inst_52815__$1);

return statearr_52857;
})();
if(inst_52815__$1){
var statearr_52858_54845 = state_52835__$1;
(statearr_52858_54845[(1)] = (15));

} else {
var statearr_52859_54846 = state_52835__$1;
(statearr_52859_54846[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (16))){
var inst_52815 = (state_52835[(11)]);
var state_52835__$1 = state_52835;
var statearr_52860_54847 = state_52835__$1;
(statearr_52860_54847[(2)] = inst_52815);

(statearr_52860_54847[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (10))){
var inst_52807 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
var statearr_52862_54848 = state_52835__$1;
(statearr_52862_54848[(2)] = inst_52807);

(statearr_52862_54848[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (18))){
var inst_52818 = (state_52835[(2)]);
var state_52835__$1 = state_52835;
var statearr_52863_54851 = state_52835__$1;
(statearr_52863_54851[(2)] = inst_52818);

(statearr_52863_54851[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52836 === (8))){
var inst_52804 = cljs.core.async.close_BANG_(to);
var state_52835__$1 = state_52835;
var statearr_52864_54852 = state_52835__$1;
(statearr_52864_54852[(2)] = inst_52804);

(statearr_52864_54852[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_52865 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_52865[(0)] = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__);

(statearr_52865[(1)] = (1));

return statearr_52865;
});
var cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1 = (function (state_52835){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52835);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52866){var ex__52109__auto__ = e52866;
var statearr_52868_54856 = state_52835;
(statearr_52868_54856[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52835[(4)]))){
var statearr_52869_54857 = state_52835;
(statearr_52869_54857[(1)] = cljs.core.first((state_52835[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54858 = state_52835;
state_52835 = G__54858;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__ = function(state_52835){
switch(arguments.length){
case 0:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1.call(this,state_52835);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____0;
cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$pipeline_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$pipeline_STAR__$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52870 = f__52309__auto__();
(statearr_52870[(6)] = c__52308__auto__);

return statearr_52870;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

return c__52308__auto__;
});
/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the async function af, with parallelism n. af
 *   must be a function of two arguments, the first an input value and
 *   the second a channel on which to place the result(s). The
 *   presumption is that af will return immediately, having launched some
 *   asynchronous operation whose completion/callback will put results on
 *   the channel, then close! it. Outputs will be returned in order
 *   relative to the inputs. By default, the to channel will be closed
 *   when the from channel closes, but can be determined by the close?
 *   parameter. Will stop consuming the from channel if the to channel
 *   closes. See also pipeline, pipeline-blocking.
 */
cljs.core.async.pipeline_async = (function cljs$core$async$pipeline_async(var_args){
var G__52873 = arguments.length;
switch (G__52873) {
case 4:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$4 = (function (n,to,af,from){
return cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5(n,to,af,from,true);
}));

(cljs.core.async.pipeline_async.cljs$core$IFn$_invoke$arity$5 = (function (n,to,af,from,close_QMARK_){
return cljs.core.async.pipeline_STAR_(n,to,af,from,close_QMARK_,null,new cljs.core.Keyword(null,"async","async",1050769601));
}));

(cljs.core.async.pipeline_async.cljs$lang$maxFixedArity = 5);

/**
 * Takes elements from the from channel and supplies them to the to
 *   channel, subject to the transducer xf, with parallelism n. Because
 *   it is parallel, the transducer will be applied independently to each
 *   element, not across elements, and may produce zero or more outputs
 *   per input.  Outputs will be returned in order relative to the
 *   inputs. By default, the to channel will be closed when the from
 *   channel closes, but can be determined by the close?  parameter. Will
 *   stop consuming the from channel if the to channel closes.
 * 
 *   Note this is supplied for API compatibility with the Clojure version.
 *   Values of N > 1 will not result in actual concurrency in a
 *   single-threaded runtime.
 */
cljs.core.async.pipeline = (function cljs$core$async$pipeline(var_args){
var G__52876 = arguments.length;
switch (G__52876) {
case 4:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
case 5:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]));

break;
case 6:
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]),(arguments[(4)]),(arguments[(5)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$4 = (function (n,to,xf,from){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5(n,to,xf,from,true);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$5 = (function (n,to,xf,from,close_QMARK_){
return cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6(n,to,xf,from,close_QMARK_,null);
}));

(cljs.core.async.pipeline.cljs$core$IFn$_invoke$arity$6 = (function (n,to,xf,from,close_QMARK_,ex_handler){
return cljs.core.async.pipeline_STAR_(n,to,xf,from,close_QMARK_,ex_handler,new cljs.core.Keyword(null,"compute","compute",1555393130));
}));

(cljs.core.async.pipeline.cljs$lang$maxFixedArity = 6);

/**
 * Takes a predicate and a source channel and returns a vector of two
 *   channels, the first of which will contain the values for which the
 *   predicate returned true, the second those for which it returned
 *   false.
 * 
 *   The out channels will be unbuffered by default, or two buf-or-ns can
 *   be supplied. The channels will close after the source channel has
 *   closed.
 */
cljs.core.async.split = (function cljs$core$async$split(var_args){
var G__52879 = arguments.length;
switch (G__52879) {
case 2:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.split.cljs$core$IFn$_invoke$arity$4(p,ch,null,null);
}));

(cljs.core.async.split.cljs$core$IFn$_invoke$arity$4 = (function (p,ch,t_buf_or_n,f_buf_or_n){
var tc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(t_buf_or_n);
var fc = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(f_buf_or_n);
var c__52308__auto___54862 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52906){
var state_val_52907 = (state_52906[(1)]);
if((state_val_52907 === (7))){
var inst_52902 = (state_52906[(2)]);
var state_52906__$1 = state_52906;
var statearr_52908_54863 = state_52906__$1;
(statearr_52908_54863[(2)] = inst_52902);

(statearr_52908_54863[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (1))){
var state_52906__$1 = state_52906;
var statearr_52910_54864 = state_52906__$1;
(statearr_52910_54864[(2)] = null);

(statearr_52910_54864[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (4))){
var inst_52883 = (state_52906[(7)]);
var inst_52883__$1 = (state_52906[(2)]);
var inst_52884 = (inst_52883__$1 == null);
var state_52906__$1 = (function (){var statearr_52911 = state_52906;
(statearr_52911[(7)] = inst_52883__$1);

return statearr_52911;
})();
if(cljs.core.truth_(inst_52884)){
var statearr_52912_54865 = state_52906__$1;
(statearr_52912_54865[(1)] = (5));

} else {
var statearr_52913_54866 = state_52906__$1;
(statearr_52913_54866[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (13))){
var state_52906__$1 = state_52906;
var statearr_52914_54869 = state_52906__$1;
(statearr_52914_54869[(2)] = null);

(statearr_52914_54869[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (6))){
var inst_52883 = (state_52906[(7)]);
var inst_52889 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_52883) : p.call(null, inst_52883));
var state_52906__$1 = state_52906;
if(cljs.core.truth_(inst_52889)){
var statearr_52915_54870 = state_52906__$1;
(statearr_52915_54870[(1)] = (9));

} else {
var statearr_52916_54872 = state_52906__$1;
(statearr_52916_54872[(1)] = (10));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (3))){
var inst_52904 = (state_52906[(2)]);
var state_52906__$1 = state_52906;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52906__$1,inst_52904);
} else {
if((state_val_52907 === (12))){
var state_52906__$1 = state_52906;
var statearr_52918_54878 = state_52906__$1;
(statearr_52918_54878[(2)] = null);

(statearr_52918_54878[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (2))){
var state_52906__$1 = state_52906;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52906__$1,(4),ch);
} else {
if((state_val_52907 === (11))){
var inst_52883 = (state_52906[(7)]);
var inst_52893 = (state_52906[(2)]);
var state_52906__$1 = state_52906;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_52906__$1,(8),inst_52893,inst_52883);
} else {
if((state_val_52907 === (9))){
var state_52906__$1 = state_52906;
var statearr_52919_54879 = state_52906__$1;
(statearr_52919_54879[(2)] = tc);

(statearr_52919_54879[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (5))){
var inst_52886 = cljs.core.async.close_BANG_(tc);
var inst_52887 = cljs.core.async.close_BANG_(fc);
var state_52906__$1 = (function (){var statearr_52920 = state_52906;
(statearr_52920[(8)] = inst_52886);

return statearr_52920;
})();
var statearr_52921_54880 = state_52906__$1;
(statearr_52921_54880[(2)] = inst_52887);

(statearr_52921_54880[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (14))){
var inst_52900 = (state_52906[(2)]);
var state_52906__$1 = state_52906;
var statearr_52922_54884 = state_52906__$1;
(statearr_52922_54884[(2)] = inst_52900);

(statearr_52922_54884[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (10))){
var state_52906__$1 = state_52906;
var statearr_52923_54885 = state_52906__$1;
(statearr_52923_54885[(2)] = fc);

(statearr_52923_54885[(1)] = (11));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52907 === (8))){
var inst_52895 = (state_52906[(2)]);
var state_52906__$1 = state_52906;
if(cljs.core.truth_(inst_52895)){
var statearr_52925_54886 = state_52906__$1;
(statearr_52925_54886[(1)] = (12));

} else {
var statearr_52926_54887 = state_52906__$1;
(statearr_52926_54887[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_52927 = [null,null,null,null,null,null,null,null,null];
(statearr_52927[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_52927[(1)] = (1));

return statearr_52927;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_52906){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52906);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52928){var ex__52109__auto__ = e52928;
var statearr_52929_54895 = state_52906;
(statearr_52929_54895[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52906[(4)]))){
var statearr_52930_54896 = state_52906;
(statearr_52930_54896[(1)] = cljs.core.first((state_52906[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54897 = state_52906;
state_52906 = G__54897;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_52906){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_52906);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52931 = f__52309__auto__();
(statearr_52931[(6)] = c__52308__auto___54862);

return statearr_52931;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [tc,fc], null);
}));

(cljs.core.async.split.cljs$lang$maxFixedArity = 4);

/**
 * f should be a function of 2 arguments. Returns a channel containing
 *   the single result of applying f to init and the first item from the
 *   channel, then applying f to that result and the 2nd item, etc. If
 *   the channel closes without yielding items, returns init and f is not
 *   called. ch must close before reduce produces a result.
 */
cljs.core.async.reduce = (function cljs$core$async$reduce(f,init,ch){
var c__52308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52954){
var state_val_52955 = (state_52954[(1)]);
if((state_val_52955 === (7))){
var inst_52950 = (state_52954[(2)]);
var state_52954__$1 = state_52954;
var statearr_52957_54898 = state_52954__$1;
(statearr_52957_54898[(2)] = inst_52950);

(statearr_52957_54898[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (1))){
var inst_52933 = init;
var inst_52934 = inst_52933;
var state_52954__$1 = (function (){var statearr_52958 = state_52954;
(statearr_52958[(7)] = inst_52934);

return statearr_52958;
})();
var statearr_52959_54899 = state_52954__$1;
(statearr_52959_54899[(2)] = null);

(statearr_52959_54899[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (4))){
var inst_52937 = (state_52954[(8)]);
var inst_52937__$1 = (state_52954[(2)]);
var inst_52938 = (inst_52937__$1 == null);
var state_52954__$1 = (function (){var statearr_52962 = state_52954;
(statearr_52962[(8)] = inst_52937__$1);

return statearr_52962;
})();
if(cljs.core.truth_(inst_52938)){
var statearr_52963_54903 = state_52954__$1;
(statearr_52963_54903[(1)] = (5));

} else {
var statearr_52964_54904 = state_52954__$1;
(statearr_52964_54904[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (6))){
var inst_52934 = (state_52954[(7)]);
var inst_52937 = (state_52954[(8)]);
var inst_52941 = (state_52954[(9)]);
var inst_52941__$1 = (f.cljs$core$IFn$_invoke$arity$2 ? f.cljs$core$IFn$_invoke$arity$2(inst_52934,inst_52937) : f.call(null, inst_52934,inst_52937));
var inst_52942 = cljs.core.reduced_QMARK_(inst_52941__$1);
var state_52954__$1 = (function (){var statearr_52965 = state_52954;
(statearr_52965[(9)] = inst_52941__$1);

return statearr_52965;
})();
if(inst_52942){
var statearr_52966_54906 = state_52954__$1;
(statearr_52966_54906[(1)] = (8));

} else {
var statearr_52967_54907 = state_52954__$1;
(statearr_52967_54907[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (3))){
var inst_52952 = (state_52954[(2)]);
var state_52954__$1 = state_52954;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52954__$1,inst_52952);
} else {
if((state_val_52955 === (2))){
var state_52954__$1 = state_52954;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52954__$1,(4),ch);
} else {
if((state_val_52955 === (9))){
var inst_52941 = (state_52954[(9)]);
var inst_52934 = inst_52941;
var state_52954__$1 = (function (){var statearr_52968 = state_52954;
(statearr_52968[(7)] = inst_52934);

return statearr_52968;
})();
var statearr_52969_54908 = state_52954__$1;
(statearr_52969_54908[(2)] = null);

(statearr_52969_54908[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (5))){
var inst_52934 = (state_52954[(7)]);
var state_52954__$1 = state_52954;
var statearr_52970_54909 = state_52954__$1;
(statearr_52970_54909[(2)] = inst_52934);

(statearr_52970_54909[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (10))){
var inst_52948 = (state_52954[(2)]);
var state_52954__$1 = state_52954;
var statearr_52971_54913 = state_52954__$1;
(statearr_52971_54913[(2)] = inst_52948);

(statearr_52971_54913[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_52955 === (8))){
var inst_52941 = (state_52954[(9)]);
var inst_52944 = cljs.core.deref(inst_52941);
var state_52954__$1 = state_52954;
var statearr_52974_54914 = state_52954__$1;
(statearr_52974_54914[(2)] = inst_52944);

(statearr_52974_54914[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$reduce_$_state_machine__52106__auto__ = null;
var cljs$core$async$reduce_$_state_machine__52106__auto____0 = (function (){
var statearr_52975 = [null,null,null,null,null,null,null,null,null,null];
(statearr_52975[(0)] = cljs$core$async$reduce_$_state_machine__52106__auto__);

(statearr_52975[(1)] = (1));

return statearr_52975;
});
var cljs$core$async$reduce_$_state_machine__52106__auto____1 = (function (state_52954){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52954);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52976){var ex__52109__auto__ = e52976;
var statearr_52977_54915 = state_52954;
(statearr_52977_54915[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52954[(4)]))){
var statearr_52978_54916 = state_52954;
(statearr_52978_54916[(1)] = cljs.core.first((state_52954[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54917 = state_52954;
state_52954 = G__54917;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$reduce_$_state_machine__52106__auto__ = function(state_52954){
switch(arguments.length){
case 0:
return cljs$core$async$reduce_$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$reduce_$_state_machine__52106__auto____1.call(this,state_52954);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$reduce_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$reduce_$_state_machine__52106__auto____0;
cljs$core$async$reduce_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$reduce_$_state_machine__52106__auto____1;
return cljs$core$async$reduce_$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52979 = f__52309__auto__();
(statearr_52979[(6)] = c__52308__auto__);

return statearr_52979;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

return c__52308__auto__;
});
/**
 * async/reduces a channel with a transformation (xform f).
 *   Returns a channel containing the result.  ch must close before
 *   transduce produces a result.
 */
cljs.core.async.transduce = (function cljs$core$async$transduce(xform,f,init,ch){
var f__$1 = (xform.cljs$core$IFn$_invoke$arity$1 ? xform.cljs$core$IFn$_invoke$arity$1(f) : xform.call(null, f));
var c__52308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_52985){
var state_val_52986 = (state_52985[(1)]);
if((state_val_52986 === (1))){
var inst_52980 = cljs.core.async.reduce(f__$1,init,ch);
var state_52985__$1 = state_52985;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_52985__$1,(2),inst_52980);
} else {
if((state_val_52986 === (2))){
var inst_52982 = (state_52985[(2)]);
var inst_52983 = (f__$1.cljs$core$IFn$_invoke$arity$1 ? f__$1.cljs$core$IFn$_invoke$arity$1(inst_52982) : f__$1.call(null, inst_52982));
var state_52985__$1 = state_52985;
return cljs.core.async.impl.ioc_helpers.return_chan(state_52985__$1,inst_52983);
} else {
return null;
}
}
});
return (function() {
var cljs$core$async$transduce_$_state_machine__52106__auto__ = null;
var cljs$core$async$transduce_$_state_machine__52106__auto____0 = (function (){
var statearr_52987 = [null,null,null,null,null,null,null];
(statearr_52987[(0)] = cljs$core$async$transduce_$_state_machine__52106__auto__);

(statearr_52987[(1)] = (1));

return statearr_52987;
});
var cljs$core$async$transduce_$_state_machine__52106__auto____1 = (function (state_52985){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_52985);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e52988){var ex__52109__auto__ = e52988;
var statearr_52989_54924 = state_52985;
(statearr_52989_54924[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_52985[(4)]))){
var statearr_52990_54925 = state_52985;
(statearr_52990_54925[(1)] = cljs.core.first((state_52985[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54926 = state_52985;
state_52985 = G__54926;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$transduce_$_state_machine__52106__auto__ = function(state_52985){
switch(arguments.length){
case 0:
return cljs$core$async$transduce_$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$transduce_$_state_machine__52106__auto____1.call(this,state_52985);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$transduce_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$transduce_$_state_machine__52106__auto____0;
cljs$core$async$transduce_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$transduce_$_state_machine__52106__auto____1;
return cljs$core$async$transduce_$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_52993 = f__52309__auto__();
(statearr_52993[(6)] = c__52308__auto__);

return statearr_52993;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

return c__52308__auto__;
});
/**
 * Puts the contents of coll into the supplied channel.
 * 
 *   By default the channel will be closed after the items are copied,
 *   but can be determined by the close? parameter.
 * 
 *   Returns a channel which will close after the items are copied.
 */
cljs.core.async.onto_chan_BANG_ = (function cljs$core$async$onto_chan_BANG_(var_args){
var G__52995 = arguments.length;
switch (G__52995) {
case 2:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
var c__52308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_53020){
var state_val_53021 = (state_53020[(1)]);
if((state_val_53021 === (7))){
var inst_53002 = (state_53020[(2)]);
var state_53020__$1 = state_53020;
var statearr_53022_54932 = state_53020__$1;
(statearr_53022_54932[(2)] = inst_53002);

(statearr_53022_54932[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (1))){
var inst_52996 = cljs.core.seq(coll);
var inst_52997 = inst_52996;
var state_53020__$1 = (function (){var statearr_53023 = state_53020;
(statearr_53023[(7)] = inst_52997);

return statearr_53023;
})();
var statearr_53024_54933 = state_53020__$1;
(statearr_53024_54933[(2)] = null);

(statearr_53024_54933[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (4))){
var inst_52997 = (state_53020[(7)]);
var inst_53000 = cljs.core.first(inst_52997);
var state_53020__$1 = state_53020;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53020__$1,(7),ch,inst_53000);
} else {
if((state_val_53021 === (13))){
var inst_53014 = (state_53020[(2)]);
var state_53020__$1 = state_53020;
var statearr_53025_54934 = state_53020__$1;
(statearr_53025_54934[(2)] = inst_53014);

(statearr_53025_54934[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (6))){
var inst_53005 = (state_53020[(2)]);
var state_53020__$1 = state_53020;
if(cljs.core.truth_(inst_53005)){
var statearr_53026_54935 = state_53020__$1;
(statearr_53026_54935[(1)] = (8));

} else {
var statearr_53027_54936 = state_53020__$1;
(statearr_53027_54936[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (3))){
var inst_53018 = (state_53020[(2)]);
var state_53020__$1 = state_53020;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53020__$1,inst_53018);
} else {
if((state_val_53021 === (12))){
var state_53020__$1 = state_53020;
var statearr_53031_54937 = state_53020__$1;
(statearr_53031_54937[(2)] = null);

(statearr_53031_54937[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (2))){
var inst_52997 = (state_53020[(7)]);
var state_53020__$1 = state_53020;
if(cljs.core.truth_(inst_52997)){
var statearr_53032_54938 = state_53020__$1;
(statearr_53032_54938[(1)] = (4));

} else {
var statearr_53033_54939 = state_53020__$1;
(statearr_53033_54939[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (11))){
var inst_53011 = cljs.core.async.close_BANG_(ch);
var state_53020__$1 = state_53020;
var statearr_53034_54940 = state_53020__$1;
(statearr_53034_54940[(2)] = inst_53011);

(statearr_53034_54940[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (9))){
var state_53020__$1 = state_53020;
if(cljs.core.truth_(close_QMARK_)){
var statearr_53038_54941 = state_53020__$1;
(statearr_53038_54941[(1)] = (11));

} else {
var statearr_53039_54942 = state_53020__$1;
(statearr_53039_54942[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (5))){
var inst_52997 = (state_53020[(7)]);
var state_53020__$1 = state_53020;
var statearr_53043_54943 = state_53020__$1;
(statearr_53043_54943[(2)] = inst_52997);

(statearr_53043_54943[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (10))){
var inst_53016 = (state_53020[(2)]);
var state_53020__$1 = state_53020;
var statearr_53044_54944 = state_53020__$1;
(statearr_53044_54944[(2)] = inst_53016);

(statearr_53044_54944[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53021 === (8))){
var inst_52997 = (state_53020[(7)]);
var inst_53007 = cljs.core.next(inst_52997);
var inst_52997__$1 = inst_53007;
var state_53020__$1 = (function (){var statearr_53045 = state_53020;
(statearr_53045[(7)] = inst_52997__$1);

return statearr_53045;
})();
var statearr_53046_54945 = state_53020__$1;
(statearr_53046_54945[(2)] = null);

(statearr_53046_54945[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_53047 = [null,null,null,null,null,null,null,null];
(statearr_53047[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_53047[(1)] = (1));

return statearr_53047;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_53020){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_53020);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e53049){var ex__52109__auto__ = e53049;
var statearr_53050_54946 = state_53020;
(statearr_53050_54946[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_53020[(4)]))){
var statearr_53053_54950 = state_53020;
(statearr_53053_54950[(1)] = cljs.core.first((state_53020[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__54951 = state_53020;
state_53020 = G__54951;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_53020){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_53020);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_53056 = f__52309__auto__();
(statearr_53056[(6)] = c__52308__auto__);

return statearr_53056;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

return c__52308__auto__;
}));

(cljs.core.async.onto_chan_BANG_.cljs$lang$maxFixedArity = 3);

/**
 * Creates and returns a channel which contains the contents of coll,
 *   closing when exhausted.
 */
cljs.core.async.to_chan_BANG_ = (function cljs$core$async$to_chan_BANG_(coll){
var ch = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.bounded_count((100),coll));
cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$2(ch,coll);

return ch;
});
/**
 * Deprecated - use onto-chan!
 */
cljs.core.async.onto_chan = (function cljs$core$async$onto_chan(var_args){
var G__53065 = arguments.length;
switch (G__53065) {
case 2:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$2 = (function (ch,coll){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,true);
}));

(cljs.core.async.onto_chan.cljs$core$IFn$_invoke$arity$3 = (function (ch,coll,close_QMARK_){
return cljs.core.async.onto_chan_BANG_.cljs$core$IFn$_invoke$arity$3(ch,coll,close_QMARK_);
}));

(cljs.core.async.onto_chan.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - use to-chan!
 */
cljs.core.async.to_chan = (function cljs$core$async$to_chan(coll){
return cljs.core.async.to_chan_BANG_(coll);
});

/**
 * @interface
 */
cljs.core.async.Mux = function(){};

var cljs$core$async$Mux$muxch_STAR_$dyn_54955 = (function (_){
var x__5350__auto__ = (((_ == null))?null:_);
var m__5351__auto__ = (cljs.core.async.muxch_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5351__auto__.call(null, _));
} else {
var m__5349__auto__ = (cljs.core.async.muxch_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(_) : m__5349__auto__.call(null, _));
} else {
throw cljs.core.missing_protocol("Mux.muxch*",_);
}
}
});
cljs.core.async.muxch_STAR_ = (function cljs$core$async$muxch_STAR_(_){
if((((!((_ == null)))) && ((!((_.cljs$core$async$Mux$muxch_STAR_$arity$1 == null)))))){
return _.cljs$core$async$Mux$muxch_STAR_$arity$1(_);
} else {
return cljs$core$async$Mux$muxch_STAR_$dyn_54955(_);
}
});


/**
 * @interface
 */
cljs.core.async.Mult = function(){};

var cljs$core$async$Mult$tap_STAR_$dyn_54957 = (function (m,ch,close_QMARK_){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.tap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5351__auto__.call(null, m,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.tap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(m,ch,close_QMARK_) : m__5349__auto__.call(null, m,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Mult.tap*",m);
}
}
});
cljs.core.async.tap_STAR_ = (function cljs$core$async$tap_STAR_(m,ch,close_QMARK_){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$tap_STAR_$arity$3 == null)))))){
return m.cljs$core$async$Mult$tap_STAR_$arity$3(m,ch,close_QMARK_);
} else {
return cljs$core$async$Mult$tap_STAR_$dyn_54957(m,ch,close_QMARK_);
}
});

var cljs$core$async$Mult$untap_STAR_$dyn_54958 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.untap_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mult.untap*",m);
}
}
});
cljs.core.async.untap_STAR_ = (function cljs$core$async$untap_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mult$untap_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mult$untap_STAR_$dyn_54958(m,ch);
}
});

var cljs$core$async$Mult$untap_all_STAR_$dyn_54959 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.untap_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.untap_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mult.untap-all*",m);
}
}
});
cljs.core.async.untap_all_STAR_ = (function cljs$core$async$untap_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mult$untap_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mult$untap_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mult$untap_all_STAR_$dyn_54959(m);
}
});


/**
* @constructor
 * @implements {cljs.core.async.Mult}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async53100 = (function (ch,cs,meta53101){
this.ch = ch;
this.cs = cs;
this.meta53101 = meta53101;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_53102,meta53101__$1){
var self__ = this;
var _53102__$1 = this;
return (new cljs.core.async.t_cljs$core$async53100(self__.ch,self__.cs,meta53101__$1));
}));

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_53102){
var self__ = this;
var _53102__$1 = this;
return self__.meta53101;
}));

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mult$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mult$tap_STAR_$arity$3 = (function (_,ch__$1,close_QMARK_){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch__$1,close_QMARK_);

return null;
}));

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mult$untap_STAR_$arity$2 = (function (_,ch__$1){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch__$1);

return null;
}));

(cljs.core.async.t_cljs$core$async53100.prototype.cljs$core$async$Mult$untap_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return null;
}));

(cljs.core.async.t_cljs$core$async53100.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"meta53101","meta53101",-1345984420,null)], null);
}));

(cljs.core.async.t_cljs$core$async53100.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async53100.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async53100");

(cljs.core.async.t_cljs$core$async53100.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async53100");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async53100.
 */
cljs.core.async.__GT_t_cljs$core$async53100 = (function cljs$core$async$__GT_t_cljs$core$async53100(ch,cs,meta53101){
return (new cljs.core.async.t_cljs$core$async53100(ch,cs,meta53101));
});


/**
 * Creates and returns a mult(iple) of the supplied channel. Channels
 *   containing copies of the channel can be created with 'tap', and
 *   detached with 'untap'.
 * 
 *   Each item is distributed to all taps in parallel and synchronously,
 *   i.e. each tap must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow taps from holding up the mult.
 * 
 *   Items received when there are no taps get dropped.
 * 
 *   If a tap puts to a closed channel, it will be removed from the mult.
 */
cljs.core.async.mult = (function cljs$core$async$mult(ch){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var m = (new cljs.core.async.t_cljs$core$async53100(ch,cs,cljs.core.PersistentArrayMap.EMPTY));
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = (function (_){
if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,true);
} else {
return null;
}
});
var c__52308__auto___54962 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_53276){
var state_val_53277 = (state_53276[(1)]);
if((state_val_53277 === (7))){
var inst_53266 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53282_54964 = state_53276__$1;
(statearr_53282_54964[(2)] = inst_53266);

(statearr_53282_54964[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (20))){
var inst_53158 = (state_53276[(7)]);
var inst_53173 = cljs.core.first(inst_53158);
var inst_53174 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53173,(0),null);
var inst_53175 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53173,(1),null);
var state_53276__$1 = (function (){var statearr_53284 = state_53276;
(statearr_53284[(8)] = inst_53174);

return statearr_53284;
})();
if(cljs.core.truth_(inst_53175)){
var statearr_53285_54969 = state_53276__$1;
(statearr_53285_54969[(1)] = (22));

} else {
var statearr_53286_54970 = state_53276__$1;
(statearr_53286_54970[(1)] = (23));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (27))){
var inst_53206 = (state_53276[(9)]);
var inst_53208 = (state_53276[(10)]);
var inst_53214 = (state_53276[(11)]);
var inst_53122 = (state_53276[(12)]);
var inst_53214__$1 = cljs.core._nth(inst_53206,inst_53208);
var inst_53215 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_53214__$1,inst_53122,done);
var state_53276__$1 = (function (){var statearr_53293 = state_53276;
(statearr_53293[(11)] = inst_53214__$1);

return statearr_53293;
})();
if(cljs.core.truth_(inst_53215)){
var statearr_53294_54975 = state_53276__$1;
(statearr_53294_54975[(1)] = (30));

} else {
var statearr_53295_54981 = state_53276__$1;
(statearr_53295_54981[(1)] = (31));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (1))){
var state_53276__$1 = state_53276;
var statearr_53299_54982 = state_53276__$1;
(statearr_53299_54982[(2)] = null);

(statearr_53299_54982[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (24))){
var inst_53158 = (state_53276[(7)]);
var inst_53181 = (state_53276[(2)]);
var inst_53182 = cljs.core.next(inst_53158);
var inst_53132 = inst_53182;
var inst_53133 = null;
var inst_53134 = (0);
var inst_53135 = (0);
var state_53276__$1 = (function (){var statearr_53300 = state_53276;
(statearr_53300[(13)] = inst_53181);

(statearr_53300[(14)] = inst_53132);

(statearr_53300[(15)] = inst_53133);

(statearr_53300[(16)] = inst_53134);

(statearr_53300[(17)] = inst_53135);

return statearr_53300;
})();
var statearr_53302_54983 = state_53276__$1;
(statearr_53302_54983[(2)] = null);

(statearr_53302_54983[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (39))){
var state_53276__$1 = state_53276;
var statearr_53310_54984 = state_53276__$1;
(statearr_53310_54984[(2)] = null);

(statearr_53310_54984[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (4))){
var inst_53122 = (state_53276[(12)]);
var inst_53122__$1 = (state_53276[(2)]);
var inst_53123 = (inst_53122__$1 == null);
var state_53276__$1 = (function (){var statearr_53313 = state_53276;
(statearr_53313[(12)] = inst_53122__$1);

return statearr_53313;
})();
if(cljs.core.truth_(inst_53123)){
var statearr_53315_54986 = state_53276__$1;
(statearr_53315_54986[(1)] = (5));

} else {
var statearr_53316_54987 = state_53276__$1;
(statearr_53316_54987[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (15))){
var inst_53135 = (state_53276[(17)]);
var inst_53132 = (state_53276[(14)]);
var inst_53133 = (state_53276[(15)]);
var inst_53134 = (state_53276[(16)]);
var inst_53153 = (state_53276[(2)]);
var inst_53154 = (inst_53135 + (1));
var tmp53306 = inst_53132;
var tmp53307 = inst_53134;
var tmp53308 = inst_53133;
var inst_53132__$1 = tmp53306;
var inst_53133__$1 = tmp53308;
var inst_53134__$1 = tmp53307;
var inst_53135__$1 = inst_53154;
var state_53276__$1 = (function (){var statearr_53318 = state_53276;
(statearr_53318[(18)] = inst_53153);

(statearr_53318[(14)] = inst_53132__$1);

(statearr_53318[(15)] = inst_53133__$1);

(statearr_53318[(16)] = inst_53134__$1);

(statearr_53318[(17)] = inst_53135__$1);

return statearr_53318;
})();
var statearr_53321_54992 = state_53276__$1;
(statearr_53321_54992[(2)] = null);

(statearr_53321_54992[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (21))){
var inst_53185 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53326_54993 = state_53276__$1;
(statearr_53326_54993[(2)] = inst_53185);

(statearr_53326_54993[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (31))){
var inst_53214 = (state_53276[(11)]);
var inst_53218 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_53214);
var state_53276__$1 = state_53276;
var statearr_53328_54994 = state_53276__$1;
(statearr_53328_54994[(2)] = inst_53218);

(statearr_53328_54994[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (32))){
var inst_53208 = (state_53276[(10)]);
var inst_53205 = (state_53276[(19)]);
var inst_53206 = (state_53276[(9)]);
var inst_53207 = (state_53276[(20)]);
var inst_53220 = (state_53276[(2)]);
var inst_53222 = (inst_53208 + (1));
var tmp53323 = inst_53207;
var tmp53324 = inst_53205;
var tmp53325 = inst_53206;
var inst_53205__$1 = tmp53324;
var inst_53206__$1 = tmp53325;
var inst_53207__$1 = tmp53323;
var inst_53208__$1 = inst_53222;
var state_53276__$1 = (function (){var statearr_53332 = state_53276;
(statearr_53332[(21)] = inst_53220);

(statearr_53332[(19)] = inst_53205__$1);

(statearr_53332[(9)] = inst_53206__$1);

(statearr_53332[(20)] = inst_53207__$1);

(statearr_53332[(10)] = inst_53208__$1);

return statearr_53332;
})();
var statearr_53333_54995 = state_53276__$1;
(statearr_53333_54995[(2)] = null);

(statearr_53333_54995[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (40))){
var inst_53238 = (state_53276[(22)]);
var inst_53242 = m.cljs$core$async$Mult$untap_STAR_$arity$2(null, inst_53238);
var state_53276__$1 = state_53276;
var statearr_53336_54996 = state_53276__$1;
(statearr_53336_54996[(2)] = inst_53242);

(statearr_53336_54996[(1)] = (41));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (33))){
var inst_53225 = (state_53276[(23)]);
var inst_53230 = cljs.core.chunked_seq_QMARK_(inst_53225);
var state_53276__$1 = state_53276;
if(inst_53230){
var statearr_53341_54997 = state_53276__$1;
(statearr_53341_54997[(1)] = (36));

} else {
var statearr_53342_54998 = state_53276__$1;
(statearr_53342_54998[(1)] = (37));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (13))){
var inst_53147 = (state_53276[(24)]);
var inst_53150 = cljs.core.async.close_BANG_(inst_53147);
var state_53276__$1 = state_53276;
var statearr_53344_54999 = state_53276__$1;
(statearr_53344_54999[(2)] = inst_53150);

(statearr_53344_54999[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (22))){
var inst_53174 = (state_53276[(8)]);
var inst_53178 = cljs.core.async.close_BANG_(inst_53174);
var state_53276__$1 = state_53276;
var statearr_53347_55000 = state_53276__$1;
(statearr_53347_55000[(2)] = inst_53178);

(statearr_53347_55000[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (36))){
var inst_53225 = (state_53276[(23)]);
var inst_53233 = cljs.core.chunk_first(inst_53225);
var inst_53234 = cljs.core.chunk_rest(inst_53225);
var inst_53235 = cljs.core.count(inst_53233);
var inst_53205 = inst_53234;
var inst_53206 = inst_53233;
var inst_53207 = inst_53235;
var inst_53208 = (0);
var state_53276__$1 = (function (){var statearr_53349 = state_53276;
(statearr_53349[(19)] = inst_53205);

(statearr_53349[(9)] = inst_53206);

(statearr_53349[(20)] = inst_53207);

(statearr_53349[(10)] = inst_53208);

return statearr_53349;
})();
var statearr_53351_55001 = state_53276__$1;
(statearr_53351_55001[(2)] = null);

(statearr_53351_55001[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (41))){
var inst_53225 = (state_53276[(23)]);
var inst_53244 = (state_53276[(2)]);
var inst_53245 = cljs.core.next(inst_53225);
var inst_53205 = inst_53245;
var inst_53206 = null;
var inst_53207 = (0);
var inst_53208 = (0);
var state_53276__$1 = (function (){var statearr_53355 = state_53276;
(statearr_53355[(25)] = inst_53244);

(statearr_53355[(19)] = inst_53205);

(statearr_53355[(9)] = inst_53206);

(statearr_53355[(20)] = inst_53207);

(statearr_53355[(10)] = inst_53208);

return statearr_53355;
})();
var statearr_53356_55002 = state_53276__$1;
(statearr_53356_55002[(2)] = null);

(statearr_53356_55002[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (43))){
var state_53276__$1 = state_53276;
var statearr_53358_55003 = state_53276__$1;
(statearr_53358_55003[(2)] = null);

(statearr_53358_55003[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (29))){
var inst_53254 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53359_55004 = state_53276__$1;
(statearr_53359_55004[(2)] = inst_53254);

(statearr_53359_55004[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (44))){
var inst_53263 = (state_53276[(2)]);
var state_53276__$1 = (function (){var statearr_53363 = state_53276;
(statearr_53363[(26)] = inst_53263);

return statearr_53363;
})();
var statearr_53364_55005 = state_53276__$1;
(statearr_53364_55005[(2)] = null);

(statearr_53364_55005[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (6))){
var inst_53195 = (state_53276[(27)]);
var inst_53194 = cljs.core.deref(cs);
var inst_53195__$1 = cljs.core.keys(inst_53194);
var inst_53196 = cljs.core.count(inst_53195__$1);
var inst_53197 = cljs.core.reset_BANG_(dctr,inst_53196);
var inst_53204 = cljs.core.seq(inst_53195__$1);
var inst_53205 = inst_53204;
var inst_53206 = null;
var inst_53207 = (0);
var inst_53208 = (0);
var state_53276__$1 = (function (){var statearr_53367 = state_53276;
(statearr_53367[(27)] = inst_53195__$1);

(statearr_53367[(28)] = inst_53197);

(statearr_53367[(19)] = inst_53205);

(statearr_53367[(9)] = inst_53206);

(statearr_53367[(20)] = inst_53207);

(statearr_53367[(10)] = inst_53208);

return statearr_53367;
})();
var statearr_53370_55007 = state_53276__$1;
(statearr_53370_55007[(2)] = null);

(statearr_53370_55007[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (28))){
var inst_53205 = (state_53276[(19)]);
var inst_53225 = (state_53276[(23)]);
var inst_53225__$1 = cljs.core.seq(inst_53205);
var state_53276__$1 = (function (){var statearr_53372 = state_53276;
(statearr_53372[(23)] = inst_53225__$1);

return statearr_53372;
})();
if(inst_53225__$1){
var statearr_53373_55011 = state_53276__$1;
(statearr_53373_55011[(1)] = (33));

} else {
var statearr_53374_55012 = state_53276__$1;
(statearr_53374_55012[(1)] = (34));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (25))){
var inst_53208 = (state_53276[(10)]);
var inst_53207 = (state_53276[(20)]);
var inst_53211 = (inst_53208 < inst_53207);
var inst_53212 = inst_53211;
var state_53276__$1 = state_53276;
if(cljs.core.truth_(inst_53212)){
var statearr_53378_55013 = state_53276__$1;
(statearr_53378_55013[(1)] = (27));

} else {
var statearr_53379_55014 = state_53276__$1;
(statearr_53379_55014[(1)] = (28));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (34))){
var state_53276__$1 = state_53276;
var statearr_53381_55016 = state_53276__$1;
(statearr_53381_55016[(2)] = null);

(statearr_53381_55016[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (17))){
var state_53276__$1 = state_53276;
var statearr_53384_55017 = state_53276__$1;
(statearr_53384_55017[(2)] = null);

(statearr_53384_55017[(1)] = (18));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (3))){
var inst_53268 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53276__$1,inst_53268);
} else {
if((state_val_53277 === (12))){
var inst_53190 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53386_55018 = state_53276__$1;
(statearr_53386_55018[(2)] = inst_53190);

(statearr_53386_55018[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (2))){
var state_53276__$1 = state_53276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53276__$1,(4),ch);
} else {
if((state_val_53277 === (23))){
var state_53276__$1 = state_53276;
var statearr_53390_55020 = state_53276__$1;
(statearr_53390_55020[(2)] = null);

(statearr_53390_55020[(1)] = (24));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (35))){
var inst_53251 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53392_55021 = state_53276__$1;
(statearr_53392_55021[(2)] = inst_53251);

(statearr_53392_55021[(1)] = (29));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (19))){
var inst_53158 = (state_53276[(7)]);
var inst_53162 = cljs.core.chunk_first(inst_53158);
var inst_53163 = cljs.core.chunk_rest(inst_53158);
var inst_53164 = cljs.core.count(inst_53162);
var inst_53132 = inst_53163;
var inst_53133 = inst_53162;
var inst_53134 = inst_53164;
var inst_53135 = (0);
var state_53276__$1 = (function (){var statearr_53398 = state_53276;
(statearr_53398[(14)] = inst_53132);

(statearr_53398[(15)] = inst_53133);

(statearr_53398[(16)] = inst_53134);

(statearr_53398[(17)] = inst_53135);

return statearr_53398;
})();
var statearr_53400_55023 = state_53276__$1;
(statearr_53400_55023[(2)] = null);

(statearr_53400_55023[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (11))){
var inst_53132 = (state_53276[(14)]);
var inst_53158 = (state_53276[(7)]);
var inst_53158__$1 = cljs.core.seq(inst_53132);
var state_53276__$1 = (function (){var statearr_53402 = state_53276;
(statearr_53402[(7)] = inst_53158__$1);

return statearr_53402;
})();
if(inst_53158__$1){
var statearr_53403_55024 = state_53276__$1;
(statearr_53403_55024[(1)] = (16));

} else {
var statearr_53406_55027 = state_53276__$1;
(statearr_53406_55027[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (9))){
var inst_53192 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53412_55028 = state_53276__$1;
(statearr_53412_55028[(2)] = inst_53192);

(statearr_53412_55028[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (5))){
var inst_53130 = cljs.core.deref(cs);
var inst_53131 = cljs.core.seq(inst_53130);
var inst_53132 = inst_53131;
var inst_53133 = null;
var inst_53134 = (0);
var inst_53135 = (0);
var state_53276__$1 = (function (){var statearr_53418 = state_53276;
(statearr_53418[(14)] = inst_53132);

(statearr_53418[(15)] = inst_53133);

(statearr_53418[(16)] = inst_53134);

(statearr_53418[(17)] = inst_53135);

return statearr_53418;
})();
var statearr_53422_55029 = state_53276__$1;
(statearr_53422_55029[(2)] = null);

(statearr_53422_55029[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (14))){
var state_53276__$1 = state_53276;
var statearr_53424_55031 = state_53276__$1;
(statearr_53424_55031[(2)] = null);

(statearr_53424_55031[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (45))){
var inst_53260 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53426_55032 = state_53276__$1;
(statearr_53426_55032[(2)] = inst_53260);

(statearr_53426_55032[(1)] = (44));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (26))){
var inst_53195 = (state_53276[(27)]);
var inst_53256 = (state_53276[(2)]);
var inst_53257 = cljs.core.seq(inst_53195);
var state_53276__$1 = (function (){var statearr_53430 = state_53276;
(statearr_53430[(29)] = inst_53256);

return statearr_53430;
})();
if(inst_53257){
var statearr_53431_55035 = state_53276__$1;
(statearr_53431_55035[(1)] = (42));

} else {
var statearr_53432_55036 = state_53276__$1;
(statearr_53432_55036[(1)] = (43));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (16))){
var inst_53158 = (state_53276[(7)]);
var inst_53160 = cljs.core.chunked_seq_QMARK_(inst_53158);
var state_53276__$1 = state_53276;
if(inst_53160){
var statearr_53438_55039 = state_53276__$1;
(statearr_53438_55039[(1)] = (19));

} else {
var statearr_53439_55040 = state_53276__$1;
(statearr_53439_55040[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (38))){
var inst_53248 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53447_55041 = state_53276__$1;
(statearr_53447_55041[(2)] = inst_53248);

(statearr_53447_55041[(1)] = (35));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (30))){
var state_53276__$1 = state_53276;
var statearr_53448_55043 = state_53276__$1;
(statearr_53448_55043[(2)] = null);

(statearr_53448_55043[(1)] = (32));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (10))){
var inst_53133 = (state_53276[(15)]);
var inst_53135 = (state_53276[(17)]);
var inst_53146 = cljs.core._nth(inst_53133,inst_53135);
var inst_53147 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53146,(0),null);
var inst_53148 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53146,(1),null);
var state_53276__$1 = (function (){var statearr_53452 = state_53276;
(statearr_53452[(24)] = inst_53147);

return statearr_53452;
})();
if(cljs.core.truth_(inst_53148)){
var statearr_53457_55044 = state_53276__$1;
(statearr_53457_55044[(1)] = (13));

} else {
var statearr_53458_55045 = state_53276__$1;
(statearr_53458_55045[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (18))){
var inst_53188 = (state_53276[(2)]);
var state_53276__$1 = state_53276;
var statearr_53461_55050 = state_53276__$1;
(statearr_53461_55050[(2)] = inst_53188);

(statearr_53461_55050[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (42))){
var state_53276__$1 = state_53276;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53276__$1,(45),dchan);
} else {
if((state_val_53277 === (37))){
var inst_53225 = (state_53276[(23)]);
var inst_53238 = (state_53276[(22)]);
var inst_53122 = (state_53276[(12)]);
var inst_53238__$1 = cljs.core.first(inst_53225);
var inst_53239 = cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$3(inst_53238__$1,inst_53122,done);
var state_53276__$1 = (function (){var statearr_53468 = state_53276;
(statearr_53468[(22)] = inst_53238__$1);

return statearr_53468;
})();
if(cljs.core.truth_(inst_53239)){
var statearr_53469_55051 = state_53276__$1;
(statearr_53469_55051[(1)] = (39));

} else {
var statearr_53470_55052 = state_53276__$1;
(statearr_53470_55052[(1)] = (40));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53277 === (8))){
var inst_53135 = (state_53276[(17)]);
var inst_53134 = (state_53276[(16)]);
var inst_53138 = (inst_53135 < inst_53134);
var inst_53139 = inst_53138;
var state_53276__$1 = state_53276;
if(cljs.core.truth_(inst_53139)){
var statearr_53471_55053 = state_53276__$1;
(statearr_53471_55053[(1)] = (10));

} else {
var statearr_53475_55054 = state_53276__$1;
(statearr_53475_55054[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mult_$_state_machine__52106__auto__ = null;
var cljs$core$async$mult_$_state_machine__52106__auto____0 = (function (){
var statearr_53477 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53477[(0)] = cljs$core$async$mult_$_state_machine__52106__auto__);

(statearr_53477[(1)] = (1));

return statearr_53477;
});
var cljs$core$async$mult_$_state_machine__52106__auto____1 = (function (state_53276){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_53276);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e53479){var ex__52109__auto__ = e53479;
var statearr_53480_55055 = state_53276;
(statearr_53480_55055[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_53276[(4)]))){
var statearr_53481_55056 = state_53276;
(statearr_53481_55056[(1)] = cljs.core.first((state_53276[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55057 = state_53276;
state_53276 = G__55057;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$mult_$_state_machine__52106__auto__ = function(state_53276){
switch(arguments.length){
case 0:
return cljs$core$async$mult_$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$mult_$_state_machine__52106__auto____1.call(this,state_53276);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mult_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mult_$_state_machine__52106__auto____0;
cljs$core$async$mult_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mult_$_state_machine__52106__auto____1;
return cljs$core$async$mult_$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_53482 = f__52309__auto__();
(statearr_53482[(6)] = c__52308__auto___54962);

return statearr_53482;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return m;
});
/**
 * Copies the mult source onto the supplied channel.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.tap = (function cljs$core$async$tap(var_args){
var G__53491 = arguments.length;
switch (G__53491) {
case 2:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$2 = (function (mult,ch){
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(mult,ch,true);
}));

(cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3 = (function (mult,ch,close_QMARK_){
cljs.core.async.tap_STAR_(mult,ch,close_QMARK_);

return ch;
}));

(cljs.core.async.tap.cljs$lang$maxFixedArity = 3);

/**
 * Disconnects a target channel from a mult
 */
cljs.core.async.untap = (function cljs$core$async$untap(mult,ch){
return cljs.core.async.untap_STAR_(mult,ch);
});
/**
 * Disconnects all target channels from a mult
 */
cljs.core.async.untap_all = (function cljs$core$async$untap_all(mult){
return cljs.core.async.untap_all_STAR_(mult);
});

/**
 * @interface
 */
cljs.core.async.Mix = function(){};

var cljs$core$async$Mix$admix_STAR_$dyn_55068 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.admix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.admix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.admix*",m);
}
}
});
cljs.core.async.admix_STAR_ = (function cljs$core$async$admix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$admix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$admix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$admix_STAR_$dyn_55068(m,ch);
}
});

var cljs$core$async$Mix$unmix_STAR_$dyn_55075 = (function (m,ch){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5351__auto__.call(null, m,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,ch) : m__5349__auto__.call(null, m,ch));
} else {
throw cljs.core.missing_protocol("Mix.unmix*",m);
}
}
});
cljs.core.async.unmix_STAR_ = (function cljs$core$async$unmix_STAR_(m,ch){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$unmix_STAR_$arity$2(m,ch);
} else {
return cljs$core$async$Mix$unmix_STAR_$dyn_55075(m,ch);
}
});

var cljs$core$async$Mix$unmix_all_STAR_$dyn_55081 = (function (m){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.unmix_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5351__auto__.call(null, m));
} else {
var m__5349__auto__ = (cljs.core.async.unmix_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(m) : m__5349__auto__.call(null, m));
} else {
throw cljs.core.missing_protocol("Mix.unmix-all*",m);
}
}
});
cljs.core.async.unmix_all_STAR_ = (function cljs$core$async$unmix_all_STAR_(m){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$unmix_all_STAR_$arity$1 == null)))))){
return m.cljs$core$async$Mix$unmix_all_STAR_$arity$1(m);
} else {
return cljs$core$async$Mix$unmix_all_STAR_$dyn_55081(m);
}
});

var cljs$core$async$Mix$toggle_STAR_$dyn_55087 = (function (m,state_map){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.toggle_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5351__auto__.call(null, m,state_map));
} else {
var m__5349__auto__ = (cljs.core.async.toggle_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,state_map) : m__5349__auto__.call(null, m,state_map));
} else {
throw cljs.core.missing_protocol("Mix.toggle*",m);
}
}
});
cljs.core.async.toggle_STAR_ = (function cljs$core$async$toggle_STAR_(m,state_map){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$toggle_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$toggle_STAR_$arity$2(m,state_map);
} else {
return cljs$core$async$Mix$toggle_STAR_$dyn_55087(m,state_map);
}
});

var cljs$core$async$Mix$solo_mode_STAR_$dyn_55094 = (function (m,mode){
var x__5350__auto__ = (((m == null))?null:m);
var m__5351__auto__ = (cljs.core.async.solo_mode_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5351__auto__.call(null, m,mode));
} else {
var m__5349__auto__ = (cljs.core.async.solo_mode_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(m,mode) : m__5349__auto__.call(null, m,mode));
} else {
throw cljs.core.missing_protocol("Mix.solo-mode*",m);
}
}
});
cljs.core.async.solo_mode_STAR_ = (function cljs$core$async$solo_mode_STAR_(m,mode){
if((((!((m == null)))) && ((!((m.cljs$core$async$Mix$solo_mode_STAR_$arity$2 == null)))))){
return m.cljs$core$async$Mix$solo_mode_STAR_$arity$2(m,mode);
} else {
return cljs$core$async$Mix$solo_mode_STAR_$dyn_55094(m,mode);
}
});

cljs.core.async.ioc_alts_BANG_ = (function cljs$core$async$ioc_alts_BANG_(var_args){
var args__5732__auto__ = [];
var len__5726__auto___55097 = arguments.length;
var i__5727__auto___55098 = (0);
while(true){
if((i__5727__auto___55098 < len__5726__auto___55097)){
args__5732__auto__.push((arguments[i__5727__auto___55098]));

var G__55103 = (i__5727__auto___55098 + (1));
i__5727__auto___55098 = G__55103;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((3) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((3)),(0),null)):null);
return cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),argseq__5733__auto__);
});

(cljs.core.async.ioc_alts_BANG_.cljs$core$IFn$_invoke$arity$variadic = (function (state,cont_block,ports,p__53535){
var map__53536 = p__53535;
var map__53536__$1 = cljs.core.__destructure_map(map__53536);
var opts = map__53536__$1;
var statearr_53540_55108 = state;
(statearr_53540_55108[(1)] = cont_block);


var temp__5823__auto__ = cljs.core.async.do_alts((function (val){
var statearr_53542_55109 = state;
(statearr_53542_55109[(2)] = val);


return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state);
}),ports,opts);
if(cljs.core.truth_(temp__5823__auto__)){
var cb = temp__5823__auto__;
var statearr_53543_55110 = state;
(statearr_53543_55110[(2)] = cljs.core.deref(cb));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}));

(cljs.core.async.ioc_alts_BANG_.cljs$lang$maxFixedArity = (3));

/** @this {Function} */
(cljs.core.async.ioc_alts_BANG_.cljs$lang$applyTo = (function (seq53527){
var G__53528 = cljs.core.first(seq53527);
var seq53527__$1 = cljs.core.next(seq53527);
var G__53529 = cljs.core.first(seq53527__$1);
var seq53527__$2 = cljs.core.next(seq53527__$1);
var G__53530 = cljs.core.first(seq53527__$2);
var seq53527__$3 = cljs.core.next(seq53527__$2);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__53528,G__53529,G__53530,seq53527__$3);
}));


/**
* @constructor
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mix}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async53556 = (function (change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta53557){
this.change = change;
this.solo_mode = solo_mode;
this.pick = pick;
this.cs = cs;
this.calc_state = calc_state;
this.out = out;
this.changed = changed;
this.solo_modes = solo_modes;
this.attrs = attrs;
this.meta53557 = meta53557;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_53558,meta53557__$1){
var self__ = this;
var _53558__$1 = this;
return (new cljs.core.async.t_cljs$core$async53556(self__.change,self__.solo_mode,self__.pick,self__.cs,self__.calc_state,self__.out,self__.changed,self__.solo_modes,self__.attrs,meta53557__$1));
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_53558){
var self__ = this;
var _53558__$1 = this;
return self__.meta53557;
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.out;
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$admix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$4(self__.cs,cljs.core.assoc,ch,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$unmix_STAR_$arity$2 = (function (_,ch){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.dissoc,ch);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$unmix_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
cljs.core.reset_BANG_(self__.cs,cljs.core.PersistentArrayMap.EMPTY);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$toggle_STAR_$arity$2 = (function (_,state_map){
var self__ = this;
var ___$1 = this;
cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.cs,cljs.core.partial.cljs$core$IFn$_invoke$arity$2(cljs.core.merge_with,cljs.core.merge),state_map);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async53556.prototype.cljs$core$async$Mix$solo_mode_STAR_$arity$2 = (function (_,mode){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.solo_modes.cljs$core$IFn$_invoke$arity$1 ? self__.solo_modes.cljs$core$IFn$_invoke$arity$1(mode) : self__.solo_modes.call(null, mode)))){
} else {
throw (new Error(["Assert failed: ",["mode must be one of: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(self__.solo_modes)].join(''),"\n","(solo-modes mode)"].join('')));
}

cljs.core.reset_BANG_(self__.solo_mode,mode);

return (self__.changed.cljs$core$IFn$_invoke$arity$0 ? self__.changed.cljs$core$IFn$_invoke$arity$0() : self__.changed.call(null, ));
}));

(cljs.core.async.t_cljs$core$async53556.getBasis = (function (){
return new cljs.core.PersistentVector(null, 10, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"change","change",477485025,null),new cljs.core.Symbol(null,"solo-mode","solo-mode",2031788074,null),new cljs.core.Symbol(null,"pick","pick",1300068175,null),new cljs.core.Symbol(null,"cs","cs",-117024463,null),new cljs.core.Symbol(null,"calc-state","calc-state",-349968968,null),new cljs.core.Symbol(null,"out","out",729986010,null),new cljs.core.Symbol(null,"changed","changed",-2083710852,null),new cljs.core.Symbol(null,"solo-modes","solo-modes",882180540,null),new cljs.core.Symbol(null,"attrs","attrs",-450137186,null),new cljs.core.Symbol(null,"meta53557","meta53557",-2025905126,null)], null);
}));

(cljs.core.async.t_cljs$core$async53556.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async53556.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async53556");

(cljs.core.async.t_cljs$core$async53556.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async53556");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async53556.
 */
cljs.core.async.__GT_t_cljs$core$async53556 = (function cljs$core$async$__GT_t_cljs$core$async53556(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta53557){
return (new cljs.core.async.t_cljs$core$async53556(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,meta53557));
});


/**
 * Creates and returns a mix of one or more input channels which will
 *   be put on the supplied out channel. Input sources can be added to
 *   the mix with 'admix', and removed with 'unmix'. A mix supports
 *   soloing, muting and pausing multiple inputs atomically using
 *   'toggle', and can solo using either muting or pausing as determined
 *   by 'solo-mode'.
 * 
 *   Each channel can have zero or more boolean modes set via 'toggle':
 * 
 *   :solo - when true, only this (ond other soloed) channel(s) will appear
 *        in the mix output channel. :mute and :pause states of soloed
 *        channels are ignored. If solo-mode is :mute, non-soloed
 *        channels are muted, if :pause, non-soloed channels are
 *        paused.
 * 
 *   :mute - muted channels will have their contents consumed but not included in the mix
 *   :pause - paused channels will not have their contents consumed (and thus also not included in the mix)
 */
cljs.core.async.mix = (function cljs$core$async$mix(out){
var cs = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var solo_modes = new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"pause","pause",-2095325672),null,new cljs.core.Keyword(null,"mute","mute",1151223646),null], null), null);
var attrs = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(solo_modes,new cljs.core.Keyword(null,"solo","solo",-316350075));
var solo_mode = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.Keyword(null,"mute","mute",1151223646));
var change = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(cljs.core.async.sliding_buffer((1)));
var changed = (function (){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(change,true);
});
var pick = (function (attr,chs){
return cljs.core.reduce_kv((function (ret,c,v){
if(cljs.core.truth_((attr.cljs$core$IFn$_invoke$arity$1 ? attr.cljs$core$IFn$_invoke$arity$1(v) : attr.call(null, v)))){
return cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,c);
} else {
return ret;
}
}),cljs.core.PersistentHashSet.EMPTY,chs);
});
var calc_state = (function (){
var chs = cljs.core.deref(cs);
var mode = cljs.core.deref(solo_mode);
var solos = pick(new cljs.core.Keyword(null,"solo","solo",-316350075),chs);
var pauses = pick(new cljs.core.Keyword(null,"pause","pause",-2095325672),chs);
return new cljs.core.PersistentArrayMap(null, 3, [new cljs.core.Keyword(null,"solos","solos",1441458643),solos,new cljs.core.Keyword(null,"mutes","mutes",1068806309),pick(new cljs.core.Keyword(null,"mute","mute",1151223646),chs),new cljs.core.Keyword(null,"reads","reads",-1215067361),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(((((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(mode,new cljs.core.Keyword(null,"pause","pause",-2095325672))) && (cljs.core.seq(solos))))?cljs.core.vec(solos):cljs.core.vec(cljs.core.remove.cljs$core$IFn$_invoke$arity$2(pauses,cljs.core.keys(chs)))),change)], null);
});
var m = (new cljs.core.async.t_cljs$core$async53556(change,solo_mode,pick,cs,calc_state,out,changed,solo_modes,attrs,cljs.core.PersistentArrayMap.EMPTY));
var c__52308__auto___55143 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_53633){
var state_val_53634 = (state_53633[(1)]);
if((state_val_53634 === (7))){
var inst_53593 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
if(cljs.core.truth_(inst_53593)){
var statearr_53635_55144 = state_53633__$1;
(statearr_53635_55144[(1)] = (8));

} else {
var statearr_53636_55145 = state_53633__$1;
(statearr_53636_55145[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (20))){
var inst_53586 = (state_53633[(7)]);
var state_53633__$1 = state_53633;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53633__$1,(23),out,inst_53586);
} else {
if((state_val_53634 === (1))){
var inst_53569 = calc_state();
var inst_53570 = cljs.core.__destructure_map(inst_53569);
var inst_53571 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53570,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_53572 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53570,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_53573 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53570,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var inst_53574 = inst_53569;
var state_53633__$1 = (function (){var statearr_53637 = state_53633;
(statearr_53637[(8)] = inst_53571);

(statearr_53637[(9)] = inst_53572);

(statearr_53637[(10)] = inst_53573);

(statearr_53637[(11)] = inst_53574);

return statearr_53637;
})();
var statearr_53638_55162 = state_53633__$1;
(statearr_53638_55162[(2)] = null);

(statearr_53638_55162[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (24))){
var inst_53577 = (state_53633[(12)]);
var inst_53574 = inst_53577;
var state_53633__$1 = (function (){var statearr_53639 = state_53633;
(statearr_53639[(11)] = inst_53574);

return statearr_53639;
})();
var statearr_53640_55166 = state_53633__$1;
(statearr_53640_55166[(2)] = null);

(statearr_53640_55166[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (4))){
var inst_53586 = (state_53633[(7)]);
var inst_53588 = (state_53633[(13)]);
var inst_53585 = (state_53633[(2)]);
var inst_53586__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53585,(0),null);
var inst_53587 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53585,(1),null);
var inst_53588__$1 = (inst_53586__$1 == null);
var state_53633__$1 = (function (){var statearr_53641 = state_53633;
(statearr_53641[(7)] = inst_53586__$1);

(statearr_53641[(14)] = inst_53587);

(statearr_53641[(13)] = inst_53588__$1);

return statearr_53641;
})();
if(cljs.core.truth_(inst_53588__$1)){
var statearr_53642_55181 = state_53633__$1;
(statearr_53642_55181[(1)] = (5));

} else {
var statearr_53643_55183 = state_53633__$1;
(statearr_53643_55183[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (15))){
var inst_53578 = (state_53633[(15)]);
var inst_53607 = (state_53633[(16)]);
var inst_53607__$1 = cljs.core.empty_QMARK_(inst_53578);
var state_53633__$1 = (function (){var statearr_53644 = state_53633;
(statearr_53644[(16)] = inst_53607__$1);

return statearr_53644;
})();
if(inst_53607__$1){
var statearr_53645_55197 = state_53633__$1;
(statearr_53645_55197[(1)] = (17));

} else {
var statearr_53646_55201 = state_53633__$1;
(statearr_53646_55201[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (21))){
var inst_53577 = (state_53633[(12)]);
var inst_53574 = inst_53577;
var state_53633__$1 = (function (){var statearr_53647 = state_53633;
(statearr_53647[(11)] = inst_53574);

return statearr_53647;
})();
var statearr_53648_55203 = state_53633__$1;
(statearr_53648_55203[(2)] = null);

(statearr_53648_55203[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (13))){
var inst_53600 = (state_53633[(2)]);
var inst_53601 = calc_state();
var inst_53574 = inst_53601;
var state_53633__$1 = (function (){var statearr_53650 = state_53633;
(statearr_53650[(17)] = inst_53600);

(statearr_53650[(11)] = inst_53574);

return statearr_53650;
})();
var statearr_53651_55206 = state_53633__$1;
(statearr_53651_55206[(2)] = null);

(statearr_53651_55206[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (22))){
var inst_53627 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
var statearr_53653_55212 = state_53633__$1;
(statearr_53653_55212[(2)] = inst_53627);

(statearr_53653_55212[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (6))){
var inst_53587 = (state_53633[(14)]);
var inst_53591 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_53587,change);
var state_53633__$1 = state_53633;
var statearr_53654_55216 = state_53633__$1;
(statearr_53654_55216[(2)] = inst_53591);

(statearr_53654_55216[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (25))){
var state_53633__$1 = state_53633;
var statearr_53655_55217 = state_53633__$1;
(statearr_53655_55217[(2)] = null);

(statearr_53655_55217[(1)] = (26));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (17))){
var inst_53579 = (state_53633[(18)]);
var inst_53587 = (state_53633[(14)]);
var inst_53609 = (inst_53579.cljs$core$IFn$_invoke$arity$1 ? inst_53579.cljs$core$IFn$_invoke$arity$1(inst_53587) : inst_53579.call(null, inst_53587));
var inst_53610 = cljs.core.not(inst_53609);
var state_53633__$1 = state_53633;
var statearr_53656_55224 = state_53633__$1;
(statearr_53656_55224[(2)] = inst_53610);

(statearr_53656_55224[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (3))){
var inst_53631 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53633__$1,inst_53631);
} else {
if((state_val_53634 === (12))){
var state_53633__$1 = state_53633;
var statearr_53657_55235 = state_53633__$1;
(statearr_53657_55235[(2)] = null);

(statearr_53657_55235[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (2))){
var inst_53574 = (state_53633[(11)]);
var inst_53577 = (state_53633[(12)]);
var inst_53577__$1 = cljs.core.__destructure_map(inst_53574);
var inst_53578 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53577__$1,new cljs.core.Keyword(null,"solos","solos",1441458643));
var inst_53579 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53577__$1,new cljs.core.Keyword(null,"mutes","mutes",1068806309));
var inst_53580 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53577__$1,new cljs.core.Keyword(null,"reads","reads",-1215067361));
var state_53633__$1 = (function (){var statearr_53659 = state_53633;
(statearr_53659[(12)] = inst_53577__$1);

(statearr_53659[(15)] = inst_53578);

(statearr_53659[(18)] = inst_53579);

return statearr_53659;
})();
return cljs.core.async.ioc_alts_BANG_(state_53633__$1,(4),inst_53580);
} else {
if((state_val_53634 === (23))){
var inst_53618 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
if(cljs.core.truth_(inst_53618)){
var statearr_53661_55247 = state_53633__$1;
(statearr_53661_55247[(1)] = (24));

} else {
var statearr_53662_55248 = state_53633__$1;
(statearr_53662_55248[(1)] = (25));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (19))){
var inst_53613 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
var statearr_53663_55249 = state_53633__$1;
(statearr_53663_55249[(2)] = inst_53613);

(statearr_53663_55249[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (11))){
var inst_53587 = (state_53633[(14)]);
var inst_53597 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(cs,cljs.core.dissoc,inst_53587);
var state_53633__$1 = state_53633;
var statearr_53664_55254 = state_53633__$1;
(statearr_53664_55254[(2)] = inst_53597);

(statearr_53664_55254[(1)] = (13));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (9))){
var inst_53578 = (state_53633[(15)]);
var inst_53587 = (state_53633[(14)]);
var inst_53604 = (state_53633[(19)]);
var inst_53604__$1 = (inst_53578.cljs$core$IFn$_invoke$arity$1 ? inst_53578.cljs$core$IFn$_invoke$arity$1(inst_53587) : inst_53578.call(null, inst_53587));
var state_53633__$1 = (function (){var statearr_53665 = state_53633;
(statearr_53665[(19)] = inst_53604__$1);

return statearr_53665;
})();
if(cljs.core.truth_(inst_53604__$1)){
var statearr_53666_55256 = state_53633__$1;
(statearr_53666_55256[(1)] = (14));

} else {
var statearr_53668_55257 = state_53633__$1;
(statearr_53668_55257[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (5))){
var inst_53588 = (state_53633[(13)]);
var state_53633__$1 = state_53633;
var statearr_53670_55258 = state_53633__$1;
(statearr_53670_55258[(2)] = inst_53588);

(statearr_53670_55258[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (14))){
var inst_53604 = (state_53633[(19)]);
var state_53633__$1 = state_53633;
var statearr_53671_55260 = state_53633__$1;
(statearr_53671_55260[(2)] = inst_53604);

(statearr_53671_55260[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (26))){
var inst_53623 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
var statearr_53672_55261 = state_53633__$1;
(statearr_53672_55261[(2)] = inst_53623);

(statearr_53672_55261[(1)] = (22));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (16))){
var inst_53615 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
if(cljs.core.truth_(inst_53615)){
var statearr_53673_55265 = state_53633__$1;
(statearr_53673_55265[(1)] = (20));

} else {
var statearr_53674_55266 = state_53633__$1;
(statearr_53674_55266[(1)] = (21));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (10))){
var inst_53629 = (state_53633[(2)]);
var state_53633__$1 = state_53633;
var statearr_53675_55267 = state_53633__$1;
(statearr_53675_55267[(2)] = inst_53629);

(statearr_53675_55267[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (18))){
var inst_53607 = (state_53633[(16)]);
var state_53633__$1 = state_53633;
var statearr_53676_55268 = state_53633__$1;
(statearr_53676_55268[(2)] = inst_53607);

(statearr_53676_55268[(1)] = (19));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53634 === (8))){
var inst_53586 = (state_53633[(7)]);
var inst_53595 = (inst_53586 == null);
var state_53633__$1 = state_53633;
if(cljs.core.truth_(inst_53595)){
var statearr_53677_55271 = state_53633__$1;
(statearr_53677_55271[(1)] = (11));

} else {
var statearr_53678_55272 = state_53633__$1;
(statearr_53678_55272[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mix_$_state_machine__52106__auto__ = null;
var cljs$core$async$mix_$_state_machine__52106__auto____0 = (function (){
var statearr_53679 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53679[(0)] = cljs$core$async$mix_$_state_machine__52106__auto__);

(statearr_53679[(1)] = (1));

return statearr_53679;
});
var cljs$core$async$mix_$_state_machine__52106__auto____1 = (function (state_53633){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_53633);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e53680){var ex__52109__auto__ = e53680;
var statearr_53681_55278 = state_53633;
(statearr_53681_55278[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_53633[(4)]))){
var statearr_53682_55282 = state_53633;
(statearr_53682_55282[(1)] = cljs.core.first((state_53633[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55287 = state_53633;
state_53633 = G__55287;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$mix_$_state_machine__52106__auto__ = function(state_53633){
switch(arguments.length){
case 0:
return cljs$core$async$mix_$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$mix_$_state_machine__52106__auto____1.call(this,state_53633);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mix_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mix_$_state_machine__52106__auto____0;
cljs$core$async$mix_$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mix_$_state_machine__52106__auto____1;
return cljs$core$async$mix_$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_53683 = f__52309__auto__();
(statearr_53683[(6)] = c__52308__auto___55143);

return statearr_53683;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return m;
});
/**
 * Adds ch as an input to the mix
 */
cljs.core.async.admix = (function cljs$core$async$admix(mix,ch){
return cljs.core.async.admix_STAR_(mix,ch);
});
/**
 * Removes ch as an input to the mix
 */
cljs.core.async.unmix = (function cljs$core$async$unmix(mix,ch){
return cljs.core.async.unmix_STAR_(mix,ch);
});
/**
 * removes all inputs from the mix
 */
cljs.core.async.unmix_all = (function cljs$core$async$unmix_all(mix){
return cljs.core.async.unmix_all_STAR_(mix);
});
/**
 * Atomically sets the state(s) of one or more channels in a mix. The
 *   state map is a map of channels -> channel-state-map. A
 *   channel-state-map is a map of attrs -> boolean, where attr is one or
 *   more of :mute, :pause or :solo. Any states supplied are merged with
 *   the current state.
 * 
 *   Note that channels can be added to a mix via toggle, which can be
 *   used to add channels in a particular (e.g. paused) state.
 */
cljs.core.async.toggle = (function cljs$core$async$toggle(mix,state_map){
return cljs.core.async.toggle_STAR_(mix,state_map);
});
/**
 * Sets the solo mode of the mix. mode must be one of :mute or :pause
 */
cljs.core.async.solo_mode = (function cljs$core$async$solo_mode(mix,mode){
return cljs.core.async.solo_mode_STAR_(mix,mode);
});

/**
 * @interface
 */
cljs.core.async.Pub = function(){};

var cljs$core$async$Pub$sub_STAR_$dyn_55295 = (function (p,v,ch,close_QMARK_){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.sub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5351__auto__.call(null, p,v,ch,close_QMARK_));
} else {
var m__5349__auto__ = (cljs.core.async.sub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$4 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$4(p,v,ch,close_QMARK_) : m__5349__auto__.call(null, p,v,ch,close_QMARK_));
} else {
throw cljs.core.missing_protocol("Pub.sub*",p);
}
}
});
cljs.core.async.sub_STAR_ = (function cljs$core$async$sub_STAR_(p,v,ch,close_QMARK_){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$sub_STAR_$arity$4 == null)))))){
return p.cljs$core$async$Pub$sub_STAR_$arity$4(p,v,ch,close_QMARK_);
} else {
return cljs$core$async$Pub$sub_STAR_$dyn_55295(p,v,ch,close_QMARK_);
}
});

var cljs$core$async$Pub$unsub_STAR_$dyn_55315 = (function (p,v,ch){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5351__auto__.call(null, p,v,ch));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$3 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$3(p,v,ch) : m__5349__auto__.call(null, p,v,ch));
} else {
throw cljs.core.missing_protocol("Pub.unsub*",p);
}
}
});
cljs.core.async.unsub_STAR_ = (function cljs$core$async$unsub_STAR_(p,v,ch){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_STAR_$arity$3 == null)))))){
return p.cljs$core$async$Pub$unsub_STAR_$arity$3(p,v,ch);
} else {
return cljs$core$async$Pub$unsub_STAR_$dyn_55315(p,v,ch);
}
});

var cljs$core$async$Pub$unsub_all_STAR_$dyn_55328 = (function() {
var G__55329 = null;
var G__55329__1 = (function (p){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5351__auto__.call(null, p));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(p) : m__5349__auto__.call(null, p));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
var G__55329__2 = (function (p,v){
var x__5350__auto__ = (((p == null))?null:p);
var m__5351__auto__ = (cljs.core.async.unsub_all_STAR_[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5351__auto__.call(null, p,v));
} else {
var m__5349__auto__ = (cljs.core.async.unsub_all_STAR_["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$2 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$2(p,v) : m__5349__auto__.call(null, p,v));
} else {
throw cljs.core.missing_protocol("Pub.unsub-all*",p);
}
}
});
G__55329 = function(p,v){
switch(arguments.length){
case 1:
return G__55329__1.call(this,p);
case 2:
return G__55329__2.call(this,p,v);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
G__55329.cljs$core$IFn$_invoke$arity$1 = G__55329__1;
G__55329.cljs$core$IFn$_invoke$arity$2 = G__55329__2;
return G__55329;
})()
;
cljs.core.async.unsub_all_STAR_ = (function cljs$core$async$unsub_all_STAR_(var_args){
var G__53699 = arguments.length;
switch (G__53699) {
case 1:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$1 = (function (p){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$1 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$1(p);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_55328(p);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$core$IFn$_invoke$arity$2 = (function (p,v){
if((((!((p == null)))) && ((!((p.cljs$core$async$Pub$unsub_all_STAR_$arity$2 == null)))))){
return p.cljs$core$async$Pub$unsub_all_STAR_$arity$2(p,v);
} else {
return cljs$core$async$Pub$unsub_all_STAR_$dyn_55328(p,v);
}
}));

(cljs.core.async.unsub_all_STAR_.cljs$lang$maxFixedArity = 2);



/**
* @constructor
 * @implements {cljs.core.async.Pub}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.async.Mux}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async53735 = (function (ch,topic_fn,buf_fn,mults,ensure_mult,meta53736){
this.ch = ch;
this.topic_fn = topic_fn;
this.buf_fn = buf_fn;
this.mults = mults;
this.ensure_mult = ensure_mult;
this.meta53736 = meta53736;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_53737,meta53736__$1){
var self__ = this;
var _53737__$1 = this;
return (new cljs.core.async.t_cljs$core$async53735(self__.ch,self__.topic_fn,self__.buf_fn,self__.mults,self__.ensure_mult,meta53736__$1));
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_53737){
var self__ = this;
var _53737__$1 = this;
return self__.meta53736;
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Mux$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Mux$muxch_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return self__.ch;
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Pub$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Pub$sub_STAR_$arity$4 = (function (p,topic,ch__$1,close_QMARK_){
var self__ = this;
var p__$1 = this;
var m = (self__.ensure_mult.cljs$core$IFn$_invoke$arity$1 ? self__.ensure_mult.cljs$core$IFn$_invoke$arity$1(topic) : self__.ensure_mult.call(null, topic));
return cljs.core.async.tap.cljs$core$IFn$_invoke$arity$3(m,ch__$1,close_QMARK_);
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Pub$unsub_STAR_$arity$3 = (function (p,topic,ch__$1){
var self__ = this;
var p__$1 = this;
var temp__5823__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(self__.mults),topic);
if(cljs.core.truth_(temp__5823__auto__)){
var m = temp__5823__auto__;
return cljs.core.async.untap(m,ch__$1);
} else {
return null;
}
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.reset_BANG_(self__.mults,cljs.core.PersistentArrayMap.EMPTY);
}));

(cljs.core.async.t_cljs$core$async53735.prototype.cljs$core$async$Pub$unsub_all_STAR_$arity$2 = (function (_,topic){
var self__ = this;
var ___$1 = this;
return cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(self__.mults,cljs.core.dissoc,topic);
}));

(cljs.core.async.t_cljs$core$async53735.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"topic-fn","topic-fn",-862449736,null),new cljs.core.Symbol(null,"buf-fn","buf-fn",-1200281591,null),new cljs.core.Symbol(null,"mults","mults",-461114485,null),new cljs.core.Symbol(null,"ensure-mult","ensure-mult",1796584816,null),new cljs.core.Symbol(null,"meta53736","meta53736",276929904,null)], null);
}));

(cljs.core.async.t_cljs$core$async53735.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async53735.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async53735");

(cljs.core.async.t_cljs$core$async53735.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async53735");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async53735.
 */
cljs.core.async.__GT_t_cljs$core$async53735 = (function cljs$core$async$__GT_t_cljs$core$async53735(ch,topic_fn,buf_fn,mults,ensure_mult,meta53736){
return (new cljs.core.async.t_cljs$core$async53735(ch,topic_fn,buf_fn,mults,ensure_mult,meta53736));
});


/**
 * Creates and returns a pub(lication) of the supplied channel,
 *   partitioned into topics by the topic-fn. topic-fn will be applied to
 *   each value on the channel and the result will determine the 'topic'
 *   on which that value will be put. Channels can be subscribed to
 *   receive copies of topics using 'sub', and unsubscribed using
 *   'unsub'. Each topic will be handled by an internal mult on a
 *   dedicated channel. By default these internal channels are
 *   unbuffered, but a buf-fn can be supplied which, given a topic,
 *   creates a buffer with desired properties.
 * 
 *   Each item is distributed to all subs in parallel and synchronously,
 *   i.e. each sub must accept before the next item is distributed. Use
 *   buffering/windowing to prevent slow subs from holding up the pub.
 * 
 *   Items received when there are no matching subs get dropped.
 * 
 *   Note that if buf-fns are used then each topic is handled
 *   asynchronously, i.e. if a channel is subscribed to more than one
 *   topic it should not expect them to be interleaved identically with
 *   the source.
 */
cljs.core.async.pub = (function cljs$core$async$pub(var_args){
var G__53725 = arguments.length;
switch (G__53725) {
case 2:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$2 = (function (ch,topic_fn){
return cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3(ch,topic_fn,cljs.core.constantly(null));
}));

(cljs.core.async.pub.cljs$core$IFn$_invoke$arity$3 = (function (ch,topic_fn,buf_fn){
var mults = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(cljs.core.PersistentArrayMap.EMPTY);
var ensure_mult = (function (topic){
var or__5002__auto__ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(mults),topic);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(mults,(function (p1__53719_SHARP_){
if(cljs.core.truth_((p1__53719_SHARP_.cljs$core$IFn$_invoke$arity$1 ? p1__53719_SHARP_.cljs$core$IFn$_invoke$arity$1(topic) : p1__53719_SHARP_.call(null, topic)))){
return p1__53719_SHARP_;
} else {
return cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(p1__53719_SHARP_,topic,cljs.core.async.mult(cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((buf_fn.cljs$core$IFn$_invoke$arity$1 ? buf_fn.cljs$core$IFn$_invoke$arity$1(topic) : buf_fn.call(null, topic)))));
}
})),topic);
}
});
var p = (new cljs.core.async.t_cljs$core$async53735(ch,topic_fn,buf_fn,mults,ensure_mult,cljs.core.PersistentArrayMap.EMPTY));
var c__52308__auto___55365 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_53821){
var state_val_53822 = (state_53821[(1)]);
if((state_val_53822 === (7))){
var inst_53817 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53823_55370 = state_53821__$1;
(statearr_53823_55370[(2)] = inst_53817);

(statearr_53823_55370[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (20))){
var state_53821__$1 = state_53821;
var statearr_53824_55377 = state_53821__$1;
(statearr_53824_55377[(2)] = null);

(statearr_53824_55377[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (1))){
var state_53821__$1 = state_53821;
var statearr_53825_55378 = state_53821__$1;
(statearr_53825_55378[(2)] = null);

(statearr_53825_55378[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (24))){
var inst_53799 = (state_53821[(7)]);
var inst_53809 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$3(mults,cljs.core.dissoc,inst_53799);
var state_53821__$1 = state_53821;
var statearr_53826_55386 = state_53821__$1;
(statearr_53826_55386[(2)] = inst_53809);

(statearr_53826_55386[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (4))){
var inst_53744 = (state_53821[(8)]);
var inst_53744__$1 = (state_53821[(2)]);
var inst_53745 = (inst_53744__$1 == null);
var state_53821__$1 = (function (){var statearr_53827 = state_53821;
(statearr_53827[(8)] = inst_53744__$1);

return statearr_53827;
})();
if(cljs.core.truth_(inst_53745)){
var statearr_53828_55401 = state_53821__$1;
(statearr_53828_55401[(1)] = (5));

} else {
var statearr_53829_55404 = state_53821__$1;
(statearr_53829_55404[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (15))){
var inst_53793 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53832_55407 = state_53821__$1;
(statearr_53832_55407[(2)] = inst_53793);

(statearr_53832_55407[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (21))){
var inst_53814 = (state_53821[(2)]);
var state_53821__$1 = (function (){var statearr_53833 = state_53821;
(statearr_53833[(9)] = inst_53814);

return statearr_53833;
})();
var statearr_53834_55413 = state_53821__$1;
(statearr_53834_55413[(2)] = null);

(statearr_53834_55413[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (13))){
var inst_53772 = (state_53821[(10)]);
var inst_53774 = cljs.core.chunked_seq_QMARK_(inst_53772);
var state_53821__$1 = state_53821;
if(inst_53774){
var statearr_53835_55420 = state_53821__$1;
(statearr_53835_55420[(1)] = (16));

} else {
var statearr_53836_55424 = state_53821__$1;
(statearr_53836_55424[(1)] = (17));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (22))){
var inst_53806 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
if(cljs.core.truth_(inst_53806)){
var statearr_53838_55430 = state_53821__$1;
(statearr_53838_55430[(1)] = (23));

} else {
var statearr_53839_55431 = state_53821__$1;
(statearr_53839_55431[(1)] = (24));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (6))){
var inst_53744 = (state_53821[(8)]);
var inst_53799 = (state_53821[(7)]);
var inst_53801 = (state_53821[(11)]);
var inst_53799__$1 = (topic_fn.cljs$core$IFn$_invoke$arity$1 ? topic_fn.cljs$core$IFn$_invoke$arity$1(inst_53744) : topic_fn.call(null, inst_53744));
var inst_53800 = cljs.core.deref(mults);
var inst_53801__$1 = cljs.core.get.cljs$core$IFn$_invoke$arity$2(inst_53800,inst_53799__$1);
var state_53821__$1 = (function (){var statearr_53844 = state_53821;
(statearr_53844[(7)] = inst_53799__$1);

(statearr_53844[(11)] = inst_53801__$1);

return statearr_53844;
})();
if(cljs.core.truth_(inst_53801__$1)){
var statearr_53845_55438 = state_53821__$1;
(statearr_53845_55438[(1)] = (19));

} else {
var statearr_53846_55443 = state_53821__$1;
(statearr_53846_55443[(1)] = (20));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (25))){
var inst_53811 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53847_55445 = state_53821__$1;
(statearr_53847_55445[(2)] = inst_53811);

(statearr_53847_55445[(1)] = (21));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (17))){
var inst_53772 = (state_53821[(10)]);
var inst_53783 = cljs.core.first(inst_53772);
var inst_53784 = cljs.core.async.muxch_STAR_(inst_53783);
var inst_53785 = cljs.core.async.close_BANG_(inst_53784);
var inst_53787 = cljs.core.next(inst_53772);
var inst_53754 = inst_53787;
var inst_53755 = null;
var inst_53756 = (0);
var inst_53757 = (0);
var state_53821__$1 = (function (){var statearr_53848 = state_53821;
(statearr_53848[(12)] = inst_53785);

(statearr_53848[(13)] = inst_53754);

(statearr_53848[(14)] = inst_53755);

(statearr_53848[(15)] = inst_53756);

(statearr_53848[(16)] = inst_53757);

return statearr_53848;
})();
var statearr_53849_55446 = state_53821__$1;
(statearr_53849_55446[(2)] = null);

(statearr_53849_55446[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (3))){
var inst_53819 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53821__$1,inst_53819);
} else {
if((state_val_53822 === (12))){
var inst_53795 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53850_55448 = state_53821__$1;
(statearr_53850_55448[(2)] = inst_53795);

(statearr_53850_55448[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (2))){
var state_53821__$1 = state_53821;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53821__$1,(4),ch);
} else {
if((state_val_53822 === (23))){
var state_53821__$1 = state_53821;
var statearr_53851_55453 = state_53821__$1;
(statearr_53851_55453[(2)] = null);

(statearr_53851_55453[(1)] = (25));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (19))){
var inst_53801 = (state_53821[(11)]);
var inst_53744 = (state_53821[(8)]);
var inst_53804 = cljs.core.async.muxch_STAR_(inst_53801);
var state_53821__$1 = state_53821;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53821__$1,(22),inst_53804,inst_53744);
} else {
if((state_val_53822 === (11))){
var inst_53754 = (state_53821[(13)]);
var inst_53772 = (state_53821[(10)]);
var inst_53772__$1 = cljs.core.seq(inst_53754);
var state_53821__$1 = (function (){var statearr_53852 = state_53821;
(statearr_53852[(10)] = inst_53772__$1);

return statearr_53852;
})();
if(inst_53772__$1){
var statearr_53853_55455 = state_53821__$1;
(statearr_53853_55455[(1)] = (13));

} else {
var statearr_53854_55456 = state_53821__$1;
(statearr_53854_55456[(1)] = (14));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (9))){
var inst_53797 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53855_55457 = state_53821__$1;
(statearr_53855_55457[(2)] = inst_53797);

(statearr_53855_55457[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (5))){
var inst_53751 = cljs.core.deref(mults);
var inst_53752 = cljs.core.vals(inst_53751);
var inst_53753 = cljs.core.seq(inst_53752);
var inst_53754 = inst_53753;
var inst_53755 = null;
var inst_53756 = (0);
var inst_53757 = (0);
var state_53821__$1 = (function (){var statearr_53856 = state_53821;
(statearr_53856[(13)] = inst_53754);

(statearr_53856[(14)] = inst_53755);

(statearr_53856[(15)] = inst_53756);

(statearr_53856[(16)] = inst_53757);

return statearr_53856;
})();
var statearr_53857_55458 = state_53821__$1;
(statearr_53857_55458[(2)] = null);

(statearr_53857_55458[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (14))){
var state_53821__$1 = state_53821;
var statearr_53861_55459 = state_53821__$1;
(statearr_53861_55459[(2)] = null);

(statearr_53861_55459[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (16))){
var inst_53772 = (state_53821[(10)]);
var inst_53776 = cljs.core.chunk_first(inst_53772);
var inst_53777 = cljs.core.chunk_rest(inst_53772);
var inst_53778 = cljs.core.count(inst_53776);
var inst_53754 = inst_53777;
var inst_53755 = inst_53776;
var inst_53756 = inst_53778;
var inst_53757 = (0);
var state_53821__$1 = (function (){var statearr_53863 = state_53821;
(statearr_53863[(13)] = inst_53754);

(statearr_53863[(14)] = inst_53755);

(statearr_53863[(15)] = inst_53756);

(statearr_53863[(16)] = inst_53757);

return statearr_53863;
})();
var statearr_53867_55462 = state_53821__$1;
(statearr_53867_55462[(2)] = null);

(statearr_53867_55462[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (10))){
var inst_53755 = (state_53821[(14)]);
var inst_53757 = (state_53821[(16)]);
var inst_53754 = (state_53821[(13)]);
var inst_53756 = (state_53821[(15)]);
var inst_53766 = cljs.core._nth(inst_53755,inst_53757);
var inst_53767 = cljs.core.async.muxch_STAR_(inst_53766);
var inst_53768 = cljs.core.async.close_BANG_(inst_53767);
var inst_53769 = (inst_53757 + (1));
var tmp53858 = inst_53754;
var tmp53859 = inst_53756;
var tmp53860 = inst_53755;
var inst_53754__$1 = tmp53858;
var inst_53755__$1 = tmp53860;
var inst_53756__$1 = tmp53859;
var inst_53757__$1 = inst_53769;
var state_53821__$1 = (function (){var statearr_53869 = state_53821;
(statearr_53869[(17)] = inst_53768);

(statearr_53869[(13)] = inst_53754__$1);

(statearr_53869[(14)] = inst_53755__$1);

(statearr_53869[(15)] = inst_53756__$1);

(statearr_53869[(16)] = inst_53757__$1);

return statearr_53869;
})();
var statearr_53870_55463 = state_53821__$1;
(statearr_53870_55463[(2)] = null);

(statearr_53870_55463[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (18))){
var inst_53790 = (state_53821[(2)]);
var state_53821__$1 = state_53821;
var statearr_53871_55464 = state_53821__$1;
(statearr_53871_55464[(2)] = inst_53790);

(statearr_53871_55464[(1)] = (15));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53822 === (8))){
var inst_53757 = (state_53821[(16)]);
var inst_53756 = (state_53821[(15)]);
var inst_53760 = (inst_53757 < inst_53756);
var inst_53761 = inst_53760;
var state_53821__$1 = state_53821;
if(cljs.core.truth_(inst_53761)){
var statearr_53873_55465 = state_53821__$1;
(statearr_53873_55465[(1)] = (10));

} else {
var statearr_53874_55466 = state_53821__$1;
(statearr_53874_55466[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_53876 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53876[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_53876[(1)] = (1));

return statearr_53876;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_53821){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_53821);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e53877){var ex__52109__auto__ = e53877;
var statearr_53878_55471 = state_53821;
(statearr_53878_55471[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_53821[(4)]))){
var statearr_53879_55472 = state_53821;
(statearr_53879_55472[(1)] = cljs.core.first((state_53821[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55473 = state_53821;
state_53821 = G__55473;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_53821){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_53821);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_53882 = f__52309__auto__();
(statearr_53882[(6)] = c__52308__auto___55365);

return statearr_53882;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return p;
}));

(cljs.core.async.pub.cljs$lang$maxFixedArity = 3);

/**
 * Subscribes a channel to a topic of a pub.
 * 
 *   By default the channel will be closed when the source closes,
 *   but can be determined by the close? parameter.
 */
cljs.core.async.sub = (function cljs$core$async$sub(var_args){
var G__53887 = arguments.length;
switch (G__53887) {
case 3:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$3 = (function (p,topic,ch){
return cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4(p,topic,ch,true);
}));

(cljs.core.async.sub.cljs$core$IFn$_invoke$arity$4 = (function (p,topic,ch,close_QMARK_){
return cljs.core.async.sub_STAR_(p,topic,ch,close_QMARK_);
}));

(cljs.core.async.sub.cljs$lang$maxFixedArity = 4);

/**
 * Unsubscribes a channel from a topic of a pub
 */
cljs.core.async.unsub = (function cljs$core$async$unsub(p,topic,ch){
return cljs.core.async.unsub_STAR_(p,topic,ch);
});
/**
 * Unsubscribes all channels from a pub, or a topic of a pub
 */
cljs.core.async.unsub_all = (function cljs$core$async$unsub_all(var_args){
var G__53889 = arguments.length;
switch (G__53889) {
case 1:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$1 = (function (p){
return cljs.core.async.unsub_all_STAR_(p);
}));

(cljs.core.async.unsub_all.cljs$core$IFn$_invoke$arity$2 = (function (p,topic){
return cljs.core.async.unsub_all_STAR_(p,topic);
}));

(cljs.core.async.unsub_all.cljs$lang$maxFixedArity = 2);

/**
 * Takes a function and a collection of source channels, and returns a
 *   channel which contains the values produced by applying f to the set
 *   of first items taken from each source channel, followed by applying
 *   f to the set of second items from each channel, until any one of the
 *   channels is closed, at which point the output channel will be
 *   closed. The returned channel will be unbuffered by default, or a
 *   buf-or-n can be supplied
 */
cljs.core.async.map = (function cljs$core$async$map(var_args){
var G__53895 = arguments.length;
switch (G__53895) {
case 2:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$2 = (function (f,chs){
return cljs.core.async.map.cljs$core$IFn$_invoke$arity$3(f,chs,null);
}));

(cljs.core.async.map.cljs$core$IFn$_invoke$arity$3 = (function (f,chs,buf_or_n){
var chs__$1 = cljs.core.vec(chs);
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var cnt = cljs.core.count(chs__$1);
var rets = cljs.core.object_array.cljs$core$IFn$_invoke$arity$1(cnt);
var dchan = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
var dctr = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(null);
var done = cljs.core.mapv.cljs$core$IFn$_invoke$arity$2((function (i){
return (function (ret){
(rets[i] = ret);

if((cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec) === (0))){
return cljs.core.async.put_BANG_.cljs$core$IFn$_invoke$arity$2(dchan,rets.slice((0)));
} else {
return null;
}
});
}),cljs.core.range.cljs$core$IFn$_invoke$arity$1(cnt));
if((cnt === (0))){
cljs.core.async.close_BANG_(out);
} else {
var c__52308__auto___55493 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_53944){
var state_val_53945 = (state_53944[(1)]);
if((state_val_53945 === (7))){
var state_53944__$1 = state_53944;
var statearr_53949_55494 = state_53944__$1;
(statearr_53949_55494[(2)] = null);

(statearr_53949_55494[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (1))){
var state_53944__$1 = state_53944;
var statearr_53950_55495 = state_53944__$1;
(statearr_53950_55495[(2)] = null);

(statearr_53950_55495[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (4))){
var inst_53903 = (state_53944[(7)]);
var inst_53902 = (state_53944[(8)]);
var inst_53905 = (inst_53903 < inst_53902);
var state_53944__$1 = state_53944;
if(cljs.core.truth_(inst_53905)){
var statearr_53951_55496 = state_53944__$1;
(statearr_53951_55496[(1)] = (6));

} else {
var statearr_53952_55497 = state_53944__$1;
(statearr_53952_55497[(1)] = (7));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (15))){
var inst_53930 = (state_53944[(9)]);
var inst_53935 = cljs.core.apply.cljs$core$IFn$_invoke$arity$2(f,inst_53930);
var state_53944__$1 = state_53944;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_53944__$1,(17),out,inst_53935);
} else {
if((state_val_53945 === (13))){
var inst_53930 = (state_53944[(9)]);
var inst_53930__$1 = (state_53944[(2)]);
var inst_53931 = cljs.core.some(cljs.core.nil_QMARK_,inst_53930__$1);
var state_53944__$1 = (function (){var statearr_53953 = state_53944;
(statearr_53953[(9)] = inst_53930__$1);

return statearr_53953;
})();
if(cljs.core.truth_(inst_53931)){
var statearr_53954_55506 = state_53944__$1;
(statearr_53954_55506[(1)] = (14));

} else {
var statearr_53955_55507 = state_53944__$1;
(statearr_53955_55507[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (6))){
var state_53944__$1 = state_53944;
var statearr_53956_55508 = state_53944__$1;
(statearr_53956_55508[(2)] = null);

(statearr_53956_55508[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (17))){
var inst_53937 = (state_53944[(2)]);
var state_53944__$1 = (function (){var statearr_53958 = state_53944;
(statearr_53958[(10)] = inst_53937);

return statearr_53958;
})();
var statearr_53959_55515 = state_53944__$1;
(statearr_53959_55515[(2)] = null);

(statearr_53959_55515[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (3))){
var inst_53942 = (state_53944[(2)]);
var state_53944__$1 = state_53944;
return cljs.core.async.impl.ioc_helpers.return_chan(state_53944__$1,inst_53942);
} else {
if((state_val_53945 === (12))){
var _ = (function (){var statearr_53960 = state_53944;
(statearr_53960[(4)] = cljs.core.rest((state_53944[(4)])));

return statearr_53960;
})();
var state_53944__$1 = state_53944;
var ex53957 = (state_53944__$1[(2)]);
var statearr_53961_55516 = state_53944__$1;
(statearr_53961_55516[(5)] = ex53957);


if((ex53957 instanceof Object)){
var statearr_53962_55517 = state_53944__$1;
(statearr_53962_55517[(1)] = (11));

(statearr_53962_55517[(5)] = null);

} else {
throw ex53957;

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (2))){
var inst_53901 = cljs.core.reset_BANG_(dctr,cnt);
var inst_53902 = cnt;
var inst_53903 = (0);
var state_53944__$1 = (function (){var statearr_53963 = state_53944;
(statearr_53963[(11)] = inst_53901);

(statearr_53963[(8)] = inst_53902);

(statearr_53963[(7)] = inst_53903);

return statearr_53963;
})();
var statearr_53964_55518 = state_53944__$1;
(statearr_53964_55518[(2)] = null);

(statearr_53964_55518[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (11))){
var inst_53907 = (state_53944[(2)]);
var inst_53908 = cljs.core.swap_BANG_.cljs$core$IFn$_invoke$arity$2(dctr,cljs.core.dec);
var state_53944__$1 = (function (){var statearr_53965 = state_53944;
(statearr_53965[(12)] = inst_53907);

return statearr_53965;
})();
var statearr_53966_55519 = state_53944__$1;
(statearr_53966_55519[(2)] = inst_53908);

(statearr_53966_55519[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (9))){
var inst_53903 = (state_53944[(7)]);
var _ = (function (){var statearr_53967 = state_53944;
(statearr_53967[(4)] = cljs.core.cons((12),(state_53944[(4)])));

return statearr_53967;
})();
var inst_53914 = (chs__$1.cljs$core$IFn$_invoke$arity$1 ? chs__$1.cljs$core$IFn$_invoke$arity$1(inst_53903) : chs__$1.call(null, inst_53903));
var inst_53915 = (done.cljs$core$IFn$_invoke$arity$1 ? done.cljs$core$IFn$_invoke$arity$1(inst_53903) : done.call(null, inst_53903));
var inst_53916 = cljs.core.async.take_BANG_.cljs$core$IFn$_invoke$arity$2(inst_53914,inst_53915);
var ___$1 = (function (){var statearr_53968 = state_53944;
(statearr_53968[(4)] = cljs.core.rest((state_53944[(4)])));

return statearr_53968;
})();
var state_53944__$1 = state_53944;
var statearr_53969_55520 = state_53944__$1;
(statearr_53969_55520[(2)] = inst_53916);

(statearr_53969_55520[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (5))){
var inst_53927 = (state_53944[(2)]);
var state_53944__$1 = (function (){var statearr_53970 = state_53944;
(statearr_53970[(13)] = inst_53927);

return statearr_53970;
})();
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_53944__$1,(13),dchan);
} else {
if((state_val_53945 === (14))){
var inst_53933 = cljs.core.async.close_BANG_(out);
var state_53944__$1 = state_53944;
var statearr_53971_55521 = state_53944__$1;
(statearr_53971_55521[(2)] = inst_53933);

(statearr_53971_55521[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (16))){
var inst_53940 = (state_53944[(2)]);
var state_53944__$1 = state_53944;
var statearr_53972_55522 = state_53944__$1;
(statearr_53972_55522[(2)] = inst_53940);

(statearr_53972_55522[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (10))){
var inst_53903 = (state_53944[(7)]);
var inst_53919 = (state_53944[(2)]);
var inst_53921 = (inst_53903 + (1));
var inst_53903__$1 = inst_53921;
var state_53944__$1 = (function (){var statearr_53973 = state_53944;
(statearr_53973[(14)] = inst_53919);

(statearr_53973[(7)] = inst_53903__$1);

return statearr_53973;
})();
var statearr_53974_55524 = state_53944__$1;
(statearr_53974_55524[(2)] = null);

(statearr_53974_55524[(1)] = (4));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_53945 === (8))){
var inst_53925 = (state_53944[(2)]);
var state_53944__$1 = state_53944;
var statearr_53975_55525 = state_53944__$1;
(statearr_53975_55525[(2)] = inst_53925);

(statearr_53975_55525[(1)] = (5));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_53976 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_53976[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_53976[(1)] = (1));

return statearr_53976;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_53944){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_53944);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e53977){var ex__52109__auto__ = e53977;
var statearr_53978_55530 = state_53944;
(statearr_53978_55530[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_53944[(4)]))){
var statearr_53979_55531 = state_53944;
(statearr_53979_55531[(1)] = cljs.core.first((state_53944[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55532 = state_53944;
state_53944 = G__55532;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_53944){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_53944);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_53981 = f__52309__auto__();
(statearr_53981[(6)] = c__52308__auto___55493);

return statearr_53981;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

}

return out;
}));

(cljs.core.async.map.cljs$lang$maxFixedArity = 3);

/**
 * Takes a collection of source channels and returns a channel which
 *   contains all values taken from them. The returned channel will be
 *   unbuffered by default, or a buf-or-n can be supplied. The channel
 *   will close after all the source channels have closed.
 */
cljs.core.async.merge = (function cljs$core$async$merge(var_args){
var G__53984 = arguments.length;
switch (G__53984) {
case 1:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$1 = (function (chs){
return cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2(chs,null);
}));

(cljs.core.async.merge.cljs$core$IFn$_invoke$arity$2 = (function (chs,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55543 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54019){
var state_val_54020 = (state_54019[(1)]);
if((state_val_54020 === (7))){
var inst_53998 = (state_54019[(7)]);
var inst_53999 = (state_54019[(8)]);
var inst_53998__$1 = (state_54019[(2)]);
var inst_53999__$1 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53998__$1,(0),null);
var inst_54000 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(inst_53998__$1,(1),null);
var inst_54001 = (inst_53999__$1 == null);
var state_54019__$1 = (function (){var statearr_54025 = state_54019;
(statearr_54025[(7)] = inst_53998__$1);

(statearr_54025[(8)] = inst_53999__$1);

(statearr_54025[(9)] = inst_54000);

return statearr_54025;
})();
if(cljs.core.truth_(inst_54001)){
var statearr_54026_55553 = state_54019__$1;
(statearr_54026_55553[(1)] = (8));

} else {
var statearr_54027_55554 = state_54019__$1;
(statearr_54027_55554[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (1))){
var inst_53985 = cljs.core.vec(chs);
var inst_53986 = inst_53985;
var state_54019__$1 = (function (){var statearr_54028 = state_54019;
(statearr_54028[(10)] = inst_53986);

return statearr_54028;
})();
var statearr_54029_55555 = state_54019__$1;
(statearr_54029_55555[(2)] = null);

(statearr_54029_55555[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (4))){
var inst_53986 = (state_54019[(10)]);
var state_54019__$1 = state_54019;
return cljs.core.async.ioc_alts_BANG_(state_54019__$1,(7),inst_53986);
} else {
if((state_val_54020 === (6))){
var inst_54015 = (state_54019[(2)]);
var state_54019__$1 = state_54019;
var statearr_54030_55563 = state_54019__$1;
(statearr_54030_55563[(2)] = inst_54015);

(statearr_54030_55563[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (3))){
var inst_54017 = (state_54019[(2)]);
var state_54019__$1 = state_54019;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54019__$1,inst_54017);
} else {
if((state_val_54020 === (2))){
var inst_53986 = (state_54019[(10)]);
var inst_53991 = cljs.core.count(inst_53986);
var inst_53992 = (inst_53991 > (0));
var state_54019__$1 = state_54019;
if(cljs.core.truth_(inst_53992)){
var statearr_54032_55567 = state_54019__$1;
(statearr_54032_55567[(1)] = (4));

} else {
var statearr_54033_55570 = state_54019__$1;
(statearr_54033_55570[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (11))){
var inst_53986 = (state_54019[(10)]);
var inst_54008 = (state_54019[(2)]);
var tmp54031 = inst_53986;
var inst_53986__$1 = tmp54031;
var state_54019__$1 = (function (){var statearr_54034 = state_54019;
(statearr_54034[(11)] = inst_54008);

(statearr_54034[(10)] = inst_53986__$1);

return statearr_54034;
})();
var statearr_54035_55575 = state_54019__$1;
(statearr_54035_55575[(2)] = null);

(statearr_54035_55575[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (9))){
var inst_53999 = (state_54019[(8)]);
var state_54019__$1 = state_54019;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54019__$1,(11),out,inst_53999);
} else {
if((state_val_54020 === (5))){
var inst_54013 = cljs.core.async.close_BANG_(out);
var state_54019__$1 = state_54019;
var statearr_54036_55580 = state_54019__$1;
(statearr_54036_55580[(2)] = inst_54013);

(statearr_54036_55580[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (10))){
var inst_54011 = (state_54019[(2)]);
var state_54019__$1 = state_54019;
var statearr_54037_55584 = state_54019__$1;
(statearr_54037_55584[(2)] = inst_54011);

(statearr_54037_55584[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54020 === (8))){
var inst_53986 = (state_54019[(10)]);
var inst_53998 = (state_54019[(7)]);
var inst_53999 = (state_54019[(8)]);
var inst_54000 = (state_54019[(9)]);
var inst_54003 = (function (){var cs = inst_53986;
var vec__53994 = inst_53998;
var v = inst_53999;
var c = inst_54000;
return (function (p1__53982_SHARP_){
return cljs.core.not_EQ_.cljs$core$IFn$_invoke$arity$2(c,p1__53982_SHARP_);
});
})();
var inst_54004 = cljs.core.filterv(inst_54003,inst_53986);
var inst_53986__$1 = inst_54004;
var state_54019__$1 = (function (){var statearr_54046 = state_54019;
(statearr_54046[(10)] = inst_53986__$1);

return statearr_54046;
})();
var statearr_54053_55590 = state_54019__$1;
(statearr_54053_55590[(2)] = null);

(statearr_54053_55590[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54060 = [null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54060[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54060[(1)] = (1));

return statearr_54060;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54019){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54019);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54061){var ex__52109__auto__ = e54061;
var statearr_54062_55593 = state_54019;
(statearr_54062_55593[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54019[(4)]))){
var statearr_54063_55594 = state_54019;
(statearr_54063_55594[(1)] = cljs.core.first((state_54019[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55595 = state_54019;
state_54019 = G__55595;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54019){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54019);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54064 = f__52309__auto__();
(statearr_54064[(6)] = c__52308__auto___55543);

return statearr_54064;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.merge.cljs$lang$maxFixedArity = 2);

/**
 * Returns a channel containing the single (collection) result of the
 *   items taken from the channel conjoined to the supplied
 *   collection. ch must close before into produces a result.
 */
cljs.core.async.into = (function cljs$core$async$into(coll,ch){
return cljs.core.async.reduce(cljs.core.conj,coll,ch);
});
/**
 * Returns a channel that will return, at most, n items from ch. After n items
 * have been returned, or ch has been closed, the return chanel will close.
 * 
 *   The output channel is unbuffered by default, unless buf-or-n is given.
 */
cljs.core.async.take = (function cljs$core$async$take(var_args){
var G__54086 = arguments.length;
switch (G__54086) {
case 2:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.take.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.take.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55597 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54112){
var state_val_54114 = (state_54112[(1)]);
if((state_val_54114 === (7))){
var inst_54094 = (state_54112[(7)]);
var inst_54094__$1 = (state_54112[(2)]);
var inst_54095 = (inst_54094__$1 == null);
var inst_54096 = cljs.core.not(inst_54095);
var state_54112__$1 = (function (){var statearr_54115 = state_54112;
(statearr_54115[(7)] = inst_54094__$1);

return statearr_54115;
})();
if(inst_54096){
var statearr_54116_55602 = state_54112__$1;
(statearr_54116_55602[(1)] = (8));

} else {
var statearr_54117_55603 = state_54112__$1;
(statearr_54117_55603[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (1))){
var inst_54089 = (0);
var state_54112__$1 = (function (){var statearr_54118 = state_54112;
(statearr_54118[(8)] = inst_54089);

return statearr_54118;
})();
var statearr_54119_55605 = state_54112__$1;
(statearr_54119_55605[(2)] = null);

(statearr_54119_55605[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (4))){
var state_54112__$1 = state_54112;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54112__$1,(7),ch);
} else {
if((state_val_54114 === (6))){
var inst_54107 = (state_54112[(2)]);
var state_54112__$1 = state_54112;
var statearr_54123_55609 = state_54112__$1;
(statearr_54123_55609[(2)] = inst_54107);

(statearr_54123_55609[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (3))){
var inst_54109 = (state_54112[(2)]);
var inst_54110 = cljs.core.async.close_BANG_(out);
var state_54112__$1 = (function (){var statearr_54124 = state_54112;
(statearr_54124[(9)] = inst_54109);

return statearr_54124;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_54112__$1,inst_54110);
} else {
if((state_val_54114 === (2))){
var inst_54089 = (state_54112[(8)]);
var inst_54091 = (inst_54089 < n);
var state_54112__$1 = state_54112;
if(cljs.core.truth_(inst_54091)){
var statearr_54125_55613 = state_54112__$1;
(statearr_54125_55613[(1)] = (4));

} else {
var statearr_54126_55616 = state_54112__$1;
(statearr_54126_55616[(1)] = (5));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (11))){
var inst_54089 = (state_54112[(8)]);
var inst_54099 = (state_54112[(2)]);
var inst_54100 = (inst_54089 + (1));
var inst_54089__$1 = inst_54100;
var state_54112__$1 = (function (){var statearr_54127 = state_54112;
(statearr_54127[(10)] = inst_54099);

(statearr_54127[(8)] = inst_54089__$1);

return statearr_54127;
})();
var statearr_54128_55617 = state_54112__$1;
(statearr_54128_55617[(2)] = null);

(statearr_54128_55617[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (9))){
var state_54112__$1 = state_54112;
var statearr_54129_55618 = state_54112__$1;
(statearr_54129_55618[(2)] = null);

(statearr_54129_55618[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (5))){
var state_54112__$1 = state_54112;
var statearr_54130_55619 = state_54112__$1;
(statearr_54130_55619[(2)] = null);

(statearr_54130_55619[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (10))){
var inst_54104 = (state_54112[(2)]);
var state_54112__$1 = state_54112;
var statearr_54131_55622 = state_54112__$1;
(statearr_54131_55622[(2)] = inst_54104);

(statearr_54131_55622[(1)] = (6));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54114 === (8))){
var inst_54094 = (state_54112[(7)]);
var state_54112__$1 = state_54112;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54112__$1,(11),out,inst_54094);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54132 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54132[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54132[(1)] = (1));

return statearr_54132;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54112){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54112);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54133){var ex__52109__auto__ = e54133;
var statearr_54134_55624 = state_54112;
(statearr_54134_55624[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54112[(4)]))){
var statearr_54135_55625 = state_54112;
(statearr_54135_55625[(1)] = cljs.core.first((state_54112[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55627 = state_54112;
state_54112 = G__55627;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54112){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54112);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54136 = f__52309__auto__();
(statearr_54136[(6)] = c__52308__auto___55597);

return statearr_54136;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.take.cljs$lang$maxFixedArity = 3);


/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Handler}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54141 = (function (f,ch,meta54139,_,fn1,meta54142){
this.f = f;
this.ch = ch;
this.meta54139 = meta54139;
this._ = _;
this.fn1 = fn1;
this.meta54142 = meta54142;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54143,meta54142__$1){
var self__ = this;
var _54143__$1 = this;
return (new cljs.core.async.t_cljs$core$async54141(self__.f,self__.ch,self__.meta54139,self__._,self__.fn1,meta54142__$1));
}));

(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54143){
var self__ = this;
var _54143__$1 = this;
return self__.meta54142;
}));

(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$async$impl$protocols$Handler$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$async$impl$protocols$Handler$active_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return cljs.core.async.impl.protocols.active_QMARK_(self__.fn1);
}));

(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$async$impl$protocols$Handler$blockable_QMARK_$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
return true;
}));

(cljs.core.async.t_cljs$core$async54141.prototype.cljs$core$async$impl$protocols$Handler$commit$arity$1 = (function (___$1){
var self__ = this;
var ___$2 = this;
var f1 = cljs.core.async.impl.protocols.commit(self__.fn1);
return (function (p1__54137_SHARP_){
var G__54144 = (((p1__54137_SHARP_ == null))?null:(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(p1__54137_SHARP_) : self__.f.call(null, p1__54137_SHARP_)));
return (f1.cljs$core$IFn$_invoke$arity$1 ? f1.cljs$core$IFn$_invoke$arity$1(G__54144) : f1.call(null, G__54144));
});
}));

(cljs.core.async.t_cljs$core$async54141.getBasis = (function (){
return new cljs.core.PersistentVector(null, 6, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta54139","meta54139",964584920,null),cljs.core.with_meta(new cljs.core.Symbol(null,"_","_",-1201019570,null),new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"tag","tag",-1290361223),new cljs.core.Symbol("cljs.core.async","t_cljs$core$async54138","cljs.core.async/t_cljs$core$async54138",-1926273936,null)], null)),new cljs.core.Symbol(null,"fn1","fn1",895834444,null),new cljs.core.Symbol(null,"meta54142","meta54142",1740993995,null)], null);
}));

(cljs.core.async.t_cljs$core$async54141.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54141.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54141");

(cljs.core.async.t_cljs$core$async54141.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async54141");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54141.
 */
cljs.core.async.__GT_t_cljs$core$async54141 = (function cljs$core$async$__GT_t_cljs$core$async54141(f,ch,meta54139,_,fn1,meta54142){
return (new cljs.core.async.t_cljs$core$async54141(f,ch,meta54139,_,fn1,meta54142));
});



/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54138 = (function (f,ch,meta54139){
this.f = f;
this.ch = ch;
this.meta54139 = meta54139;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54140,meta54139__$1){
var self__ = this;
var _54140__$1 = this;
return (new cljs.core.async.t_cljs$core$async54138(self__.f,self__.ch,meta54139__$1));
}));

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54140){
var self__ = this;
var _54140__$1 = this;
return self__.meta54139;
}));

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
var ret = cljs.core.async.impl.protocols.take_BANG_(self__.ch,(new cljs.core.async.t_cljs$core$async54141(self__.f,self__.ch,self__.meta54139,___$1,fn1,cljs.core.PersistentArrayMap.EMPTY)));
if(cljs.core.truth_((function (){var and__5000__auto__ = ret;
if(cljs.core.truth_(and__5000__auto__)){
return (!((cljs.core.deref(ret) == null)));
} else {
return and__5000__auto__;
}
})())){
return cljs.core.async.impl.channels.box((function (){var G__54156 = cljs.core.deref(ret);
return (self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(G__54156) : self__.f.call(null, G__54156));
})());
} else {
return ret;
}
}));

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54138.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
}));

(cljs.core.async.t_cljs$core$async54138.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta54139","meta54139",964584920,null)], null);
}));

(cljs.core.async.t_cljs$core$async54138.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54138.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54138");

(cljs.core.async.t_cljs$core$async54138.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async54138");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54138.
 */
cljs.core.async.__GT_t_cljs$core$async54138 = (function cljs$core$async$__GT_t_cljs$core$async54138(f,ch,meta54139){
return (new cljs.core.async.t_cljs$core$async54138(f,ch,meta54139));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_LT_ = (function cljs$core$async$map_LT_(f,ch){
return (new cljs.core.async.t_cljs$core$async54138(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54157 = (function (f,ch,meta54158){
this.f = f;
this.ch = ch;
this.meta54158 = meta54158;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54159,meta54158__$1){
var self__ = this;
var _54159__$1 = this;
return (new cljs.core.async.t_cljs$core$async54157(self__.f,self__.ch,meta54158__$1));
}));

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54159){
var self__ = this;
var _54159__$1 = this;
return self__.meta54158;
}));

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54157.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,(self__.f.cljs$core$IFn$_invoke$arity$1 ? self__.f.cljs$core$IFn$_invoke$arity$1(val) : self__.f.call(null, val)),fn1);
}));

(cljs.core.async.t_cljs$core$async54157.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"f","f",43394975,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta54158","meta54158",-130660165,null)], null);
}));

(cljs.core.async.t_cljs$core$async54157.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54157.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54157");

(cljs.core.async.t_cljs$core$async54157.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async54157");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54157.
 */
cljs.core.async.__GT_t_cljs$core$async54157 = (function cljs$core$async$__GT_t_cljs$core$async54157(f,ch,meta54158){
return (new cljs.core.async.t_cljs$core$async54157(f,ch,meta54158));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.map_GT_ = (function cljs$core$async$map_GT_(f,ch){
return (new cljs.core.async.t_cljs$core$async54157(f,ch,cljs.core.PersistentArrayMap.EMPTY));
});

/**
* @constructor
 * @implements {cljs.core.async.impl.protocols.Channel}
 * @implements {cljs.core.async.impl.protocols.WritePort}
 * @implements {cljs.core.async.impl.protocols.ReadPort}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.IWithMeta}
*/
cljs.core.async.t_cljs$core$async54160 = (function (p,ch,meta54161){
this.p = p;
this.ch = ch;
this.meta54161 = meta54161;
this.cljs$lang$protocol_mask$partition0$ = 393216;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (_54162,meta54161__$1){
var self__ = this;
var _54162__$1 = this;
return (new cljs.core.async.t_cljs$core$async54160(self__.p,self__.ch,meta54161__$1));
}));

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$IMeta$_meta$arity$1 = (function (_54162){
var self__ = this;
var _54162__$1 = this;
return self__.meta54161;
}));

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Channel$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Channel$close_BANG_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.close_BANG_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$Channel$closed_QMARK_$arity$1 = (function (_){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.closed_QMARK_(self__.ch);
}));

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$ReadPort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$ReadPort$take_BANG_$arity$2 = (function (_,fn1){
var self__ = this;
var ___$1 = this;
return cljs.core.async.impl.protocols.take_BANG_(self__.ch,fn1);
}));

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$WritePort$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.async.t_cljs$core$async54160.prototype.cljs$core$async$impl$protocols$WritePort$put_BANG_$arity$3 = (function (_,val,fn1){
var self__ = this;
var ___$1 = this;
if(cljs.core.truth_((self__.p.cljs$core$IFn$_invoke$arity$1 ? self__.p.cljs$core$IFn$_invoke$arity$1(val) : self__.p.call(null, val)))){
return cljs.core.async.impl.protocols.put_BANG_(self__.ch,val,fn1);
} else {
return cljs.core.async.impl.channels.box(cljs.core.not(cljs.core.async.impl.protocols.closed_QMARK_(self__.ch)));
}
}));

(cljs.core.async.t_cljs$core$async54160.getBasis = (function (){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"p","p",1791580836,null),new cljs.core.Symbol(null,"ch","ch",1085813622,null),new cljs.core.Symbol(null,"meta54161","meta54161",1718604197,null)], null);
}));

(cljs.core.async.t_cljs$core$async54160.cljs$lang$type = true);

(cljs.core.async.t_cljs$core$async54160.cljs$lang$ctorStr = "cljs.core.async/t_cljs$core$async54160");

(cljs.core.async.t_cljs$core$async54160.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"cljs.core.async/t_cljs$core$async54160");
}));

/**
 * Positional factory function for cljs.core.async/t_cljs$core$async54160.
 */
cljs.core.async.__GT_t_cljs$core$async54160 = (function cljs$core$async$__GT_t_cljs$core$async54160(p,ch,meta54161){
return (new cljs.core.async.t_cljs$core$async54160(p,ch,meta54161));
});


/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_GT_ = (function cljs$core$async$filter_GT_(p,ch){
return (new cljs.core.async.t_cljs$core$async54160(p,ch,cljs.core.PersistentArrayMap.EMPTY));
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_GT_ = (function cljs$core$async$remove_GT_(p,ch){
return cljs.core.async.filter_GT_(cljs.core.complement(p),ch);
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.filter_LT_ = (function cljs$core$async$filter_LT_(var_args){
var G__54172 = arguments.length;
switch (G__54172) {
case 2:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55659 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54193){
var state_val_54194 = (state_54193[(1)]);
if((state_val_54194 === (7))){
var inst_54189 = (state_54193[(2)]);
var state_54193__$1 = state_54193;
var statearr_54195_55661 = state_54193__$1;
(statearr_54195_55661[(2)] = inst_54189);

(statearr_54195_55661[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (1))){
var state_54193__$1 = state_54193;
var statearr_54196_55663 = state_54193__$1;
(statearr_54196_55663[(2)] = null);

(statearr_54196_55663[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (4))){
var inst_54175 = (state_54193[(7)]);
var inst_54175__$1 = (state_54193[(2)]);
var inst_54176 = (inst_54175__$1 == null);
var state_54193__$1 = (function (){var statearr_54197 = state_54193;
(statearr_54197[(7)] = inst_54175__$1);

return statearr_54197;
})();
if(cljs.core.truth_(inst_54176)){
var statearr_54198_55668 = state_54193__$1;
(statearr_54198_55668[(1)] = (5));

} else {
var statearr_54199_55669 = state_54193__$1;
(statearr_54199_55669[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (6))){
var inst_54175 = (state_54193[(7)]);
var inst_54180 = (p.cljs$core$IFn$_invoke$arity$1 ? p.cljs$core$IFn$_invoke$arity$1(inst_54175) : p.call(null, inst_54175));
var state_54193__$1 = state_54193;
if(cljs.core.truth_(inst_54180)){
var statearr_54200_55670 = state_54193__$1;
(statearr_54200_55670[(1)] = (8));

} else {
var statearr_54201_55671 = state_54193__$1;
(statearr_54201_55671[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (3))){
var inst_54191 = (state_54193[(2)]);
var state_54193__$1 = state_54193;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54193__$1,inst_54191);
} else {
if((state_val_54194 === (2))){
var state_54193__$1 = state_54193;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54193__$1,(4),ch);
} else {
if((state_val_54194 === (11))){
var inst_54183 = (state_54193[(2)]);
var state_54193__$1 = state_54193;
var statearr_54202_55673 = state_54193__$1;
(statearr_54202_55673[(2)] = inst_54183);

(statearr_54202_55673[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (9))){
var state_54193__$1 = state_54193;
var statearr_54206_55674 = state_54193__$1;
(statearr_54206_55674[(2)] = null);

(statearr_54206_55674[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (5))){
var inst_54178 = cljs.core.async.close_BANG_(out);
var state_54193__$1 = state_54193;
var statearr_54207_55677 = state_54193__$1;
(statearr_54207_55677[(2)] = inst_54178);

(statearr_54207_55677[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (10))){
var inst_54186 = (state_54193[(2)]);
var state_54193__$1 = (function (){var statearr_54208 = state_54193;
(statearr_54208[(8)] = inst_54186);

return statearr_54208;
})();
var statearr_54209_55681 = state_54193__$1;
(statearr_54209_55681[(2)] = null);

(statearr_54209_55681[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54194 === (8))){
var inst_54175 = (state_54193[(7)]);
var state_54193__$1 = state_54193;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54193__$1,(11),out,inst_54175);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54210 = [null,null,null,null,null,null,null,null,null];
(statearr_54210[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54210[(1)] = (1));

return statearr_54210;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54193){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54193);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54211){var ex__52109__auto__ = e54211;
var statearr_54212_55688 = state_54193;
(statearr_54212_55688[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54193[(4)]))){
var statearr_54213_55692 = state_54193;
(statearr_54213_55692[(1)] = cljs.core.first((state_54193[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55694 = state_54193;
state_54193 = G__55694;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54193){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54193);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54221 = f__52309__auto__();
(statearr_54221[(6)] = c__52308__auto___55659);

return statearr_54221;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.filter_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.remove_LT_ = (function cljs$core$async$remove_LT_(var_args){
var G__54229 = arguments.length;
switch (G__54229) {
case 2:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$2 = (function (p,ch){
return cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3(p,ch,null);
}));

(cljs.core.async.remove_LT_.cljs$core$IFn$_invoke$arity$3 = (function (p,ch,buf_or_n){
return cljs.core.async.filter_LT_.cljs$core$IFn$_invoke$arity$3(cljs.core.complement(p),ch,buf_or_n);
}));

(cljs.core.async.remove_LT_.cljs$lang$maxFixedArity = 3);

cljs.core.async.mapcat_STAR_ = (function cljs$core$async$mapcat_STAR_(f,in$,out){
var c__52308__auto__ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54314){
var state_val_54319 = (state_54314[(1)]);
if((state_val_54319 === (7))){
var inst_54310 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54320_55716 = state_54314__$1;
(statearr_54320_55716[(2)] = inst_54310);

(statearr_54320_55716[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (20))){
var inst_54270 = (state_54314[(7)]);
var inst_54288 = (state_54314[(2)]);
var inst_54289 = cljs.core.next(inst_54270);
var inst_54253 = inst_54289;
var inst_54254 = null;
var inst_54255 = (0);
var inst_54256 = (0);
var state_54314__$1 = (function (){var statearr_54323 = state_54314;
(statearr_54323[(8)] = inst_54288);

(statearr_54323[(9)] = inst_54253);

(statearr_54323[(10)] = inst_54254);

(statearr_54323[(11)] = inst_54255);

(statearr_54323[(12)] = inst_54256);

return statearr_54323;
})();
var statearr_54324_55722 = state_54314__$1;
(statearr_54324_55722[(2)] = null);

(statearr_54324_55722[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (1))){
var state_54314__$1 = state_54314;
var statearr_54325_55728 = state_54314__$1;
(statearr_54325_55728[(2)] = null);

(statearr_54325_55728[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (4))){
var inst_54242 = (state_54314[(13)]);
var inst_54242__$1 = (state_54314[(2)]);
var inst_54243 = (inst_54242__$1 == null);
var state_54314__$1 = (function (){var statearr_54326 = state_54314;
(statearr_54326[(13)] = inst_54242__$1);

return statearr_54326;
})();
if(cljs.core.truth_(inst_54243)){
var statearr_54327_55740 = state_54314__$1;
(statearr_54327_55740[(1)] = (5));

} else {
var statearr_54328_55741 = state_54314__$1;
(statearr_54328_55741[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (15))){
var state_54314__$1 = state_54314;
var statearr_54332_55743 = state_54314__$1;
(statearr_54332_55743[(2)] = null);

(statearr_54332_55743[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (21))){
var state_54314__$1 = state_54314;
var statearr_54333_55746 = state_54314__$1;
(statearr_54333_55746[(2)] = null);

(statearr_54333_55746[(1)] = (23));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (13))){
var inst_54256 = (state_54314[(12)]);
var inst_54253 = (state_54314[(9)]);
var inst_54254 = (state_54314[(10)]);
var inst_54255 = (state_54314[(11)]);
var inst_54266 = (state_54314[(2)]);
var inst_54267 = (inst_54256 + (1));
var tmp54329 = inst_54254;
var tmp54330 = inst_54255;
var tmp54331 = inst_54253;
var inst_54253__$1 = tmp54331;
var inst_54254__$1 = tmp54329;
var inst_54255__$1 = tmp54330;
var inst_54256__$1 = inst_54267;
var state_54314__$1 = (function (){var statearr_54334 = state_54314;
(statearr_54334[(14)] = inst_54266);

(statearr_54334[(9)] = inst_54253__$1);

(statearr_54334[(10)] = inst_54254__$1);

(statearr_54334[(11)] = inst_54255__$1);

(statearr_54334[(12)] = inst_54256__$1);

return statearr_54334;
})();
var statearr_54335_55750 = state_54314__$1;
(statearr_54335_55750[(2)] = null);

(statearr_54335_55750[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (22))){
var state_54314__$1 = state_54314;
var statearr_54336_55757 = state_54314__$1;
(statearr_54336_55757[(2)] = null);

(statearr_54336_55757[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (6))){
var inst_54242 = (state_54314[(13)]);
var inst_54251 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_54242) : f.call(null, inst_54242));
var inst_54252 = cljs.core.seq(inst_54251);
var inst_54253 = inst_54252;
var inst_54254 = null;
var inst_54255 = (0);
var inst_54256 = (0);
var state_54314__$1 = (function (){var statearr_54337 = state_54314;
(statearr_54337[(9)] = inst_54253);

(statearr_54337[(10)] = inst_54254);

(statearr_54337[(11)] = inst_54255);

(statearr_54337[(12)] = inst_54256);

return statearr_54337;
})();
var statearr_54338_55763 = state_54314__$1;
(statearr_54338_55763[(2)] = null);

(statearr_54338_55763[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (17))){
var inst_54270 = (state_54314[(7)]);
var inst_54278 = cljs.core.chunk_first(inst_54270);
var inst_54282 = cljs.core.chunk_rest(inst_54270);
var inst_54283 = cljs.core.count(inst_54278);
var inst_54253 = inst_54282;
var inst_54254 = inst_54278;
var inst_54255 = inst_54283;
var inst_54256 = (0);
var state_54314__$1 = (function (){var statearr_54339 = state_54314;
(statearr_54339[(9)] = inst_54253);

(statearr_54339[(10)] = inst_54254);

(statearr_54339[(11)] = inst_54255);

(statearr_54339[(12)] = inst_54256);

return statearr_54339;
})();
var statearr_54340_55768 = state_54314__$1;
(statearr_54340_55768[(2)] = null);

(statearr_54340_55768[(1)] = (8));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (3))){
var inst_54312 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54314__$1,inst_54312);
} else {
if((state_val_54319 === (12))){
var inst_54297 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54341_55773 = state_54314__$1;
(statearr_54341_55773[(2)] = inst_54297);

(statearr_54341_55773[(1)] = (9));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (2))){
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54314__$1,(4),in$);
} else {
if((state_val_54319 === (23))){
var inst_54308 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54342_55774 = state_54314__$1;
(statearr_54342_55774[(2)] = inst_54308);

(statearr_54342_55774[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (19))){
var inst_54292 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54343_55775 = state_54314__$1;
(statearr_54343_55775[(2)] = inst_54292);

(statearr_54343_55775[(1)] = (16));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (11))){
var inst_54253 = (state_54314[(9)]);
var inst_54270 = (state_54314[(7)]);
var inst_54270__$1 = cljs.core.seq(inst_54253);
var state_54314__$1 = (function (){var statearr_54344 = state_54314;
(statearr_54344[(7)] = inst_54270__$1);

return statearr_54344;
})();
if(inst_54270__$1){
var statearr_54345_55776 = state_54314__$1;
(statearr_54345_55776[(1)] = (14));

} else {
var statearr_54346_55777 = state_54314__$1;
(statearr_54346_55777[(1)] = (15));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (9))){
var inst_54299 = (state_54314[(2)]);
var inst_54300 = cljs.core.async.impl.protocols.closed_QMARK_(out);
var state_54314__$1 = (function (){var statearr_54347 = state_54314;
(statearr_54347[(15)] = inst_54299);

return statearr_54347;
})();
if(cljs.core.truth_(inst_54300)){
var statearr_54348_55782 = state_54314__$1;
(statearr_54348_55782[(1)] = (21));

} else {
var statearr_54349_55783 = state_54314__$1;
(statearr_54349_55783[(1)] = (22));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (5))){
var inst_54245 = cljs.core.async.close_BANG_(out);
var state_54314__$1 = state_54314;
var statearr_54350_55784 = state_54314__$1;
(statearr_54350_55784[(2)] = inst_54245);

(statearr_54350_55784[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (14))){
var inst_54270 = (state_54314[(7)]);
var inst_54276 = cljs.core.chunked_seq_QMARK_(inst_54270);
var state_54314__$1 = state_54314;
if(inst_54276){
var statearr_54353_55785 = state_54314__$1;
(statearr_54353_55785[(1)] = (17));

} else {
var statearr_54354_55786 = state_54314__$1;
(statearr_54354_55786[(1)] = (18));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (16))){
var inst_54295 = (state_54314[(2)]);
var state_54314__$1 = state_54314;
var statearr_54355_55787 = state_54314__$1;
(statearr_54355_55787[(2)] = inst_54295);

(statearr_54355_55787[(1)] = (12));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54319 === (10))){
var inst_54254 = (state_54314[(10)]);
var inst_54256 = (state_54314[(12)]);
var inst_54261 = cljs.core._nth(inst_54254,inst_54256);
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54314__$1,(13),out,inst_54261);
} else {
if((state_val_54319 === (18))){
var inst_54270 = (state_54314[(7)]);
var inst_54286 = cljs.core.first(inst_54270);
var state_54314__$1 = state_54314;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54314__$1,(20),out,inst_54286);
} else {
if((state_val_54319 === (8))){
var inst_54256 = (state_54314[(12)]);
var inst_54255 = (state_54314[(11)]);
var inst_54258 = (inst_54256 < inst_54255);
var inst_54259 = inst_54258;
var state_54314__$1 = state_54314;
if(cljs.core.truth_(inst_54259)){
var statearr_54356_55792 = state_54314__$1;
(statearr_54356_55792[(1)] = (10));

} else {
var statearr_54357_55793 = state_54314__$1;
(statearr_54357_55793[(1)] = (11));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__ = null;
var cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____0 = (function (){
var statearr_54369 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54369[(0)] = cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__);

(statearr_54369[(1)] = (1));

return statearr_54369;
});
var cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____1 = (function (state_54314){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54314);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54370){var ex__52109__auto__ = e54370;
var statearr_54371_55806 = state_54314;
(statearr_54371_55806[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54314[(4)]))){
var statearr_54372_55808 = state_54314;
(statearr_54372_55808[(1)] = cljs.core.first((state_54314[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55809 = state_54314;
state_54314 = G__55809;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__ = function(state_54314){
switch(arguments.length){
case 0:
return cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____1.call(this,state_54314);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____0;
cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$mapcat_STAR__$_state_machine__52106__auto____1;
return cljs$core$async$mapcat_STAR__$_state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54374 = f__52309__auto__();
(statearr_54374[(6)] = c__52308__auto__);

return statearr_54374;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));

return c__52308__auto__;
});
/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_LT_ = (function cljs$core$async$mapcat_LT_(var_args){
var G__54377 = arguments.length;
switch (G__54377) {
case 2:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$2 = (function (f,in$){
return cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3(f,in$,null);
}));

(cljs.core.async.mapcat_LT_.cljs$core$IFn$_invoke$arity$3 = (function (f,in$,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return out;
}));

(cljs.core.async.mapcat_LT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.mapcat_GT_ = (function cljs$core$async$mapcat_GT_(var_args){
var G__54379 = arguments.length;
switch (G__54379) {
case 2:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$2 = (function (f,out){
return cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3(f,out,null);
}));

(cljs.core.async.mapcat_GT_.cljs$core$IFn$_invoke$arity$3 = (function (f,out,buf_or_n){
var in$ = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
cljs.core.async.mapcat_STAR_(f,in$,out);

return in$;
}));

(cljs.core.async.mapcat_GT_.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.unique = (function cljs$core$async$unique(var_args){
var G__54381 = arguments.length;
switch (G__54381) {
case 1:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$1 = (function (ch){
return cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2(ch,null);
}));

(cljs.core.async.unique.cljs$core$IFn$_invoke$arity$2 = (function (ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55822 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54407){
var state_val_54408 = (state_54407[(1)]);
if((state_val_54408 === (7))){
var inst_54400 = (state_54407[(2)]);
var state_54407__$1 = state_54407;
var statearr_54409_55826 = state_54407__$1;
(statearr_54409_55826[(2)] = inst_54400);

(statearr_54409_55826[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (1))){
var inst_54382 = null;
var state_54407__$1 = (function (){var statearr_54411 = state_54407;
(statearr_54411[(7)] = inst_54382);

return statearr_54411;
})();
var statearr_54412_55831 = state_54407__$1;
(statearr_54412_55831[(2)] = null);

(statearr_54412_55831[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (4))){
var inst_54385 = (state_54407[(8)]);
var inst_54385__$1 = (state_54407[(2)]);
var inst_54386 = (inst_54385__$1 == null);
var inst_54387 = cljs.core.not(inst_54386);
var state_54407__$1 = (function (){var statearr_54413 = state_54407;
(statearr_54413[(8)] = inst_54385__$1);

return statearr_54413;
})();
if(inst_54387){
var statearr_54414_55832 = state_54407__$1;
(statearr_54414_55832[(1)] = (5));

} else {
var statearr_54415_55833 = state_54407__$1;
(statearr_54415_55833[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (6))){
var state_54407__$1 = state_54407;
var statearr_54416_55836 = state_54407__$1;
(statearr_54416_55836[(2)] = null);

(statearr_54416_55836[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (3))){
var inst_54402 = (state_54407[(2)]);
var inst_54403 = cljs.core.async.close_BANG_(out);
var state_54407__$1 = (function (){var statearr_54417 = state_54407;
(statearr_54417[(9)] = inst_54402);

return statearr_54417;
})();
return cljs.core.async.impl.ioc_helpers.return_chan(state_54407__$1,inst_54403);
} else {
if((state_val_54408 === (2))){
var state_54407__$1 = state_54407;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54407__$1,(4),ch);
} else {
if((state_val_54408 === (11))){
var inst_54385 = (state_54407[(8)]);
var inst_54394 = (state_54407[(2)]);
var inst_54382 = inst_54385;
var state_54407__$1 = (function (){var statearr_54427 = state_54407;
(statearr_54427[(10)] = inst_54394);

(statearr_54427[(7)] = inst_54382);

return statearr_54427;
})();
var statearr_54428_55837 = state_54407__$1;
(statearr_54428_55837[(2)] = null);

(statearr_54428_55837[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (9))){
var inst_54385 = (state_54407[(8)]);
var state_54407__$1 = state_54407;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54407__$1,(11),out,inst_54385);
} else {
if((state_val_54408 === (5))){
var inst_54385 = (state_54407[(8)]);
var inst_54382 = (state_54407[(7)]);
var inst_54389 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54385,inst_54382);
var state_54407__$1 = state_54407;
if(inst_54389){
var statearr_54430_55838 = state_54407__$1;
(statearr_54430_55838[(1)] = (8));

} else {
var statearr_54431_55839 = state_54407__$1;
(statearr_54431_55839[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (10))){
var inst_54397 = (state_54407[(2)]);
var state_54407__$1 = state_54407;
var statearr_54433_55841 = state_54407__$1;
(statearr_54433_55841[(2)] = inst_54397);

(statearr_54433_55841[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54408 === (8))){
var inst_54382 = (state_54407[(7)]);
var tmp54429 = inst_54382;
var inst_54382__$1 = tmp54429;
var state_54407__$1 = (function (){var statearr_54434 = state_54407;
(statearr_54434[(7)] = inst_54382__$1);

return statearr_54434;
})();
var statearr_54435_55844 = state_54407__$1;
(statearr_54435_55844[(2)] = null);

(statearr_54435_55844[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54436 = [null,null,null,null,null,null,null,null,null,null,null];
(statearr_54436[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54436[(1)] = (1));

return statearr_54436;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54407){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54407);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54437){var ex__52109__auto__ = e54437;
var statearr_54438_55845 = state_54407;
(statearr_54438_55845[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54407[(4)]))){
var statearr_54439_55846 = state_54407;
(statearr_54439_55846[(1)] = cljs.core.first((state_54407[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55850 = state_54407;
state_54407 = G__55850;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54407){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54407);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54440 = f__52309__auto__();
(statearr_54440[(6)] = c__52308__auto___55822);

return statearr_54440;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.unique.cljs$lang$maxFixedArity = 2);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition = (function cljs$core$async$partition(var_args){
var G__54442 = arguments.length;
switch (G__54442) {
case 2:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$2 = (function (n,ch){
return cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3(n,ch,null);
}));

(cljs.core.async.partition.cljs$core$IFn$_invoke$arity$3 = (function (n,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55862 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54482){
var state_val_54483 = (state_54482[(1)]);
if((state_val_54483 === (7))){
var inst_54478 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
var statearr_54485_55865 = state_54482__$1;
(statearr_54485_55865[(2)] = inst_54478);

(statearr_54485_55865[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (1))){
var inst_54443 = (new Array(n));
var inst_54444 = inst_54443;
var inst_54445 = (0);
var state_54482__$1 = (function (){var statearr_54486 = state_54482;
(statearr_54486[(7)] = inst_54444);

(statearr_54486[(8)] = inst_54445);

return statearr_54486;
})();
var statearr_54488_55869 = state_54482__$1;
(statearr_54488_55869[(2)] = null);

(statearr_54488_55869[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (4))){
var inst_54448 = (state_54482[(9)]);
var inst_54448__$1 = (state_54482[(2)]);
var inst_54449 = (inst_54448__$1 == null);
var inst_54450 = cljs.core.not(inst_54449);
var state_54482__$1 = (function (){var statearr_54489 = state_54482;
(statearr_54489[(9)] = inst_54448__$1);

return statearr_54489;
})();
if(inst_54450){
var statearr_54490_55873 = state_54482__$1;
(statearr_54490_55873[(1)] = (5));

} else {
var statearr_54491_55874 = state_54482__$1;
(statearr_54491_55874[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (15))){
var inst_54472 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
var statearr_54492_55875 = state_54482__$1;
(statearr_54492_55875[(2)] = inst_54472);

(statearr_54492_55875[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (13))){
var state_54482__$1 = state_54482;
var statearr_54493_55877 = state_54482__$1;
(statearr_54493_55877[(2)] = null);

(statearr_54493_55877[(1)] = (14));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (6))){
var inst_54445 = (state_54482[(8)]);
var inst_54468 = (inst_54445 > (0));
var state_54482__$1 = state_54482;
if(cljs.core.truth_(inst_54468)){
var statearr_54494_55880 = state_54482__$1;
(statearr_54494_55880[(1)] = (12));

} else {
var statearr_54495_55881 = state_54482__$1;
(statearr_54495_55881[(1)] = (13));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (3))){
var inst_54480 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54482__$1,inst_54480);
} else {
if((state_val_54483 === (12))){
var inst_54444 = (state_54482[(7)]);
var inst_54470 = cljs.core.vec(inst_54444);
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54482__$1,(15),out,inst_54470);
} else {
if((state_val_54483 === (2))){
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54482__$1,(4),ch);
} else {
if((state_val_54483 === (11))){
var inst_54462 = (state_54482[(2)]);
var inst_54463 = (new Array(n));
var inst_54444 = inst_54463;
var inst_54445 = (0);
var state_54482__$1 = (function (){var statearr_54496 = state_54482;
(statearr_54496[(10)] = inst_54462);

(statearr_54496[(7)] = inst_54444);

(statearr_54496[(8)] = inst_54445);

return statearr_54496;
})();
var statearr_54504_55886 = state_54482__$1;
(statearr_54504_55886[(2)] = null);

(statearr_54504_55886[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (9))){
var inst_54444 = (state_54482[(7)]);
var inst_54460 = cljs.core.vec(inst_54444);
var state_54482__$1 = state_54482;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54482__$1,(11),out,inst_54460);
} else {
if((state_val_54483 === (5))){
var inst_54444 = (state_54482[(7)]);
var inst_54445 = (state_54482[(8)]);
var inst_54448 = (state_54482[(9)]);
var inst_54455 = (state_54482[(11)]);
var inst_54452 = (inst_54444[inst_54445] = inst_54448);
var inst_54455__$1 = (inst_54445 + (1));
var inst_54456 = (inst_54455__$1 < n);
var state_54482__$1 = (function (){var statearr_54506 = state_54482;
(statearr_54506[(12)] = inst_54452);

(statearr_54506[(11)] = inst_54455__$1);

return statearr_54506;
})();
if(cljs.core.truth_(inst_54456)){
var statearr_54507_55887 = state_54482__$1;
(statearr_54507_55887[(1)] = (8));

} else {
var statearr_54508_55888 = state_54482__$1;
(statearr_54508_55888[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (14))){
var inst_54475 = (state_54482[(2)]);
var inst_54476 = cljs.core.async.close_BANG_(out);
var state_54482__$1 = (function (){var statearr_54519 = state_54482;
(statearr_54519[(13)] = inst_54475);

return statearr_54519;
})();
var statearr_54520_55891 = state_54482__$1;
(statearr_54520_55891[(2)] = inst_54476);

(statearr_54520_55891[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (10))){
var inst_54466 = (state_54482[(2)]);
var state_54482__$1 = state_54482;
var statearr_54521_55896 = state_54482__$1;
(statearr_54521_55896[(2)] = inst_54466);

(statearr_54521_55896[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54483 === (8))){
var inst_54444 = (state_54482[(7)]);
var inst_54455 = (state_54482[(11)]);
var tmp54509 = inst_54444;
var inst_54444__$1 = tmp54509;
var inst_54445 = inst_54455;
var state_54482__$1 = (function (){var statearr_54522 = state_54482;
(statearr_54522[(7)] = inst_54444__$1);

(statearr_54522[(8)] = inst_54445);

return statearr_54522;
})();
var statearr_54527_55898 = state_54482__$1;
(statearr_54527_55898[(2)] = null);

(statearr_54527_55898[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54528 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54528[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54528[(1)] = (1));

return statearr_54528;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54482){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54482);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54536){var ex__52109__auto__ = e54536;
var statearr_54537_55899 = state_54482;
(statearr_54537_55899[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54482[(4)]))){
var statearr_54538_55900 = state_54482;
(statearr_54538_55900[(1)] = cljs.core.first((state_54482[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55901 = state_54482;
state_54482 = G__55901;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54482){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54482);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54540 = f__52309__auto__();
(statearr_54540[(6)] = c__52308__auto___55862);

return statearr_54540;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.partition.cljs$lang$maxFixedArity = 3);

/**
 * Deprecated - this function will be removed. Use transducer instead
 */
cljs.core.async.partition_by = (function cljs$core$async$partition_by(var_args){
var G__54544 = arguments.length;
switch (G__54544) {
case 2:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$2 = (function (f,ch){
return cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3(f,ch,null);
}));

(cljs.core.async.partition_by.cljs$core$IFn$_invoke$arity$3 = (function (f,ch,buf_or_n){
var out = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1(buf_or_n);
var c__52308__auto___55910 = cljs.core.async.chan.cljs$core$IFn$_invoke$arity$1((1));
cljs.core.async.impl.dispatch.run((function (){
var f__52309__auto__ = (function (){var switch__52105__auto__ = (function (state_54598){
var state_val_54599 = (state_54598[(1)]);
if((state_val_54599 === (7))){
var inst_54591 = (state_54598[(2)]);
var state_54598__$1 = state_54598;
var statearr_54601_55911 = state_54598__$1;
(statearr_54601_55911[(2)] = inst_54591);

(statearr_54601_55911[(1)] = (3));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (1))){
var inst_54550 = [];
var inst_54551 = inst_54550;
var inst_54552 = new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123);
var state_54598__$1 = (function (){var statearr_54602 = state_54598;
(statearr_54602[(7)] = inst_54551);

(statearr_54602[(8)] = inst_54552);

return statearr_54602;
})();
var statearr_54603_55916 = state_54598__$1;
(statearr_54603_55916[(2)] = null);

(statearr_54603_55916[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (4))){
var inst_54555 = (state_54598[(9)]);
var inst_54555__$1 = (state_54598[(2)]);
var inst_54556 = (inst_54555__$1 == null);
var inst_54557 = cljs.core.not(inst_54556);
var state_54598__$1 = (function (){var statearr_54604 = state_54598;
(statearr_54604[(9)] = inst_54555__$1);

return statearr_54604;
})();
if(inst_54557){
var statearr_54605_55917 = state_54598__$1;
(statearr_54605_55917[(1)] = (5));

} else {
var statearr_54606_55919 = state_54598__$1;
(statearr_54606_55919[(1)] = (6));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (15))){
var inst_54551 = (state_54598[(7)]);
var inst_54583 = cljs.core.vec(inst_54551);
var state_54598__$1 = state_54598;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54598__$1,(18),out,inst_54583);
} else {
if((state_val_54599 === (13))){
var inst_54578 = (state_54598[(2)]);
var state_54598__$1 = state_54598;
var statearr_54608_55921 = state_54598__$1;
(statearr_54608_55921[(2)] = inst_54578);

(statearr_54608_55921[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (6))){
var inst_54551 = (state_54598[(7)]);
var inst_54580 = inst_54551.length;
var inst_54581 = (inst_54580 > (0));
var state_54598__$1 = state_54598;
if(cljs.core.truth_(inst_54581)){
var statearr_54616_55926 = state_54598__$1;
(statearr_54616_55926[(1)] = (15));

} else {
var statearr_54617_55931 = state_54598__$1;
(statearr_54617_55931[(1)] = (16));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (17))){
var inst_54588 = (state_54598[(2)]);
var inst_54589 = cljs.core.async.close_BANG_(out);
var state_54598__$1 = (function (){var statearr_54618 = state_54598;
(statearr_54618[(10)] = inst_54588);

return statearr_54618;
})();
var statearr_54619_55932 = state_54598__$1;
(statearr_54619_55932[(2)] = inst_54589);

(statearr_54619_55932[(1)] = (7));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (3))){
var inst_54593 = (state_54598[(2)]);
var state_54598__$1 = state_54598;
return cljs.core.async.impl.ioc_helpers.return_chan(state_54598__$1,inst_54593);
} else {
if((state_val_54599 === (12))){
var inst_54551 = (state_54598[(7)]);
var inst_54571 = cljs.core.vec(inst_54551);
var state_54598__$1 = state_54598;
return cljs.core.async.impl.ioc_helpers.put_BANG_(state_54598__$1,(14),out,inst_54571);
} else {
if((state_val_54599 === (2))){
var state_54598__$1 = state_54598;
return cljs.core.async.impl.ioc_helpers.take_BANG_(state_54598__$1,(4),ch);
} else {
if((state_val_54599 === (11))){
var inst_54551 = (state_54598[(7)]);
var inst_54555 = (state_54598[(9)]);
var inst_54559 = (state_54598[(11)]);
var inst_54567 = inst_54551.push(inst_54555);
var tmp54621 = inst_54551;
var inst_54551__$1 = tmp54621;
var inst_54552 = inst_54559;
var state_54598__$1 = (function (){var statearr_54622 = state_54598;
(statearr_54622[(12)] = inst_54567);

(statearr_54622[(7)] = inst_54551__$1);

(statearr_54622[(8)] = inst_54552);

return statearr_54622;
})();
var statearr_54623_55957 = state_54598__$1;
(statearr_54623_55957[(2)] = null);

(statearr_54623_55957[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (9))){
var inst_54552 = (state_54598[(8)]);
var inst_54563 = cljs.core.keyword_identical_QMARK_(inst_54552,new cljs.core.Keyword("cljs.core.async","nothing","cljs.core.async/nothing",-69252123));
var state_54598__$1 = state_54598;
var statearr_54626_55963 = state_54598__$1;
(statearr_54626_55963[(2)] = inst_54563);

(statearr_54626_55963[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (5))){
var inst_54555 = (state_54598[(9)]);
var inst_54559 = (state_54598[(11)]);
var inst_54552 = (state_54598[(8)]);
var inst_54560 = (state_54598[(13)]);
var inst_54559__$1 = (f.cljs$core$IFn$_invoke$arity$1 ? f.cljs$core$IFn$_invoke$arity$1(inst_54555) : f.call(null, inst_54555));
var inst_54560__$1 = cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(inst_54559__$1,inst_54552);
var state_54598__$1 = (function (){var statearr_54629 = state_54598;
(statearr_54629[(11)] = inst_54559__$1);

(statearr_54629[(13)] = inst_54560__$1);

return statearr_54629;
})();
if(inst_54560__$1){
var statearr_54630_55965 = state_54598__$1;
(statearr_54630_55965[(1)] = (8));

} else {
var statearr_54631_55966 = state_54598__$1;
(statearr_54631_55966[(1)] = (9));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (14))){
var inst_54555 = (state_54598[(9)]);
var inst_54559 = (state_54598[(11)]);
var inst_54573 = (state_54598[(2)]);
var inst_54574 = [];
var inst_54575 = inst_54574.push(inst_54555);
var inst_54551 = inst_54574;
var inst_54552 = inst_54559;
var state_54598__$1 = (function (){var statearr_54632 = state_54598;
(statearr_54632[(14)] = inst_54573);

(statearr_54632[(15)] = inst_54575);

(statearr_54632[(7)] = inst_54551);

(statearr_54632[(8)] = inst_54552);

return statearr_54632;
})();
var statearr_54633_55968 = state_54598__$1;
(statearr_54633_55968[(2)] = null);

(statearr_54633_55968[(1)] = (2));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (16))){
var state_54598__$1 = state_54598;
var statearr_54635_55969 = state_54598__$1;
(statearr_54635_55969[(2)] = null);

(statearr_54635_55969[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (10))){
var inst_54565 = (state_54598[(2)]);
var state_54598__$1 = state_54598;
if(cljs.core.truth_(inst_54565)){
var statearr_54636_55970 = state_54598__$1;
(statearr_54636_55970[(1)] = (11));

} else {
var statearr_54638_55971 = state_54598__$1;
(statearr_54638_55971[(1)] = (12));

}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (18))){
var inst_54585 = (state_54598[(2)]);
var state_54598__$1 = state_54598;
var statearr_54639_55973 = state_54598__$1;
(statearr_54639_55973[(2)] = inst_54585);

(statearr_54639_55973[(1)] = (17));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
if((state_val_54599 === (8))){
var inst_54560 = (state_54598[(13)]);
var state_54598__$1 = state_54598;
var statearr_54640_55974 = state_54598__$1;
(statearr_54640_55974[(2)] = inst_54560);

(statearr_54640_55974[(1)] = (10));


return new cljs.core.Keyword(null,"recur","recur",-437573268);
} else {
return null;
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
}
});
return (function() {
var cljs$core$async$state_machine__52106__auto__ = null;
var cljs$core$async$state_machine__52106__auto____0 = (function (){
var statearr_54641 = [null,null,null,null,null,null,null,null,null,null,null,null,null,null,null,null];
(statearr_54641[(0)] = cljs$core$async$state_machine__52106__auto__);

(statearr_54641[(1)] = (1));

return statearr_54641;
});
var cljs$core$async$state_machine__52106__auto____1 = (function (state_54598){
while(true){
var ret_value__52107__auto__ = (function (){try{while(true){
var result__52108__auto__ = switch__52105__auto__(state_54598);
if(cljs.core.keyword_identical_QMARK_(result__52108__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
continue;
} else {
return result__52108__auto__;
}
break;
}
}catch (e54642){var ex__52109__auto__ = e54642;
var statearr_54643_55976 = state_54598;
(statearr_54643_55976[(2)] = ex__52109__auto__);


if(cljs.core.seq((state_54598[(4)]))){
var statearr_54644_55977 = state_54598;
(statearr_54644_55977[(1)] = cljs.core.first((state_54598[(4)])));

} else {
throw ex__52109__auto__;
}

return new cljs.core.Keyword(null,"recur","recur",-437573268);
}})();
if(cljs.core.keyword_identical_QMARK_(ret_value__52107__auto__,new cljs.core.Keyword(null,"recur","recur",-437573268))){
var G__55979 = state_54598;
state_54598 = G__55979;
continue;
} else {
return ret_value__52107__auto__;
}
break;
}
});
cljs$core$async$state_machine__52106__auto__ = function(state_54598){
switch(arguments.length){
case 0:
return cljs$core$async$state_machine__52106__auto____0.call(this);
case 1:
return cljs$core$async$state_machine__52106__auto____1.call(this,state_54598);
}
throw(new Error('Invalid arity: ' + arguments.length));
};
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$0 = cljs$core$async$state_machine__52106__auto____0;
cljs$core$async$state_machine__52106__auto__.cljs$core$IFn$_invoke$arity$1 = cljs$core$async$state_machine__52106__auto____1;
return cljs$core$async$state_machine__52106__auto__;
})()
})();
var state__52310__auto__ = (function (){var statearr_54645 = f__52309__auto__();
(statearr_54645[(6)] = c__52308__auto___55910);

return statearr_54645;
})();
return cljs.core.async.impl.ioc_helpers.run_state_machine_wrapped(state__52310__auto__);
}));


return out;
}));

(cljs.core.async.partition_by.cljs$lang$maxFixedArity = 3);


//# sourceMappingURL=cljs.core.async.js.map
