goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_50546 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_50546(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_50548 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_50548(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__49099 = coll;
var G__49100 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__49099,G__49100) : shadow.dom.lazy_native_coll_seq.call(null, G__49099,G__49100));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null, );
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__49127 = arguments.length;
switch (G__49127) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__49134 = arguments.length;
switch (G__49134) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__49136 = arguments.length;
switch (G__49136) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__49142 = arguments.length;
switch (G__49142) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__49171 = arguments.length;
switch (G__49171) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__49184 = arguments.length;
switch (G__49184) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
}));
}catch (e49204){if((e49204 instanceof Object)){
var e = e49204;
return console.log("didnt support attachEvent",el,e);
} else {
throw e49204;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__49234 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__49236 = null;
var count__49237 = (0);
var i__49238 = (0);
while(true){
if((i__49238 < count__49237)){
var el = chunk__49236.cljs$core$IIndexed$_nth$arity$2(null, i__49238);
var handler_50590__$1 = ((function (seq__49234,chunk__49236,count__49237,i__49238,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__49234,chunk__49236,count__49237,i__49238,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50590__$1);


var G__50591 = seq__49234;
var G__50592 = chunk__49236;
var G__50593 = count__49237;
var G__50594 = (i__49238 + (1));
seq__49234 = G__50591;
chunk__49236 = G__50592;
count__49237 = G__50593;
i__49238 = G__50594;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__49234);
if(temp__5823__auto__){
var seq__49234__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49234__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__49234__$1);
var G__50597 = cljs.core.chunk_rest(seq__49234__$1);
var G__50598 = c__5525__auto__;
var G__50599 = cljs.core.count(c__5525__auto__);
var G__50600 = (0);
seq__49234 = G__50597;
chunk__49236 = G__50598;
count__49237 = G__50599;
i__49238 = G__50600;
continue;
} else {
var el = cljs.core.first(seq__49234__$1);
var handler_50603__$1 = ((function (seq__49234,chunk__49236,count__49237,i__49238,el,seq__49234__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__49234,chunk__49236,count__49237,i__49238,el,seq__49234__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_50603__$1);


var G__50604 = cljs.core.next(seq__49234__$1);
var G__50605 = null;
var G__50606 = (0);
var G__50607 = (0);
seq__49234 = G__50604;
chunk__49236 = G__50605;
count__49237 = G__50606;
i__49238 = G__50607;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__49269 = arguments.length;
switch (G__49269) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__49285 = cljs.core.seq(events);
var chunk__49286 = null;
var count__49287 = (0);
var i__49288 = (0);
while(true){
if((i__49288 < count__49287)){
var vec__49302 = chunk__49286.cljs$core$IIndexed$_nth$arity$2(null, i__49288);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49302,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49302,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50616 = seq__49285;
var G__50617 = chunk__49286;
var G__50618 = count__49287;
var G__50619 = (i__49288 + (1));
seq__49285 = G__50616;
chunk__49286 = G__50617;
count__49287 = G__50618;
i__49288 = G__50619;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__49285);
if(temp__5823__auto__){
var seq__49285__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49285__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__49285__$1);
var G__50621 = cljs.core.chunk_rest(seq__49285__$1);
var G__50622 = c__5525__auto__;
var G__50623 = cljs.core.count(c__5525__auto__);
var G__50624 = (0);
seq__49285 = G__50621;
chunk__49286 = G__50622;
count__49287 = G__50623;
i__49288 = G__50624;
continue;
} else {
var vec__49312 = cljs.core.first(seq__49285__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49312,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49312,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__50628 = cljs.core.next(seq__49285__$1);
var G__50629 = null;
var G__50630 = (0);
var G__50631 = (0);
seq__49285 = G__50628;
chunk__49286 = G__50629;
count__49287 = G__50630;
i__49288 = G__50631;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__49322 = cljs.core.seq(styles);
var chunk__49323 = null;
var count__49324 = (0);
var i__49325 = (0);
while(true){
if((i__49325 < count__49324)){
var vec__49339 = chunk__49323.cljs$core$IIndexed$_nth$arity$2(null, i__49325);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49339,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49339,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50638 = seq__49322;
var G__50639 = chunk__49323;
var G__50640 = count__49324;
var G__50641 = (i__49325 + (1));
seq__49322 = G__50638;
chunk__49323 = G__50639;
count__49324 = G__50640;
i__49325 = G__50641;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__49322);
if(temp__5823__auto__){
var seq__49322__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49322__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__49322__$1);
var G__50642 = cljs.core.chunk_rest(seq__49322__$1);
var G__50643 = c__5525__auto__;
var G__50644 = cljs.core.count(c__5525__auto__);
var G__50645 = (0);
seq__49322 = G__50642;
chunk__49323 = G__50643;
count__49324 = G__50644;
i__49325 = G__50645;
continue;
} else {
var vec__49346 = cljs.core.first(seq__49322__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49346,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49346,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__50648 = cljs.core.next(seq__49322__$1);
var G__50649 = null;
var G__50650 = (0);
var G__50651 = (0);
seq__49322 = G__50648;
chunk__49323 = G__50649;
count__49324 = G__50650;
i__49325 = G__50651;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__49362_50653 = key;
var G__49362_50654__$1 = (((G__49362_50653 instanceof cljs.core.Keyword))?G__49362_50653.fqn:null);
switch (G__49362_50654__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_50660 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_50660,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_50660,"aria-");
}
})())){
el.setAttribute(ks_50660,value);
} else {
(el[ks_50660] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__49383){
var map__49384 = p__49383;
var map__49384__$1 = cljs.core.__destructure_map(map__49384);
var props = map__49384__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__49384__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__49385 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49385,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49385,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49385,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__49388 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__49388,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__49388;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__49390 = arguments.length;
switch (G__49390) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__49405){
var vec__49407 = p__49405;
var seq__49408 = cljs.core.seq(vec__49407);
var first__49409 = cljs.core.first(seq__49408);
var seq__49408__$1 = cljs.core.next(seq__49408);
var nn = first__49409;
var first__49409__$1 = cljs.core.first(seq__49408__$1);
var seq__49408__$2 = cljs.core.next(seq__49408__$1);
var np = first__49409__$1;
var nc = seq__49408__$2;
var node = vec__49407;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49411 = nn;
var G__49412 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49411,G__49412) : create_fn.call(null, G__49411,G__49412));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null, nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__49413 = nn;
var G__49414 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__49413,G__49414) : create_fn.call(null, G__49413,G__49414));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__49426 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49426,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49426,(1),null);
var seq__49429_50719 = cljs.core.seq(node_children);
var chunk__49430_50720 = null;
var count__49431_50721 = (0);
var i__49432_50722 = (0);
while(true){
if((i__49432_50722 < count__49431_50721)){
var child_struct_50723 = chunk__49430_50720.cljs$core$IIndexed$_nth$arity$2(null, i__49432_50722);
var children_50724 = shadow.dom.dom_node(child_struct_50723);
if(cljs.core.seq_QMARK_(children_50724)){
var seq__49504_50725 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50724));
var chunk__49506_50726 = null;
var count__49507_50727 = (0);
var i__49508_50728 = (0);
while(true){
if((i__49508_50728 < count__49507_50727)){
var child_50729 = chunk__49506_50726.cljs$core$IIndexed$_nth$arity$2(null, i__49508_50728);
if(cljs.core.truth_(child_50729)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50729);


var G__50730 = seq__49504_50725;
var G__50731 = chunk__49506_50726;
var G__50732 = count__49507_50727;
var G__50733 = (i__49508_50728 + (1));
seq__49504_50725 = G__50730;
chunk__49506_50726 = G__50731;
count__49507_50727 = G__50732;
i__49508_50728 = G__50733;
continue;
} else {
var G__50735 = seq__49504_50725;
var G__50736 = chunk__49506_50726;
var G__50737 = count__49507_50727;
var G__50738 = (i__49508_50728 + (1));
seq__49504_50725 = G__50735;
chunk__49506_50726 = G__50736;
count__49507_50727 = G__50737;
i__49508_50728 = G__50738;
continue;
}
} else {
var temp__5823__auto___50739 = cljs.core.seq(seq__49504_50725);
if(temp__5823__auto___50739){
var seq__49504_50740__$1 = temp__5823__auto___50739;
if(cljs.core.chunked_seq_QMARK_(seq__49504_50740__$1)){
var c__5525__auto___50742 = cljs.core.chunk_first(seq__49504_50740__$1);
var G__50743 = cljs.core.chunk_rest(seq__49504_50740__$1);
var G__50744 = c__5525__auto___50742;
var G__50745 = cljs.core.count(c__5525__auto___50742);
var G__50746 = (0);
seq__49504_50725 = G__50743;
chunk__49506_50726 = G__50744;
count__49507_50727 = G__50745;
i__49508_50728 = G__50746;
continue;
} else {
var child_50748 = cljs.core.first(seq__49504_50740__$1);
if(cljs.core.truth_(child_50748)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50748);


var G__50749 = cljs.core.next(seq__49504_50740__$1);
var G__50750 = null;
var G__50751 = (0);
var G__50752 = (0);
seq__49504_50725 = G__50749;
chunk__49506_50726 = G__50750;
count__49507_50727 = G__50751;
i__49508_50728 = G__50752;
continue;
} else {
var G__50753 = cljs.core.next(seq__49504_50740__$1);
var G__50754 = null;
var G__50755 = (0);
var G__50756 = (0);
seq__49504_50725 = G__50753;
chunk__49506_50726 = G__50754;
count__49507_50727 = G__50755;
i__49508_50728 = G__50756;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50724);
}


var G__50758 = seq__49429_50719;
var G__50759 = chunk__49430_50720;
var G__50760 = count__49431_50721;
var G__50761 = (i__49432_50722 + (1));
seq__49429_50719 = G__50758;
chunk__49430_50720 = G__50759;
count__49431_50721 = G__50760;
i__49432_50722 = G__50761;
continue;
} else {
var temp__5823__auto___50763 = cljs.core.seq(seq__49429_50719);
if(temp__5823__auto___50763){
var seq__49429_50765__$1 = temp__5823__auto___50763;
if(cljs.core.chunked_seq_QMARK_(seq__49429_50765__$1)){
var c__5525__auto___50766 = cljs.core.chunk_first(seq__49429_50765__$1);
var G__50767 = cljs.core.chunk_rest(seq__49429_50765__$1);
var G__50768 = c__5525__auto___50766;
var G__50769 = cljs.core.count(c__5525__auto___50766);
var G__50770 = (0);
seq__49429_50719 = G__50767;
chunk__49430_50720 = G__50768;
count__49431_50721 = G__50769;
i__49432_50722 = G__50770;
continue;
} else {
var child_struct_50772 = cljs.core.first(seq__49429_50765__$1);
var children_50773 = shadow.dom.dom_node(child_struct_50772);
if(cljs.core.seq_QMARK_(children_50773)){
var seq__49540_50775 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_50773));
var chunk__49542_50776 = null;
var count__49543_50777 = (0);
var i__49544_50778 = (0);
while(true){
if((i__49544_50778 < count__49543_50777)){
var child_50781 = chunk__49542_50776.cljs$core$IIndexed$_nth$arity$2(null, i__49544_50778);
if(cljs.core.truth_(child_50781)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50781);


var G__50782 = seq__49540_50775;
var G__50783 = chunk__49542_50776;
var G__50784 = count__49543_50777;
var G__50785 = (i__49544_50778 + (1));
seq__49540_50775 = G__50782;
chunk__49542_50776 = G__50783;
count__49543_50777 = G__50784;
i__49544_50778 = G__50785;
continue;
} else {
var G__50787 = seq__49540_50775;
var G__50788 = chunk__49542_50776;
var G__50789 = count__49543_50777;
var G__50790 = (i__49544_50778 + (1));
seq__49540_50775 = G__50787;
chunk__49542_50776 = G__50788;
count__49543_50777 = G__50789;
i__49544_50778 = G__50790;
continue;
}
} else {
var temp__5823__auto___50792__$1 = cljs.core.seq(seq__49540_50775);
if(temp__5823__auto___50792__$1){
var seq__49540_50793__$1 = temp__5823__auto___50792__$1;
if(cljs.core.chunked_seq_QMARK_(seq__49540_50793__$1)){
var c__5525__auto___50795 = cljs.core.chunk_first(seq__49540_50793__$1);
var G__50796 = cljs.core.chunk_rest(seq__49540_50793__$1);
var G__50797 = c__5525__auto___50795;
var G__50798 = cljs.core.count(c__5525__auto___50795);
var G__50799 = (0);
seq__49540_50775 = G__50796;
chunk__49542_50776 = G__50797;
count__49543_50777 = G__50798;
i__49544_50778 = G__50799;
continue;
} else {
var child_50803 = cljs.core.first(seq__49540_50793__$1);
if(cljs.core.truth_(child_50803)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_50803);


var G__50805 = cljs.core.next(seq__49540_50793__$1);
var G__50806 = null;
var G__50807 = (0);
var G__50808 = (0);
seq__49540_50775 = G__50805;
chunk__49542_50776 = G__50806;
count__49543_50777 = G__50807;
i__49544_50778 = G__50808;
continue;
} else {
var G__50809 = cljs.core.next(seq__49540_50793__$1);
var G__50810 = null;
var G__50811 = (0);
var G__50812 = (0);
seq__49540_50775 = G__50809;
chunk__49542_50776 = G__50810;
count__49543_50777 = G__50811;
i__49544_50778 = G__50812;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_50773);
}


var G__50813 = cljs.core.next(seq__49429_50765__$1);
var G__50814 = null;
var G__50815 = (0);
var G__50816 = (0);
seq__49429_50719 = G__50813;
chunk__49430_50720 = G__50814;
count__49431_50721 = G__50815;
i__49432_50722 = G__50816;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__49591 = cljs.core.seq(node);
var chunk__49592 = null;
var count__49593 = (0);
var i__49594 = (0);
while(true){
if((i__49594 < count__49593)){
var n = chunk__49592.cljs$core$IIndexed$_nth$arity$2(null, i__49594);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__50828 = seq__49591;
var G__50829 = chunk__49592;
var G__50830 = count__49593;
var G__50832 = (i__49594 + (1));
seq__49591 = G__50828;
chunk__49592 = G__50829;
count__49593 = G__50830;
i__49594 = G__50832;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__49591);
if(temp__5823__auto__){
var seq__49591__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49591__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__49591__$1);
var G__50836 = cljs.core.chunk_rest(seq__49591__$1);
var G__50837 = c__5525__auto__;
var G__50838 = cljs.core.count(c__5525__auto__);
var G__50839 = (0);
seq__49591 = G__50836;
chunk__49592 = G__50837;
count__49593 = G__50838;
i__49594 = G__50839;
continue;
} else {
var n = cljs.core.first(seq__49591__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__50840 = cljs.core.next(seq__49591__$1);
var G__50841 = null;
var G__50842 = (0);
var G__50843 = (0);
seq__49591 = G__50840;
chunk__49592 = G__50841;
count__49593 = G__50842;
i__49594 = G__50843;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__49609 = arguments.length;
switch (G__49609) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__49620 = arguments.length;
switch (G__49620) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__49635 = arguments.length;
switch (G__49635) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___50860 = arguments.length;
var i__5727__auto___50861 = (0);
while(true){
if((i__5727__auto___50861 < len__5726__auto___50860)){
args__5732__auto__.push((arguments[i__5727__auto___50861]));

var G__50862 = (i__5727__auto___50861 + (1));
i__5727__auto___50861 = G__50862;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__49674_50864 = cljs.core.seq(nodes);
var chunk__49675_50865 = null;
var count__49676_50866 = (0);
var i__49677_50867 = (0);
while(true){
if((i__49677_50867 < count__49676_50866)){
var node_50870 = chunk__49675_50865.cljs$core$IIndexed$_nth$arity$2(null, i__49677_50867);
fragment.appendChild(shadow.dom._to_dom(node_50870));


var G__50871 = seq__49674_50864;
var G__50872 = chunk__49675_50865;
var G__50873 = count__49676_50866;
var G__50874 = (i__49677_50867 + (1));
seq__49674_50864 = G__50871;
chunk__49675_50865 = G__50872;
count__49676_50866 = G__50873;
i__49677_50867 = G__50874;
continue;
} else {
var temp__5823__auto___50875 = cljs.core.seq(seq__49674_50864);
if(temp__5823__auto___50875){
var seq__49674_50876__$1 = temp__5823__auto___50875;
if(cljs.core.chunked_seq_QMARK_(seq__49674_50876__$1)){
var c__5525__auto___50877 = cljs.core.chunk_first(seq__49674_50876__$1);
var G__50878 = cljs.core.chunk_rest(seq__49674_50876__$1);
var G__50879 = c__5525__auto___50877;
var G__50880 = cljs.core.count(c__5525__auto___50877);
var G__50881 = (0);
seq__49674_50864 = G__50878;
chunk__49675_50865 = G__50879;
count__49676_50866 = G__50880;
i__49677_50867 = G__50881;
continue;
} else {
var node_50883 = cljs.core.first(seq__49674_50876__$1);
fragment.appendChild(shadow.dom._to_dom(node_50883));


var G__50884 = cljs.core.next(seq__49674_50876__$1);
var G__50885 = null;
var G__50886 = (0);
var G__50887 = (0);
seq__49674_50864 = G__50884;
chunk__49675_50865 = G__50885;
count__49676_50866 = G__50886;
i__49677_50867 = G__50887;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq49670){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq49670));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__49690_50888 = cljs.core.seq(scripts);
var chunk__49691_50889 = null;
var count__49692_50890 = (0);
var i__49693_50891 = (0);
while(true){
if((i__49693_50891 < count__49692_50890)){
var vec__49705_50893 = chunk__49691_50889.cljs$core$IIndexed$_nth$arity$2(null, i__49693_50891);
var script_tag_50894 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49705_50893,(0),null);
var script_body_50895 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49705_50893,(1),null);
eval(script_body_50895);


var G__50897 = seq__49690_50888;
var G__50898 = chunk__49691_50889;
var G__50899 = count__49692_50890;
var G__50900 = (i__49693_50891 + (1));
seq__49690_50888 = G__50897;
chunk__49691_50889 = G__50898;
count__49692_50890 = G__50899;
i__49693_50891 = G__50900;
continue;
} else {
var temp__5823__auto___50901 = cljs.core.seq(seq__49690_50888);
if(temp__5823__auto___50901){
var seq__49690_50902__$1 = temp__5823__auto___50901;
if(cljs.core.chunked_seq_QMARK_(seq__49690_50902__$1)){
var c__5525__auto___50904 = cljs.core.chunk_first(seq__49690_50902__$1);
var G__50905 = cljs.core.chunk_rest(seq__49690_50902__$1);
var G__50906 = c__5525__auto___50904;
var G__50907 = cljs.core.count(c__5525__auto___50904);
var G__50908 = (0);
seq__49690_50888 = G__50905;
chunk__49691_50889 = G__50906;
count__49692_50890 = G__50907;
i__49693_50891 = G__50908;
continue;
} else {
var vec__49708_50910 = cljs.core.first(seq__49690_50902__$1);
var script_tag_50911 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49708_50910,(0),null);
var script_body_50912 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49708_50910,(1),null);
eval(script_body_50912);


var G__50914 = cljs.core.next(seq__49690_50902__$1);
var G__50915 = null;
var G__50916 = (0);
var G__50917 = (0);
seq__49690_50888 = G__50914;
chunk__49691_50889 = G__50915;
count__49692_50890 = G__50916;
i__49693_50891 = G__50917;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__49714){
var vec__49715 = p__49714;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49715,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49715,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__49725 = arguments.length;
switch (G__49725) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__49745 = cljs.core.seq(style_keys);
var chunk__49746 = null;
var count__49747 = (0);
var i__49748 = (0);
while(true){
if((i__49748 < count__49747)){
var it = chunk__49746.cljs$core$IIndexed$_nth$arity$2(null, i__49748);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50934 = seq__49745;
var G__50935 = chunk__49746;
var G__50936 = count__49747;
var G__50937 = (i__49748 + (1));
seq__49745 = G__50934;
chunk__49746 = G__50935;
count__49747 = G__50936;
i__49748 = G__50937;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__49745);
if(temp__5823__auto__){
var seq__49745__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__49745__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__49745__$1);
var G__50939 = cljs.core.chunk_rest(seq__49745__$1);
var G__50940 = c__5525__auto__;
var G__50941 = cljs.core.count(c__5525__auto__);
var G__50942 = (0);
seq__49745 = G__50939;
chunk__49746 = G__50940;
count__49747 = G__50941;
i__49748 = G__50942;
continue;
} else {
var it = cljs.core.first(seq__49745__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__50943 = cljs.core.next(seq__49745__$1);
var G__50944 = null;
var G__50945 = (0);
var G__50946 = (0);
seq__49745 = G__50943;
chunk__49746 = G__50944;
count__49747 = G__50945;
i__49748 = G__50946;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k49777,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__49787 = k49777;
var G__49787__$1 = (((G__49787 instanceof cljs.core.Keyword))?G__49787.fqn:null);
switch (G__49787__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49777,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__49789){
var vec__49790 = p__49789;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49790,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49790,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49776){
var self__ = this;
var G__49776__$1 = this;
return (new cljs.core.RecordIter((0),G__49776__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49778,other49779){
var self__ = this;
var this49778__$1 = this;
return (((!((other49779 == null)))) && ((((this49778__$1.constructor === other49779.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49778__$1.x,other49779.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49778__$1.y,other49779.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49778__$1.__extmap,other49779.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k49777){
var self__ = this;
var this__5307__auto____$1 = this;
var G__49839 = k49777;
var G__49839__$1 = (((G__49839 instanceof cljs.core.Keyword))?G__49839.fqn:null);
switch (G__49839__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49777);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__49776){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__49845 = cljs.core.keyword_identical_QMARK_;
var expr__49846 = k__5309__auto__;
if(cljs.core.truth_((pred__49845.cljs$core$IFn$_invoke$arity$2 ? pred__49845.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__49846) : pred__49845.call(null, new cljs.core.Keyword(null,"x","x",2099068185),expr__49846)))){
return (new shadow.dom.Coordinate(G__49776,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__49845.cljs$core$IFn$_invoke$arity$2 ? pred__49845.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__49846) : pred__49845.call(null, new cljs.core.Keyword(null,"y","y",-1757859776),expr__49846)))){
return (new shadow.dom.Coordinate(self__.x,G__49776,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__49776),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__49776){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__49776,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__49781){
var extmap__5342__auto__ = (function (){var G__49872 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49781,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__49781)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__49872);
} else {
return G__49872;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__49781),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__49781),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k49911,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__49935 = k49911;
var G__49935__$1 = (((G__49935 instanceof cljs.core.Keyword))?G__49935.fqn:null);
switch (G__49935__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k49911,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__49946){
var vec__49947 = p__49946;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49947,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__49947,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__49910){
var self__ = this;
var G__49910__$1 = this;
return (new cljs.core.RecordIter((0),G__49910__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this49912,other49913){
var self__ = this;
var this49912__$1 = this;
return (((!((other49913 == null)))) && ((((this49912__$1.constructor === other49913.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49912__$1.w,other49913.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49912__$1.h,other49913.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this49912__$1.__extmap,other49913.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k49911){
var self__ = this;
var this__5307__auto____$1 = this;
var G__50006 = k49911;
var G__50006__$1 = (((G__50006 instanceof cljs.core.Keyword))?G__50006.fqn:null);
switch (G__50006__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k49911);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__49910){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__50010 = cljs.core.keyword_identical_QMARK_;
var expr__50011 = k__5309__auto__;
if(cljs.core.truth_((pred__50010.cljs$core$IFn$_invoke$arity$2 ? pred__50010.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__50011) : pred__50010.call(null, new cljs.core.Keyword(null,"w","w",354169001),expr__50011)))){
return (new shadow.dom.Size(G__49910,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__50010.cljs$core$IFn$_invoke$arity$2 ? pred__50010.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__50011) : pred__50010.call(null, new cljs.core.Keyword(null,"h","h",1109658740),expr__50011)))){
return (new shadow.dom.Size(self__.w,G__49910,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__49910),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__49910){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__49910,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__49919){
var extmap__5342__auto__ = (function (){var G__50050 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__49919,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__49919)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__50050);
} else {
return G__50050;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__49919),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__49919),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__50990 = (i + (1));
var G__50991 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__50990;
ret = G__50991;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__50186){
var vec__50187 = p__50186;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50187,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50187,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__50201 = arguments.length;
switch (G__50201) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__51000 = ps;
var G__51001 = (i + (1));
el__$1 = G__51000;
i = G__51001;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null, parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__50345 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50345,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50345,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50345,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__50353_51004 = cljs.core.seq(props);
var chunk__50354_51005 = null;
var count__50355_51006 = (0);
var i__50356_51007 = (0);
while(true){
if((i__50356_51007 < count__50355_51006)){
var vec__50392_51008 = chunk__50354_51005.cljs$core$IIndexed$_nth$arity$2(null, i__50356_51007);
var k_51009 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50392_51008,(0),null);
var v_51010 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50392_51008,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_51009);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51009),v_51010);


var G__51011 = seq__50353_51004;
var G__51012 = chunk__50354_51005;
var G__51013 = count__50355_51006;
var G__51014 = (i__50356_51007 + (1));
seq__50353_51004 = G__51011;
chunk__50354_51005 = G__51012;
count__50355_51006 = G__51013;
i__50356_51007 = G__51014;
continue;
} else {
var temp__5823__auto___51016 = cljs.core.seq(seq__50353_51004);
if(temp__5823__auto___51016){
var seq__50353_51017__$1 = temp__5823__auto___51016;
if(cljs.core.chunked_seq_QMARK_(seq__50353_51017__$1)){
var c__5525__auto___51019 = cljs.core.chunk_first(seq__50353_51017__$1);
var G__51020 = cljs.core.chunk_rest(seq__50353_51017__$1);
var G__51021 = c__5525__auto___51019;
var G__51022 = cljs.core.count(c__5525__auto___51019);
var G__51023 = (0);
seq__50353_51004 = G__51020;
chunk__50354_51005 = G__51021;
count__50355_51006 = G__51022;
i__50356_51007 = G__51023;
continue;
} else {
var vec__50407_51025 = cljs.core.first(seq__50353_51017__$1);
var k_51026 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50407_51025,(0),null);
var v_51027 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50407_51025,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_51026);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_51026),v_51027);


var G__51031 = cljs.core.next(seq__50353_51017__$1);
var G__51032 = null;
var G__51033 = (0);
var G__51034 = (0);
seq__50353_51004 = G__51031;
chunk__50354_51005 = G__51032;
count__50355_51006 = G__51033;
i__50356_51007 = G__51034;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null, );
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__50428 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50428,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__50428,(1),null);
var seq__50435_51035 = cljs.core.seq(node_children);
var chunk__50437_51036 = null;
var count__50438_51037 = (0);
var i__50439_51038 = (0);
while(true){
if((i__50439_51038 < count__50438_51037)){
var child_struct_51040 = chunk__50437_51036.cljs$core$IIndexed$_nth$arity$2(null, i__50439_51038);
if((!((child_struct_51040 == null)))){
if(typeof child_struct_51040 === 'string'){
var text_51041 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51041),child_struct_51040].join(''));
} else {
var children_51046 = shadow.dom.svg_node(child_struct_51040);
if(cljs.core.seq_QMARK_(children_51046)){
var seq__50478_51047 = cljs.core.seq(children_51046);
var chunk__50480_51048 = null;
var count__50481_51049 = (0);
var i__50482_51050 = (0);
while(true){
if((i__50482_51050 < count__50481_51049)){
var child_51055 = chunk__50480_51048.cljs$core$IIndexed$_nth$arity$2(null, i__50482_51050);
if(cljs.core.truth_(child_51055)){
node.appendChild(child_51055);


var G__51056 = seq__50478_51047;
var G__51057 = chunk__50480_51048;
var G__51058 = count__50481_51049;
var G__51059 = (i__50482_51050 + (1));
seq__50478_51047 = G__51056;
chunk__50480_51048 = G__51057;
count__50481_51049 = G__51058;
i__50482_51050 = G__51059;
continue;
} else {
var G__51060 = seq__50478_51047;
var G__51061 = chunk__50480_51048;
var G__51062 = count__50481_51049;
var G__51063 = (i__50482_51050 + (1));
seq__50478_51047 = G__51060;
chunk__50480_51048 = G__51061;
count__50481_51049 = G__51062;
i__50482_51050 = G__51063;
continue;
}
} else {
var temp__5823__auto___51064 = cljs.core.seq(seq__50478_51047);
if(temp__5823__auto___51064){
var seq__50478_51065__$1 = temp__5823__auto___51064;
if(cljs.core.chunked_seq_QMARK_(seq__50478_51065__$1)){
var c__5525__auto___51066 = cljs.core.chunk_first(seq__50478_51065__$1);
var G__51067 = cljs.core.chunk_rest(seq__50478_51065__$1);
var G__51068 = c__5525__auto___51066;
var G__51069 = cljs.core.count(c__5525__auto___51066);
var G__51070 = (0);
seq__50478_51047 = G__51067;
chunk__50480_51048 = G__51068;
count__50481_51049 = G__51069;
i__50482_51050 = G__51070;
continue;
} else {
var child_51071 = cljs.core.first(seq__50478_51065__$1);
if(cljs.core.truth_(child_51071)){
node.appendChild(child_51071);


var G__51072 = cljs.core.next(seq__50478_51065__$1);
var G__51073 = null;
var G__51074 = (0);
var G__51075 = (0);
seq__50478_51047 = G__51072;
chunk__50480_51048 = G__51073;
count__50481_51049 = G__51074;
i__50482_51050 = G__51075;
continue;
} else {
var G__51076 = cljs.core.next(seq__50478_51065__$1);
var G__51077 = null;
var G__51078 = (0);
var G__51079 = (0);
seq__50478_51047 = G__51076;
chunk__50480_51048 = G__51077;
count__50481_51049 = G__51078;
i__50482_51050 = G__51079;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51046);
}
}


var G__51081 = seq__50435_51035;
var G__51082 = chunk__50437_51036;
var G__51083 = count__50438_51037;
var G__51084 = (i__50439_51038 + (1));
seq__50435_51035 = G__51081;
chunk__50437_51036 = G__51082;
count__50438_51037 = G__51083;
i__50439_51038 = G__51084;
continue;
} else {
var G__51086 = seq__50435_51035;
var G__51087 = chunk__50437_51036;
var G__51088 = count__50438_51037;
var G__51089 = (i__50439_51038 + (1));
seq__50435_51035 = G__51086;
chunk__50437_51036 = G__51087;
count__50438_51037 = G__51088;
i__50439_51038 = G__51089;
continue;
}
} else {
var temp__5823__auto___51090 = cljs.core.seq(seq__50435_51035);
if(temp__5823__auto___51090){
var seq__50435_51091__$1 = temp__5823__auto___51090;
if(cljs.core.chunked_seq_QMARK_(seq__50435_51091__$1)){
var c__5525__auto___51092 = cljs.core.chunk_first(seq__50435_51091__$1);
var G__51094 = cljs.core.chunk_rest(seq__50435_51091__$1);
var G__51095 = c__5525__auto___51092;
var G__51096 = cljs.core.count(c__5525__auto___51092);
var G__51097 = (0);
seq__50435_51035 = G__51094;
chunk__50437_51036 = G__51095;
count__50438_51037 = G__51096;
i__50439_51038 = G__51097;
continue;
} else {
var child_struct_51098 = cljs.core.first(seq__50435_51091__$1);
if((!((child_struct_51098 == null)))){
if(typeof child_struct_51098 === 'string'){
var text_51100 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_51100),child_struct_51098].join(''));
} else {
var children_51101 = shadow.dom.svg_node(child_struct_51098);
if(cljs.core.seq_QMARK_(children_51101)){
var seq__50498_51103 = cljs.core.seq(children_51101);
var chunk__50500_51104 = null;
var count__50501_51105 = (0);
var i__50502_51106 = (0);
while(true){
if((i__50502_51106 < count__50501_51105)){
var child_51107 = chunk__50500_51104.cljs$core$IIndexed$_nth$arity$2(null, i__50502_51106);
if(cljs.core.truth_(child_51107)){
node.appendChild(child_51107);


var G__51108 = seq__50498_51103;
var G__51109 = chunk__50500_51104;
var G__51110 = count__50501_51105;
var G__51111 = (i__50502_51106 + (1));
seq__50498_51103 = G__51108;
chunk__50500_51104 = G__51109;
count__50501_51105 = G__51110;
i__50502_51106 = G__51111;
continue;
} else {
var G__51112 = seq__50498_51103;
var G__51113 = chunk__50500_51104;
var G__51114 = count__50501_51105;
var G__51115 = (i__50502_51106 + (1));
seq__50498_51103 = G__51112;
chunk__50500_51104 = G__51113;
count__50501_51105 = G__51114;
i__50502_51106 = G__51115;
continue;
}
} else {
var temp__5823__auto___51116__$1 = cljs.core.seq(seq__50498_51103);
if(temp__5823__auto___51116__$1){
var seq__50498_51118__$1 = temp__5823__auto___51116__$1;
if(cljs.core.chunked_seq_QMARK_(seq__50498_51118__$1)){
var c__5525__auto___51119 = cljs.core.chunk_first(seq__50498_51118__$1);
var G__51120 = cljs.core.chunk_rest(seq__50498_51118__$1);
var G__51121 = c__5525__auto___51119;
var G__51122 = cljs.core.count(c__5525__auto___51119);
var G__51123 = (0);
seq__50498_51103 = G__51120;
chunk__50500_51104 = G__51121;
count__50501_51105 = G__51122;
i__50502_51106 = G__51123;
continue;
} else {
var child_51125 = cljs.core.first(seq__50498_51118__$1);
if(cljs.core.truth_(child_51125)){
node.appendChild(child_51125);


var G__51126 = cljs.core.next(seq__50498_51118__$1);
var G__51127 = null;
var G__51128 = (0);
var G__51129 = (0);
seq__50498_51103 = G__51126;
chunk__50500_51104 = G__51127;
count__50501_51105 = G__51128;
i__50502_51106 = G__51129;
continue;
} else {
var G__51130 = cljs.core.next(seq__50498_51118__$1);
var G__51131 = null;
var G__51132 = (0);
var G__51133 = (0);
seq__50498_51103 = G__51130;
chunk__50500_51104 = G__51131;
count__50501_51105 = G__51132;
i__50502_51106 = G__51133;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_51101);
}
}


var G__51134 = cljs.core.next(seq__50435_51091__$1);
var G__51135 = null;
var G__51136 = (0);
var G__51137 = (0);
seq__50435_51035 = G__51134;
chunk__50437_51036 = G__51135;
count__50438_51037 = G__51136;
i__50439_51038 = G__51137;
continue;
} else {
var G__51138 = cljs.core.next(seq__50435_51091__$1);
var G__51139 = null;
var G__51140 = (0);
var G__51141 = (0);
seq__50435_51035 = G__51138;
chunk__50437_51036 = G__51139;
count__50438_51037 = G__51140;
i__50439_51038 = G__51141;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___51144 = arguments.length;
var i__5727__auto___51145 = (0);
while(true){
if((i__5727__auto___51145 < len__5726__auto___51144)){
args__5732__auto__.push((arguments[i__5727__auto___51145]));

var G__51146 = (i__5727__auto___51145 + (1));
i__5727__auto___51145 = G__51146;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq50518){
var G__50519 = cljs.core.first(seq50518);
var seq50518__$1 = cljs.core.next(seq50518);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__50519,seq50518__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
