;;   Copyright (c) 7theta. All rights reserved.
;;   The use and distribution terms for this software are covered by the
;;   MIT License (https://opensource.org/licenses/MIT) which can also be
;;   found in the LICENSE file at the root of this distribution.
;;
;;   By using this software in any fashion, you are agreeing to be bound by
;;   the terms of this license.
;;   You must not remove this notice, or any others, from this software.

(ns vectio.core
  (:require [vectio.http :as http]
            [helix.core :refer [defnc $]]
            [helix.dom :refer [div button]]
            ["react-dom/client" :refer [createRoot]]
            [fluxus.flow :as f]
            [fluxus.promise :as p]
            [utilis.js :as j]))

(f/set-default-on-error! (fn [& args] (js/console.error [:fluxus.flow/error args])))

(def connection (atom nil))

(defn connect
  []
  (let [address (http/websocket-origin "/ws")]
    (-> (http/websocket-client {:address address
                                :on-close (fn [e]
                                            (js/console.warn [:ws :close e]))
                                :on-error (fn [e]
                                            (js/console.warn [:ws :error e]))})
        (p/then
          (fn [flow]
            (reset! connection flow)
            (js/console.warn [:ws :connect flow])
            (f/on-close flow
                        (fn [_]
                          (js/console.warn [:ws :closed flow])))
            (f/consume (fn [m]
                         (js/console.warn [:ws :< m]))
                       flow)
            (-> (f/put! flow "client-handshake")
                (p/then (fn [v] (js/console.warn [:ws :connect :put v]))))))
        (p/catch
          (fn [e]
            (js/console.error [:ws :error-p] e))))))

(connect)

(defnc root-panel
  []
  (div
   {:style {:margin "20px"}}
   (button
    {:on-click
     (fn []
       (js/console.warn [:ws :send])
       (-> (f/put! @connection "client-message")
           (p/then
             (fn [v]
               (js/console.warn [:ws :send v])))
           (p/catch
             (fn [v]
               (js/console.warn [:ws :send v])))))
     :style {:margin-left "20px"}}
    "SEND")))

(defn ^:export init
  []
  (enable-console-print!)
  (j/call (createRoot (js/document.getElementById "app"))
          :render ($ root-panel)))
