goog.provide('shadow.dom');
shadow.dom.transition_supported_QMARK_ = true;

/**
 * @interface
 */
shadow.dom.IElement = function(){};

var shadow$dom$IElement$_to_dom$dyn_47982 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_dom[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_dom["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("IElement.-to-dom",this$);
}
}
});
shadow.dom._to_dom = (function shadow$dom$_to_dom(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$IElement$_to_dom$arity$1 == null)))))){
return this$.shadow$dom$IElement$_to_dom$arity$1(this$);
} else {
return shadow$dom$IElement$_to_dom$dyn_47982(this$);
}
});


/**
 * @interface
 */
shadow.dom.SVGElement = function(){};

var shadow$dom$SVGElement$_to_svg$dyn_47984 = (function (this$){
var x__5350__auto__ = (((this$ == null))?null:this$);
var m__5351__auto__ = (shadow.dom._to_svg[goog.typeOf(x__5350__auto__)]);
if((!((m__5351__auto__ == null)))){
return (m__5351__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5351__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5351__auto__.call(null, this$));
} else {
var m__5349__auto__ = (shadow.dom._to_svg["_"]);
if((!((m__5349__auto__ == null)))){
return (m__5349__auto__.cljs$core$IFn$_invoke$arity$1 ? m__5349__auto__.cljs$core$IFn$_invoke$arity$1(this$) : m__5349__auto__.call(null, this$));
} else {
throw cljs.core.missing_protocol("SVGElement.-to-svg",this$);
}
}
});
shadow.dom._to_svg = (function shadow$dom$_to_svg(this$){
if((((!((this$ == null)))) && ((!((this$.shadow$dom$SVGElement$_to_svg$arity$1 == null)))))){
return this$.shadow$dom$SVGElement$_to_svg$arity$1(this$);
} else {
return shadow$dom$SVGElement$_to_svg$dyn_47984(this$);
}
});

shadow.dom.lazy_native_coll_seq = (function shadow$dom$lazy_native_coll_seq(coll,idx){
if((idx < coll.length)){
return (new cljs.core.LazySeq(null,(function (){
return cljs.core.cons((coll[idx]),(function (){var G__46527 = coll;
var G__46528 = (idx + (1));
return (shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2 ? shadow.dom.lazy_native_coll_seq.cljs$core$IFn$_invoke$arity$2(G__46527,G__46528) : shadow.dom.lazy_native_coll_seq.call(null, G__46527,G__46528));
})());
}),null,null));
} else {
return null;
}
});

/**
* @constructor
 * @implements {cljs.core.IIndexed}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IDeref}
 * @implements {shadow.dom.IElement}
*/
shadow.dom.NativeColl = (function (coll){
this.coll = coll;
this.cljs$lang$protocol_mask$partition0$ = 8421394;
this.cljs$lang$protocol_mask$partition1$ = 0;
});
(shadow.dom.NativeColl.prototype.cljs$core$IDeref$_deref$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$2 = (function (this$,n){
var self__ = this;
var this$__$1 = this;
return (self__.coll[n]);
}));

(shadow.dom.NativeColl.prototype.cljs$core$IIndexed$_nth$arity$3 = (function (this$,n,not_found){
var self__ = this;
var this$__$1 = this;
var or__5002__auto__ = (self__.coll[n]);
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return not_found;
}
}));

(shadow.dom.NativeColl.prototype.cljs$core$ICounted$_count$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll.length;
}));

(shadow.dom.NativeColl.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return shadow.dom.lazy_native_coll_seq(self__.coll,(0));
}));

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(shadow.dom.NativeColl.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var self__ = this;
var this$__$1 = this;
return self__.coll;
}));

(shadow.dom.NativeColl.getBasis = (function (){
return new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"coll","coll",-1006698606,null)], null);
}));

(shadow.dom.NativeColl.cljs$lang$type = true);

(shadow.dom.NativeColl.cljs$lang$ctorStr = "shadow.dom/NativeColl");

(shadow.dom.NativeColl.cljs$lang$ctorPrWriter = (function (this__5287__auto__,writer__5288__auto__,opt__5289__auto__){
return cljs.core._write(writer__5288__auto__,"shadow.dom/NativeColl");
}));

/**
 * Positional factory function for shadow.dom/NativeColl.
 */
shadow.dom.__GT_NativeColl = (function shadow$dom$__GT_NativeColl(coll){
return (new shadow.dom.NativeColl(coll));
});

shadow.dom.native_coll = (function shadow$dom$native_coll(coll){
return (new shadow.dom.NativeColl(coll));
});
shadow.dom.dom_node = (function shadow$dom$dom_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$IElement$))))?true:false):false)){
return el.shadow$dom$IElement$_to_dom$arity$1(null, );
} else {
if(typeof el === 'string'){
return document.createTextNode(el);
} else {
if(typeof el === 'number'){
return document.createTextNode(cljs.core.str.cljs$core$IFn$_invoke$arity$1(el));
} else {
return el;

}
}
}
}
});
shadow.dom.query_one = (function shadow$dom$query_one(var_args){
var G__46569 = arguments.length;
switch (G__46569) {
case 1:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return document.querySelector(sel);
}));

(shadow.dom.query_one.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return shadow.dom.dom_node(root).querySelector(sel);
}));

(shadow.dom.query_one.cljs$lang$maxFixedArity = 2);

shadow.dom.query = (function shadow$dom$query(var_args){
var G__46582 = arguments.length;
switch (G__46582) {
case 1:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.query.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.query.cljs$core$IFn$_invoke$arity$1 = (function (sel){
return (new shadow.dom.NativeColl(document.querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$core$IFn$_invoke$arity$2 = (function (sel,root){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(root).querySelectorAll(sel)));
}));

(shadow.dom.query.cljs$lang$maxFixedArity = 2);

shadow.dom.by_id = (function shadow$dom$by_id(var_args){
var G__46584 = arguments.length;
switch (G__46584) {
case 2:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$2 = (function (id,el){
return shadow.dom.dom_node(el).getElementById(id);
}));

(shadow.dom.by_id.cljs$core$IFn$_invoke$arity$1 = (function (id){
return document.getElementById(id);
}));

(shadow.dom.by_id.cljs$lang$maxFixedArity = 2);

shadow.dom.build = shadow.dom.dom_node;
shadow.dom.ev_stop = (function shadow$dom$ev_stop(var_args){
var G__46598 = arguments.length;
switch (G__46598) {
case 1:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 4:
return shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1 = (function (e){
if(cljs.core.truth_(e.stopPropagation)){
e.stopPropagation();

e.preventDefault();
} else {
(e.cancelBubble = true);

(e.returnValue = false);
}

return e;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$2 = (function (e,el){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$4 = (function (e,el,scope,owner){
shadow.dom.ev_stop.cljs$core$IFn$_invoke$arity$1(e);

return el;
}));

(shadow.dom.ev_stop.cljs$lang$maxFixedArity = 4);

/**
 * check wether a parent node (or the document) contains the child
 */
shadow.dom.contains_QMARK_ = (function shadow$dom$contains_QMARK_(var_args){
var G__46609 = arguments.length;
switch (G__46609) {
case 1:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$1 = (function (el){
return goog.dom.contains(document,shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$core$IFn$_invoke$arity$2 = (function (parent,el){
return goog.dom.contains(shadow.dom.dom_node(parent),shadow.dom.dom_node(el));
}));

(shadow.dom.contains_QMARK_.cljs$lang$maxFixedArity = 2);

shadow.dom.add_class = (function shadow$dom$add_class(el,cls){
return goog.dom.classlist.add(shadow.dom.dom_node(el),cls);
});
shadow.dom.remove_class = (function shadow$dom$remove_class(el,cls){
return goog.dom.classlist.remove(shadow.dom.dom_node(el),cls);
});
shadow.dom.toggle_class = (function shadow$dom$toggle_class(var_args){
var G__46616 = arguments.length;
switch (G__46616) {
case 2:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$2 = (function (el,cls){
return goog.dom.classlist.toggle(shadow.dom.dom_node(el),cls);
}));

(shadow.dom.toggle_class.cljs$core$IFn$_invoke$arity$3 = (function (el,cls,v){
if(cljs.core.truth_(v)){
return shadow.dom.add_class(el,cls);
} else {
return shadow.dom.remove_class(el,cls);
}
}));

(shadow.dom.toggle_class.cljs$lang$maxFixedArity = 3);

shadow.dom.dom_listen = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.addEventListener;
}
})())?(function shadow$dom$dom_listen_good(el,ev,handler){
return el.addEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_ie(el,ev,handler){
try{return el.attachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),(function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
}));
}catch (e46626){if((e46626 instanceof Object)){
var e = e46626;
return console.log("didnt support attachEvent",el,e);
} else {
throw e46626;

}
}}));
shadow.dom.dom_listen_remove = (cljs.core.truth_((function (){var or__5002__auto__ = (!((typeof document !== 'undefined')));
if(or__5002__auto__){
return or__5002__auto__;
} else {
return document.removeEventListener;
}
})())?(function shadow$dom$dom_listen_remove_good(el,ev,handler){
return el.removeEventListener(ev,handler,false);
}):(function shadow$dom$dom_listen_remove_ie(el,ev,handler){
return el.detachEvent(["on",cljs.core.str.cljs$core$IFn$_invoke$arity$1(ev)].join(''),handler);
}));
shadow.dom.on_query = (function shadow$dom$on_query(root_el,ev,selector,handler){
var seq__46630 = cljs.core.seq(shadow.dom.query.cljs$core$IFn$_invoke$arity$2(selector,root_el));
var chunk__46631 = null;
var count__46632 = (0);
var i__46633 = (0);
while(true){
if((i__46633 < count__46632)){
var el = chunk__46631.cljs$core$IIndexed$_nth$arity$2(null, i__46633);
var handler_48028__$1 = ((function (seq__46630,chunk__46631,count__46632,i__46633,el){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__46630,chunk__46631,count__46632,i__46633,el))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48028__$1);


var G__48030 = seq__46630;
var G__48031 = chunk__46631;
var G__48032 = count__46632;
var G__48033 = (i__46633 + (1));
seq__46630 = G__48030;
chunk__46631 = G__48031;
count__46632 = G__48032;
i__46633 = G__48033;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__46630);
if(temp__5823__auto__){
var seq__46630__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46630__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__46630__$1);
var G__48035 = cljs.core.chunk_rest(seq__46630__$1);
var G__48036 = c__5525__auto__;
var G__48037 = cljs.core.count(c__5525__auto__);
var G__48038 = (0);
seq__46630 = G__48035;
chunk__46631 = G__48036;
count__46632 = G__48037;
i__46633 = G__48038;
continue;
} else {
var el = cljs.core.first(seq__46630__$1);
var handler_48039__$1 = ((function (seq__46630,chunk__46631,count__46632,i__46633,el,seq__46630__$1,temp__5823__auto__){
return (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});})(seq__46630,chunk__46631,count__46632,i__46633,el,seq__46630__$1,temp__5823__auto__))
;
shadow.dom.dom_listen(el,cljs.core.name(ev),handler_48039__$1);


var G__48040 = cljs.core.next(seq__46630__$1);
var G__48041 = null;
var G__48042 = (0);
var G__48043 = (0);
seq__46630 = G__48040;
chunk__46631 = G__48041;
count__46632 = G__48042;
i__46633 = G__48043;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.on = (function shadow$dom$on(var_args){
var G__46694 = arguments.length;
switch (G__46694) {
case 3:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
case 4:
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4((arguments[(0)]),(arguments[(1)]),(arguments[(2)]),(arguments[(3)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.on.cljs$core$IFn$_invoke$arity$3 = (function (el,ev,handler){
return shadow.dom.on.cljs$core$IFn$_invoke$arity$4(el,ev,handler,false);
}));

(shadow.dom.on.cljs$core$IFn$_invoke$arity$4 = (function (el,ev,handler,capture){
if(cljs.core.vector_QMARK_(ev)){
return shadow.dom.on_query(el,cljs.core.first(ev),cljs.core.second(ev),handler);
} else {
var handler__$1 = (function (e){
return (handler.cljs$core$IFn$_invoke$arity$2 ? handler.cljs$core$IFn$_invoke$arity$2(e,el) : handler.call(null, e,el));
});
return shadow.dom.dom_listen(shadow.dom.dom_node(el),cljs.core.name(ev),handler__$1);
}
}));

(shadow.dom.on.cljs$lang$maxFixedArity = 4);

shadow.dom.remove_event_handler = (function shadow$dom$remove_event_handler(el,ev,handler){
return shadow.dom.dom_listen_remove(shadow.dom.dom_node(el),cljs.core.name(ev),handler);
});
shadow.dom.add_event_listeners = (function shadow$dom$add_event_listeners(el,events){
var seq__46704 = cljs.core.seq(events);
var chunk__46705 = null;
var count__46706 = (0);
var i__46707 = (0);
while(true){
if((i__46707 < count__46706)){
var vec__46725 = chunk__46705.cljs$core$IIndexed$_nth$arity$2(null, i__46707);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46725,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46725,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48047 = seq__46704;
var G__48048 = chunk__46705;
var G__48049 = count__46706;
var G__48050 = (i__46707 + (1));
seq__46704 = G__48047;
chunk__46705 = G__48048;
count__46706 = G__48049;
i__46707 = G__48050;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__46704);
if(temp__5823__auto__){
var seq__46704__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46704__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__46704__$1);
var G__48052 = cljs.core.chunk_rest(seq__46704__$1);
var G__48053 = c__5525__auto__;
var G__48054 = cljs.core.count(c__5525__auto__);
var G__48055 = (0);
seq__46704 = G__48052;
chunk__46705 = G__48053;
count__46706 = G__48054;
i__46707 = G__48055;
continue;
} else {
var vec__46734 = cljs.core.first(seq__46704__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46734,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46734,(1),null);
shadow.dom.on.cljs$core$IFn$_invoke$arity$3(el,k,v);


var G__48057 = cljs.core.next(seq__46704__$1);
var G__48058 = null;
var G__48059 = (0);
var G__48060 = (0);
seq__46704 = G__48057;
chunk__46705 = G__48058;
count__46706 = G__48059;
i__46707 = G__48060;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_style = (function shadow$dom$set_style(el,styles){
var dom = shadow.dom.dom_node(el);
var seq__46741 = cljs.core.seq(styles);
var chunk__46742 = null;
var count__46743 = (0);
var i__46744 = (0);
while(true){
if((i__46744 < count__46743)){
var vec__46760 = chunk__46742.cljs$core$IIndexed$_nth$arity$2(null, i__46744);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46760,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46760,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48064 = seq__46741;
var G__48065 = chunk__46742;
var G__48066 = count__46743;
var G__48067 = (i__46744 + (1));
seq__46741 = G__48064;
chunk__46742 = G__48065;
count__46743 = G__48066;
i__46744 = G__48067;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__46741);
if(temp__5823__auto__){
var seq__46741__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46741__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__46741__$1);
var G__48070 = cljs.core.chunk_rest(seq__46741__$1);
var G__48071 = c__5525__auto__;
var G__48072 = cljs.core.count(c__5525__auto__);
var G__48073 = (0);
seq__46741 = G__48070;
chunk__46742 = G__48071;
count__46743 = G__48072;
i__46744 = G__48073;
continue;
} else {
var vec__46771 = cljs.core.first(seq__46741__$1);
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46771,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46771,(1),null);
goog.style.setStyle(dom,cljs.core.name(k),(((v == null))?"":v));


var G__48075 = cljs.core.next(seq__46741__$1);
var G__48076 = null;
var G__48077 = (0);
var G__48078 = (0);
seq__46741 = G__48075;
chunk__46742 = G__48076;
count__46743 = G__48077;
i__46744 = G__48078;
continue;
}
} else {
return null;
}
}
break;
}
});
shadow.dom.set_attr_STAR_ = (function shadow$dom$set_attr_STAR_(el,key,value){
var G__46785_48079 = key;
var G__46785_48080__$1 = (((G__46785_48079 instanceof cljs.core.Keyword))?G__46785_48079.fqn:null);
switch (G__46785_48080__$1) {
case "id":
(el.id = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "class":
(el.className = cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));

break;
case "for":
(el.htmlFor = value);

break;
case "cellpadding":
el.setAttribute("cellPadding",value);

break;
case "cellspacing":
el.setAttribute("cellSpacing",value);

break;
case "colspan":
el.setAttribute("colSpan",value);

break;
case "frameborder":
el.setAttribute("frameBorder",value);

break;
case "height":
el.setAttribute("height",value);

break;
case "maxlength":
el.setAttribute("maxLength",value);

break;
case "role":
el.setAttribute("role",value);

break;
case "rowspan":
el.setAttribute("rowSpan",value);

break;
case "type":
el.setAttribute("type",value);

break;
case "usemap":
el.setAttribute("useMap",value);

break;
case "valign":
el.setAttribute("vAlign",value);

break;
case "width":
el.setAttribute("width",value);

break;
case "on":
shadow.dom.add_event_listeners(el,value);

break;
case "style":
if((value == null)){
} else {
if(typeof value === 'string'){
el.setAttribute("style",value);
} else {
if(cljs.core.map_QMARK_(value)){
shadow.dom.set_style(el,value);
} else {
goog.style.setStyle(el,value);

}
}
}

break;
default:
var ks_48087 = cljs.core.name(key);
if(cljs.core.truth_((function (){var or__5002__auto__ = goog.string.startsWith(ks_48087,"data-");
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return goog.string.startsWith(ks_48087,"aria-");
}
})())){
el.setAttribute(ks_48087,value);
} else {
(el[ks_48087] = value);
}

}

return el;
});
shadow.dom.set_attrs = (function shadow$dom$set_attrs(el,attrs){
return cljs.core.reduce_kv((function (el__$1,key,value){
shadow.dom.set_attr_STAR_(el__$1,key,value);

return el__$1;
}),shadow.dom.dom_node(el),attrs);
});
shadow.dom.set_attr = (function shadow$dom$set_attr(el,key,value){
return shadow.dom.set_attr_STAR_(shadow.dom.dom_node(el),key,value);
});
shadow.dom.has_class_QMARK_ = (function shadow$dom$has_class_QMARK_(el,cls){
return goog.dom.classlist.contains(shadow.dom.dom_node(el),cls);
});
shadow.dom.merge_class_string = (function shadow$dom$merge_class_string(current,extra_class){
if(cljs.core.seq(current)){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(current)," ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(extra_class)].join('');
} else {
return extra_class;
}
});
shadow.dom.parse_tag = (function shadow$dom$parse_tag(spec){
var spec__$1 = cljs.core.name(spec);
var fdot = spec__$1.indexOf(".");
var fhash = spec__$1.indexOf("#");
if(((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)))){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1,null,null], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fhash)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fdot),null,clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);
} else {
if(cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2((-1),fdot)){
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1))),null], null);
} else {
if((fhash > fdot)){
throw ["cant have id after class?",spec__$1].join('');
} else {
return new cljs.core.PersistentVector(null, 3, 5, cljs.core.PersistentVector.EMPTY_NODE, [spec__$1.substring((0),fhash),spec__$1.substring((fhash + (1)),fdot),clojure.string.replace(spec__$1.substring((fdot + (1))),/\./," ")], null);

}
}
}
}
});
shadow.dom.create_dom_node = (function shadow$dom$create_dom_node(tag_def,p__46802){
var map__46803 = p__46802;
var map__46803__$1 = cljs.core.__destructure_map(map__46803);
var props = map__46803__$1;
var class$ = cljs.core.get.cljs$core$IFn$_invoke$arity$2(map__46803__$1,new cljs.core.Keyword(null,"class","class",-2030961996));
var tag_props = ({});
var vec__46807 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46807,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46807,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46807,(2),null);
if(cljs.core.truth_(tag_id)){
(tag_props["id"] = tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
(tag_props["class"] = shadow.dom.merge_class_string(class$,tag_classes));
} else {
}

var G__46812 = goog.dom.createDom(tag_name,tag_props);
shadow.dom.set_attrs(G__46812,cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(props,new cljs.core.Keyword(null,"class","class",-2030961996)));

return G__46812;
});
shadow.dom.append = (function shadow$dom$append(var_args){
var G__46815 = arguments.length;
switch (G__46815) {
case 1:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.append.cljs$core$IFn$_invoke$arity$1 = (function (node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
document.body.appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$core$IFn$_invoke$arity$2 = (function (el,node){
if(cljs.core.truth_(node)){
var temp__5823__auto__ = shadow.dom.dom_node(node);
if(cljs.core.truth_(temp__5823__auto__)){
var n = temp__5823__auto__;
shadow.dom.dom_node(el).appendChild(n);

return n;
} else {
return null;
}
} else {
return null;
}
}));

(shadow.dom.append.cljs$lang$maxFixedArity = 2);

shadow.dom.destructure_node = (function shadow$dom$destructure_node(create_fn,p__46827){
var vec__46835 = p__46827;
var seq__46836 = cljs.core.seq(vec__46835);
var first__46837 = cljs.core.first(seq__46836);
var seq__46836__$1 = cljs.core.next(seq__46836);
var nn = first__46837;
var first__46837__$1 = cljs.core.first(seq__46836__$1);
var seq__46836__$2 = cljs.core.next(seq__46836__$1);
var np = first__46837__$1;
var nc = seq__46836__$2;
var node = vec__46835;
if((nn instanceof cljs.core.Keyword)){
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("invalid dom node",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"node","node",581201198),node], null));
}

if((((np == null)) && ((nc == null)))){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46855 = nn;
var G__46856 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46855,G__46856) : create_fn.call(null, G__46855,G__46856));
})(),cljs.core.List.EMPTY], null);
} else {
if(cljs.core.map_QMARK_(np)){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(nn,np) : create_fn.call(null, nn,np)),nc], null);
} else {
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(function (){var G__46863 = nn;
var G__46864 = cljs.core.PersistentArrayMap.EMPTY;
return (create_fn.cljs$core$IFn$_invoke$arity$2 ? create_fn.cljs$core$IFn$_invoke$arity$2(G__46863,G__46864) : create_fn.call(null, G__46863,G__46864));
})(),cljs.core.conj.cljs$core$IFn$_invoke$arity$2(nc,np)], null);

}
}
});
shadow.dom.make_dom_node = (function shadow$dom$make_dom_node(structure){
var vec__46870 = shadow.dom.destructure_node(shadow.dom.create_dom_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46870,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__46870,(1),null);
var seq__46874_48111 = cljs.core.seq(node_children);
var chunk__46875_48112 = null;
var count__46876_48113 = (0);
var i__46877_48114 = (0);
while(true){
if((i__46877_48114 < count__46876_48113)){
var child_struct_48115 = chunk__46875_48112.cljs$core$IIndexed$_nth$arity$2(null, i__46877_48114);
var children_48116 = shadow.dom.dom_node(child_struct_48115);
if(cljs.core.seq_QMARK_(children_48116)){
var seq__46937_48118 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48116));
var chunk__46939_48119 = null;
var count__46940_48120 = (0);
var i__46941_48121 = (0);
while(true){
if((i__46941_48121 < count__46940_48120)){
var child_48122 = chunk__46939_48119.cljs$core$IIndexed$_nth$arity$2(null, i__46941_48121);
if(cljs.core.truth_(child_48122)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48122);


var G__48123 = seq__46937_48118;
var G__48124 = chunk__46939_48119;
var G__48125 = count__46940_48120;
var G__48126 = (i__46941_48121 + (1));
seq__46937_48118 = G__48123;
chunk__46939_48119 = G__48124;
count__46940_48120 = G__48125;
i__46941_48121 = G__48126;
continue;
} else {
var G__48127 = seq__46937_48118;
var G__48128 = chunk__46939_48119;
var G__48129 = count__46940_48120;
var G__48130 = (i__46941_48121 + (1));
seq__46937_48118 = G__48127;
chunk__46939_48119 = G__48128;
count__46940_48120 = G__48129;
i__46941_48121 = G__48130;
continue;
}
} else {
var temp__5823__auto___48131 = cljs.core.seq(seq__46937_48118);
if(temp__5823__auto___48131){
var seq__46937_48132__$1 = temp__5823__auto___48131;
if(cljs.core.chunked_seq_QMARK_(seq__46937_48132__$1)){
var c__5525__auto___48133 = cljs.core.chunk_first(seq__46937_48132__$1);
var G__48134 = cljs.core.chunk_rest(seq__46937_48132__$1);
var G__48135 = c__5525__auto___48133;
var G__48136 = cljs.core.count(c__5525__auto___48133);
var G__48137 = (0);
seq__46937_48118 = G__48134;
chunk__46939_48119 = G__48135;
count__46940_48120 = G__48136;
i__46941_48121 = G__48137;
continue;
} else {
var child_48139 = cljs.core.first(seq__46937_48132__$1);
if(cljs.core.truth_(child_48139)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48139);


var G__48140 = cljs.core.next(seq__46937_48132__$1);
var G__48141 = null;
var G__48142 = (0);
var G__48143 = (0);
seq__46937_48118 = G__48140;
chunk__46939_48119 = G__48141;
count__46940_48120 = G__48142;
i__46941_48121 = G__48143;
continue;
} else {
var G__48145 = cljs.core.next(seq__46937_48132__$1);
var G__48146 = null;
var G__48147 = (0);
var G__48148 = (0);
seq__46937_48118 = G__48145;
chunk__46939_48119 = G__48146;
count__46940_48120 = G__48147;
i__46941_48121 = G__48148;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48116);
}


var G__48149 = seq__46874_48111;
var G__48150 = chunk__46875_48112;
var G__48151 = count__46876_48113;
var G__48152 = (i__46877_48114 + (1));
seq__46874_48111 = G__48149;
chunk__46875_48112 = G__48150;
count__46876_48113 = G__48151;
i__46877_48114 = G__48152;
continue;
} else {
var temp__5823__auto___48154 = cljs.core.seq(seq__46874_48111);
if(temp__5823__auto___48154){
var seq__46874_48155__$1 = temp__5823__auto___48154;
if(cljs.core.chunked_seq_QMARK_(seq__46874_48155__$1)){
var c__5525__auto___48156 = cljs.core.chunk_first(seq__46874_48155__$1);
var G__48158 = cljs.core.chunk_rest(seq__46874_48155__$1);
var G__48159 = c__5525__auto___48156;
var G__48160 = cljs.core.count(c__5525__auto___48156);
var G__48161 = (0);
seq__46874_48111 = G__48158;
chunk__46875_48112 = G__48159;
count__46876_48113 = G__48160;
i__46877_48114 = G__48161;
continue;
} else {
var child_struct_48162 = cljs.core.first(seq__46874_48155__$1);
var children_48163 = shadow.dom.dom_node(child_struct_48162);
if(cljs.core.seq_QMARK_(children_48163)){
var seq__46974_48165 = cljs.core.seq(cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom.dom_node,children_48163));
var chunk__46976_48166 = null;
var count__46977_48168 = (0);
var i__46978_48169 = (0);
while(true){
if((i__46978_48169 < count__46977_48168)){
var child_48170 = chunk__46976_48166.cljs$core$IIndexed$_nth$arity$2(null, i__46978_48169);
if(cljs.core.truth_(child_48170)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48170);


var G__48171 = seq__46974_48165;
var G__48172 = chunk__46976_48166;
var G__48173 = count__46977_48168;
var G__48174 = (i__46978_48169 + (1));
seq__46974_48165 = G__48171;
chunk__46976_48166 = G__48172;
count__46977_48168 = G__48173;
i__46978_48169 = G__48174;
continue;
} else {
var G__48175 = seq__46974_48165;
var G__48176 = chunk__46976_48166;
var G__48177 = count__46977_48168;
var G__48178 = (i__46978_48169 + (1));
seq__46974_48165 = G__48175;
chunk__46976_48166 = G__48176;
count__46977_48168 = G__48177;
i__46978_48169 = G__48178;
continue;
}
} else {
var temp__5823__auto___48179__$1 = cljs.core.seq(seq__46974_48165);
if(temp__5823__auto___48179__$1){
var seq__46974_48180__$1 = temp__5823__auto___48179__$1;
if(cljs.core.chunked_seq_QMARK_(seq__46974_48180__$1)){
var c__5525__auto___48181 = cljs.core.chunk_first(seq__46974_48180__$1);
var G__48182 = cljs.core.chunk_rest(seq__46974_48180__$1);
var G__48183 = c__5525__auto___48181;
var G__48184 = cljs.core.count(c__5525__auto___48181);
var G__48185 = (0);
seq__46974_48165 = G__48182;
chunk__46976_48166 = G__48183;
count__46977_48168 = G__48184;
i__46978_48169 = G__48185;
continue;
} else {
var child_48186 = cljs.core.first(seq__46974_48180__$1);
if(cljs.core.truth_(child_48186)){
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,child_48186);


var G__48188 = cljs.core.next(seq__46974_48180__$1);
var G__48189 = null;
var G__48190 = (0);
var G__48191 = (0);
seq__46974_48165 = G__48188;
chunk__46976_48166 = G__48189;
count__46977_48168 = G__48190;
i__46978_48169 = G__48191;
continue;
} else {
var G__48192 = cljs.core.next(seq__46974_48180__$1);
var G__48193 = null;
var G__48194 = (0);
var G__48195 = (0);
seq__46974_48165 = G__48192;
chunk__46976_48166 = G__48193;
count__46977_48168 = G__48194;
i__46978_48169 = G__48195;
continue;
}
}
} else {
}
}
break;
}
} else {
shadow.dom.append.cljs$core$IFn$_invoke$arity$2(node,children_48163);
}


var G__48199 = cljs.core.next(seq__46874_48155__$1);
var G__48200 = null;
var G__48201 = (0);
var G__48202 = (0);
seq__46874_48111 = G__48199;
chunk__46875_48112 = G__48200;
count__46876_48113 = G__48201;
i__46877_48114 = G__48202;
continue;
}
} else {
}
}
break;
}

return node;
});
(cljs.core.Keyword.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.Keyword.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$__$1], null));
}));

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_dom_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_dom,this$__$1);
}));
if(cljs.core.truth_(((typeof HTMLElement) != 'undefined'))){
(HTMLElement.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(HTMLElement.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
if(cljs.core.truth_(((typeof DocumentFragment) != 'undefined'))){
(DocumentFragment.prototype.shadow$dom$IElement$ = cljs.core.PROTOCOL_SENTINEL);

(DocumentFragment.prototype.shadow$dom$IElement$_to_dom$arity$1 = (function (this$){
var this$__$1 = this;
return this$__$1;
}));
} else {
}
/**
 * clear node children
 */
shadow.dom.reset = (function shadow$dom$reset(node){
return goog.dom.removeChildren(shadow.dom.dom_node(node));
});
shadow.dom.remove = (function shadow$dom$remove(node){
if((((!((node == null))))?(((((node.cljs$lang$protocol_mask$partition0$ & (8388608))) || ((cljs.core.PROTOCOL_SENTINEL === node.cljs$core$ISeqable$))))?true:false):false)){
var seq__46994 = cljs.core.seq(node);
var chunk__46995 = null;
var count__46996 = (0);
var i__46997 = (0);
while(true){
if((i__46997 < count__46996)){
var n = chunk__46995.cljs$core$IIndexed$_nth$arity$2(null, i__46997);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__48209 = seq__46994;
var G__48210 = chunk__46995;
var G__48211 = count__46996;
var G__48212 = (i__46997 + (1));
seq__46994 = G__48209;
chunk__46995 = G__48210;
count__46996 = G__48211;
i__46997 = G__48212;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__46994);
if(temp__5823__auto__){
var seq__46994__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__46994__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__46994__$1);
var G__48214 = cljs.core.chunk_rest(seq__46994__$1);
var G__48215 = c__5525__auto__;
var G__48216 = cljs.core.count(c__5525__auto__);
var G__48217 = (0);
seq__46994 = G__48214;
chunk__46995 = G__48215;
count__46996 = G__48216;
i__46997 = G__48217;
continue;
} else {
var n = cljs.core.first(seq__46994__$1);
(shadow.dom.remove.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.remove.cljs$core$IFn$_invoke$arity$1(n) : shadow.dom.remove.call(null, n));


var G__48219 = cljs.core.next(seq__46994__$1);
var G__48220 = null;
var G__48221 = (0);
var G__48222 = (0);
seq__46994 = G__48219;
chunk__46995 = G__48220;
count__46996 = G__48221;
i__46997 = G__48222;
continue;
}
} else {
return null;
}
}
break;
}
} else {
return goog.dom.removeNode(node);
}
});
shadow.dom.replace_node = (function shadow$dom$replace_node(old,new$){
return goog.dom.replaceNode(shadow.dom.dom_node(new$),shadow.dom.dom_node(old));
});
shadow.dom.text = (function shadow$dom$text(var_args){
var G__47001 = arguments.length;
switch (G__47001) {
case 2:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 1:
return shadow.dom.text.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.text.cljs$core$IFn$_invoke$arity$2 = (function (el,new_text){
return (shadow.dom.dom_node(el).innerText = new_text);
}));

(shadow.dom.text.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.dom_node(el).innerText;
}));

(shadow.dom.text.cljs$lang$maxFixedArity = 2);

shadow.dom.check = (function shadow$dom$check(var_args){
var G__47006 = arguments.length;
switch (G__47006) {
case 1:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.check.cljs$core$IFn$_invoke$arity$1 = (function (el){
return shadow.dom.check.cljs$core$IFn$_invoke$arity$2(el,true);
}));

(shadow.dom.check.cljs$core$IFn$_invoke$arity$2 = (function (el,checked){
return (shadow.dom.dom_node(el).checked = checked);
}));

(shadow.dom.check.cljs$lang$maxFixedArity = 2);

shadow.dom.checked_QMARK_ = (function shadow$dom$checked_QMARK_(el){
return shadow.dom.dom_node(el).checked;
});
shadow.dom.form_elements = (function shadow$dom$form_elements(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).elements));
});
shadow.dom.children = (function shadow$dom$children(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).children));
});
shadow.dom.child_nodes = (function shadow$dom$child_nodes(el){
return (new shadow.dom.NativeColl(shadow.dom.dom_node(el).childNodes));
});
shadow.dom.attr = (function shadow$dom$attr(var_args){
var G__47029 = arguments.length;
switch (G__47029) {
case 2:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.attr.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$2 = (function (el,key){
return shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
}));

(shadow.dom.attr.cljs$core$IFn$_invoke$arity$3 = (function (el,key,default$){
var or__5002__auto__ = shadow.dom.dom_node(el).getAttribute(cljs.core.name(key));
if(cljs.core.truth_(or__5002__auto__)){
return or__5002__auto__;
} else {
return default$;
}
}));

(shadow.dom.attr.cljs$lang$maxFixedArity = 3);

shadow.dom.del_attr = (function shadow$dom$del_attr(el,key){
return shadow.dom.dom_node(el).removeAttribute(cljs.core.name(key));
});
shadow.dom.data = (function shadow$dom$data(el,key){
return shadow.dom.dom_node(el).getAttribute(["data-",cljs.core.name(key)].join(''));
});
shadow.dom.set_data = (function shadow$dom$set_data(el,key,value){
return shadow.dom.dom_node(el).setAttribute(["data-",cljs.core.name(key)].join(''),cljs.core.str.cljs$core$IFn$_invoke$arity$1(value));
});
shadow.dom.set_html = (function shadow$dom$set_html(node,text){
return (shadow.dom.dom_node(node).innerHTML = text);
});
shadow.dom.get_html = (function shadow$dom$get_html(node){
return shadow.dom.dom_node(node).innerHTML;
});
shadow.dom.fragment = (function shadow$dom$fragment(var_args){
var args__5732__auto__ = [];
var len__5726__auto___48232 = arguments.length;
var i__5727__auto___48233 = (0);
while(true){
if((i__5727__auto___48233 < len__5726__auto___48232)){
args__5732__auto__.push((arguments[i__5727__auto___48233]));

var G__48234 = (i__5727__auto___48233 + (1));
i__5727__auto___48233 = G__48234;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((0) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((0)),(0),null)):null);
return shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic(argseq__5733__auto__);
});

(shadow.dom.fragment.cljs$core$IFn$_invoke$arity$variadic = (function (nodes){
var fragment = document.createDocumentFragment();
var seq__47041_48235 = cljs.core.seq(nodes);
var chunk__47042_48236 = null;
var count__47043_48237 = (0);
var i__47044_48238 = (0);
while(true){
if((i__47044_48238 < count__47043_48237)){
var node_48239 = chunk__47042_48236.cljs$core$IIndexed$_nth$arity$2(null, i__47044_48238);
fragment.appendChild(shadow.dom._to_dom(node_48239));


var G__48240 = seq__47041_48235;
var G__48241 = chunk__47042_48236;
var G__48242 = count__47043_48237;
var G__48243 = (i__47044_48238 + (1));
seq__47041_48235 = G__48240;
chunk__47042_48236 = G__48241;
count__47043_48237 = G__48242;
i__47044_48238 = G__48243;
continue;
} else {
var temp__5823__auto___48244 = cljs.core.seq(seq__47041_48235);
if(temp__5823__auto___48244){
var seq__47041_48245__$1 = temp__5823__auto___48244;
if(cljs.core.chunked_seq_QMARK_(seq__47041_48245__$1)){
var c__5525__auto___48246 = cljs.core.chunk_first(seq__47041_48245__$1);
var G__48247 = cljs.core.chunk_rest(seq__47041_48245__$1);
var G__48248 = c__5525__auto___48246;
var G__48249 = cljs.core.count(c__5525__auto___48246);
var G__48250 = (0);
seq__47041_48235 = G__48247;
chunk__47042_48236 = G__48248;
count__47043_48237 = G__48249;
i__47044_48238 = G__48250;
continue;
} else {
var node_48251 = cljs.core.first(seq__47041_48245__$1);
fragment.appendChild(shadow.dom._to_dom(node_48251));


var G__48252 = cljs.core.next(seq__47041_48245__$1);
var G__48253 = null;
var G__48254 = (0);
var G__48255 = (0);
seq__47041_48235 = G__48252;
chunk__47042_48236 = G__48253;
count__47043_48237 = G__48254;
i__47044_48238 = G__48255;
continue;
}
} else {
}
}
break;
}

return (new shadow.dom.NativeColl(fragment));
}));

(shadow.dom.fragment.cljs$lang$maxFixedArity = (0));

/** @this {Function} */
(shadow.dom.fragment.cljs$lang$applyTo = (function (seq47040){
var self__5712__auto__ = this;
return self__5712__auto__.cljs$core$IFn$_invoke$arity$variadic(cljs.core.seq(seq47040));
}));

/**
 * given a html string, eval all <script> tags and return the html without the scripts
 * don't do this for everything, only content you trust.
 */
shadow.dom.eval_scripts = (function shadow$dom$eval_scripts(s){
var scripts = cljs.core.re_seq(/<script[^>]*?>(.+?)<\/script>/,s);
var seq__47051_48257 = cljs.core.seq(scripts);
var chunk__47052_48258 = null;
var count__47053_48259 = (0);
var i__47054_48260 = (0);
while(true){
if((i__47054_48260 < count__47053_48259)){
var vec__47072_48262 = chunk__47052_48258.cljs$core$IIndexed$_nth$arity$2(null, i__47054_48260);
var script_tag_48263 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47072_48262,(0),null);
var script_body_48264 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47072_48262,(1),null);
eval(script_body_48264);


var G__48266 = seq__47051_48257;
var G__48267 = chunk__47052_48258;
var G__48268 = count__47053_48259;
var G__48269 = (i__47054_48260 + (1));
seq__47051_48257 = G__48266;
chunk__47052_48258 = G__48267;
count__47053_48259 = G__48268;
i__47054_48260 = G__48269;
continue;
} else {
var temp__5823__auto___48270 = cljs.core.seq(seq__47051_48257);
if(temp__5823__auto___48270){
var seq__47051_48271__$1 = temp__5823__auto___48270;
if(cljs.core.chunked_seq_QMARK_(seq__47051_48271__$1)){
var c__5525__auto___48273 = cljs.core.chunk_first(seq__47051_48271__$1);
var G__48274 = cljs.core.chunk_rest(seq__47051_48271__$1);
var G__48275 = c__5525__auto___48273;
var G__48276 = cljs.core.count(c__5525__auto___48273);
var G__48277 = (0);
seq__47051_48257 = G__48274;
chunk__47052_48258 = G__48275;
count__47053_48259 = G__48276;
i__47054_48260 = G__48277;
continue;
} else {
var vec__47094_48279 = cljs.core.first(seq__47051_48271__$1);
var script_tag_48280 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47094_48279,(0),null);
var script_body_48281 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47094_48279,(1),null);
eval(script_body_48281);


var G__48283 = cljs.core.next(seq__47051_48271__$1);
var G__48284 = null;
var G__48285 = (0);
var G__48286 = (0);
seq__47051_48257 = G__48283;
chunk__47052_48258 = G__48284;
count__47053_48259 = G__48285;
i__47054_48260 = G__48286;
continue;
}
} else {
}
}
break;
}

return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (s__$1,p__47099){
var vec__47100 = p__47099;
var script_tag = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47100,(0),null);
var script_body = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47100,(1),null);
return clojure.string.replace(s__$1,script_tag,"");
}),s,scripts);
});
shadow.dom.str__GT_fragment = (function shadow$dom$str__GT_fragment(s){
var el = document.createElement("div");
(el.innerHTML = s);

return (new shadow.dom.NativeColl(goog.dom.childrenToNode_(document,el)));
});
shadow.dom.node_name = (function shadow$dom$node_name(el){
return shadow.dom.dom_node(el).nodeName;
});
shadow.dom.ancestor_by_class = (function shadow$dom$ancestor_by_class(el,cls){
return goog.dom.getAncestorByClass(shadow.dom.dom_node(el),cls);
});
shadow.dom.ancestor_by_tag = (function shadow$dom$ancestor_by_tag(var_args){
var G__47105 = arguments.length;
switch (G__47105) {
case 2:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
case 3:
return shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3((arguments[(0)]),(arguments[(1)]),(arguments[(2)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$2 = (function (el,tag){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag));
}));

(shadow.dom.ancestor_by_tag.cljs$core$IFn$_invoke$arity$3 = (function (el,tag,cls){
return goog.dom.getAncestorByTagNameAndClass(shadow.dom.dom_node(el),cljs.core.name(tag),cljs.core.name(cls));
}));

(shadow.dom.ancestor_by_tag.cljs$lang$maxFixedArity = 3);

shadow.dom.get_value = (function shadow$dom$get_value(dom){
return goog.dom.forms.getValue(shadow.dom.dom_node(dom));
});
shadow.dom.set_value = (function shadow$dom$set_value(dom,value){
return goog.dom.forms.setValue(shadow.dom.dom_node(dom),value);
});
shadow.dom.px = (function shadow$dom$px(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1((value | (0))),"px"].join('');
});
shadow.dom.pct = (function shadow$dom$pct(value){
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(value),"%"].join('');
});
shadow.dom.remove_style_STAR_ = (function shadow$dom$remove_style_STAR_(el,style){
return el.style.removeProperty(cljs.core.name(style));
});
shadow.dom.remove_style = (function shadow$dom$remove_style(el,style){
var el__$1 = shadow.dom.dom_node(el);
return shadow.dom.remove_style_STAR_(el__$1,style);
});
shadow.dom.remove_styles = (function shadow$dom$remove_styles(el,style_keys){
var el__$1 = shadow.dom.dom_node(el);
var seq__47120 = cljs.core.seq(style_keys);
var chunk__47121 = null;
var count__47122 = (0);
var i__47123 = (0);
while(true){
if((i__47123 < count__47122)){
var it = chunk__47121.cljs$core$IIndexed$_nth$arity$2(null, i__47123);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48304 = seq__47120;
var G__48305 = chunk__47121;
var G__48306 = count__47122;
var G__48307 = (i__47123 + (1));
seq__47120 = G__48304;
chunk__47121 = G__48305;
count__47122 = G__48306;
i__47123 = G__48307;
continue;
} else {
var temp__5823__auto__ = cljs.core.seq(seq__47120);
if(temp__5823__auto__){
var seq__47120__$1 = temp__5823__auto__;
if(cljs.core.chunked_seq_QMARK_(seq__47120__$1)){
var c__5525__auto__ = cljs.core.chunk_first(seq__47120__$1);
var G__48309 = cljs.core.chunk_rest(seq__47120__$1);
var G__48310 = c__5525__auto__;
var G__48311 = cljs.core.count(c__5525__auto__);
var G__48312 = (0);
seq__47120 = G__48309;
chunk__47121 = G__48310;
count__47122 = G__48311;
i__47123 = G__48312;
continue;
} else {
var it = cljs.core.first(seq__47120__$1);
shadow.dom.remove_style_STAR_(el__$1,it);


var G__48313 = cljs.core.next(seq__47120__$1);
var G__48314 = null;
var G__48315 = (0);
var G__48316 = (0);
seq__47120 = G__48313;
chunk__47121 = G__48314;
count__47122 = G__48315;
i__47123 = G__48316;
continue;
}
} else {
return null;
}
}
break;
}
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Coordinate = (function (x,y,__meta,__extmap,__hash){
this.x = x;
this.y = y;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Coordinate.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k47141,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__47157 = k47141;
var G__47157__$1 = (((G__47157 instanceof cljs.core.Keyword))?G__47157.fqn:null);
switch (G__47157__$1) {
case "x":
return self__.x;

break;
case "y":
return self__.y;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47141,else__5303__auto__);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__47161){
var vec__47162 = p__47161;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47162,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47162,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Coordinate.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Coordinate{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"x","x",2099068185),self__.x],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"y","y",-1757859776),self__.y],null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47140){
var self__ = this;
var G__47140__$1 = this;
return (new cljs.core.RecordIter((0),G__47140__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"x","x",2099068185),new cljs.core.Keyword(null,"y","y",-1757859776)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (145542109 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47142,other47143){
var self__ = this;
var this47142__$1 = this;
return (((!((other47143 == null)))) && ((((this47142__$1.constructor === other47143.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47142__$1.x,other47143.x)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47142__$1.y,other47143.y)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47142__$1.__extmap,other47143.__extmap)))))))));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"y","y",-1757859776),null,new cljs.core.Keyword(null,"x","x",2099068185),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k47141){
var self__ = this;
var this__5307__auto____$1 = this;
var G__47202 = k47141;
var G__47202__$1 = (((G__47202 instanceof cljs.core.Keyword))?G__47202.fqn:null);
switch (G__47202__$1) {
case "x":
case "y":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k47141);

}
}));

(shadow.dom.Coordinate.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__47140){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__47204 = cljs.core.keyword_identical_QMARK_;
var expr__47205 = k__5309__auto__;
if(cljs.core.truth_((pred__47204.cljs$core$IFn$_invoke$arity$2 ? pred__47204.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"x","x",2099068185),expr__47205) : pred__47204.call(null, new cljs.core.Keyword(null,"x","x",2099068185),expr__47205)))){
return (new shadow.dom.Coordinate(G__47140,self__.y,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47204.cljs$core$IFn$_invoke$arity$2 ? pred__47204.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"y","y",-1757859776),expr__47205) : pred__47204.call(null, new cljs.core.Keyword(null,"y","y",-1757859776),expr__47205)))){
return (new shadow.dom.Coordinate(self__.x,G__47140,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Coordinate(self__.x,self__.y,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__47140),null));
}
}
}));

(shadow.dom.Coordinate.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"x","x",2099068185),self__.x,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"y","y",-1757859776),self__.y,null))], null),self__.__extmap));
}));

(shadow.dom.Coordinate.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__47140){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Coordinate(self__.x,self__.y,G__47140,self__.__extmap,self__.__hash));
}));

(shadow.dom.Coordinate.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Coordinate.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"x","x",-555367584,null),new cljs.core.Symbol(null,"y","y",-117328249,null)], null);
}));

(shadow.dom.Coordinate.cljs$lang$type = true);

(shadow.dom.Coordinate.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Coordinate",null,(1),null));
}));

(shadow.dom.Coordinate.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Coordinate");
}));

/**
 * Positional factory function for shadow.dom/Coordinate.
 */
shadow.dom.__GT_Coordinate = (function shadow$dom$__GT_Coordinate(x,y){
return (new shadow.dom.Coordinate(x,y,null,null,null));
});

/**
 * Factory function for shadow.dom/Coordinate, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Coordinate = (function shadow$dom$map__GT_Coordinate(G__47147){
var extmap__5342__auto__ = (function (){var G__47229 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47147,new cljs.core.Keyword(null,"x","x",2099068185),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"y","y",-1757859776)], 0));
if(cljs.core.record_QMARK_(G__47147)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47229);
} else {
return G__47229;
}
})();
return (new shadow.dom.Coordinate(new cljs.core.Keyword(null,"x","x",2099068185).cljs$core$IFn$_invoke$arity$1(G__47147),new cljs.core.Keyword(null,"y","y",-1757859776).cljs$core$IFn$_invoke$arity$1(G__47147),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.get_position = (function shadow$dom$get_position(el){
var pos = goog.style.getPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_client_position = (function shadow$dom$get_client_position(el){
var pos = goog.style.getClientPosition(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});
shadow.dom.get_page_offset = (function shadow$dom$get_page_offset(el){
var pos = goog.style.getPageOffset(shadow.dom.dom_node(el));
return shadow.dom.__GT_Coordinate(pos.x,pos.y);
});

/**
* @constructor
 * @implements {cljs.core.IRecord}
 * @implements {cljs.core.IKVReduce}
 * @implements {cljs.core.IEquiv}
 * @implements {cljs.core.IHash}
 * @implements {cljs.core.ICollection}
 * @implements {cljs.core.ICounted}
 * @implements {cljs.core.ISeqable}
 * @implements {cljs.core.IMeta}
 * @implements {cljs.core.ICloneable}
 * @implements {cljs.core.IPrintWithWriter}
 * @implements {cljs.core.IIterable}
 * @implements {cljs.core.IWithMeta}
 * @implements {cljs.core.IAssociative}
 * @implements {cljs.core.IMap}
 * @implements {cljs.core.ILookup}
*/
shadow.dom.Size = (function (w,h,__meta,__extmap,__hash){
this.w = w;
this.h = h;
this.__meta = __meta;
this.__extmap = __extmap;
this.__hash = __hash;
this.cljs$lang$protocol_mask$partition0$ = 2230716170;
this.cljs$lang$protocol_mask$partition1$ = 139264;
});
(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$2 = (function (this__5300__auto__,k__5301__auto__){
var self__ = this;
var this__5300__auto____$1 = this;
return this__5300__auto____$1.cljs$core$ILookup$_lookup$arity$3(null, k__5301__auto__,null);
}));

(shadow.dom.Size.prototype.cljs$core$ILookup$_lookup$arity$3 = (function (this__5302__auto__,k47244,else__5303__auto__){
var self__ = this;
var this__5302__auto____$1 = this;
var G__47265 = k47244;
var G__47265__$1 = (((G__47265 instanceof cljs.core.Keyword))?G__47265.fqn:null);
switch (G__47265__$1) {
case "w":
return self__.w;

break;
case "h":
return self__.h;

break;
default:
return cljs.core.get.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k47244,else__5303__auto__);

}
}));

(shadow.dom.Size.prototype.cljs$core$IKVReduce$_kv_reduce$arity$3 = (function (this__5320__auto__,f__5321__auto__,init__5322__auto__){
var self__ = this;
var this__5320__auto____$1 = this;
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3((function (ret__5323__auto__,p__47274){
var vec__47276 = p__47274;
var k__5324__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47276,(0),null);
var v__5325__auto__ = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47276,(1),null);
return (f__5321__auto__.cljs$core$IFn$_invoke$arity$3 ? f__5321__auto__.cljs$core$IFn$_invoke$arity$3(ret__5323__auto__,k__5324__auto__,v__5325__auto__) : f__5321__auto__.call(null, ret__5323__auto__,k__5324__auto__,v__5325__auto__));
}),init__5322__auto__,this__5320__auto____$1);
}));

(shadow.dom.Size.prototype.cljs$core$IPrintWithWriter$_pr_writer$arity$3 = (function (this__5315__auto__,writer__5316__auto__,opts__5317__auto__){
var self__ = this;
var this__5315__auto____$1 = this;
var pr_pair__5318__auto__ = (function (keyval__5319__auto__){
return cljs.core.pr_sequential_writer(writer__5316__auto__,cljs.core.pr_writer,""," ","",opts__5317__auto__,keyval__5319__auto__);
});
return cljs.core.pr_sequential_writer(writer__5316__auto__,pr_pair__5318__auto__,"#shadow.dom.Size{",", ","}",opts__5317__auto__,cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"w","w",354169001),self__.w],null)),(new cljs.core.PersistentVector(null,2,(5),cljs.core.PersistentVector.EMPTY_NODE,[new cljs.core.Keyword(null,"h","h",1109658740),self__.h],null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IIterable$_iterator$arity$1 = (function (G__47243){
var self__ = this;
var G__47243__$1 = this;
return (new cljs.core.RecordIter((0),G__47243__$1,2,new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"w","w",354169001),new cljs.core.Keyword(null,"h","h",1109658740)], null),(cljs.core.truth_(self__.__extmap)?cljs.core._iterator(self__.__extmap):cljs.core.nil_iter())));
}));

(shadow.dom.Size.prototype.cljs$core$IMeta$_meta$arity$1 = (function (this__5298__auto__){
var self__ = this;
var this__5298__auto____$1 = this;
return self__.__meta;
}));

(shadow.dom.Size.prototype.cljs$core$ICloneable$_clone$arity$1 = (function (this__5295__auto__){
var self__ = this;
var this__5295__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICounted$_count$arity$1 = (function (this__5304__auto__){
var self__ = this;
var this__5304__auto____$1 = this;
return (2 + cljs.core.count(self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IHash$_hash$arity$1 = (function (this__5296__auto__){
var self__ = this;
var this__5296__auto____$1 = this;
var h__5111__auto__ = self__.__hash;
if((!((h__5111__auto__ == null)))){
return h__5111__auto__;
} else {
var h__5111__auto____$1 = (function (coll__5297__auto__){
return (-1228019642 ^ cljs.core.hash_unordered_coll(coll__5297__auto__));
})(this__5296__auto____$1);
(self__.__hash = h__5111__auto____$1);

return h__5111__auto____$1;
}
}));

(shadow.dom.Size.prototype.cljs$core$IEquiv$_equiv$arity$2 = (function (this47245,other47246){
var self__ = this;
var this47245__$1 = this;
return (((!((other47246 == null)))) && ((((this47245__$1.constructor === other47246.constructor)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47245__$1.w,other47246.w)) && (((cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47245__$1.h,other47246.h)) && (cljs.core._EQ_.cljs$core$IFn$_invoke$arity$2(this47245__$1.__extmap,other47246.__extmap)))))))));
}));

(shadow.dom.Size.prototype.cljs$core$IMap$_dissoc$arity$2 = (function (this__5310__auto__,k__5311__auto__){
var self__ = this;
var this__5310__auto____$1 = this;
if(cljs.core.contains_QMARK_(new cljs.core.PersistentHashSet(null, new cljs.core.PersistentArrayMap(null, 2, [new cljs.core.Keyword(null,"w","w",354169001),null,new cljs.core.Keyword(null,"h","h",1109658740),null], null), null),k__5311__auto__)){
return cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(cljs.core._with_meta(cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,this__5310__auto____$1),self__.__meta),k__5311__auto__);
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.not_empty(cljs.core.dissoc.cljs$core$IFn$_invoke$arity$2(self__.__extmap,k__5311__auto__)),null));
}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_contains_key_QMARK_$arity$2 = (function (this__5307__auto__,k47244){
var self__ = this;
var this__5307__auto____$1 = this;
var G__47327 = k47244;
var G__47327__$1 = (((G__47327 instanceof cljs.core.Keyword))?G__47327.fqn:null);
switch (G__47327__$1) {
case "w":
case "h":
return true;

break;
default:
return cljs.core.contains_QMARK_(self__.__extmap,k47244);

}
}));

(shadow.dom.Size.prototype.cljs$core$IAssociative$_assoc$arity$3 = (function (this__5308__auto__,k__5309__auto__,G__47243){
var self__ = this;
var this__5308__auto____$1 = this;
var pred__47333 = cljs.core.keyword_identical_QMARK_;
var expr__47334 = k__5309__auto__;
if(cljs.core.truth_((pred__47333.cljs$core$IFn$_invoke$arity$2 ? pred__47333.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"w","w",354169001),expr__47334) : pred__47333.call(null, new cljs.core.Keyword(null,"w","w",354169001),expr__47334)))){
return (new shadow.dom.Size(G__47243,self__.h,self__.__meta,self__.__extmap,null));
} else {
if(cljs.core.truth_((pred__47333.cljs$core$IFn$_invoke$arity$2 ? pred__47333.cljs$core$IFn$_invoke$arity$2(new cljs.core.Keyword(null,"h","h",1109658740),expr__47334) : pred__47333.call(null, new cljs.core.Keyword(null,"h","h",1109658740),expr__47334)))){
return (new shadow.dom.Size(self__.w,G__47243,self__.__meta,self__.__extmap,null));
} else {
return (new shadow.dom.Size(self__.w,self__.h,self__.__meta,cljs.core.assoc.cljs$core$IFn$_invoke$arity$3(self__.__extmap,k__5309__auto__,G__47243),null));
}
}
}));

(shadow.dom.Size.prototype.cljs$core$ISeqable$_seq$arity$1 = (function (this__5313__auto__){
var self__ = this;
var this__5313__auto____$1 = this;
return cljs.core.seq(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [(new cljs.core.MapEntry(new cljs.core.Keyword(null,"w","w",354169001),self__.w,null)),(new cljs.core.MapEntry(new cljs.core.Keyword(null,"h","h",1109658740),self__.h,null))], null),self__.__extmap));
}));

(shadow.dom.Size.prototype.cljs$core$IWithMeta$_with_meta$arity$2 = (function (this__5299__auto__,G__47243){
var self__ = this;
var this__5299__auto____$1 = this;
return (new shadow.dom.Size(self__.w,self__.h,G__47243,self__.__extmap,self__.__hash));
}));

(shadow.dom.Size.prototype.cljs$core$ICollection$_conj$arity$2 = (function (this__5305__auto__,entry__5306__auto__){
var self__ = this;
var this__5305__auto____$1 = this;
if(cljs.core.vector_QMARK_(entry__5306__auto__)){
return this__5305__auto____$1.cljs$core$IAssociative$_assoc$arity$3(null, cljs.core._nth(entry__5306__auto__,(0)),cljs.core._nth(entry__5306__auto__,(1)));
} else {
return cljs.core.reduce.cljs$core$IFn$_invoke$arity$3(cljs.core._conj,this__5305__auto____$1,entry__5306__auto__);
}
}));

(shadow.dom.Size.getBasis = (function (){
return new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Symbol(null,"w","w",1994700528,null),new cljs.core.Symbol(null,"h","h",-1544777029,null)], null);
}));

(shadow.dom.Size.cljs$lang$type = true);

(shadow.dom.Size.cljs$lang$ctorPrSeq = (function (this__5346__auto__){
return (new cljs.core.List(null,"shadow.dom/Size",null,(1),null));
}));

(shadow.dom.Size.cljs$lang$ctorPrWriter = (function (this__5346__auto__,writer__5347__auto__){
return cljs.core._write(writer__5347__auto__,"shadow.dom/Size");
}));

/**
 * Positional factory function for shadow.dom/Size.
 */
shadow.dom.__GT_Size = (function shadow$dom$__GT_Size(w,h){
return (new shadow.dom.Size(w,h,null,null,null));
});

/**
 * Factory function for shadow.dom/Size, taking a map of keywords to field values.
 */
shadow.dom.map__GT_Size = (function shadow$dom$map__GT_Size(G__47253){
var extmap__5342__auto__ = (function (){var G__47387 = cljs.core.dissoc.cljs$core$IFn$_invoke$arity$variadic(G__47253,new cljs.core.Keyword(null,"w","w",354169001),cljs.core.prim_seq.cljs$core$IFn$_invoke$arity$2([new cljs.core.Keyword(null,"h","h",1109658740)], 0));
if(cljs.core.record_QMARK_(G__47253)){
return cljs.core.into.cljs$core$IFn$_invoke$arity$2(cljs.core.PersistentArrayMap.EMPTY,G__47387);
} else {
return G__47387;
}
})();
return (new shadow.dom.Size(new cljs.core.Keyword(null,"w","w",354169001).cljs$core$IFn$_invoke$arity$1(G__47253),new cljs.core.Keyword(null,"h","h",1109658740).cljs$core$IFn$_invoke$arity$1(G__47253),null,cljs.core.not_empty(extmap__5342__auto__),null));
});

shadow.dom.size__GT_clj = (function shadow$dom$size__GT_clj(size){
return (new shadow.dom.Size(size.width,size.height,null,null,null));
});
shadow.dom.get_size = (function shadow$dom$get_size(el){
return shadow.dom.size__GT_clj(goog.style.getSize(shadow.dom.dom_node(el)));
});
shadow.dom.get_height = (function shadow$dom$get_height(el){
return shadow.dom.get_size(el).h;
});
shadow.dom.get_viewport_size = (function shadow$dom$get_viewport_size(){
return shadow.dom.size__GT_clj(goog.dom.getViewportSize());
});
shadow.dom.first_child = (function shadow$dom$first_child(el){
return (shadow.dom.dom_node(el).children[(0)]);
});
shadow.dom.select_option_values = (function shadow$dom$select_option_values(el){
var native$ = shadow.dom.dom_node(el);
var opts = (native$["options"]);
var a__5590__auto__ = opts;
var l__5591__auto__ = a__5590__auto__.length;
var i = (0);
var ret = cljs.core.PersistentVector.EMPTY;
while(true){
if((i < l__5591__auto__)){
var G__48361 = (i + (1));
var G__48362 = cljs.core.conj.cljs$core$IFn$_invoke$arity$2(ret,(opts[i]["value"]));
i = G__48361;
ret = G__48362;
continue;
} else {
return ret;
}
break;
}
});
shadow.dom.build_url = (function shadow$dom$build_url(path,query_params){
if(cljs.core.empty_QMARK_(query_params)){
return path;
} else {
return [cljs.core.str.cljs$core$IFn$_invoke$arity$1(path),"?",clojure.string.join.cljs$core$IFn$_invoke$arity$2("&",cljs.core.map.cljs$core$IFn$_invoke$arity$2((function (p__47463){
var vec__47465 = p__47463;
var k = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47465,(0),null);
var v = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47465,(1),null);
return [cljs.core.name(k),"=",cljs.core.str.cljs$core$IFn$_invoke$arity$1(encodeURIComponent(cljs.core.str.cljs$core$IFn$_invoke$arity$1(v)))].join('');
}),query_params))].join('');
}
});
shadow.dom.redirect = (function shadow$dom$redirect(var_args){
var G__47479 = arguments.length;
switch (G__47479) {
case 1:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1((arguments[(0)]));

break;
case 2:
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2((arguments[(0)]),(arguments[(1)]));

break;
default:
throw (new Error(["Invalid arity: ",cljs.core.str.cljs$core$IFn$_invoke$arity$1(arguments.length)].join('')));

}
});

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$1 = (function (path){
return shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2(path,cljs.core.PersistentArrayMap.EMPTY);
}));

(shadow.dom.redirect.cljs$core$IFn$_invoke$arity$2 = (function (path,query_params){
return (document["location"]["href"] = shadow.dom.build_url(path,query_params));
}));

(shadow.dom.redirect.cljs$lang$maxFixedArity = 2);

shadow.dom.reload_BANG_ = (function shadow$dom$reload_BANG_(){
return (document.location.href = document.location.href);
});
shadow.dom.tag_name = (function shadow$dom$tag_name(el){
var dom = shadow.dom.dom_node(el);
return dom.tagName;
});
shadow.dom.insert_after = (function shadow$dom$insert_after(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingAfter(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_before = (function shadow$dom$insert_before(ref,new$){
var new_node = shadow.dom.dom_node(new$);
goog.dom.insertSiblingBefore(new_node,shadow.dom.dom_node(ref));

return new_node;
});
shadow.dom.insert_first = (function shadow$dom$insert_first(ref,new$){
var temp__5821__auto__ = shadow.dom.dom_node(ref).firstChild;
if(cljs.core.truth_(temp__5821__auto__)){
var child = temp__5821__auto__;
return shadow.dom.insert_before(child,new$);
} else {
return shadow.dom.append.cljs$core$IFn$_invoke$arity$2(ref,new$);
}
});
shadow.dom.index_of = (function shadow$dom$index_of(el){
var el__$1 = shadow.dom.dom_node(el);
var i = (0);
while(true){
var ps = el__$1.previousSibling;
if((ps == null)){
return i;
} else {
var G__48378 = ps;
var G__48379 = (i + (1));
el__$1 = G__48378;
i = G__48379;
continue;
}
break;
}
});
shadow.dom.get_parent = (function shadow$dom$get_parent(el){
return goog.dom.getParentElement(shadow.dom.dom_node(el));
});
shadow.dom.parents = (function shadow$dom$parents(el){
var parent = shadow.dom.get_parent(el);
if(cljs.core.truth_(parent)){
return cljs.core.cons(parent,(new cljs.core.LazySeq(null,(function (){
return (shadow.dom.parents.cljs$core$IFn$_invoke$arity$1 ? shadow.dom.parents.cljs$core$IFn$_invoke$arity$1(parent) : shadow.dom.parents.call(null, parent));
}),null,null)));
} else {
return null;
}
});
shadow.dom.matches = (function shadow$dom$matches(el,sel){
return shadow.dom.dom_node(el).matches(sel);
});
shadow.dom.get_next_sibling = (function shadow$dom$get_next_sibling(el){
return goog.dom.getNextElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.get_previous_sibling = (function shadow$dom$get_previous_sibling(el){
return goog.dom.getPreviousElementSibling(shadow.dom.dom_node(el));
});
shadow.dom.xmlns = cljs.core.atom.cljs$core$IFn$_invoke$arity$1(new cljs.core.PersistentArrayMap(null, 2, ["svg","http://www.w3.org/2000/svg","xlink","http://www.w3.org/1999/xlink"], null));
shadow.dom.create_svg_node = (function shadow$dom$create_svg_node(tag_def,props){
var vec__47618 = shadow.dom.parse_tag(tag_def);
var tag_name = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47618,(0),null);
var tag_id = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47618,(1),null);
var tag_classes = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47618,(2),null);
var el = document.createElementNS("http://www.w3.org/2000/svg",tag_name);
if(cljs.core.truth_(tag_id)){
el.setAttribute("id",tag_id);
} else {
}

if(cljs.core.truth_(tag_classes)){
el.setAttribute("class",shadow.dom.merge_class_string(new cljs.core.Keyword(null,"class","class",-2030961996).cljs$core$IFn$_invoke$arity$1(props),tag_classes));
} else {
}

var seq__47641_48383 = cljs.core.seq(props);
var chunk__47643_48384 = null;
var count__47644_48385 = (0);
var i__47645_48386 = (0);
while(true){
if((i__47645_48386 < count__47644_48385)){
var vec__47699_48388 = chunk__47643_48384.cljs$core$IIndexed$_nth$arity$2(null, i__47645_48386);
var k_48389 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47699_48388,(0),null);
var v_48390 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47699_48388,(1),null);
el.setAttributeNS((function (){var temp__5823__auto__ = cljs.core.namespace(k_48389);
if(cljs.core.truth_(temp__5823__auto__)){
var ns = temp__5823__auto__;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48389),v_48390);


var G__48392 = seq__47641_48383;
var G__48393 = chunk__47643_48384;
var G__48394 = count__47644_48385;
var G__48395 = (i__47645_48386 + (1));
seq__47641_48383 = G__48392;
chunk__47643_48384 = G__48393;
count__47644_48385 = G__48394;
i__47645_48386 = G__48395;
continue;
} else {
var temp__5823__auto___48396 = cljs.core.seq(seq__47641_48383);
if(temp__5823__auto___48396){
var seq__47641_48397__$1 = temp__5823__auto___48396;
if(cljs.core.chunked_seq_QMARK_(seq__47641_48397__$1)){
var c__5525__auto___48399 = cljs.core.chunk_first(seq__47641_48397__$1);
var G__48400 = cljs.core.chunk_rest(seq__47641_48397__$1);
var G__48401 = c__5525__auto___48399;
var G__48402 = cljs.core.count(c__5525__auto___48399);
var G__48403 = (0);
seq__47641_48383 = G__48400;
chunk__47643_48384 = G__48401;
count__47644_48385 = G__48402;
i__47645_48386 = G__48403;
continue;
} else {
var vec__47714_48404 = cljs.core.first(seq__47641_48397__$1);
var k_48405 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47714_48404,(0),null);
var v_48406 = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47714_48404,(1),null);
el.setAttributeNS((function (){var temp__5823__auto____$1 = cljs.core.namespace(k_48405);
if(cljs.core.truth_(temp__5823__auto____$1)){
var ns = temp__5823__auto____$1;
return cljs.core.get.cljs$core$IFn$_invoke$arity$2(cljs.core.deref(shadow.dom.xmlns),ns);
} else {
return null;
}
})(),cljs.core.name(k_48405),v_48406);


var G__48408 = cljs.core.next(seq__47641_48397__$1);
var G__48409 = null;
var G__48410 = (0);
var G__48411 = (0);
seq__47641_48383 = G__48408;
chunk__47643_48384 = G__48409;
count__47644_48385 = G__48410;
i__47645_48386 = G__48411;
continue;
}
} else {
}
}
break;
}

return el;
});
shadow.dom.svg_node = (function shadow$dom$svg_node(el){
if((el == null)){
return null;
} else {
if((((!((el == null))))?((((false) || ((cljs.core.PROTOCOL_SENTINEL === el.shadow$dom$SVGElement$))))?true:false):false)){
return el.shadow$dom$SVGElement$_to_svg$arity$1(null, );
} else {
return el;

}
}
});
shadow.dom.make_svg_node = (function shadow$dom$make_svg_node(structure){
var vec__47758 = shadow.dom.destructure_node(shadow.dom.create_svg_node,structure);
var node = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47758,(0),null);
var node_children = cljs.core.nth.cljs$core$IFn$_invoke$arity$3(vec__47758,(1),null);
var seq__47763_48412 = cljs.core.seq(node_children);
var chunk__47765_48413 = null;
var count__47766_48414 = (0);
var i__47767_48415 = (0);
while(true){
if((i__47767_48415 < count__47766_48414)){
var child_struct_48416 = chunk__47765_48413.cljs$core$IIndexed$_nth$arity$2(null, i__47767_48415);
if((!((child_struct_48416 == null)))){
if(typeof child_struct_48416 === 'string'){
var text_48419 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48419),child_struct_48416].join(''));
} else {
var children_48420 = shadow.dom.svg_node(child_struct_48416);
if(cljs.core.seq_QMARK_(children_48420)){
var seq__47876_48421 = cljs.core.seq(children_48420);
var chunk__47878_48422 = null;
var count__47879_48423 = (0);
var i__47880_48424 = (0);
while(true){
if((i__47880_48424 < count__47879_48423)){
var child_48425 = chunk__47878_48422.cljs$core$IIndexed$_nth$arity$2(null, i__47880_48424);
if(cljs.core.truth_(child_48425)){
node.appendChild(child_48425);


var G__48426 = seq__47876_48421;
var G__48427 = chunk__47878_48422;
var G__48428 = count__47879_48423;
var G__48429 = (i__47880_48424 + (1));
seq__47876_48421 = G__48426;
chunk__47878_48422 = G__48427;
count__47879_48423 = G__48428;
i__47880_48424 = G__48429;
continue;
} else {
var G__48430 = seq__47876_48421;
var G__48431 = chunk__47878_48422;
var G__48432 = count__47879_48423;
var G__48433 = (i__47880_48424 + (1));
seq__47876_48421 = G__48430;
chunk__47878_48422 = G__48431;
count__47879_48423 = G__48432;
i__47880_48424 = G__48433;
continue;
}
} else {
var temp__5823__auto___48434 = cljs.core.seq(seq__47876_48421);
if(temp__5823__auto___48434){
var seq__47876_48435__$1 = temp__5823__auto___48434;
if(cljs.core.chunked_seq_QMARK_(seq__47876_48435__$1)){
var c__5525__auto___48436 = cljs.core.chunk_first(seq__47876_48435__$1);
var G__48437 = cljs.core.chunk_rest(seq__47876_48435__$1);
var G__48438 = c__5525__auto___48436;
var G__48439 = cljs.core.count(c__5525__auto___48436);
var G__48440 = (0);
seq__47876_48421 = G__48437;
chunk__47878_48422 = G__48438;
count__47879_48423 = G__48439;
i__47880_48424 = G__48440;
continue;
} else {
var child_48441 = cljs.core.first(seq__47876_48435__$1);
if(cljs.core.truth_(child_48441)){
node.appendChild(child_48441);


var G__48443 = cljs.core.next(seq__47876_48435__$1);
var G__48444 = null;
var G__48445 = (0);
var G__48446 = (0);
seq__47876_48421 = G__48443;
chunk__47878_48422 = G__48444;
count__47879_48423 = G__48445;
i__47880_48424 = G__48446;
continue;
} else {
var G__48447 = cljs.core.next(seq__47876_48435__$1);
var G__48448 = null;
var G__48449 = (0);
var G__48450 = (0);
seq__47876_48421 = G__48447;
chunk__47878_48422 = G__48448;
count__47879_48423 = G__48449;
i__47880_48424 = G__48450;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48420);
}
}


var G__48452 = seq__47763_48412;
var G__48453 = chunk__47765_48413;
var G__48454 = count__47766_48414;
var G__48455 = (i__47767_48415 + (1));
seq__47763_48412 = G__48452;
chunk__47765_48413 = G__48453;
count__47766_48414 = G__48454;
i__47767_48415 = G__48455;
continue;
} else {
var G__48457 = seq__47763_48412;
var G__48458 = chunk__47765_48413;
var G__48459 = count__47766_48414;
var G__48460 = (i__47767_48415 + (1));
seq__47763_48412 = G__48457;
chunk__47765_48413 = G__48458;
count__47766_48414 = G__48459;
i__47767_48415 = G__48460;
continue;
}
} else {
var temp__5823__auto___48461 = cljs.core.seq(seq__47763_48412);
if(temp__5823__auto___48461){
var seq__47763_48463__$1 = temp__5823__auto___48461;
if(cljs.core.chunked_seq_QMARK_(seq__47763_48463__$1)){
var c__5525__auto___48464 = cljs.core.chunk_first(seq__47763_48463__$1);
var G__48466 = cljs.core.chunk_rest(seq__47763_48463__$1);
var G__48467 = c__5525__auto___48464;
var G__48468 = cljs.core.count(c__5525__auto___48464);
var G__48469 = (0);
seq__47763_48412 = G__48466;
chunk__47765_48413 = G__48467;
count__47766_48414 = G__48468;
i__47767_48415 = G__48469;
continue;
} else {
var child_struct_48471 = cljs.core.first(seq__47763_48463__$1);
if((!((child_struct_48471 == null)))){
if(typeof child_struct_48471 === 'string'){
var text_48472 = (node["textContent"]);
(node["textContent"] = [cljs.core.str.cljs$core$IFn$_invoke$arity$1(text_48472),child_struct_48471].join(''));
} else {
var children_48473 = shadow.dom.svg_node(child_struct_48471);
if(cljs.core.seq_QMARK_(children_48473)){
var seq__47934_48474 = cljs.core.seq(children_48473);
var chunk__47936_48475 = null;
var count__47937_48476 = (0);
var i__47938_48477 = (0);
while(true){
if((i__47938_48477 < count__47937_48476)){
var child_48478 = chunk__47936_48475.cljs$core$IIndexed$_nth$arity$2(null, i__47938_48477);
if(cljs.core.truth_(child_48478)){
node.appendChild(child_48478);


var G__48479 = seq__47934_48474;
var G__48480 = chunk__47936_48475;
var G__48481 = count__47937_48476;
var G__48482 = (i__47938_48477 + (1));
seq__47934_48474 = G__48479;
chunk__47936_48475 = G__48480;
count__47937_48476 = G__48481;
i__47938_48477 = G__48482;
continue;
} else {
var G__48483 = seq__47934_48474;
var G__48484 = chunk__47936_48475;
var G__48485 = count__47937_48476;
var G__48486 = (i__47938_48477 + (1));
seq__47934_48474 = G__48483;
chunk__47936_48475 = G__48484;
count__47937_48476 = G__48485;
i__47938_48477 = G__48486;
continue;
}
} else {
var temp__5823__auto___48488__$1 = cljs.core.seq(seq__47934_48474);
if(temp__5823__auto___48488__$1){
var seq__47934_48489__$1 = temp__5823__auto___48488__$1;
if(cljs.core.chunked_seq_QMARK_(seq__47934_48489__$1)){
var c__5525__auto___48490 = cljs.core.chunk_first(seq__47934_48489__$1);
var G__48495 = cljs.core.chunk_rest(seq__47934_48489__$1);
var G__48496 = c__5525__auto___48490;
var G__48497 = cljs.core.count(c__5525__auto___48490);
var G__48498 = (0);
seq__47934_48474 = G__48495;
chunk__47936_48475 = G__48496;
count__47937_48476 = G__48497;
i__47938_48477 = G__48498;
continue;
} else {
var child_48499 = cljs.core.first(seq__47934_48489__$1);
if(cljs.core.truth_(child_48499)){
node.appendChild(child_48499);


var G__48503 = cljs.core.next(seq__47934_48489__$1);
var G__48504 = null;
var G__48505 = (0);
var G__48506 = (0);
seq__47934_48474 = G__48503;
chunk__47936_48475 = G__48504;
count__47937_48476 = G__48505;
i__47938_48477 = G__48506;
continue;
} else {
var G__48508 = cljs.core.next(seq__47934_48489__$1);
var G__48509 = null;
var G__48510 = (0);
var G__48511 = (0);
seq__47934_48474 = G__48508;
chunk__47936_48475 = G__48509;
count__47937_48476 = G__48510;
i__47938_48477 = G__48511;
continue;
}
}
} else {
}
}
break;
}
} else {
node.appendChild(children_48473);
}
}


var G__48512 = cljs.core.next(seq__47763_48463__$1);
var G__48513 = null;
var G__48514 = (0);
var G__48515 = (0);
seq__47763_48412 = G__48512;
chunk__47765_48413 = G__48513;
count__47766_48414 = G__48514;
i__47767_48415 = G__48515;
continue;
} else {
var G__48516 = cljs.core.next(seq__47763_48463__$1);
var G__48517 = null;
var G__48518 = (0);
var G__48519 = (0);
seq__47763_48412 = G__48516;
chunk__47765_48413 = G__48517;
count__47766_48414 = G__48518;
i__47767_48415 = G__48519;
continue;
}
}
} else {
}
}
break;
}

return node;
});
(shadow.dom.SVGElement["string"] = true);

(shadow.dom._to_svg["string"] = (function (this$){
if((this$ instanceof cljs.core.Keyword)){
return shadow.dom.make_svg_node(new cljs.core.PersistentVector(null, 1, 5, cljs.core.PersistentVector.EMPTY_NODE, [this$], null));
} else {
throw cljs.core.ex_info.cljs$core$IFn$_invoke$arity$2("strings cannot be in svgs",new cljs.core.PersistentArrayMap(null, 1, [new cljs.core.Keyword(null,"this","this",-611633625),this$], null));
}
}));

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.PersistentVector.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return shadow.dom.make_svg_node(this$__$1);
}));

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$ = cljs.core.PROTOCOL_SENTINEL);

(cljs.core.LazySeq.prototype.shadow$dom$SVGElement$_to_svg$arity$1 = (function (this$){
var this$__$1 = this;
return cljs.core.map.cljs$core$IFn$_invoke$arity$2(shadow.dom._to_svg,this$__$1);
}));

(shadow.dom.SVGElement["null"] = true);

(shadow.dom._to_svg["null"] = (function (_){
return null;
}));
shadow.dom.svg = (function shadow$dom$svg(var_args){
var args__5732__auto__ = [];
var len__5726__auto___48524 = arguments.length;
var i__5727__auto___48525 = (0);
while(true){
if((i__5727__auto___48525 < len__5726__auto___48524)){
args__5732__auto__.push((arguments[i__5727__auto___48525]));

var G__48527 = (i__5727__auto___48525 + (1));
i__5727__auto___48525 = G__48527;
continue;
} else {
}
break;
}

var argseq__5733__auto__ = ((((1) < args__5732__auto__.length))?(new cljs.core.IndexedSeq(args__5732__auto__.slice((1)),(0),null)):null);
return shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic((arguments[(0)]),argseq__5733__auto__);
});

(shadow.dom.svg.cljs$core$IFn$_invoke$arity$variadic = (function (attrs,children){
return shadow.dom._to_svg(cljs.core.vec(cljs.core.concat.cljs$core$IFn$_invoke$arity$2(new cljs.core.PersistentVector(null, 2, 5, cljs.core.PersistentVector.EMPTY_NODE, [new cljs.core.Keyword(null,"svg","svg",856789142),attrs], null),children)));
}));

(shadow.dom.svg.cljs$lang$maxFixedArity = (1));

/** @this {Function} */
(shadow.dom.svg.cljs$lang$applyTo = (function (seq47952){
var G__47953 = cljs.core.first(seq47952);
var seq47952__$1 = cljs.core.next(seq47952);
var self__5711__auto__ = this;
return self__5711__auto__.cljs$core$IFn$_invoke$arity$variadic(G__47953,seq47952__$1);
}));


//# sourceMappingURL=shadow.dom.js.map
