(ns ventus.util.malli
  (:require [ventus.util.schema :as s]
            [sci.core]
            [malli.core :as m]
            [malli.error :as me]))

(defn validate
  [component-name schema value]
  (when (not (m/validate schema value))
    (let [error (m/explain schema value)
          human-error (me/humanize error)]
      (throw (js/Error. (str "Component prop validation failed "
                             {:component component-name
                              :error (pr-str human-error)
                              :value value}))))))

(reset! s/validate-fn validate)
