(ns ventus.util.schema
  (:require [shadow.loader :as loader]
            [utilis.js :as j]
            [reagent.core :as r]))

(goog-define VALIDATE false)

(def loading? (r/atom false))
(def loaded? (r/atom false))
(def validate-fn (r/atom nil))

(defn load-modules
  []
  (let [module :malli]
    (when (not (loader/loaded? (name module)))
      (reset! loading? true)
      (js/console.info "Loading schema validation modules.")
      (j/call (loader/load (name module)) :then
              #(do (reset! loading? false)
                   (reset! loaded? true)
                   (js/console.info "Loaded schema validation modules."))
              #(do (reset! loading? false)
                   (js/console.warn "Unable to load schema validation modules."))))))

(defn validate
  [component-name schema value]
  (when VALIDATE
    (when (and (not @loaded?)
               (not @loading?))
      (load-modules))
    (when-let [validate-fn @validate-fn]
      (validate-fn component-name schema value))))
