/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcublas;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.jcublas.cublasHandle;
import jcuda.jcublas.cublasStatus;
import jcuda.runtime.cudaStream_t;

public class JCublas2 {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCublas2.initialize();
    }

    private JCublas2() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary("JCublas2");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCublas2.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cublasStatus.stringFor(result));
        }
        return result;
    }

    public static int cublasCreate(cublasHandle handle) {
        return JCublas2.checkResult(JCublas2.cublasCreateNative(handle));
    }

    private static native int cublasCreateNative(cublasHandle var0);

    public static int cublasDestroy(cublasHandle handle) {
        return JCublas2.checkResult(JCublas2.cublasDestroyNative(handle));
    }

    private static native int cublasDestroyNative(cublasHandle var0);

    public static int cublasGetVersion(cublasHandle handle, int[] version) {
        return JCublas2.checkResult(JCublas2.cublasGetVersionNative(handle, version));
    }

    private static native int cublasGetVersionNative(cublasHandle var0, int[] var1);

    public static int cublasSetStream(cublasHandle handle, cudaStream_t streamId) {
        return JCublas2.checkResult(JCublas2.cublasSetStreamNative(handle, streamId));
    }

    private static native int cublasSetStreamNative(cublasHandle var0, cudaStream_t var1);

    public static int cublasGetStream(cublasHandle handle, cudaStream_t streamId) {
        return JCublas2.checkResult(JCublas2.cublasGetStreamNative(handle, streamId));
    }

    private static native int cublasGetStreamNative(cublasHandle var0, cudaStream_t var1);

    public static int cublasGetPointerMode(cublasHandle handle, int[] mode) {
        return JCublas2.checkResult(JCublas2.cublasGetPointerModeNative(handle, mode));
    }

    private static native int cublasGetPointerModeNative(cublasHandle var0, int[] var1);

    public static int cublasSetPointerMode(cublasHandle handle, int mode) {
        return JCublas2.checkResult(JCublas2.cublasSetPointerModeNative(handle, mode));
    }

    private static native int cublasSetPointerModeNative(cublasHandle var0, int var1);

    public static int cublasGetAtomicsMode(cublasHandle handle, int[] mode) {
        return JCublas2.checkResult(JCublas2.cublasGetAtomicsModeNative(handle, mode));
    }

    private static native int cublasGetAtomicsModeNative(cublasHandle var0, int[] var1);

    public static int cublasSetAtomicsMode(cublasHandle handle, int mode) {
        return JCublas2.checkResult(JCublas2.cublasSetAtomicsModeNative(handle, mode));
    }

    private static native int cublasSetAtomicsModeNative(cublasHandle var0, int var1);

    public static int cublasSetVector(int n, int elemSize, Pointer x, int incx, Pointer devicePtr, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSetVectorNative(n, elemSize, x, incx, devicePtr, incy));
    }

    private static native int cublasSetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasGetVector(int n, int elemSize, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasGetVectorNative(n, elemSize, x, incx, y, incy));
    }

    private static native int cublasGetVectorNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasSetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrixNative(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasSetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasGetMatrix(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrixNative(rows, cols, elemSize, A, lda, B, ldb));
    }

    private static native int cublasGetMatrixNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasSetVectorAsync(int n, int elemSize, Pointer hostPtr, int incx, Pointer devicePtr, int incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetVectorAsyncNative(n, elemSize, hostPtr, incx, devicePtr, incy, stream));
    }

    private static native int cublasSetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    public static int cublasGetVectorAsync(int n, int elemSize, Pointer devicePtr, int incx, Pointer hostPtr, int incy, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetVectorAsyncNative(n, elemSize, devicePtr, incx, hostPtr, incy, stream));
    }

    private static native int cublasGetVectorAsyncNative(int var0, int var1, Pointer var2, int var3, Pointer var4, int var5, cudaStream_t var6);

    public static int cublasSetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasSetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasSetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    public static int cublasGetMatrixAsync(int rows, int cols, int elemSize, Pointer A, int lda, Pointer B, int ldb, cudaStream_t stream) {
        return JCublas2.checkResult(JCublas2.cublasGetMatrixAsyncNative(rows, cols, elemSize, A, lda, B, ldb, stream));
    }

    private static native int cublasGetMatrixAsyncNative(int var0, int var1, int var2, Pointer var3, int var4, Pointer var5, int var6, cudaStream_t var7);

    public static int cublasSnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasSnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasDnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasScnrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScnrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasScnrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDznrm2(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDznrm2Native(handle, n, x, incx, result));
    }

    private static native int cublasDznrm2Native(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasSdot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSdotNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasSdotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDdot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDdotNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasDdotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasCdotu(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotuNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotuNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasCdotc(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasCdotcNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasCdotcNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZdotu(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotuNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotuNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZdotc(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasZdotcNative(handle, n, x, incx, y, incy, result));
    }

    private static native int cublasZdotcNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasSscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasSscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasDscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasDscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasCscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasCscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasCsscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCsscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasCsscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasZscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasZscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasZdscal(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZdscalNative(handle, n, alpha, x, incx));
    }

    private static native int cublasZdscalNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4);

    public static int cublasSaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasSaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasDaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasDaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasCaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasCaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasZaxpy(cublasHandle handle, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZaxpyNative(handle, n, alpha, x, incx, y, incy));
    }

    private static native int cublasZaxpyNative(cublasHandle var0, int var1, Pointer var2, Pointer var3, int var4, Pointer var5, int var6);

    public static int cublasScopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasScopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasScopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasDcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasDcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasCcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasCcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasZcopy(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZcopyNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasZcopyNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasSswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasSswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasDswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasDswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasCswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasCswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasZswap(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZswapNative(handle, n, x, incx, y, incy));
    }

    private static native int cublasZswapNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5);

    public static int cublasIsamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIsamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIsamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIdamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIdamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIdamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIcamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIcamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIcamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIzamax(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIzamaxNative(handle, n, x, incx, result));
    }

    private static native int cublasIzamaxNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIsamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIsaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIsaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIdamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIdaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIdaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIcamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIcaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIcaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasIzamin(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasIzaminNative(handle, n, x, incx, result));
    }

    private static native int cublasIzaminNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasSasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasSasumNative(handle, n, x, incx, result));
    }

    private static native int cublasSasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDasumNative(handle, n, x, incx, result));
    }

    private static native int cublasDasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasScasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasScasumNative(handle, n, x, incx, result));
    }

    private static native int cublasScasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasDzasum(cublasHandle handle, int n, Pointer x, int incx, Pointer result) {
        return JCublas2.checkResult(JCublas2.cublasDzasumNative(handle, n, x, incx, result));
    }

    private static native int cublasDzasumNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4);

    public static int cublasSrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasSrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasSrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasDrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasDrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasDrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasCrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasCsrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCsrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasCsrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasZrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasZdrot(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZdrotNative(handle, n, x, incx, y, incy, c, s));
    }

    private static native int cublasZdrotNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, Pointer var7);

    public static int cublasSrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasSrotgNative(handle, a, b, c, s));
    }

    private static native int cublasSrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasDrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasDrotgNative(handle, a, b, c, s));
    }

    private static native int cublasDrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasCrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasCrotgNative(handle, a, b, c, s));
    }

    private static native int cublasCrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasZrotg(cublasHandle handle, Pointer a, Pointer b, Pointer c, Pointer s) {
        return JCublas2.checkResult(JCublas2.cublasZrotgNative(handle, a, b, c, s));
    }

    private static native int cublasZrotgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4);

    public static int cublasSrotm(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasSrotmNative(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasSrotmNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDrotm(cublasHandle handle, int n, Pointer x, int incx, Pointer y, int incy, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasDrotmNative(handle, n, x, incx, y, incy, param));
    }

    private static native int cublasDrotmNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSrotmg(cublasHandle handle, Pointer d1, Pointer d2, Pointer x1, Pointer y1, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasSrotmgNative(handle, d1, d2, x1, y1, param));
    }

    private static native int cublasSrotmgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cublasDrotmg(cublasHandle handle, Pointer d1, Pointer d2, Pointer x1, Pointer y1, Pointer param) {
        return JCublas2.checkResult(JCublas2.cublasDrotmgNative(handle, d1, d2, x1, y1, param));
    }

    private static native int cublasDrotmgNative(cublasHandle var0, Pointer var1, Pointer var2, Pointer var3, Pointer var4, Pointer var5);

    public static int cublasSgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasDgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasCgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasZgemv(cublasHandle handle, int trans, int m, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZgemvNative(handle, trans, m, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgemvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasSgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasDgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasCgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasZgbmv(cublasHandle handle, int trans, int m, int n, int kl, int ku, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZgbmvNative(handle, trans, m, n, kl, ku, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZgbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasStrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZtrmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrmvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasStbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZtbmv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbmvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasStpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasDtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasCtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasZtpmv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpmvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpmvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasStrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasStrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasDtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasCtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZtrsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtrsvNative(handle, uplo, trans, diag, n, A, lda, x, incx));
    }

    private static native int cublasZtrsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasStpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasStpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasDtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasDtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasCtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasCtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasZtpsv(cublasHandle handle, int uplo, int trans, int diag, int n, Pointer AP, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtpsvNative(handle, uplo, trans, diag, n, AP, x, incx));
    }

    private static native int cublasZtpsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7);

    public static int cublasStbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasStbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasStbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasDtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasDtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasCtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasCtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZtbsv(cublasHandle handle, int uplo, int trans, int diag, int n, int k, Pointer A, int lda, Pointer x, int incx) {
        return JCublas2.checkResult(JCublas2.cublasZtbsvNative(handle, uplo, trans, diag, n, k, A, lda, x, incx));
    }

    private static native int cublasZtbsvNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasDsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasCsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasCsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZsymv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZsymvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZsymvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasChemv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChemvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChemvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZhemv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhemvNative(handle, uplo, n, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhemvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasSsbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSsbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasSsbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasDsbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDsbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasDsbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasChbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasChbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasZhbmv(cublasHandle handle, int uplo, int n, int k, Pointer alpha, Pointer A, int lda, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhbmvNative(handle, uplo, n, k, alpha, A, lda, x, incx, beta, y, incy));
    }

    private static native int cublasZhbmvNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8, Pointer var9, Pointer var10, int var11);

    public static int cublasSspmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasSspmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasSspmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasDspmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasDspmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasDspmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasChpmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasChpmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasChpmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasZhpmv(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer AP, Pointer x, int incx, Pointer beta, Pointer y, int incy) {
        return JCublas2.checkResult(JCublas2.cublasZhpmvNative(handle, uplo, n, alpha, AP, x, incx, beta, y, incy));
    }

    private static native int cublasZhpmvNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, int var6, Pointer var7, Pointer var8, int var9);

    public static int cublasSger(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSgerNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSgerNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDger(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDgerNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDgerNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCgeru(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCgeruNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgeruNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCgerc(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCgercNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCgercNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZgeru(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZgeruNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgeruNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZgerc(cublasHandle handle, int m, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZgercNative(handle, m, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZgercNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasSsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasDsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasDsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZsyr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyrNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZsyrNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCher(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCherNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasCherNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZher(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZherNative(handle, uplo, n, alpha, x, incx, A, lda));
    }

    private static native int cublasZherNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasSspr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSsprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasSsprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasDspr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDsprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasDsprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasChpr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasChprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasZhpr(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhprNative(handle, uplo, n, alpha, x, incx, AP));
    }

    private static native int cublasZhprNative(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6);

    public static int cublasSsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasSsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasDsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZsyr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZsyr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCher2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasCher2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasCher2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZher2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer A, int lda) {
        return JCublas2.checkResult(JCublas2.cublasZher2Native(handle, uplo, n, alpha, x, incx, y, incy, A, lda));
    }

    private static native int cublasZher2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasSspr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasSspr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasSspr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasDspr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasDspr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasDspr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasChpr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasChpr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasChpr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasZhpr2(cublasHandle handle, int uplo, int n, Pointer alpha, Pointer x, int incx, Pointer y, int incy, Pointer AP) {
        return JCublas2.checkResult(JCublas2.cublasZhpr2Native(handle, uplo, n, alpha, x, incx, y, incy, AP));
    }

    private static native int cublasZhpr2Native(cublasHandle var0, int var1, int var2, Pointer var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8);

    public static int cublasSgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasDgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasCgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasZgemm(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgemmNative(handle, transa, transb, m, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZgemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13);

    public static int cublasSsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasSsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasDsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasDsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZsyrk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZsyrkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasCherk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasCherkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasZherk(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherkNative(handle, uplo, trans, n, k, alpha, A, lda, beta, C, ldc));
    }

    private static native int cublasZherkNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10);

    public static int cublasSsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsyr2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyr2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyr2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCher2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCher2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCher2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZher2k(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZher2kNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZher2kNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasSsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsyrkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsyrkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsyrkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCherkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCherkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCherkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZherkx(cublasHandle handle, int uplo, int trans, int n, int k, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZherkxNative(handle, uplo, trans, n, k, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZherkxNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasSsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasSsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasDsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasDsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasCsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasCsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZsymm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZsymmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZsymmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasChemm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasChemmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasChemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasZhemm(cublasHandle handle, int side, int uplo, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer beta, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZhemmNative(handle, side, uplo, m, n, alpha, A, lda, B, ldb, beta, C, ldc));
    }

    private static native int cublasZhemmNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, int var9, Pointer var10, Pointer var11, int var12);

    public static int cublasStrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasStrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasStrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasDtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasDtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasDtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasCtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasCtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasCtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasZtrsm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb) {
        return JCublas2.checkResult(JCublas2.cublasZtrsmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb));
    }

    private static native int cublasZtrsmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11);

    public static int cublasStrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasStrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasStrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasDtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasDtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasCtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasCtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasZtrmm(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZtrmmNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, C, ldc));
    }

    private static native int cublasZtrmmNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, Pointer var12, int var13);

    public static int cublasSgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasSgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasSgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasDgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasDgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasCgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasCgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasZgemmBatched(cublasHandle handle, int transa, int transb, int m, int n, int k, Pointer alpha, Pointer Aarray, int lda, Pointer Barray, int ldb, Pointer beta, Pointer Carray, int ldc, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZgemmBatchedNative(handle, transa, transb, m, n, k, alpha, Aarray, lda, Barray, ldb, beta, Carray, ldc, batchCount));
    }

    private static native int cublasZgemmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, Pointer var6, Pointer var7, int var8, Pointer var9, int var10, Pointer var11, Pointer var12, int var13, int var14);

    public static int cublasSgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasSgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasDgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasDgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasCgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasCgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasZgeam(cublasHandle handle, int transa, int transb, int m, int n, Pointer alpha, Pointer A, int lda, Pointer beta, Pointer B, int ldb, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZgeamNative(handle, transa, transb, m, n, alpha, A, lda, beta, B, ldb, C, ldc));
    }

    private static native int cublasZgeamNative(cublasHandle var0, int var1, int var2, int var3, int var4, Pointer var5, Pointer var6, int var7, Pointer var8, Pointer var9, int var10, Pointer var11, int var12);

    public static int cublasSgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgetrfBatchedNative(handle, n, A, lda, P, INFO, batchSize));
    }

    private static native int cublasSgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasDgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgetrfBatchedNative(handle, n, A, lda, P, INFO, batchSize));
    }

    private static native int cublasDgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasCgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgetrfBatchedNative(handle, n, A, lda, P, INFO, batchSize));
    }

    private static native int cublasCgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasZgetrfBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgetrfBatchedNative(handle, n, A, lda, P, INFO, batchSize));
    }

    private static native int cublasZgetrfBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6);

    public static int cublasSgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSgetriBatchedNative(handle, n, A, lda, P, C, ldc, INFO, batchSize));
    }

    private static native int cublasSgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasDgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDgetriBatchedNative(handle, n, A, lda, P, C, ldc, INFO, batchSize));
    }

    private static native int cublasDgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasCgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCgetriBatchedNative(handle, n, A, lda, P, C, ldc, INFO, batchSize));
    }

    private static native int cublasCgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasZgetriBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer P, Pointer C, int ldc, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZgetriBatchedNative(handle, n, A, lda, P, C, ldc, INFO, batchSize));
    }

    private static native int cublasZgetriBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, Pointer var5, int var6, Pointer var7, int var8);

    public static int cublasStrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasStrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasStrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasDtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasDtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasDtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasCtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasCtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasCtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasZtrsmBatched(cublasHandle handle, int side, int uplo, int trans, int diag, int m, int n, Pointer alpha, Pointer A, int lda, Pointer B, int ldb, int batchCount) {
        return JCublas2.checkResult(JCublas2.cublasZtrsmBatchedNative(handle, side, uplo, trans, diag, m, n, alpha, A, lda, B, ldb, batchCount));
    }

    private static native int cublasZtrsmBatchedNative(cublasHandle var0, int var1, int var2, int var3, int var4, int var5, int var6, Pointer var7, Pointer var8, int var9, Pointer var10, int var11, int var12);

    public static int cublasSmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasSmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, INFO, batchSize));
    }

    private static native int cublasSmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasDmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasDmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, INFO, batchSize));
    }

    private static native int cublasDmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasCmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasCmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, INFO, batchSize));
    }

    private static native int cublasCmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasZmatinvBatched(cublasHandle handle, int n, Pointer A, int lda, Pointer Ainv, int lda_inv, Pointer INFO, int batchSize) {
        return JCublas2.checkResult(JCublas2.cublasZmatinvBatchedNative(handle, n, A, lda, Ainv, lda_inv, INFO, batchSize));
    }

    private static native int cublasZmatinvBatchedNative(cublasHandle var0, int var1, Pointer var2, int var3, Pointer var4, int var5, Pointer var6, int var7);

    public static int cublasSdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasSdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasSdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasDdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasDdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasDdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasCdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasCdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasCdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);

    public static int cublasZdgmm(cublasHandle handle, int mode, int m, int n, Pointer A, int lda, Pointer x, int incx, Pointer C, int ldc) {
        return JCublas2.checkResult(JCublas2.cublasZdgmmNative(handle, mode, m, n, A, lda, x, incx, C, ldc));
    }

    private static native int cublasZdgmmNative(cublasHandle var0, int var1, int var2, int var3, Pointer var4, int var5, Pointer var6, int var7, Pointer var8, int var9);
}

