/*
 * Decompiled with CFR 0.152.
 */
package jcuda.jcusparse;

import jcuda.CudaException;
import jcuda.LibUtils;
import jcuda.LogLevel;
import jcuda.Pointer;
import jcuda.cuComplex;
import jcuda.cuDoubleComplex;
import jcuda.jcusparse.cusparseHandle;
import jcuda.jcusparse.cusparseMatDescr;
import jcuda.jcusparse.cusparseSolveAnalysisInfo;
import jcuda.jcusparse.cusparseStatus;
import jcuda.runtime.cudaStream_t;

public class JCusparse {
    private static boolean initialized = false;
    private static boolean exceptionsEnabled = false;

    static {
        JCusparse.initialize();
    }

    private JCusparse() {
    }

    public static void initialize() {
        if (!initialized) {
            LibUtils.loadLibrary("JCusparse");
            initialized = true;
        }
    }

    public static void setLogLevel(LogLevel logLevel) {
        JCusparse.setLogLevelNative(logLevel.ordinal());
    }

    private static native void setLogLevelNative(int var0);

    public static void setExceptionsEnabled(boolean enabled) {
        exceptionsEnabled = enabled;
    }

    private static int checkResult(int result) {
        if (exceptionsEnabled && result != 0) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    private static int checkForError(int result) {
        if (exceptionsEnabled && result == -1) {
            throw new CudaException(cusparseStatus.stringFor(result));
        }
        return result;
    }

    public static int cusparseCreate(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseCreateNative(handle));
    }

    private static native int cusparseCreateNative(cusparseHandle var0);

    public static int cusparseDestroy(cusparseHandle handle) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyNative(handle));
    }

    private static native int cusparseDestroyNative(cusparseHandle var0);

    public static int cusparseGetVersion(cusparseHandle handle, int[] version) {
        return JCusparse.checkResult(JCusparse.cusparseGetVersionNative(handle, version));
    }

    private static native int cusparseGetVersionNative(cusparseHandle var0, int[] var1);

    public static int cusparseSetKernelStream(cusparseHandle handle, cudaStream_t streamId) {
        return JCusparse.checkResult(JCusparse.cusparseSetKernelStreamNative(handle, streamId));
    }

    private static native int cusparseSetKernelStreamNative(cusparseHandle var0, cudaStream_t var1);

    public static int cusparseCreateMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseCreateMatDescrNative(descrA));
    }

    private static native int cusparseCreateMatDescrNative(cusparseMatDescr var0);

    public static int cusparseDestroyMatDescr(cusparseMatDescr descrA) {
        return JCusparse.checkResult(JCusparse.cusparseDestroyMatDescrNative(descrA));
    }

    private static native int cusparseDestroyMatDescrNative(cusparseMatDescr var0);

    public static int cusparseSetMatType(cusparseMatDescr descrA, int type) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatTypeNative(descrA, type));
    }

    private static native int cusparseSetMatTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatType(cusparseMatDescr descrA) {
        return JCusparse.checkForError(JCusparse.cusparseGetMatTypeNative(descrA));
    }

    private static native int cusparseGetMatTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatFillMode(cusparseMatDescr descrA, int fillMode) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatFillModeNative(descrA, fillMode));
    }

    private static native int cusparseSetMatFillModeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatFillMode(cusparseMatDescr descrA) {
        return JCusparse.checkForError(JCusparse.cusparseGetMatFillModeNative(descrA));
    }

    private static native int cusparseGetMatFillModeNative(cusparseMatDescr var0);

    public static int cusparseSetMatDiagType(cusparseMatDescr descrA, int diagType) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatDiagTypeNative(descrA, diagType));
    }

    private static native int cusparseSetMatDiagTypeNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatDiagType(cusparseMatDescr descrA) {
        return JCusparse.checkForError(JCusparse.cusparseGetMatDiagTypeNative(descrA));
    }

    private static native int cusparseGetMatDiagTypeNative(cusparseMatDescr var0);

    public static int cusparseSetMatIndexBase(cusparseMatDescr descrA, int base) {
        return JCusparse.checkResult(JCusparse.cusparseSetMatIndexBaseNative(descrA, base));
    }

    private static native int cusparseSetMatIndexBaseNative(cusparseMatDescr var0, int var1);

    public static int cusparseGetMatIndexBase(cusparseMatDescr descrA) {
        return JCusparse.checkForError(JCusparse.cusparseGetMatIndexBaseNative(descrA));
    }

    private static native int cusparseGetMatIndexBaseNative(cusparseMatDescr var0);

    public static int cusparseCreateSolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCreateSolveAnalysisInfoNative(info));
    }

    private static native int cusparseCreateSolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseDestroySolveAnalysisInfo(cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDestroySolveAnalysisInfoNative(info));
    }

    private static native int cusparseDestroySolveAnalysisInfoNative(cusparseSolveAnalysisInfo var0);

    public static int cusparseSaxpyi(cusparseHandle handle, int nnz, float alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSaxpyiNative(cusparseHandle var0, int var1, float var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseDaxpyi(cusparseHandle handle, int nnz, double alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDaxpyiNative(cusparseHandle var0, int var1, double var2, Pointer var4, Pointer var5, Pointer var6, int var7);

    public static int cusparseCaxpyi(cusparseHandle handle, int nnz, cuComplex alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCaxpyiNative(cusparseHandle var0, int var1, cuComplex var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseZaxpyi(cusparseHandle handle, int nnz, cuDoubleComplex alpha, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZaxpyiNative(handle, nnz, alpha, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZaxpyiNative(cusparseHandle var0, int var1, cuDoubleComplex var2, Pointer var3, Pointer var4, Pointer var5, int var6);

    public static int cusparseSdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, float[] resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSdotiNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseSdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, float[] var5, int var6);

    public static int cusparseDdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, double[] resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDdotiNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseDdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, double[] var5, int var6);

    public static int cusparseCdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, cuComplex resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCdotiNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseCdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, cuComplex var5, int var6);

    public static int cusparseZdoti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, cuDoubleComplex resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZdotiNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseZdotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, cuDoubleComplex var5, int var6);

    public static int cusparseCdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, cuComplex resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCdotciNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseCdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, cuComplex var5, int var6);

    public static int cusparseZdotci(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, cuDoubleComplex resultHostPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZdotciNative(handle, nnz, xVal, xInd, y, resultHostPtr, idxBase));
    }

    private static native int cusparseZdotciNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, cuDoubleComplex var5, int var6);

    public static int cusparseSgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthr(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseSgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseDgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseCgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZgthrz(cusparseHandle handle, int nnz, Pointer y, Pointer xVal, Pointer xInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZgthrzNative(handle, nnz, y, xVal, xInd, idxBase));
    }

    private static native int cusparseZgthrzNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseSsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseDsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseDsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseCsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseCsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseZsctr(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZsctrNative(handle, nnz, xVal, xInd, y, idxBase));
    }

    private static native int cusparseZsctrNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, int var5);

    public static int cusparseSroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, float c, float s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseSrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseSrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, float var5, float var6, int var7);

    public static int cusparseDroti(cusparseHandle handle, int nnz, Pointer xVal, Pointer xInd, Pointer y, double c, double s, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDrotiNative(handle, nnz, xVal, xInd, y, c, s, idxBase));
    }

    private static native int cusparseDrotiNative(cusparseHandle var0, int var1, Pointer var2, Pointer var3, Pointer var4, double var5, double var7, int var9);

    public static int cusparseScsrmv(cusparseHandle handle, int transA, int m, int n, float alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, float beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmvNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseScsrmvNative(cusparseHandle var0, int var1, int var2, int var3, float var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, float var10, Pointer var11);

    public static int cusparseDcsrmv(cusparseHandle handle, int transA, int m, int n, double alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, double beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmvNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseDcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, double var4, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, double var11, Pointer var13);

    public static int cusparseCcsrmv(cusparseHandle handle, int transA, int m, int n, cuComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, cuComplex beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmvNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseCcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, cuComplex var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cuComplex var10, Pointer var11);

    public static int cusparseZcsrmv(cusparseHandle handle, int transA, int m, int n, cuDoubleComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer x, cuDoubleComplex beta, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmvNative(handle, transA, m, n, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, x, beta, y));
    }

    private static native int cusparseZcsrmvNative(cusparseHandle var0, int var1, int var2, int var3, cuDoubleComplex var4, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9, cuDoubleComplex var10, Pointer var11);

    public static int cusparseScsrsv_analysis(cusparseHandle handle, int transA, int m, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv_analysisNative(handle, transA, m, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseScsrsv_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseDcsrsv_analysis(cusparseHandle handle, int transA, int m, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv_analysisNative(handle, transA, m, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseDcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseCcsrsv_analysis(cusparseHandle handle, int transA, int m, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv_analysisNative(handle, transA, m, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseCcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseZcsrsv_analysis(cusparseHandle handle, int transA, int m, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv_analysisNative(handle, transA, m, descrA, csrValA, csrRowPtrA, csrColIndA, info));
    }

    private static native int cusparseZcsrsv_analysisNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, cusparseSolveAnalysisInfo var7);

    public static int cusparseScsrsv_solve(cusparseHandle handle, int transA, int m, float alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseScsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseScsrsv_solveNative(cusparseHandle var0, int var1, int var2, float var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseDcsrsv_solve(cusparseHandle handle, int transA, int m, double alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseDcsrsv_solveNative(cusparseHandle var0, int var1, int var2, double var3, cusparseMatDescr var5, Pointer var6, Pointer var7, Pointer var8, cusparseSolveAnalysisInfo var9, Pointer var10, Pointer var11);

    public static int cusparseCcsrsv_solve(cusparseHandle handle, int transA, int m, cuComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseCcsrsv_solveNative(cusparseHandle var0, int var1, int var2, cuComplex var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseZcsrsv_solve(cusparseHandle handle, int transA, int m, cuDoubleComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, cusparseSolveAnalysisInfo info, Pointer x, Pointer y) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrsv_solveNative(handle, transA, m, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, info, x, y));
    }

    private static native int cusparseZcsrsv_solveNative(cusparseHandle var0, int var1, int var2, cuDoubleComplex var3, cusparseMatDescr var4, Pointer var5, Pointer var6, Pointer var7, cusparseSolveAnalysisInfo var8, Pointer var9, Pointer var10);

    public static int cusparseScsrmm(cusparseHandle handle, int transA, int m, int n, int k, float alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, float beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseScsrmmNative(handle, transA, m, n, k, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseScsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, float var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, int var11, float var12, Pointer var13, int var14);

    public static int cusparseDcsrmm(cusparseHandle handle, int transA, int m, int n, int k, double alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, double beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseDcsrmmNative(handle, transA, m, n, k, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseDcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, double var5, cusparseMatDescr var7, Pointer var8, Pointer var9, Pointer var10, Pointer var11, int var12, double var13, Pointer var15, int var16);

    public static int cusparseCcsrmm(cusparseHandle handle, int transA, int m, int n, int k, cuComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, cuComplex beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseCcsrmmNative(handle, transA, m, n, k, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseCcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cuComplex var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, int var11, cuComplex var12, Pointer var13, int var14);

    public static int cusparseZcsrmm(cusparseHandle handle, int transA, int m, int n, int k, cuDoubleComplex alpha, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer B, int ldb, cuDoubleComplex beta, Pointer C, int ldc) {
        return JCusparse.checkResult(JCusparse.cusparseZcsrmmNative(handle, transA, m, n, k, alpha, descrA, csrValA, csrRowPtrA, csrColIndA, B, ldb, beta, C, ldc));
    }

    private static native int cusparseZcsrmmNative(cusparseHandle var0, int var1, int var2, int var3, int var4, cuDoubleComplex var5, cusparseMatDescr var6, Pointer var7, Pointer var8, Pointer var9, Pointer var10, int var11, cuDoubleComplex var12, Pointer var13, int var14);

    public static int cusparseSnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseSnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzHostPtr));
    }

    private static native int cusparseSnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseDnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseDnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzHostPtr));
    }

    private static native int cusparseDnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseCnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseCnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzHostPtr));
    }

    private static native int cusparseCnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseZnnz(cusparseHandle handle, int dirA, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRowCol, Pointer nnzHostPtr) {
        return JCusparse.checkResult(JCusparse.cusparseZnnzNative(handle, dirA, m, n, descrA, A, lda, nnzPerRowCol, nnzHostPtr));
    }

    private static native int cusparseZnnzNative(cusparseHandle var0, int var1, int var2, int var3, cusparseMatDescr var4, Pointer var5, int var6, Pointer var7, Pointer var8);

    public static int cusparseSdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseSdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseDdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseCdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csr(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerRow, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2csrNative(handle, m, n, descrA, A, lda, nnzPerRow, csrValA, csrRowPtrA, csrColIndA));
    }

    private static native int cusparseZdense2csrNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseScsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseDcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseCcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsr2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer csrValA, Pointer csrRowPtrA, Pointer csrColIndA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2denseNative(handle, m, n, descrA, csrValA, csrRowPtrA, csrColIndA, A, lda));
    }

    private static native int cusparseZcsr2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseSdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseSdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseSdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseDdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseDdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseDdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseCdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseCdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseCdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseZdense2csc(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer A, int lda, Pointer nnzPerCol, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA) {
        return JCusparse.checkResult(JCusparse.cusparseZdense2cscNative(handle, m, n, descrA, A, lda, nnzPerCol, cscValA, cscRowIndA, cscColPtrA));
    }

    private static native int cusparseZdense2cscNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, int var5, Pointer var6, Pointer var7, Pointer var8, Pointer var9);

    public static int cusparseScsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseScsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseScsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseDcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseDcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseDcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseCcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseCcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseCcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseZcsc2dense(cusparseHandle handle, int m, int n, cusparseMatDescr descrA, Pointer cscValA, Pointer cscRowIndA, Pointer cscColPtrA, Pointer A, int lda) {
        return JCusparse.checkResult(JCusparse.cusparseZcsc2denseNative(handle, m, n, descrA, cscValA, cscRowIndA, cscColPtrA, A, lda));
    }

    private static native int cusparseZcsc2denseNative(cusparseHandle var0, int var1, int var2, cusparseMatDescr var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, int var8);

    public static int cusparseXcoo2csr(cusparseHandle handle, Pointer cooRowInd, int nnz, int m, Pointer csrRowPtr, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcoo2csrNative(handle, cooRowInd, nnz, m, csrRowPtr, idxBase));
    }

    private static native int cusparseXcoo2csrNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseXcsr2coo(cusparseHandle handle, Pointer csrRowPtr, int nnz, int m, Pointer cooRowInd, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseXcsr2cooNative(handle, csrRowPtr, nnz, m, cooRowInd, idxBase));
    }

    private static native int cusparseXcsr2cooNative(cusparseHandle var0, Pointer var1, int var2, int var3, Pointer var4, int var5);

    public static int cusparseScsr2csc(cusparseHandle handle, int m, int n, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseScsr2cscNative(handle, m, n, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseScsr2cscNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10);

    public static int cusparseDcsr2csc(cusparseHandle handle, int m, int n, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseDcsr2cscNative(handle, m, n, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseDcsr2cscNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10);

    public static int cusparseCcsr2csc(cusparseHandle handle, int m, int n, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseCcsr2cscNative(handle, m, n, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseCcsr2cscNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10);

    public static int cusparseZcsr2csc(cusparseHandle handle, int m, int n, Pointer csrVal, Pointer csrRowPtr, Pointer csrColInd, Pointer cscVal, Pointer cscRowInd, Pointer cscColPtr, int copyValues, int idxBase) {
        return JCusparse.checkResult(JCusparse.cusparseZcsr2cscNative(handle, m, n, csrVal, csrRowPtr, csrColInd, cscVal, cscRowInd, cscColPtr, copyValues, idxBase));
    }

    private static native int cusparseZcsr2cscNative(cusparseHandle var0, int var1, int var2, Pointer var3, Pointer var4, Pointer var5, Pointer var6, Pointer var7, Pointer var8, int var9, int var10);
}

