(ns coconut.repl
  (:require
    [clojure.tools.namespace.repl :as ctnr]
    [clojure.repl :refer :all]
    [clojure.string :as cs]
    [coconut.v1.main :as m]
    [coconut.v1.platform :as platform]
    ))

(defn clear-screen
  []
  (do (print "\033[2J\033[;H")
      (flush)))

(defn generate-uuid
  ([]
   (platform/generate-uuid)))

(defn run-tests*
  ([]
   (do #_(clear-screen)
       (m/run {:reporters [:progress :results]
               :critera [:and
                         [:namespace-matches #"coconut.*-test"]
                         [:not [:has-tag :fixture]]]}))))

(defn run-tests
  ([]
   (ctnr/refresh :after `run-tests*)))
