(ns coconut.v1.aggregation
  #?(:cljs (:require-macros [cljs.core.async.macros :as async]))
  (:require
    [clojure.core.async :as async :refer [<! >!]]
    ))

(defn aggregation
  "Given a reducing function which takes the current state and a value
  from the channel and returns a result containing a collection of events
  to publish to the output channel as well as the updated state, returns
  a channel which will contain the produced events."
  ([f]
   (fn aggregate
     ([c]
      (aggregate c (async/chan 250)))
     ([c ret]
      (async/go
        (loop [state nil]
          (when-let [e (<! c)]
            (let [fret (f state e)]
              (doseq [out (::events fret)]
                (>! ret out))
              (recur (::state fret)))))
        (async/close! ret))
      ret))))

(defn compose
  "Composes multiple aggregation reducing functions. The events
  returned will be the events produced from each aggregation function
  in order."
  ([fs]
   (reduce (fn [f g]
             (fn [state event]
               (let [f-ret (f (::f state) event)
                     g-ret (g (::g state) event)]
                 #::{:events (into (::events f-ret)
                                   (::events g-ret))
                     :state #::{:f (::state f-ret)
                                :g (::state g-ret)}})))
           fs)))
