(ns coconut.v1.console
  (:require
    [coconut.v1.rendering :as rendering]
    [coconut.v1.query :as query]
    [coconut.v1.running :as running]
    [coconut.v1.summarizing :as summarizing]
    [coconut.v1.documentation :as documentation]
    [coconut.v1.util :as util]
    [coconut.v1.platform :as platform]
    ))

(defn ^{:private true} color-string
  ([data]
   (case (::rendering/color data)
     ::rendering/red "color: red;"
     ::rendering/green "color: green;"
     ::rendering/yellow "color: yellow;"
     ::rendering/teal "color: teal;"
     "color: none;")))

(defmulti ^{:private true} print-output
  (fn [data]
    (::rendering/type data)))

(defmethod print-output
  ::rendering/newline
  ([data]
   (js/console.log "")))

(defmethod print-output
  ::rendering/line
  ([data]
   (let [output (transduce (comp (map ::rendering/text)
                                 (map (partial str "%c")))
                           str
                           (::rendering/segments data))
         color-strings (into (vector)
                             (map color-string)
                             (::rendering/segments data))]
     (apply js/console.log output color-strings))))

;; can't print without newline in browser console... what to do!?
(defmethod print-output
  ::rendering/segment
  ([data]
   (let [output (transduce (comp (map ::rendering/text)
                                 (map (partial str "%c")))
                           str
                           (::rendering/segments data))
         color-strings (into (vector)
                             (map color-string)
                             (::rendering/segments data))]
     (apply js/console.log output color-strings))))

(def output
  "Given a core.async channel of output, prints it to
  the browser console. Returns nil."
  (util/channel-consuming print-output))
