(ns coconut.v1.test-namespaces.core
  (:require
    [coconut.v1.core :as c]
    ))

(c/describe "+"
  {:tags #{:fixture
           :3953659b-f974-4aeb-86d3-1e60d3405dfa}}
  (c/it "..." (fn [_])))

(c/describe "contains one of each of the before/after components"
  {:tags #{:fixture
           :7386ca36-2747-4eee-b6fb-8e6270caf3cc}}
  (c/before-all (fn []))
  (c/before-each (fn []))
  (c/after-each (fn []))
  (c/after-all (fn []))
  (c/it "..." (fn [_])))

(c/describe "contains one of each of the before/after components within a let"
  {:tags #{:fixture
           :0fe50449-b0b5-4459-b139-37f05b6fe4c5}}
  (c/let [x nil]
    (c/before-all (fn []))
    (c/before-each (fn []))
    (c/after-each (fn []))
    (c/after-all (fn []))
    (c/it "..." (fn [_]))))

(c/describe "contains one of each of the before/after components within a for containing a single iteration"
  {:tags #{:fixture
           :d2daccd4-dbcb-4a91-a852-4a4d51677520}}
  (c/for [x [0]]
    (c/before-all (fn []))
    (c/before-each (fn []))
    (c/after-each (fn []))
    (c/after-all (fn []))
    (c/it "..." (fn [_]))))

(c/describe "contains multiple empty contexts"
  {:tags #{:fixture
           :830ae88c-3283-44d4-8ac9-c2c9e48e2909}}
  (c/context "one")
  (c/context "two")
  (c/context "three")
  (c/it "..." (fn [_])))

(c/describe "contains multiple empty contexts"
  {:tags #{:fixture
           :4d5e9ee7-add3-446e-9db0-d5c5cedb3631}}
  (c/it "one" (fn [_]))
  (c/it "two" (fn [_]))
  (c/it "three" (fn [_])))

(c/describe "is not marked asynchronous"
  {:tags #{:fixture
           :7c23fd0b-87c3-47c8-81b3-de8683e5d2ef}}
  (c/it "..." (fn [_])))

(c/describe "is marked asynchronous with a timeout"
  {:asynchronous {:timeout 250}
   :tags #{:fixture
           :13e6c394-4a21-4413-adbb-2fb0077e69ff}}
  (c/it "..." (fn [_ _])))

(c/describe "is explicitly marked not asynchronous"
  {:asynchronous false
   :tags #{:fixture
           :ee722610-50b7-490c-afcb-45a6236e95fc}}
  (c/it "..." (fn [_])))

(c/describe "is marked pending with a boolean"
  {:pending true
   :tags #{:fixture
           :9dc702d3-582e-48b7-aba9-b16bd6724547}}
  (c/it "..." (fn [_])))

(c/describe "is marked pending with a reason"
  {:pending "for some reason"
   :tags #{:fixture
           :c4b16359-6954-4497-9f2b-246bae933015}}
  (c/it "..." (fn [_])))

(c/describe "contains tags"
  {:tags #{:foo
           :bar
           :fixture
           :6b76a442-7478-4029-8a44-a8ff363c9f0a}}
  (c/it "..." (fn [_])))

(c/describe "contains an unknown option"
  {:tags #{:fixture
           :bce4c8c7-abcc-46d3-bce1-ad62bb6c43e3}
   ::foo "bar"}
  (c/it "..." (fn [_])))

(c/deftest "+ returns the sum of two numbers"
  {:tags #{:fixture
           :9d198027-a5d3-4f8e-8b5a-8e85489019b8}}
  (fn [_]))

(c/deftest "is not marked asynchronous"
  {:tags #{:fixture
           :53104943-7b89-40d7-a441-360c79e2d30a}}
  (fn [_]))

(c/deftest "is marked asynchronous with a timeout"
  {:asynchronous {:timeout 250}
   :tags #{:fixture
           :70141b5f-22d9-4275-b2ec-7498683423ea}}
  (fn [_]))

(c/deftest "is explicitly marked not asynchronous"
  {:asynchronous false
   :tags #{:fixture
           :a39c7b30-1935-49eb-bbf1-0d8e7eac57e5}}
  (fn [_]))

(c/deftest "is marked pending with a boolean"
  {:pending true
   :tags #{:fixture
           :e65d6526-2bea-420c-aac1-f6e1f3cfddcf}}
  (fn [_]))

(c/deftest "is marked pending with a reason"
  {:pending "for some reason"
   :tags #{:fixture
           :6efead89-6dd2-4477-975a-4f4ca87e402c}}
  (fn [_]))

(c/deftest "contains tags"
  {:tags #{:foo
           :bar
           :fixture
           :6d152479-2ac0-49f5-89f5-e0ffb9818850}}
  (fn [_]))

(c/deftest "contains an unknown option"
  {:tags #{:fixture
           :12d90faa-dda0-4c59-8c6c-94901e0cae92}
   ::foo "bar"}
  (fn [_]))
