(ns aclaimant.server.core.request
  (:require [clojure.walk :refer [postwalk]]
            [clojure.string :as string]))

(defn modify-key-values [aMap func]
  (postwalk (fn [x]
              (if (map? x)
                (into {} (map func x))
                x))
            aMap))

(defn modify-keys-recursive [aMap func]
  (let [f (fn [[k v]] [(func k) v])]
    (modify-key-values aMap f)))

(defn modify-values-recursive [aMap func]
  (let [func' (fn [x] (if (seq? x) (mapv func x) (func x)))
        f (fn [[k v]] [k (func' v)])]
    (modify-key-values aMap f)))

(defn snake->dashify-word [word]
  (when word
    (let [finish-fn (if (keyword? word) keyword identity)]
      (-> word
          name
          (string/replace #"[A-Z]" (fn [m] (str "-" (string/lower-case m))))
          (string/replace #"^-" "")
          (string/replace #"_" "-")
          finish-fn))))

(defn dashify->snake [word]
  (when word
    (let [finish-fn (if (keyword? word) keyword identity)]
      (-> word
          name
          (string/replace #"_" "-")
          (string/replace #"-(\w)" (fn [[_ m]] (string/upper-case m)))
          finish-fn))))

(defn dashify-keys
  ([aMap]
   (dashify-keys aMap {:keywordize? false}))
  ([aMap {:keys [keywordize?]}]
   (let [f (if keywordize?
             (comp keyword snake->dashify-word)
             snake->dashify-word)]
     (modify-keys-recursive aMap f))))

(defn jsonify-keys [aMap]
  (modify-keys-recursive aMap dashify->snake))

(defn api-upgrade?
  [req]
  (when-let [api-upgrade (get-in req [:headers "x-aclaimant-api-upgrade"])]
    (= "true" (string/lower-case (str api-upgrade)))))
