(ns com.adgoji.cm-api.client
  (:require
   [com.adgoji.cm-client.interface :as cm-client]
   [com.adgoji.google-credential.interface :as google-credential])
  (:import
   (com.google.api.client.auth.oauth2 Credential)
   (com.google.api.services.dfareporting Dfareporting DfareportingScopes)))

(def ^:private ->scope
  {:dfareporting   DfareportingScopes/DFAREPORTING
   :ddmconversions DfareportingScopes/DDMCONVERSIONS
   :dfatrafficking DfareportingScopes/DFATRAFFICKING})

(defn- convert-scopes
  [scopes]
  (if (coll? scopes)
    (into #{}
          (comp (map (fn [scope]
                       (if (keyword? scope)
                         (->scope scope)
                         scope)))
                (remove nil?)
                (filter #(contains? (set (DfareportingScopes/all)) %)))
          scopes)
    (if (and (keyword? scopes)
             (= :all ^clojure.lang.Keyword scopes))
      (set (DfareportingScopes/all))
      (throw (ex-info "Invalid scopes" {:scopes scopes})))))

(defn google-credential
  [opts]
  (google-credential/new (update opts :scopes convert-scopes)))

(defn new
  ^Dfareporting
  [^Credential credential ^String application-name opts]
  (cm-client/new credential application-name opts))
