(ns com.adgoji.api.utils.api
  (:require
   [camel-snake-kebab.core :as csk]
   [clojure.core.memoize :as m]
   [clojure.java.data :as j]
   [camel-snake-kebab.extras :as cske])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideoRequest)))

(set! *warn-on-reflection* true)

(def ^:private memoized->kebab-case-keyword
  (m/fifo csk/->kebab-case-keyword {} :fifo/threshold 512))

(defn execute
  [^DisplayVideoRequest request]
  (.execute request))

(defn execute-and-convert
  "Execute Google API request and convert response to clojure data."
  [^DisplayVideoRequest request]
  (let [response (-> request
                     (execute)
                     (j/from-java-deep {}))]
    (cske/transform-keys memoized->kebab-case-keyword response)))

(defn execute-and-convert-paginated
  "Execute Google API request and covert response to clojure data.

  If `next-page-token` in the response is not empty, fetch next page
  using this token until all pages are consumed. Return only `limit`
  number of entries."
  [fetch-page-fn vkey limit]
  (let [xform (if limit
                (comp cat (take limit))
                cat)]
    (->> (iteration fetch-page-fn
                    :kf :next-page-token
                    :vf vkey
                    :initk nil)
         (into [] xform))))
