(ns com.adgoji.displayvideo-api.advertisers.insertion-orders
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.insertion-orders.interface :as insertion-orders]))

(defn create
  "Create a new insertion-order.

  For insertionOrders.create method, only ENTITY_STATUS_DRAFT is
  allowed.

  To activate an insertion order, use insertionOrders.patch method and
  update the status to ENTITY_STATUS_ACTIVE after creation."
  [client advertiser-id insertion-order]
  (insertion-orders/create client advertiser-id insertion-order))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order ::displayvideo-spec/insertion-order)
  :ret ::displayvideo-spec/insertion-order)

(defn delete
  "Delete an insertion-order by `advertiser-id` and `insertion-order-id`."
  [client advertiser-id insertion-order-id]
  (insertion-orders/delete client advertiser-id insertion-order-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Returns a single insertion-order by `insertion-order-id`."
  [client advertiser-id insertion-order-id]
  (insertion-orders/get-by-id client advertiser-id insertion-order-id))

(s/fdef get-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id)
  :ret ::displayvideo-spec/insertion-order)

(defn get-list
  "Returns a list of all campaigns insertion orders"
  [client advertiser-id opts]
  (insertion-orders/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/insertion-orders)

(defn update-by-id
  "Update an existing insertion-order by `advertiser-id` and `insertion-order-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords).

  An insertion order cannot be changed back to ENTITY_STATUS_DRAFT
  status from any other status.

  An insertion order cannot be set to ENTITY_STATUS_ACTIVE if its
  parent campaign is not active.

  To activate an insertion order, use insertionOrders.patch method and
  update the status to ENTITY_STATUS_ACTIVE after creation."
  [client advertiser-id insertion-order-id insertion-order update-mask]
  (insertion-orders/update-by-id client
                                 advertiser-id
                                 insertion-order-id
                                 insertion-order
                                 update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :insertion-order-id ::displayvideo-spec/insertion-order-id
               :insertion-order ::displayvideo-spec/insertion-order
               :update-mask ::displayvideo-spec/update-mask)
  :ret ::displayvideo-spec/insertion-order)
