(ns com.adgoji.displayvideo-api.advertisers.channels.sites
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.advertisers-channels-sites.interface :as sites]))

(defn bulk-edit
  "Bulk edits sites under a single channel."
  [client advertiser-id channel-id bulk-edit-request]
  (sites/bulk-edit client advertiser-id channel-id bulk-edit-request))

(s/fdef bulk-edit
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :channel-id ::displayvideo-spec/channel-id
               :bulk-edit-request ::displayvideo-spec/bulk-edit-sites-request)
  :ret ::displayvideo-spec/sites)

(defn create
  "Creates a site in a channel"
  [client advertiser-id channel-id site]
  (sites/create client advertiser-id channel-id site))

(s/fdef create
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :channel-id ::displayvideo-spec/channel-id
               :site ::displayvideo-spec/site)
  :ret ::displayvideo-spec/site)

(defn replace-sites
  "Replaces all of the sites under a single channel."
  [client advertiser-id channel-id replace-sites]
  (sites/replace-sites client
                       advertiser-id
                       channel-id
                       replace-sites))

(s/fdef replace-sites
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :channel-id ::displayvideo-spec/channel-id
               :replace-sites ::displayvideo-spec/replace-sites-request)
  :ret ::displayvideo-spec/sites)

(defn get-list
  "Lists sites in a channel."
  [client advertiser-id channel-id opts]
  (sites/get-list client advertiser-id channel-id opts))

(s/fdef get-list
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :channel-id ::displayvideo-spec/channel-id
               :opts (s/keys :opt-un [::displayvideo-spec/order-by
                                      ::displayvideo-spec/filter-expr
                                      ::displayvideo-spec/limit]))
  :ret ::displayvideo-spec/sites)

(defn delete
  "Deletes a site from a channel."
  [client advertiser-id channel-id url-or-app-id]
  (sites/delete client advertiser-id channel-id url-or-app-id))

(s/fdef delete
  :args (s/cat :client ::displayvideo-spec/displayvideo-client
               :advertiser-id ::displayvideo-spec/advertiser-id
               :channel-id ::displayvideo-spec/channel-id
               :url-or-app-id ::displayvideo-spec/url-or-app-id)
  :ret (s/and map? empty?))
