(ns com.adgoji.google-audiences.core
  (:require
   [com.adgoji.displayvideo-spec.interface :as displayvideo-spec]
   [com.adgoji.sdk-client-utils.interface :as sdk-client-utils]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo DisplayVideo$GoogleAudiences$List)))

(defn get-by-id
  [^DisplayVideo client google-audience-id {:keys [advertiser-id partner-id] :as accessor-map}]
  (cond
    (and advertiser-id partner-id)
    (throw (ex-info "Only 1 accessor is allowed" {:accessor accessor-map}))

    (and (not advertiser-id) (not partner-id))
    (throw (ex-info "Missing accessor" {}))

    :else
    (let [request (cond-> (-> client
                              (.googleAudiences)
                              (.get (long google-audience-id)))
                    advertiser-id (.setAdvertiserId advertiser-id)
                    partner-id    (.setPartnerId partner-id))]
      (-> request
          (sdk-client-utils/execute-and-convert)
          (spec/check ::displayvideo-spec/google-audience)))))

(defn- fetch-google-audiences-page
  [^DisplayVideo$GoogleAudiences$List request ^String next-page-token]
  (-> request
      (.setPageToken next-page-token)
      (sdk-client-utils/execute-and-convert)))

(defn get-list
  [^DisplayVideo client
   {:keys [advertiser-id partner-id] :as accessor-map}
   {:keys [order-by limit filter-expr]}]
  (cond
    (and advertiser-id partner-id)
    (throw (ex-info "Only 1 accessor is allowed" {:accessor accessor-map}))

    (and (not advertiser-id) (not partner-id))
    (throw (ex-info "Missing accessor" {}))

    :else
    (let [request  (cond-> (.list (.googleAudiences client))
                     advertiser-id (.setAdvertiserId advertiser-id)
                     partner-id    (.setPartnerId partner-id)
                     order-by      (.setOrderBy order-by)
                     filter-expr   (.setFilter filter-expr))
          fetch-fn (partial fetch-google-audiences-page request)]
      (-> (sdk-client-utils/execute-and-convert-paginated fetch-fn
                                                          :google-audiences
                                                          limit)
          (spec/check ::displayvideo-spec/google-audiences)))))
