(ns  com.adgoji.displayvideo-spec.displayvideo.assigned-targeting-option
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.displayvideo-spec.displayvideo.age-range-targeting-option-details
    :as age-range-details]
   [com.adgoji.displayvideo-spec.displayvideo.app-assigned-targeting-option-details
    :as app-details]
   [com.adgoji.displayvideo-spec.displayvideo.audience-group-assigned-targeting-option-details
    :as audience-group-details]
   [com.adgoji.displayvideo-spec.displayvideo.audio-content-type-targeting-option-details
    :as audio-content-type-details]
   [com.adgoji.displayvideo-spec.displayvideo.authorized-seller-status-targeting-option-details
    :as authorized-seller-status-details]
   [com.adgoji.displayvideo-spec.displayvideo.channel-assigned-targeting-option-details
    :as channel-details]
   [com.adgoji.displayvideo-spec.displayvideo.common-assigned-targeting-option-details
    :as common-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-duration-targeting-option-details
    :as content-duration-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-instream-position-targeting-option-details
    :as content-instream-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-outstream-position-targeting-option-details
    :as content-outstream-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.content-stream-type-targeting-option-details
    :as content-stream-type-details]
   [com.adgoji.displayvideo-spec.displayvideo.day-and-time-assigned-targeting-option-details
    :as day-and-time-details]
   [com.adgoji.displayvideo-spec.displayvideo.device-type-assigned-targeting-option-details
    :as device-type-details]
   [com.adgoji.displayvideo-spec.displayvideo.digital-content-label-exclusion-assigned-targeting-option-details
    :as digital-content-label-exclusion-details]
   [com.adgoji.displayvideo-spec.displayvideo.environment-targeting-option-details
    :as environment-details]
   [com.adgoji.displayvideo-spec.displayvideo.exchange-targeting-option-details
    :as exchange-details]
   [com.adgoji.displayvideo-spec.displayvideo.gender-targeting-option-details
    :as gender-details]
   [com.adgoji.displayvideo-spec.displayvideo.geo-region-targeting-option-details
    :as geo-region-details]
   [com.adgoji.displayvideo-spec.displayvideo.household-income-targeting-option-details
    :as household-income-details]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source-assigned-targeting-option-details
    :as inventory-source-details]
   [com.adgoji.displayvideo-spec.displayvideo.inventory-source-group-assigned-targeting-option-details
    :as inventory-source-group-details]
   [com.adgoji.displayvideo-spec.displayvideo.keyword-assigned-targeting-option-details
    :as keyword-details]
   [com.adgoji.displayvideo-spec.displayvideo.native-content-position-targeting-option-details
    :as native-content-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.negative-keyword-list-assigned-targeting-option-details
    :as negative-keyword-list-details]
   [com.adgoji.displayvideo-spec.displayvideo.omid-targeting-option-details
    :as omid-details]
   [com.adgoji.displayvideo-spec.displayvideo.on-screen-position-targeting-option-details
    :as on-screen-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.parental-status-targeting-option-details
    :as parental-status-details]
   [com.adgoji.displayvideo-spec.displayvideo.poi-targeting-option-details
    :as poi-details]
   [com.adgoji.displayvideo-spec.displayvideo.proximity-location-list-assigned-targeting-option-details
    :as proximity-location-list-details]
   [com.adgoji.displayvideo-spec.displayvideo.regional-location-list-assigned-targeting-option-details
    :as regional-location-list-details]
   [com.adgoji.displayvideo-spec.displayvideo.sensitive-category-assigned-targeting-option-details
    :as sensitive-category-details]
   [com.adgoji.displayvideo-spec.displayvideo.session-position-assigned-targeting-option-details
    :as session-position-details]
   [com.adgoji.displayvideo-spec.displayvideo.third-party-verifier-assigned-targeting-option-details
    :as third-party-verifier-details]
   [com.adgoji.displayvideo-spec.displayvideo.url-assigned-targeting-option
    :as url-details]
   [com.adgoji.displayvideo-spec.displayvideo.user-rewarded-content-targeting-option-details
    :as user-rewarded-content-details]
   [com.adgoji.displayvideo-spec.displayvideo.video-player-size-targeting-option-details
    :as video-player-size-details]
   [com.adgoji.displayvideo-spec.displayvideo.viewability-targeting-option-details
    :as viewability-details]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-channel-assigned-targeting-option-details
    :as youtube-channel-details]
   [com.adgoji.displayvideo-spec.displayvideo.youtube-video-assigned-targeting-option-details
    :as youtube-video-details]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.targeting-type :as targeting-type]))

(s/def ::name string?)

(s/def ::assigned-targeting-option-id string?)

(s/def ::assigned-targeting-option-id-alias string?)

(s/def ::inheritance
  #{"INHERITANCE_UNSPECIFIED"
    "INHERITED_FROM_PARTNER"
    "NOT_INHERITED"
    "INHERITED_FROM_ADVERTISER"})

;; Union field of details starts here.

(s/def ::channel-details
  (spec/only-keys :req-un [::channel-details/channel-id]
                  :opt-un [::common-details/negative]))

(s/def ::app-category-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::app-details
  (spec/only-keys :req-un [::app-details/app-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative
                           ::app-details/app-platform]))

(s/def ::url-details
  (spec/only-keys :req-un [::url-details/url]
                  :opt-un [::common-details/negative]))

(s/def ::day-and-time-details
  (spec/only-keys :req-un [::day-and-time-details/day-of-week
                           ::day-and-time-details/time-zone-resolution]
                  :opt-un [::day-and-time-details/start-hour
                           ::day-and-time-details/end-hour]))

(s/def ::age-range-details
  (spec/only-keys :req-un [::age-range-details/age-range]))

(s/def ::regional-location-list-details
  (spec/only-keys :req-un [::regional-location-list-details/regional-location-list-id]
                  :opt-un [::common-details/negative]))

(s/def ::proximity-location-list-details
  (spec/only-keys :req-un [::proximity-location-list-details/proximity-location-list-id
                           ::proximity-location-list-details/proximity-radius
                           ::proximity-location-list-details/proximity-radius-unit]))

(s/def ::gender-details
  (spec/only-keys :req-un [::gender-details/gender]))

(s/def ::video-player-size-details
  (spec/only-keys :req-un [::video-player-size-details/video-player-size]))

(s/def ::user-rewarded-content-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::user-rewarded-content-details/user-rewarded-content]))

(s/def ::parental-status-details
  (spec/only-keys :req-un [::parental-status-details/parental-status]))

(s/def ::content-instream-position-details
  (spec/only-keys :req-un [::content-instream-position-details/content-instream-position]
                  :opt-un [::common-details/ad-type]))

(s/def ::content-outstream-position-details
  (spec/only-keys :req-un [::content-outstream-position-details/content-outstream-position]
                  :opt-un [::common-details/ad-type]))

(s/def ::device-type-details
  (spec/only-keys :req-un [::device-type-details/device-type]
                  :opt-un [::device-type-details/youtube-and-partners-bid-multiplier]))

(s/def ::audience-group-details
  (spec/only-keys :opt-un [::audience-group-details/included-first-and-third-party-audience-groups
                           ::audience-group-details/included-google-audience-group
                           ::audience-group-details/included-custom-list-group
                           ::audience-group-details/included-combined-audience-group
                           ::audience-group-details/excluded-first-and-third-party-audience-groups
                           ::audience-group-details/excluded-google-audience-group]))

(s/def ::browser-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::household-income-details
  (spec/only-keys :req-un [::household-income-details/household-income]))

(s/def ::on-screen-position-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::on-screen-position-details/on-screen-position
                           ::common-details/ad-type]))

(s/def ::carrier-and-isp-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))
(s/def ::keyword-details
  (spec/only-keys :req-un [::keyword-details/keyword]
                  :opt-un [::common-details/negative]))

(s/def ::negative-keyword-list-details
  (spec/only-keys :req-un [::negative-keyword-list-details/negative-keyword-list-id]))

(s/def ::operating-system-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::device-make-model-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::environment-details
  (spec/only-keys :req-un [::environment-details/environment]))

(s/def ::inventory-source-details
  (spec/only-keys :req-un [::inventory-source-details/inventory-source-id]))

(s/def ::category-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::viewability-details
  (spec/only-keys :req-un [::viewability-details/viewability]))

(s/def ::authorized-seller-status-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::authorized-seller-status-details/authorized-seller-status]))

(s/def ::language-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::geo-region-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::geo-region-details/geo-region-type
                           ::common-details/negative]))

(s/def ::inventory-source-group-details
  (spec/only-keys :req-un [::inventory-source-group-details/inventory-source-group-id]))

(s/def ::digital-content-label-exclusion-details
  (spec/only-keys :req-un [::digital-content-label-exclusion-details/excluded-content-rating-tier]))

(s/def ::sensitive-category-exclusion-details
  (spec/only-keys :req-un [::sensitive-category-details/excluded-sensitive-category]))

(s/def ::exchange-details
  (spec/only-keys :req-un [::exchange-details/exchange]))

(s/def ::sub-exchange-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]))

;;TODO change to `defmulti`
(s/def ::third-party-verifier-details
  (spec/only-keys :opt-un [::third-party-verifier-details/adloox
                           ::third-party-verifier-details/double-verify
                           ::third-party-verifier-details/integral-ad-science]))

(s/def ::poi-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::poi-details/latitude
                           ::poi-details/longitude
                           ::common-details/proximity-radius-amount
                           ::common-details/proximity-radius-unit]))

(s/def ::business-chain-details
  (spec/only-keys :req-un [::common-details/targeting-option-id
                           ::common-details/proximity-radius-amount
                           ::common-details/proximity-radius-unit]
                  :opt-un [::common-details/display-name]))

(s/def ::content-duration-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::content-duration-details/content-duration]))

(s/def ::content-stream-type-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::content-stream-type-details/content-stream-type]))

(s/def ::native-content-position-details
  (spec/only-keys :req-un [::native-content-position-details/content-position]))

(s/def ::omid-details
  (spec/only-keys :req-un [::omid-details/omid]))

(s/def ::audio-content-type-details
  (spec/only-keys :req-un [::audio-content-type-details/audio-content-type]))

(s/def ::content-genre-details
  (spec/only-keys :req-un [::common-details/targeting-option-id]
                  :opt-un [::common-details/display-name
                           ::common-details/negative]))

(s/def ::youtube-video-details
  (spec/only-keys :opt-un [::youtube-video-details/video-id
                           ::common-details/negative]))

(s/def ::youtube-channel-details
  (spec/only-keys :opt-un [::youtube-channel-details/channel-id
                           ::common-details/negative]))

(s/def ::session-position-details
  (spec/only-keys :opt-un [::session-position-details/session-position]))

;; End of list of possible types for union field details

(s/def ::spec
  (spec/only-keys :opt-un [::name
                           ::assigned-targeting-option-id
                           ::assigned-targeting-option-id-alias
                           ::targeting-type/targeting-type
                           ::inheritance
                           ::channel-details
                           ::app-category-details
                           ::app-details
                           ::url-details
                           ::day-and-time-details
                           ::age-range-details
                           ::regional-location-list-details
                           ::proximity-location-list-details
                           ::gender-details
                           ::video-player-size-details
                           ::user-rewarded-content-details
                           ::parental-status-details
                           ::content-instream-position-details
                           ::content-outstream-position-details
                           ::device-type-details
                           ::audience-group-details
                           ::browser-details
                           ::household-income-details
                           ::on-screen-position-details
                           ::carrier-and-isp-details
                           ::keyword-details
                           ::negative-keyword-list-details
                           ::operating-system-details
                           ::device-make-model-details
                           ::environment-details
                           ::inventory-source-details
                           ::category-details
                           ::viewability-details
                           ::authorized-seller-status-details
                           ::language-details
                           ::geo-region-details
                           ::inventory-source-group-details
                           ::digital-content-label-exclusion-details
                           ::sensitive-category-exclusion-details
                           ::exchange-details
                           ::sub-exchange-details
                           ::third-party-verifier-details
                           ::poi-details
                           ::business-chain-details
                           ::content-duration-details
                           ::content-stream-type-details
                           ::native-content-position-details
                           ::omid-details
                           ::audio-content-type-details
                           ::content-genre-details
                           ::youtube-video-details
                           ::youtube-channel-details
                           ::session-position-details]))
