(ns com.adgoji.displayvideo-spec.displayvideo.advertiser
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.general-config :as advertiser.general-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.ad-server-config :as advertiser.ad-server-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.creative-config :as advertiser.creative-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.data-access-config :as advertiser.data-access-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.targeting-config :as advertiser.targeting-config]
   [com.adgoji.displayvideo-spec.displayvideo.advertiser.billing-config :as advertiser.billing-config]
   [com.adgoji.displayvideo-spec.displayvideo.integration-details :as integration-details]
   [com.adgoji.displayvideo-spec.displayvideo.partner :as partner]))

(s/def ::name string?)
(s/def ::advertiser-id int?)
(s/def ::display-name string?)
(s/def ::entity-status
  #{"ENTITY_STATUS_ACTIVE"
    "ENTITY_STATUS_PAUSED"
    "ENTITY_STATUS_SCHEDULED_FOR_DELETION"})
(s/def ::update-time string?)
(s/def ::prisma-enabled boolean?)
(s/def ::general-config
  (spec/only-keys :req-un [::advertiser.general-config/domain-url
                           ::advertiser.general-config/currency-code]
                  :opt-un [::advertiser.general-config/time-zone]))

(defmulti ad-server-config-spec keys)

(defmethod ad-server-config-spec '(:third-party-only-config)
  [_]
  (spec/only-keys :req-un [::advertiser.ad-server-config/third-party-only-config]))

(defmethod ad-server-config-spec '(:cm-hybrid-config)
  [_]
  (spec/only-keys :req-un [::advertiser.ad-server-config/cm-hybrid-config]))

(s/def ::ad-server-config (s/multi-spec ad-server-config-spec ::ad-server-config))
(s/def ::creative-config
  (spec/only-keys :opt-un [::advertiser.creative-config/ias-client-id
                           ::advertiser.creative-config/oba-compliance-disabled
                           ::advertiser.creative-config/dynamic-creative-enabled
                           ::advertiser.creative-config/video-creative-data-sharing-authorized]))

(s/def ::data-access-config
  (spec/only-keys :opt-un [::advertiser.data-access-config/sdf-config]))

(s/def ::integration-details
  (spec/only-keys :opt-un [::integration-details/integration-code
                           ::integration-details/details]))

(s/def ::serving-config
  (spec/only-keys :opt-un [::advertiser.targeting-config/exempt-tv-from-viewability-targeting]))

(s/def ::billing-config
  (spec/only-keys :opt-un [::advertiser.billing-config/billing-profile-id]))

(s/def ::spec
  (spec/only-keys :req-un [::partner/partner-id
                           ::display-name
                           ::entity-status
                           ::general-config
                           ::ad-server-config
                           ::creative-config]
                  :opt-un [::name
                           ::advertiser-id
                           ::update-time
                           ::prisma-enabled
                           ::data-access-config
                           ::integration-details
                           ::serving-config
                           ::billing-config]))

(s/def ::update-spec
  (spec/only-keys :opt-un [::partner/partner-id
                           ::display-name
                           ::entity-status
                           ::general-config
                           ::ad-server-config
                           ::creative-config
                           ::name
                           ::advertiser-id
                           ::update-time
                           ::prisma-enabled
                           ::data-access-config
                           ::integration-details
                           ::serving-config
                           ::billing-config]))
