(ns com.adgoji.advertisers.interface
  (:require
   [com.adgoji.advertisers.core :as core])
  (:import com.google.api.services.displayvideo.v2.DisplayVideo))

(defn get-list
  [^DisplayVideo client partner-id opts]
  (core/get-list client partner-id opts))

(defn get-by-id
  [^DisplayVideo client advertiser-id]
  (core/get-by-id client advertiser-id))

(defn create
  [^DisplayVideo client advertiser]
  (core/create client advertiser))

(defn delete
  [^DisplayVideo client advertiser-id]
  (core/delete client advertiser-id))

(defn update-by-id
  [^DisplayVideo client advertiser-id advertiser update-mask]
  (core/update-by-id client advertiser-id advertiser update-mask))
