(ns com.adgoji.displayvideo-api.advertisers.campaigns
  (:require
   [com.adgoji.campaigns.interface :as campaigns]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  "Create a new campaign."
  [^DisplayVideo client advertiser-id campaign]
  (campaigns/create client advertiser-id campaign))

(s/fdef create
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :campaign ::spec/campaign)
  :ret ::spec/campaign)

(defn delete
  "Delete campaign by `advertiser-id` and `campaign-id`."
  [^DisplayVideo client advertiser-id campaign-id]
  (campaigns/delete client advertiser-id campaign-id))

(s/fdef delete
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :campaign-id ::spec/campaign-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Get a single campaign by `advertiser-id` and `campaign-id`."
  [^DisplayVideo client advertiser-id campaign-id]
  (campaigns/get-by-id client advertiser-id campaign-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :campaign-id ::spec/campaign-id)
  :ret ::spec/campaign)

(defn get-list
  "Returns a list of all advertiser's campaigns."
  [^DisplayVideo client advertiser-id opts]
  (campaigns/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/campaigns)

(defn update-by-id
  "Update an existing campaign by `advertiser-id` and `campaign-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [^DisplayVideo client advertiser-id campaign-id campaign update-mask]
  (campaigns/update-by-id client
                          advertiser-id
                          campaign-id
                          campaign
                          update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :campaign-id ::spec/campaign-id
               :campaign ::spec/campaign
               :update-mask ::spec/update-mask)
  :ret ::spec/campaign)
