(ns com.adgoji.displayvideo-api.advertisers.creatives
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo))
  (:require
   [com.adgoji.creatives.interface :as creatives]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec]))

(defn create
  "Create a new asset."
  [^DisplayVideo client advertiser-id creative]
  (creatives/create client advertiser-id creative))

(s/fdef create
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :creative ::spec/creative)
  :ret ::spec/creative)

(defn delete
  "Delete creative by `advertiser-id` and `creative-id`.

  It is only possible to delete archived creatives, for all other
  creatives Google will throw an exception. To archive a creative one
  should use [[update-by-id]] function and set `:entity-status` to
  \"ENTITY_STATUS_ARCHIVED\" value."
  [^DisplayVideo client advertiser-id creative-id]
  (creatives/delete client advertiser-id creative-id))

(s/fdef delete
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :creative-id ::spec/creative-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Get a single creative by `advertiser-id` and `creative-id`."
  [^DisplayVideo client advertiser-id creative-id]
  (creatives/get-by-id client advertiser-id creative-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :creative-id ::spec/creative-id)
  :ret ::spec/creative)

(defn get-list
  "Returns a list of all advertiser's creatives."
  [^DisplayVideo client advertiser-id opts]
  (creatives/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/creatives)

(defn update-by-id
  "Update an existing creative by `advertiser-id` and `creative-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords)."
  [^DisplayVideo client advertiser-id creative-id creative update-mask]
  (creatives/update-by-id client advertiser-id creative-id creative update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::spec/client
               :advertiser-id ::spec/advertiser-id
               :creative-id ::spec/creative-id
               :creative ::spec/creative
               :update-mask ::spec/update-mask)
  :ret ::spec/creative)
