(ns com.adgoji.spec.displayvideo
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.displayvideo.advertiser :as advertiser]
   [com.adgoji.spec.displayvideo.create-asset-request
    :as create-asset-request]
   [com.adgoji.spec.displayvideo.create-asset-response
    :as create-asset-response]
   [com.adgoji.spec.displayvideo.creative :as creative]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.campaign :as campaign]
   [com.adgoji.spec.displayvideo.line-item :as line-item]
   [com.adgoji.spec.displayvideo.insertion-order :as insertion-order])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(s/def ::client (partial instance? DisplayVideo))
(s/def ::order-by string?)
(s/def ::filter-expr string?)
(s/def ::limit int?)

(s/def ::advertiser
  (spec.utils/only-keys :req-un [::advertiser/partner-id
                                 ::advertiser/display-name
                                 ::advertiser/entity-status
                                 ::advertiser/general-config
                                 ::advertiser/ad-server-config
                                 ::advertiser/creative-config]
                        :opt-un [::advertiser/name
                                 ::advertiser/advertiser-id
                                 ::advertiser/update-time
                                 ::advertiser/prisma-enabled
                                 ::advertiser/data-access-config
                                 ::advertiser/integration-details
                                 ::advertiser/serving-config
                                 ::advertiser/billing-config]))

(s/def ::advertisers
  (s/coll-of ::advertiser :distinct true :into []))

(s/def ::update-mask
  (s/coll-of keyword? :distinct true :into []))

(s/def ::create-asset-request
  (spec.utils/only-keys :req-un [::create-asset-request/filename]))

(s/def ::create-asset-response
  (spec.utils/only-keys :req-un [::create-asset-response/asset]))

(s/def ::creative
  (spec.utils/only-keys :req-un [::creative/display-name
                                 ::creative/entity-status
                                 ::creative/creative-type
                                 ::creative/hosting-source
                                 ::creative/dimensions]
                        :opt-un [::creative/name
                                 ::creative/advertiser-id
                                 ::creative/creative-id
                                 ::creative/assets
                                 ::creative/cm-placement-id
                                 ::creative/update-time
                                 ::creative/create-time
                                 ::creative/dynamic
                                 ::creative/additional-dimensions
                                 ::creative/media-duration
                                 ::creative/creative-attributes
                                 ::creative/review-status
                                 ::creative/exit-events
                                 ::creative/timer-events
                                 ::creative/counter-events
                                 ::creative/appended-tag
                                 ::creative/integration-code
                                 ::creative/notes
                                 ::creative/ias-campaign-monitoring
                                 ::creative/companion-creative-ids
                                 ::creative/skippable
                                 ::creative/skip-offset
                                 ::creative/progress-offset
                                 ::creative/universal-ad-id
                                 ::creative/third-party-urls
                                 ::creative/transcodes
                                 ::creative/tracker-urls
                                 ::creative/js-tracker-url
                                 ::creative/cm-tracking-ad
                                 ::creative/oba-icon
                                 ::creative/third-party-tag
                                 ::creative/require-mraid
                                 ::creative/require-html5
                                 ::creative/require-ping-for-attribution
                                 ::creative/expanding-direction
                                 ::creative/expand-on-hover
                                 ::creative/vast-tag-url
                                 ::creative/vpaid
                                 ::creative/html5-video
                                 ::creative/line-item-ids
                                 ::creative/mp3-audio
                                 ::creative/ogg-audio]))

(s/def ::creatives
  (s/coll-of ::creative :distinct true :into []))

(s/def ::campaign
  (spec.utils/only-keys :req-un [::campaign/display-name
                                 ::campaign/entity-status
                                 ::campaign/campaign-goal
                                 ::campaign/campaign-flight
                                 ::campaign/frequency-cap]
                        :opt-un [::campaign/name
                                 ::advertiser/advertiser-id
                                 ::campaign/campaign-id
                                 ::campaign/update-time
                                 ::campaign/campaign-budgets]))

(s/def ::campaigns
  (s/coll-of ::campaign :distinct true :into []))

(s/def ::line-item
  (spec.utils/only-keys :req-un [::line-item/bid-strategy
                                 ::line-item/budget
                                 ::line-item/display-name
                                 ::line-item/entity-status
                                 ::line-item/flight
                                 ::line-item/frequency-cap
                                 ::line-item/insertion-order-id
                                 ::line-item/line-item-type
                                 ::line-item/pacing
                                 ::line-item/partner-revenue-model]
                        :opt-un [::advertiser/advertiser-id
                                 ::campaign/campaign-id
                                 ::line-item/conversion-counting
                                 ::line-item/creative-ids
                                 ::line-item/exclude-new-changes
                                 ::line-item/integration-details
                                 ::line-item/line-item-id
                                 ::line-item/mobile-app
                                 ::line-item/name
                                 ::line-item/partner-costs
                                 ::line-item/reservation-type
                                 ::line-item/targeting-expansion
                                 ::line-item/update-time
                                 ::line-item/warning-messages
                                 ::line-item/youtube-partner-settings]))

(s/def ::line-items
  (s/coll-of ::line-item :distinct true :into []))

(s/def ::insertion-order
  (spec.utils/only-keys :req-un [::insertion-order/display-name
                                 ::campaign/campaign-id
                                 ::insertion-order/entity-status
                                 ::insertion-order/pacing
                                 ::insertion-order/frequency-cap
                                 ::insertion-order/performance-goal
                                 ::insertion-order/budget]
                        :opt-un [::insertion-order/name
                                 ::advertiser/advertiser-id
                                 ::insertion-order/insertion-order-id
                                 ::insertion-order/insertion-order-type
                                 ::insertion-order/update-time
                                 ::insertion-order/partner-costs
                                 ::insertion-order/integration-details
                                 ::insertion-order/bid-strategy
                                 ::insertion-order/reservation-type
                                 ::insertion-order/billable-outcome]))

(s/def ::insertion-orders
  (s/coll-of ::insertion-order :distinct true :into []))
