(ns com.adgoji.spec.displayvideo.insertion-order.budget
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.date-range :as date-range]))

(s/def ::budget-unit
  #{"BUDGET_UNIT_UNSPECIFIED"
    "BUDGET_UNIT_CURRENCY"
    "BUDGET_UNIT_IMPRESSIONS"})

(s/def ::automation-type
  #{"INSERTION_ORDER_AUTOMATION_TYPE_UNSPECIFIED"
    "INSERTION_ORDER_AUTOMATION_TYPE_BUDGET"
    "INSERTION_ORDER_AUTOMATION_TYPE_NONE"
    "INSERTION_ORDER_AUTOMATION_TYPE_BID_BUDGET"})

;; Must be greater than 0. For example, 500000000 represents 500 standard units of the currency.
(s/def ::budget-amount-micros pos-int?)
(s/def ::description string?)
(s/def ::campaign-budget-id int?)

(s/def ::budget-segment
  (spec.utils/only-keys :req-un [::budget-amount-micros
                                 ::date-range]
                        :opt-un [::description
                                 ::campaign-budget-id]))

(s/def ::budget-segments
  (s/coll-of ::budget-segment :into []))

(s/def ::date-range
  (spec.utils/only-keys :opt-un [::date-range/start-date
                                 ::date-range/end-date]))
