(ns com.adgoji.campaigns.interface
  (:require
   [com.adgoji.campaigns.core :as campaigns.core])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  [^DisplayVideo client advertiser-id campaign]
  (campaigns.core/create client advertiser-id campaign))

(defn delete
  [^DisplayVideo client advertiser-id campaign-id]
  (campaigns.core/delete client advertiser-id campaign-id))

(defn get-by-id
  [^DisplayVideo client advertiser-id campaign-id]
  (campaigns.core/get-by-id client advertiser-id campaign-id))

(defn get-list
  [^DisplayVideo client advertiser-id opts]
  (campaigns.core/get-list client advertiser-id opts))

(defn update-by-id
  [^DisplayVideo client advertiser-id campaign-id campaign update-mask]
  (campaigns.core/update-by-id client
                               advertiser-id
                               campaign-id
                               campaign
                               update-mask))
