(ns com.adgoji.displayvideo-api.advertisers
  (:require
   [com.adgoji.advertisers.interface :as advertisers]
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.interface :as spec])
  (:import com.google.api.services.displayvideo.v2.DisplayVideo))

(defn get-list
  "Returns a list of available advertisers by `partner-id`."
  [^DisplayVideo client partner-id opts]
  (advertisers/get-list client partner-id opts))

(s/fdef get-list
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/advertisers)

(defn get-by-id
  "Returns a single advertiser by `advertiser-id`."
  [^DisplayVideo client advertiser-id]
  (advertisers/get-by-id client advertiser-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id)
  :ret ::spec/advertiser)

(defn create
  "Create a new advertiser."
  [^DisplayVideo client advertiser]
  (advertisers/create client advertiser))

(s/fdef create
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser ::spec/advertiser)
  :ret ::spec/advertiser)

(defn delete
  "Delete an advertives by `advertiser-id`."
  [^DisplayVideo client advertiser-id]
  (advertisers/delete client advertiser-id))

(s/fdef delete
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id)
  :ret (s/and map? empty?))

(defn update-by-id
  "Update an existing advertiser by `advertiser-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords).

  Example:
  ```
  [:display-name general-config.domain-url]
  ```."
  [^DisplayVideo client advertiser-id advertiser update-mask]
  (advertisers/update-by-id client advertiser-id advertiser update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :advertiser ::spec/advertiser
               :update-mask ::spec/update-mask)
  :ret ::spec/advertiser)
