(ns com.adgoji.displayvideo-api.advertisers.insertion-orders
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.insertion-orders.interface :as insertion-orders]
   [com.adgoji.spec.interface :as spec])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  "Create a new insertion-order.

  For insertionOrders.create method, only ENTITY_STATUS_DRAFT is
  allowed.

  To activate an insertion order, use insertionOrders.patch method and
  update the status to ENTITY_STATUS_ACTIVE after creation."
  [^DisplayVideo client advertiser-id insertion-order]
  (insertion-orders/create client advertiser-id insertion-order))

(s/fdef create
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order ::spec/insertion-order)
  :ret ::spec/insertion-order)

(defn delete
  "Delete an insertion-order by `advertiser-id` and `insertion-order-id`."
  [^DisplayVideo client advertiser-id insertion-order-id]
  (insertion-orders/delete client advertiser-id insertion-order-id))

(s/fdef delete
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id)
  :ret (s/and map? empty?))

(defn get-by-id
  "Returns a single insertion-order by `insertion-order-id`."
  [^DisplayVideo client advertiser-id insertion-order-id]
  (insertion-orders/get-by-id client advertiser-id insertion-order-id))

(s/fdef get-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id)
  :ret ::spec/insertion-order)

(defn get-list
  "Returns a list of all campaigns insertion orders"
  [^DisplayVideo client advertiser-id opts]
  (insertion-orders/get-list client advertiser-id opts))

(s/fdef get-list
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :opts (s/keys :opt-un [::spec/order-by
                                      ::spec/filter-expr
                                      ::spec/limit]))
  :ret ::spec/insertion-orders)

(defn update-by-id
  "Update an existing insertion-order by `advertiser-id` and `insertion-order-id`.

  Request body is the same as for [[create]] function. Additionally
  `update-mask` is a mandatory parameter, it should be a sequence of
  fully qualified names of fields (as keywords).

  An insertion order cannot be changed back to ENTITY_STATUS_DRAFT
  status from any other status.

  An insertion order cannot be set to ENTITY_STATUS_ACTIVE if its
  parent campaign is not active.

  To activate an insertion order, use insertionOrders.patch method and
  update the status to ENTITY_STATUS_ACTIVE after creation."
  [^DisplayVideo client advertiser-id insertion-order-id insertion-order update-mask]
  (insertion-orders/update-by-id client
                                 advertiser-id
                                 insertion-order-id
                                 insertion-order
                                 update-mask))

(s/fdef update-by-id
  :args (s/cat :client ::spec/displayvideo-client
               :advertiser-id ::spec/advertiser-id
               :insertion-order-id ::spec/insertion-order-id
               :insertion-order ::spec/insertion-order
               :update-mask ::spec/update-mask)
  :ret ::spec/insertion-order)
