(ns com.adgoji.insertion-orders.interface
  (:require
   [com.adgoji.insertion-orders.core :as insertion-orders.core])
  (:import
   (com.google.api.services.displayvideo.v2 DisplayVideo)))

(defn create
  [^DisplayVideo client advertiser-id insertion-order]
  (insertion-orders.core/create client advertiser-id insertion-order))

(defn delete
  [^DisplayVideo client advertiser-id insertion-order-id]
  (insertion-orders.core/delete client advertiser-id insertion-order-id))

(defn get-by-id
  [^DisplayVideo client advertiser-id insertion-order-id]
  (insertion-orders.core/get-by-id client advertiser-id insertion-order-id))

(defn get-list
  [^DisplayVideo client advertiser-id opts]
  (insertion-orders.core/get-list client advertiser-id opts))

(defn update-by-id
  [^DisplayVideo client advertiser-id insertion-order-id insertion-order update-mask]
  (insertion-orders.core/update-by-id client
                                      advertiser-id
                                      insertion-order-id
                                      insertion-order
                                      update-mask))
