(ns com.adgoji.spec.displayvideo.review-status-info
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.exchange-review-status :as exchange-review-status]
   [com.adgoji.spec.displayvideo.publisher-review-status :as publisher-review-status]
   [com.adgoji.spec.common :as spec.common]))

(s/def ::approval-status
  #{"APPROVAL_STATUS_UNSPECIFIED"
    "APPROVAL_STATUS_PENDING_NOT_SERVABLE"
    "APPROVAL_STATUS_PENDING_SERVABLE"
    "APPROVAL_STATUS_APPROVED_SERVABLE"
    "APPROVAL_STATUS_REJECTED_NOT_SERVABLE"})
(s/def ::creative-and-landing-page-review-status ::spec.common/review-status)
(s/def ::content-and-policy-review-status ::spec.common/review-status)
(s/def ::exchange-review-status
  (spec.utils/only-keys :req-un [::exchange-review-status/exchange
                                 ::exchange-review-status/status]))
(s/def ::exchange-review-statuses
  (s/coll-of ::exchange-review-status :distinct true :into []))
(s/def ::publisher-review-status
  (spec.utils/only-keys :req-un [::publisher-review-status/publisher-name
                                 ::publisher-review-status/status]))
(s/def ::publisher-review-statuses
  (s/coll-of ::publisher-review-status :distinct true :into []))
