(ns com.adgoji.spec.displayvideo.transcode
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.dimensions :as dimensions]))

(s/def ::name string?)
(s/def ::mime-type string?)
(s/def ::transcoded boolean?)
(s/def ::dimensions
  (spec.utils/only-keys :req-un [::dimensions/width-pixels
                                 ::dimensions/height-pixels]))
(s/def ::bit-rate-kbps int?)
(s/def ::frame-rate double?)
(s/def ::audio-bit-rate-kbps int?)
(s/def ::audio-sample-rate-hz int?)
(s/def ::file-size-bytes int?)
