(ns com.adgoji.spec.displayvideo.video-ad-sequence-settings
  (:require
   [clojure.spec.alpha :as s]
   [com.adgoji.spec.utils :as spec.utils]
   [com.adgoji.spec.displayvideo.video-ad-sequence-step :as video-ad-sequence-step]))

(s/def ::minimum-duration
  #{"VIDEO_AD_SEQUENCE_MINIMUM_DURATION_UNSPECIFIED"
    "VIDEO_AD_SEQUENCE_MINIMUM_DURATION_WEEK"
    "VIDEO_AD_SEQUENCE_MINIMUM_DURATION_MONTH"})

(s/def ::step
  (spec.utils/only-keys
   :opt-un [::video-ad-sequence-step/ad-group-id
            ::video-ad-sequence-step/interaction-type
            ::video-ad-sequence-step/previous-step-id
            ::video-ad-sequence-step/step-id]))

(s/def ::steps
  (s/coll-of ::step :distinct true :into []))
